/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.upgradeTests;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.UpgradeRun;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.JDBC;

public class _Suite
extends BaseTestCase {
    static final String OLD_VERSIONS_PATH_PROPERTY = "derbyTesting.oldVersionsPath";
    static final String OLD_RELEASE_PATH_PROPERTY = "derbyTesting.oldReleasePath";
    static final String OLD_JAR_URL = "http://svn.apache.org/repos/asf/db/derby/jars";
    private static OldVersions old;

    private _Suite(String name) {
        super(name);
    }

    public static Test suite() {
        String id = "Upgrade Suite: derbyTesting.oldReleasePath=" + UpgradeRun.jarPath + " / " + OLD_VERSIONS_PATH_PROPERTY + "=" + UpgradeRun.oldVersionsPath;
        TestSuite suite = new TestSuite(id);
        if (UpgradeRun.oldVersionsPath != null) {
            old = new OldVersions(UpgradeRun.oldVersionsPath);
        }
        OldVersions.show();
        for (int i = 0; i < OldVersions.VERSIONS.length; ++i) {
            if (JDBC.vmSupportsJSR169()) {
                if (OldVersions.VERSIONS[i][0] == 10) {
                    if (OldVersions.VERSIONS[i][1] == 0) {
                        _Suite.traceit("Skipping 10.0 on JSR169");
                        continue;
                    }
                }
            }
            if (System.getProperty("java.vm.name").equals("CVM") && System.getProperty("java.vm.version").startsWith("phoneme")) {
                if (OldVersions.VERSIONS[i][0] == 10) {
                    if (OldVersions.VERSIONS[i][1] == 3) {
                        if (OldVersions.VERSIONS[i][2] == 1) {
                            if (OldVersions.VERSIONS[i][3] == 4) {
                                _Suite.traceit("Skipping 10.3.1.4 on CVM/phoneme");
                                continue;
                            }
                        }
                    }
                }
            }
            suite.addTest(UpgradeRun.suite(OldVersions.VERSIONS[i]));
        }
        return suite;
    }

    private static class OldVersions {
        private static int[][] VERSIONS = new int[][]{{10, 0, 2, 1}, {10, 1, 1, 0}, {10, 1, 2, 1}, {10, 1, 3, 1}, {10, 2, 1, 6}, {10, 2, 2, 0}, {10, 3, 1, 4}, {10, 3, 3, 0}, {10, 4, 1, 3}, {10, 4, 2, 0}};

        private OldVersions(String oldVersionsPath) {
            BufferedReader br = null;
            try {
                FileReader fr = new FileReader(oldVersionsPath);
                br = new BufferedReader(fr);
            }
            catch (FileNotFoundException fNFE) {
                BaseTestCase.alarm("File '" + oldVersionsPath + "' was not found, using default old versions for upgrade tests.");
                return;
            }
            BaseTestCase.traceit("Run upgrade tests on versions defined in '" + oldVersionsPath + "'");
            this.getVersions(br, oldVersionsPath);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void getVersions(BufferedReader br, String oldVersionsPath) {
            VERSIONS = new int[256][4];
            int versions = 0;
            String line = null;
            int lineNum = 0;
            try {
                while ((line = br.readLine()) != null) {
                    ++lineNum;
                    try {
                        String[] parts = OldVersions.split4(line, '.');
                        if (parts.length >= 3) {
                            int[] vstr = new int[4];
                            for (int i = 0; i < 4; ++i) {
                                String str = parts[i];
                                if (i == 3) {
                                    str = OldVersions.clean(str, "0123456789");
                                }
                                vstr[i] = Integer.parseInt(str);
                            }
                            OldVersions.VERSIONS[versions++] = vstr;
                            continue;
                        }
                        BaseTestCase.alarm("Illegal version format on: " + line);
                    }
                    catch (NumberFormatException nfe) {
                        BaseTestCase.alarm("NumberFormatException on line " + lineNum + ": " + line + ": " + " " + nfe.getMessage());
                    }
                    catch (ArrayIndexOutOfBoundsException aie) {
                        BaseTestCase.alarm("ArrayIndexOutOfBoundsException on line " + lineNum + ": " + line + ": " + " " + aie.getMessage());
                    }
                }
            }
            catch (IOException ioe) {
                BaseTestCase.alarm("Error reading from file: " + oldVersionsPath + ioe.getMessage());
            }
            int[][] finalVERSIONS = new int[versions][4];
            int v = 0;
            while (true) {
                if (v >= versions) {
                    VERSIONS = finalVERSIONS;
                    return;
                }
                finalVERSIONS[v] = VERSIONS[v];
                ++v;
            }
        }

        private static void show() {
            BaseTestCase.traceit("Upgrade test versions listed:");
            for (int o = 0; o < VERSIONS.length; ++o) {
                String ver = "";
                for (int i = 0; i < VERSIONS[o].length; ++i) {
                    ver = i == 0 ? "" + VERSIONS[o][i] : ver + "." + VERSIONS[o][i];
                }
                BaseTestCase.traceit(ver);
            }
        }

        private static String[] split4(String l, char c) {
            String[] res = new String[4];
            try {
                int p0 = l.indexOf(c);
                if (p0 < 0) {
                    return res;
                }
                res[0] = l.substring(0, p0);
                int p1 = l.indexOf(c, p0 + 1);
                if (p1 < 0) {
                    return res;
                }
                res[1] = l.substring(p0 + 1, p1);
                int p2 = l.indexOf(c, p1 + 1);
                if (p2 < 0) {
                    return res;
                }
                res[2] = l.substring(p1 + 1, p2);
                int p3 = l.indexOf(c, p2 + 1);
                if (p3 < 0) {
                    p3 = l.length();
                }
                res[3] = l.substring(p2 + 1, p3);
            }
            catch (StringIndexOutOfBoundsException sie) {
                BaseTestCase.println("split4 StringIndexOutOfBoundsException: " + sie.getMessage());
                sie.printStackTrace();
            }
            return res;
        }

        private static String clean(String l, String allowed) {
            for (int i = 0; i < l.length(); ++i) {
                if (OldVersions.matches(l.charAt(i), allowed)) continue;
                return l.substring(0, i);
            }
            return l;
        }

        private static boolean matches(char c, String allowed) {
            for (int j = 0; j < allowed.length(); ++j) {
                if (allowed.charAt(j) != c) continue;
                return true;
            }
            return false;
        }
    }
}

