/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.TestConfiguration;

public class OSReadOnlyTest
extends BaseJDBCTestCase {
    public OSReadOnlyTest(String name) {
        super(name);
    }

    private static Test newCleanDatabase(TestSuite s) {
        return new CleanDatabaseTestSetup((Test)s){

            protected void decorateSQL(Statement stmt) throws SQLException {
                this.getConnection();
                stmt.executeUpdate("CREATE TABLE foo (a int, b char(100))");
                stmt.execute("insert into foo values (1, 'hello world')");
                stmt.execute("insert into foo values (2, 'happy world')");
                stmt.execute("insert into foo values (3, 'sad world')");
                stmt.execute("insert into foo values (4, 'crazy world')");
                for (int i = 0; i < 7; ++i) {
                    stmt.execute("insert into foo select * from foo");
                }
                stmt.execute("create index fooi on foo(a, b)");
            }
        };
    }

    protected static Test baseSuite(String name) {
        TestSuite readonly = new TestSuite("OSReadOnly");
        TestSuite suite = new TestSuite(name);
        readonly.addTestSuite(OSReadOnlyTest.class);
        suite.addTest((Test)TestConfiguration.singleUseDatabaseDecorator(OSReadOnlyTest.newCleanDatabase(readonly)));
        return suite;
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("OSReadOnlyTest");
        suite.addTest(OSReadOnlyTest.baseSuite("OSReadOnlyTest:embedded"));
        suite.addTest(TestConfiguration.clientServerDecorator(OSReadOnlyTest.baseSuite("OSReadOnlyTest:client")));
        return suite;
    }

    public void testOSReadOnly() throws Exception {
        this.setAutoCommit(false);
        Statement stmt = this.createStatement();
        JDBC.assertFullResultSet(stmt.executeQuery("select count(*) from foo"), new String[][]{{"512"}});
        stmt.executeUpdate("delete from foo where a = 1");
        JDBC.assertFullResultSet(stmt.executeQuery("select count(*) from foo"), new String[][]{{"384"}});
        this.rollback();
        JDBC.assertFullResultSet(stmt.executeQuery("select count(*) from foo"), new String[][]{{"512"}});
        stmt.executeUpdate("insert into foo select * from foo where a = 1");
        JDBC.assertFullResultSet(stmt.executeQuery("select count(*) from foo"), new String[][]{{"640"}});
        this.commit();
        stmt.executeUpdate("delete from foo where a = 1");
        JDBC.assertFullResultSet(stmt.executeQuery("select count(*) from foo"), new String[][]{{"384"}});
        this.rollback();
        JDBC.assertFullResultSet(stmt.executeQuery("select count(*) from foo"), new String[][]{{"640"}});
        this.setAutoCommit(false);
        TestConfiguration.getCurrent().shutdownDatabase();
        String phDbName = this.getPhysicalDbName();
        this.copyDatabaseOnOS(phDbName, "readOnly");
        this.changeFilePermissions("readOnly");
        DataSource ds = JDBCDataSource.getDataSource();
        JDBCDataSource.setBeanProperty(ds, "databaseName", "singleUse/readOnly");
        this.assertReadDB(ds);
        this.assertExpectedInsertBehaviour(ds, false, 10, "will fail");
        this.shutdownDB(ds);
        this.copyDatabaseOnOS("readOnly", "readWrite");
        ds = JDBCDataSource.getDataSource();
        JDBCDataSource.setBeanProperty(ds, "databaseName", "singleUse/readWrite");
        this.assertReadDB(ds);
        this.assertExpectedInsertBehaviour(ds, true, 20, "will go in");
        this.shutdownDB(ds);
        this.copyDatabaseOnOS("readWrite", "readOnly2");
        this.changeFilePermissions("readOnly2");
        ds = JDBCDataSource.getDataSource();
        JDBCDataSource.setBeanProperty(ds, "databaseName", "singleUse/readOnly2");
        this.assertReadDB(ds);
        this.assertExpectedInsertBehaviour(ds, false, 30, "will also fail");
        this.shutdownDB(ds);
        this.copyDatabaseOnOS("readOnly2", phDbName);
    }

    private String getPhysicalDbName() {
        String pdbName = TestConfiguration.getCurrent().getJDBCUrl();
        pdbName = pdbName != null ? pdbName.substring(pdbName.lastIndexOf("oneuse"), pdbName.length()) : (String)AccessController.doPrivileged(new PrivilegedAction(){
            String filesep = OSReadOnlyTest.access$000("file.separator");

            public Object run() {
                File dbdir = new File("system" + this.filesep + "singleUse");
                String[] list = dbdir.list();
                if (list != null) {
                    if (list.length > 1) {
                        for (int i = 0; i < list.length; ++i) {
                            if (list[i].indexOf("oneuse") < 0) continue;
                            return list[i];
                        }
                        return "oneuse0";
                    }
                    return list[0];
                }
                return null;
            }
        });
        return pdbName;
    }

    private void shutdownDB(DataSource ds) throws SQLException {
        JDBCDataSource.setBeanProperty(ds, "ConnectionAttributes", "shutdown=true");
        try {
            ds.getConnection();
            OSReadOnlyTest.fail((String)"expected an sqlexception 08006");
        }
        catch (SQLException sqle) {
            OSReadOnlyTest.assertSQLState("08006", sqle);
        }
    }

    private void assertReadDB(DataSource ds) throws SQLException {
        Connection con = ds.getConnection();
        Statement stmt2 = con.createStatement();
        JDBC.assertFullResultSet(stmt2.executeQuery("select count(*) from foo where a=1"), new String[][]{{"256"}});
        JDBC.assertFullResultSet(stmt2.executeQuery("select count(*) from foo where a=2"), new String[][]{{"128"}});
        JDBC.assertFullResultSet(stmt2.executeQuery("select count(*) from foo where a=1 and b='hello world'"), new String[][]{{"256"}});
        stmt2.close();
        con.close();
    }

    private void assertExpectedInsertBehaviour(DataSource ds, boolean expectedSuccess, int insertIntValue, String insertStringValue) throws SQLException {
        Connection con = ds.getConnection();
        Statement stmt = con.createStatement();
        if (expectedSuccess) {
            stmt.executeUpdate("insert into foo values (" + insertIntValue + ", '" + insertStringValue + "')");
            OSReadOnlyTest.assertTrue((stmt.getUpdateCount() == 1 ? 1 : 0) != 0);
            JDBC.assertFullResultSet(stmt.executeQuery("select count(*) from foo where a=" + insertIntValue), new String[][]{{"1"}});
        } else {
            try {
                stmt.executeUpdate("insert into foo values (" + insertIntValue + ", '" + insertStringValue + "')");
                OSReadOnlyTest.fail((String)"expected an error indicating the db is readonly");
            }
            catch (SQLException sqle) {
                OSReadOnlyTest.assertSQLState("40XD1", sqle);
            }
        }
        stmt.close();
        con.close();
    }

    private void copyDatabaseOnOS(String fromwhere, String todir) {
        String filesep = OSReadOnlyTest.getSystemProperty("file.separator");
        String testpath = new String(OSReadOnlyTest.getSystemProperty("user.dir") + filesep + "system" + filesep + "singleUse" + filesep);
        String from_dir = testpath + fromwhere;
        String to_dir = testpath + todir;
        OSReadOnlyTest.assertTrue((String)("Failed to copy directory from " + from_dir + " to " + to_dir), (boolean)OSReadOnlyTest.copyDirectory(from_dir, to_dir));
        OSReadOnlyTest.assertTrue((String)("Failed to remove directory: " + from_dir), (boolean)OSReadOnlyTest.removeTemporaryDirectory(from_dir));
    }

    public void changeFilePermissions(String dir) {
        String filesep = OSReadOnlyTest.getSystemProperty("file.separator");
        String dir_to_change = new String(OSReadOnlyTest.getSystemProperty("user.dir") + filesep + "system" + filesep + "singleUse" + filesep + dir);
        OSReadOnlyTest.assertTrue((String)("Failed to change files in " + dir_to_change + " to ReadOnly"), (boolean)OSReadOnlyTest.changeDirectoryToReadOnly(dir_to_change));
    }

    public static boolean changeDirectoryToReadOnly(String directory) {
        return OSReadOnlyTest.changeDirectoryToReadOnly(new File(directory));
    }

    public static boolean changeDirectoryToReadOnly(File directory) {
        if (null == directory) {
            return false;
        }
        final File sdirectory = directory;
        Boolean b = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String[] list;
                boolean success = true;
                if (!sdirectory.isDirectory()) {
                    success = false;
                }
                if ((list = sdirectory.list()) != null) {
                    for (int i = 0; i < list.length; ++i) {
                        File entry = new File(sdirectory, list[i]);
                        if (entry.isDirectory()) {
                            if (OSReadOnlyTest.changeDirectoryToReadOnly(entry)) continue;
                            success = false;
                            continue;
                        }
                        if (entry.setReadOnly()) continue;
                        success = false;
                    }
                }
                return new Boolean(success);
            }
        });
        return b != false;
    }

    private static final boolean removeTemporaryDirectory(File directory) {
        if (directory == null) {
            return false;
        }
        final File sdirectory = directory;
        Boolean b = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (!sdirectory.exists()) {
                    return new Boolean(true);
                }
                if (!sdirectory.isDirectory()) {
                    return new Boolean(false);
                }
                String[] list = sdirectory.list();
                if (list != null) {
                    for (int i = 0; i < list.length; ++i) {
                        File entry = new File(sdirectory, list[i]);
                        if (!(entry.isDirectory() ? !OSReadOnlyTest.removeTemporaryDirectory(entry) : !entry.delete())) continue;
                        return new Boolean(false);
                    }
                }
                return new Boolean(sdirectory.delete());
            }
        });
        return b != false;
    }

    public static boolean removeTemporaryDirectory(String directory) {
        return OSReadOnlyTest.removeTemporaryDirectory(new File(directory));
    }

    private static boolean copyDirectory(File from, File to) {
        return OSReadOnlyTest.copyDirectory(from, to, null);
    }

    private static boolean copyDirectory(String from, String to) {
        return OSReadOnlyTest.copyDirectory(new File(from), new File(to));
    }

    private static boolean copyDirectory(File from, File to, byte[] buffer) {
        byte[] sbuffer;
        Boolean b;
        if (from == null) {
            return false;
        }
        final File sfrom = from;
        final File sto = to;
        if (buffer == null) {
            buffer = new byte[16384];
        }
        return (b = (Boolean)AccessController.doPrivileged(new PrivilegedAction(sbuffer = buffer){
            private final /* synthetic */ byte[] val$sbuffer;
            {
                this.val$sbuffer = byArray;
            }

            public Object run() {
                if (!sfrom.exists() || !sfrom.isDirectory() || sto.exists() || !sto.mkdirs()) {
                    return new Boolean(false);
                }
                boolean success = true;
                String[] list = sfrom.list();
                if (list != null) {
                    for (int i = 0; i < list.length; ++i) {
                        File entry = new File(sfrom, list[i]);
                        success = entry.isDirectory() ? OSReadOnlyTest.copyDirectory(entry, new File(sto, list[i]), this.val$sbuffer) : OSReadOnlyTest.copyFile(entry, new File(sto, list[i]), this.val$sbuffer);
                    }
                }
                return new Boolean(success);
            }
        })) != false;
    }

    public static boolean copyFile(File from, File to) {
        return OSReadOnlyTest.copyFile(from, to, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(File from, File to, byte[] buf) {
        if (buf == null) {
            buf = new byte[16384];
        }
        FileInputStream from_s = null;
        FileOutputStream to_s = null;
        try {
            from_s = new FileInputStream(from);
            to_s = new FileOutputStream(to);
            int bytesRead = from_s.read(buf);
            while (bytesRead != -1) {
                to_s.write(buf, 0, bytesRead);
                bytesRead = from_s.read(buf);
            }
            from_s.close();
            from_s = null;
            to_s.getFD().sync();
            to_s.close();
            to_s = null;
        }
        catch (IOException ioe) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (from_s != null) {
                try {
                    from_s.close();
                }
                catch (IOException ioe) {}
            }
            if (to_s != null) {
                try {
                    to_s.close();
                }
                catch (IOException ioe) {}
            }
        }
        return true;
    }

    static /* synthetic */ String access$000(String x0) {
        return OSReadOnlyTest.getSystemProperty(x0);
    }
}

