/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.LinkedList;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class Derby3980DeadlockTest
extends BaseJDBCTestCase {
    private final int THREAD_COUNT = 2;
    private LinkedList listExceptions = new LinkedList();
    private Object syncObject = new Object();
    private int startedCount = 0;

    public Derby3980DeadlockTest(String name) {
        super(name);
    }

    public void test3980Deadlock() {
        Thread[] t = new Thread[2];
        this.createThreads(t);
        this.waitForThreads(t);
        this.checkExceptions();
    }

    private void checkExceptions() {
        Iterator i = this.listExceptions.iterator();
        while (i.hasNext()) {
            SQLException e = (SQLException)i.next();
            Derby3980DeadlockTest.assertSQLState("40001", e);
        }
        Derby3980DeadlockTest.assertEquals((String)("Expected 1 exception, got" + this.listExceptions.size()), (int)1, (int)this.listExceptions.size());
    }

    private void waitForThreads(Thread[] t) {
        for (int i = 0; i < 2; ++i) {
            try {
                t[i].join();
                continue;
            }
            catch (InterruptedException e) {
                Derby3980DeadlockTest.fail((String)"FAIL - InterruptedException  thrown waiting for the threads");
            }
        }
    }

    private void createThreads(Thread[] t) {
        for (int i = 0; i < 2; ++i) {
            t[i] = new Thread(new Runnable(){

                public void run() {
                    this.threadWorker();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void threadWorker() {
                    Connection threadConnection = null;
                    try {
                        Object object = Derby3980DeadlockTest.this.syncObject;
                        synchronized (object) {
                            if (threadConnection == null) {
                                threadConnection = Derby3980DeadlockTest.this.openDefaultConnection();
                            }
                            Derby3980DeadlockTest.this.startedCount++;
                            Derby3980DeadlockTest.this.syncObject.notifyAll();
                            while (Derby3980DeadlockTest.this.startedCount < 2) {
                                Derby3980DeadlockTest.this.syncObject.wait();
                            }
                        }
                        Statement stmt = threadConnection.createStatement();
                        threadConnection.setAutoCommit(false);
                        threadConnection.setTransactionIsolation(4);
                        ResultSet rs = stmt.executeQuery("select * from t where i = 456");
                        while (rs.next()) {
                        }
                        stmt.executeUpdate("delete from t  where i = 456");
                        threadConnection.commit();
                    }
                    catch (Exception e) {
                        Object object = Derby3980DeadlockTest.this.syncObject;
                        synchronized (object) {
                            Derby3980DeadlockTest.this.listExceptions.add(e);
                        }
                    }
                }
            }, "Thread" + i);
            t[i].start();
        }
    }

    public static Test suite() {
        Test suite = TestConfiguration.embeddedSuite(Derby3980DeadlockTest.class);
        return new CleanDatabaseTestSetup(DatabasePropertyTestSetup.setLockTimeouts(suite, 5, 10)){

            protected void decorateSQL(Statement s) throws SQLException {
                s.executeUpdate("CREATE TABLE T (I INT)");
                s.executeUpdate("INSERT INTO T VALUES(456)");
            }
        };
    }
}

