/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.io.Reader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseJDBCTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.TestConfiguration;
import org.apache.derbyTesting.junit.XML;

public class XMLBindingTest
extends BaseJDBCTestCase {
    public XMLBindingTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("XML Binding Suite");
        if (XML.classpathMeetsXMLReqs()) {
            suite.addTest(TestConfiguration.defaultSuite(XMLBindingTest.class, false));
            XBindTestSetup wrapper = new XBindTestSetup(suite);
            return new SupportFilesSetup((Test)wrapper, new String[]{"functionTests/tests/lang/xmlTestFiles/personal.dtd"});
        }
        return suite;
    }

    public void testInvalidXMLBindings() throws Exception {
        this.assertCompileError("42Z70", "insert into xTable.t1(x) values (?)");
        this.assertCompileError("42Z70", "select XMLSERIALIZE(? AS CLOB) FROM XTABLE.T1");
        this.assertCompileError("42Z70", "select i from xTable.t1 where XMLEXISTS('//*' PASSING BY REF ?)");
        this.assertCompileError("42Z70", "select i from xTable.t1 where XMLQUERY('//*' PASSING BY REF ? EMPTY ON EMPTY) is not null");
        this.assertCompileError("42Z71", "select x from xTable.t1");
    }

    public void testXMLSerializeBinding() throws Exception {
        int[] expectedCharCounts = new int[]{40228, 38712, 1948, 1942, 1967, 1709, 22, -1, -1};
        int rowCount = 0;
        ResultSet rs = this.createStatement().executeQuery("select i, XMLSERIALIZE(X AS CLOB) FROM xTable.t1");
        while (rs.next()) {
            int charCount;
            Reader xResult = rs.getCharacterStream(2);
            if (!rs.wasNull()) {
                int ch = xResult.read();
                charCount = 0;
                while (ch != -1) {
                    if ((char)ch != '\r') {
                        ++charCount;
                    }
                    ch = xResult.read();
                }
                xResult.close();
            } else {
                charCount = -1;
            }
            XMLBindingTest.assertEquals((String)"Unexpected serialized character count:", (int)expectedCharCounts[rowCount], (int)charCount);
            ++rowCount;
        }
        XMLBindingTest.assertEquals((String)"Unexpected row count when serializing:", (int)expectedCharCounts.length, (int)rowCount);
    }

    public void testXMLExistsBinding() throws Exception {
        this.assertCompileError("42Z75", "select i from xTable.t1 where XMLEXISTS (? PASSING BY REF x)");
        this.existsQuery("//abb", 1);
        this.existsQuery("//d50", 1);
        this.existsQuery("//person/email", 4);
        this.existsQuery("/personnel", 5);
        this.existsQuery("//person/@id", 4);
        this.existsQuery("//person/@noteTwo", 1);
    }

    public void testXMLQueryBinding() throws Exception {
        this.assertCompileError("42Z75", "select i from xTable.t1 where XMLQUERY (? PASSING BY REF x EMPTY ON EMPTY) is not null");
    }

    private void existsQuery(String xPath, int expectedRows) throws Exception {
        ResultSet rs = this.createStatement().executeQuery("select i from xTable.t1 where xmlexists('" + xPath + "' passing by ref x)");
        JDBC.assertDrainResults(rs, expectedRows);
    }

    private static class XBindTestSetup
    extends BaseJDBCTestSetup {
        public XBindTestSetup(TestSuite tSuite) {
            super((Test)tSuite);
        }

        public void setUp() throws Exception {
            String tName = "xTable.t1";
            Connection c = this.getConnection();
            c.createStatement().execute("create table " + tName + "(i int generated always as identity, x xml)");
            XML.insertFile(c, tName, "x", "wide40k.xml", 1);
            XML.insertFile(c, tName, "x", "deep40k.xml", 1);
            XML.insertFile(c, tName, "x", "xsdDoc.xml", 1);
            XML.insertDocWithDTD(c, tName, "x", "dtdDoc.xml", "personal.dtd", 1);
            XML.insertFile(c, tName, "x", "xsdDoc_invalid.xml", 1);
            XML.insertDocWithDTD(c, tName, "x", "dtdDoc_invalid.xml", "personal.dtd", 1);
            PreparedStatement pSt = this.getConnection().prepareStatement("insert into xTable.t1(x) values (XMLPARSE (DOCUMENT CAST (? as CLOB) PRESERVE WHITESPACE))");
            pSt.setString(1, "<simple> doc </simple>");
            pSt.execute();
            pSt.setString(1, null);
            pSt.execute();
            pSt.setNull(1, 2005);
            pSt.execute();
            pSt.close();
            c = null;
        }

        public void tearDown() throws Exception {
            this.getConnection().createStatement().execute("drop table xTable.t1");
            super.tearDown();
        }
    }
}

