/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.RuntimeStatisticsParser;
import org.apache.derbyTesting.junit.SQLUtilities;
import org.apache.derbyTesting.junit.TestConfiguration;

public class UpdateStatisticsTest
extends BaseJDBCTestCase {
    public UpdateStatisticsTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(UpdateStatisticsTest.class);
    }

    public void testUpdateStatistics() throws SQLException {
        Statement s = this.createStatement();
        UpdateStatisticsTest.assertStatementError("42Y55", s, "CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','T1',null)");
        s.executeUpdate("CREATE TABLE t1 (c11 int, c12 varchar(128))");
        s.execute("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','T1',null)");
        UpdateStatisticsTest.assertStatementError("42X65", s, "CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','T1','I1')");
        s.executeUpdate("CREATE INDEX i1 on t1(c12)");
        s.execute("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','T1','I1')");
        ResultSet rs = s.executeQuery("SELECT * FROM SYS.SYSSTATISTICS");
        JDBC.assertEmpty(rs);
        s.executeUpdate("INSERT INTO T1 VALUES(1,'a'),(2,'b'),(3,'c'),(4,'d')");
        s.executeUpdate("CREATE INDEX i2 ON t1(c11)");
        rs = s.executeQuery("SELECT * FROM SYS.SYSSTATISTICS");
        JDBC.assertDrainResults(rs, 1);
        s.execute("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','T1','I1')");
        rs = s.executeQuery("SELECT * FROM SYS.SYSSTATISTICS");
        JDBC.assertDrainResults(rs, 2);
        UpdateStatisticsTest.assertStatementError("42X01", s, "ALTER TABLE APP.T1 ALL UPDATE STATISTICS");
        UpdateStatisticsTest.assertStatementError("42X01", s, "ALTER TABLE APP.T1 UPDATE STATISTICS I1");
        s.executeUpdate("DROP TABLE t1");
        s.executeUpdate("declare global temporary table SESSION.t1(c11 int, c12 int) on commit delete rows not logged");
        s.executeUpdate("insert into session.t1 values(11, 1)");
        UpdateStatisticsTest.assertStatementError("42995", s, "CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('SESSION','T1',null)");
        s.executeUpdate("CREATE TABLE t2(c21 int, c22 char(14), c23 char(200))");
        s.executeUpdate("CREATE INDEX t2i1 ON t2(c21)");
        s.executeUpdate("CREATE INDEX t2i2 ON t2(c22)");
        rs = s.executeQuery("SELECT * FROM SYS.SYSSTATISTICS");
        JDBC.assertEmpty(rs);
        PreparedStatement ps = this.prepareStatement("INSERT INTO T2 VALUES(?,?,?)");
        for (int i = 0; i < 1000; ++i) {
            ps.setInt(1, i % 2);
            ps.setString(2, "Tuple " + i);
            ps.setString(3, "any value");
            ps.addBatch();
        }
        ps.executeBatch();
        s.execute("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        ps = this.prepareStatement("SELECT * FROM t2 WHERE c21=? AND c22=?");
        ps.setInt(1, 0);
        ps.setString(2, "Tuple 4");
        JDBC.assertDrainResults(ps.executeQuery());
        RuntimeStatisticsParser rtsp = SQLUtilities.getRuntimeStatisticsParser(s);
        UpdateStatisticsTest.assertTrue((boolean)rtsp.usedSpecificIndexForIndexScan("T2", "T2I1"));
        s.execute("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','T2','T2I2')");
        rs = s.executeQuery("SELECT * FROM SYS.SYSSTATISTICS");
        JDBC.assertDrainResults(rs, 1);
        JDBC.assertDrainResults(ps.executeQuery());
        rtsp = SQLUtilities.getRuntimeStatisticsParser(s);
        UpdateStatisticsTest.assertTrue((boolean)rtsp.usedSpecificIndexForIndexScan("T2", "T2I2"));
        s.executeUpdate("DROP TABLE t2");
    }

    public void testNoExclusiveLockOnTable() throws SQLException {
        Statement s = this.createStatement();
        s.execute("create table t (x char(1))");
        s.execute("create index ti on t(x)");
        s.execute("insert into t values 'a','b','c','d'");
        this.setAutoCommit(false);
        s.execute("lock table t in share mode");
        Connection c2 = this.openDefaultConnection();
        Statement s2 = c2.createStatement();
        s2.execute("call syscs_util.syscs_update_statistics('APP', 'T', null)");
        s2.close();
        c2.close();
        s.execute("drop table t");
        this.commit();
    }
}

