/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import org.apache.derby.vti.VTICosting;
import org.apache.derby.vti.VTIEnvironment;
import org.apache.derbyTesting.functionTests.tests.lang.StringColumnVTI;

public class StringArrayVTI
extends StringColumnVTI {
    public static final double FAKE_ROW_COUNT = 13.0;
    public static final double FAKE_INSTANTIATION_COST = 3149.0;
    private static final String[] EXPECTED_STACK = new String[]{"deduceGetXXXCaller", "getRawColumn", "getString"};
    private int _rowIdx = -1;
    private String[][] _rows;
    private static StringBuffer _callers;

    public StringArrayVTI(String[] columnNames, String[][] rows) {
        super(columnNames);
        this._rows = rows;
    }

    public static String getXXXrecord() {
        if (_callers == null) {
            return null;
        }
        return _callers.toString();
    }

    protected String getRawColumn(int columnNumber) throws SQLException {
        String callersCallerMethod = this.deduceGetXXXCaller();
        _callers.append(callersCallerMethod);
        _callers.append(' ');
        return this._rows[this._rowIdx][columnNumber - 1];
    }

    private String deduceGetXXXCaller() throws SQLException {
        StackTraceElement[] stack = null;
        try {
            stack = new Throwable().getStackTrace();
        }
        catch (Throwable t) {
            throw new SQLException(t.getMessage());
        }
        return this.locateGetXXXCaller(stack);
    }

    public boolean next() throws SQLException {
        if (++this._rowIdx >= this._rows.length) {
            return false;
        }
        _callers = new StringBuffer();
        return true;
    }

    public void close() throws SQLException {
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        throw new SQLException("Not implemented.");
    }

    private String locateGetXXXCaller(StackTraceElement[] stack) throws SQLException {
        String result;
        String[] actualMethodNames = this.squeezeMethodNames(stack);
        String[] expectedMethodNames = EXPECTED_STACK;
        int actualIdx = this.findIndex("getString", actualMethodNames);
        if (actualIdx < 0) {
            throw this.badStack(EXPECTED_STACK, actualMethodNames);
        }
        if (!(result = actualMethodNames[++actualIdx]).startsWith("get")) {
            result = "getString";
        }
        return result;
    }

    private SQLException badStack(String[] expected, String[] actual) {
        return new SQLException("Expected stack to include " + this.stringify(expected) + ", but the stack was actually this: " + this.stringify(actual));
    }

    private int findIndex(String expectedMethod, String[] actualMethodNames) {
        int count = actualMethodNames.length;
        for (int i = 0; i < count; ++i) {
            if (!expectedMethod.equals(actualMethodNames[i])) continue;
            return i;
        }
        return -1;
    }

    private String[] squeezeMethodNames(StackTraceElement[] stack) {
        if (stack == null) {
            stack = new StackTraceElement[]{};
        }
        int count = stack.length;
        String[] result = new String[count];
        for (int i = 0; i < count; ++i) {
            result[i] = stack[i].getMethodName();
        }
        return result;
    }

    private String stringify(Object[] raw) {
        if (raw == null) {
            raw = new Object[]{};
        }
        return Arrays.asList(raw).toString();
    }

    public static class GoodVTICosting
    extends ZeroArgConstructorNotPublic {
    }

    public static class ConstructorException
    extends ZeroArgConstructorNotPublic {
        public ConstructorException() {
            Object shameOnYou = null;
            shameOnYou.hashCode();
        }
    }

    public static class ZeroArgConstructorNotPublic
    extends MissingConstructor {
        ZeroArgConstructorNotPublic() {
            super(new String[]{"foo"}, new String[][]{{"bar"}});
        }
    }

    public static class MissingConstructor
    extends StringArrayVTI
    implements VTICosting {
        private MissingConstructor(String[] columnNames, String[][] rows) {
            super(columnNames, rows);
        }

        public static ResultSet dummyVTI() {
            return new StringArrayVTI(new String[]{"foo"}, new String[][]{{"bar"}});
        }

        public double getEstimatedRowCount(VTIEnvironment env) throws SQLException {
            return 13.0;
        }

        public double getEstimatedCostPerInstantiation(VTIEnvironment env) throws SQLException {
            return 3149.0;
        }

        public boolean supportsMultipleInstantiations(VTIEnvironment env) throws SQLException {
            return false;
        }
    }
}

