/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.sql.DataSource;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derby.iapi.services.info.JVMInfo;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.SecurityManagerSetup;
import org.apache.derbyTesting.junit.SupportFilesSetup;

public class DatabaseClassLoadingTest
extends BaseJDBCTestCase {
    public DatabaseClassLoadingTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite;
        Object test = suite = new TestSuite("DatabaseClassLoadingTest");
        if (JDBC.vmSupportsJDBC3()) {
            String[] orderedTests = new String[]{"testJarHandling", "testWithNoInstalledJars", "testWithNoClasspath", "testSetClasspath", "testAddContact", "testGetResource", "testAlterTable", "testClassPathRollback", "testReplaceJar", "testReplacedClass", "testSecondJar", "testSignedJar", "testCreateDatabaseJar", "testHackedJarReplacedClass", "testInvalidJar", "testRemoveJar", "testLoadJavaClassIndirectly", "testLoadJavaClassDirectly", "testLoadJavaClassDirectly2", "testLoadJavaClassDirectly3", "testLoadDerbyClassIndirectly", "testIndirectLoading", "testTableFunctionInJar"};
            for (int i = 0; i < orderedTests.length; ++i) {
                suite.addTest((Test)new DatabaseClassLoadingTest(orderedTests[i]));
            }
            suite.addTest(SecurityManagerSetup.noSecurityManager((Test)new DatabaseClassLoadingTest("testDatabaseInJar")));
            suite.addTest(SecurityManagerSetup.noSecurityManager((Test)new DatabaseClassLoadingTest("testDatabaseInClasspath")));
            suite.addTest(SecurityManagerSetup.noSecurityManager((Test)new DatabaseClassLoadingTest("testClassLoadOrdering")));
            test = new SupportFilesSetup((Test)suite, new String[]{"functionTests/tests/lang/dcl_emc1.jar", "functionTests/tests/lang/dcl_emcaddon.jar", "functionTests/tests/lang/dcl_emc2.jar", "functionTests/tests/lang/dcl_emc2s.jar", "functionTests/tests/lang/dcl_emc2sm.jar", "functionTests/tests/lang/dcl_emc2l.jar", "functionTests/tests/lang/dcl_java.jar", "functionTests/tests/lang/dcl_ot1.jar", "functionTests/tests/lang/dcl_ot2.jar", "functionTests/tests/lang/dcl_ot3.jar", "functionTests/tests/lang/dcl_id.jar", "functionTests/tests/lang/dummy_vti.jar"});
        }
        return new CleanDatabaseTestSetup((Test)test){

            protected void decorateSQL(Statement s) throws SQLException {
                s.executeUpdate("create schema emc");
                s.executeUpdate("create schema \"emcAddOn\"");
                s.executeUpdate("create table emc.contacts (id int primary key, e_mail varchar(30))");
                s.executeUpdate("create procedure EMC.ADDCONTACT(id INT, e_mail VARCHAR(30)) MODIFIES SQL DATA external name 'org.apache.derbyTesting.databaseclassloader.emc.addContact' language java parameter style java");
                s.executeUpdate("create function EMC.GETARTICLE(path VARCHAR(40)) RETURNS VARCHAR(256) NO SQL external name 'org.apache.derbyTesting.databaseclassloader.emc.getArticle' language java parameter style java");
                s.executeUpdate("CREATE FUNCTION EMC.GETSIGNERS(CLASS_NAME VARCHAR(256)) RETURNS VARCHAR(60) NO SQL LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME 'org.apache.derbyTesting.databaseclassloader.emc.getSigners'");
                s.executeUpdate("CREATE FUNCTION \"emcAddOn\".VALIDCONTACT(E_MAIL VARCHAR(30)) RETURNS SMALLINT READS SQL DATA LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME 'org.apache.derbyTesting.databaseclassloader.addon.vendor.util.valid'");
            }
        };
    }

    public void testWithNoInstalledJars() throws SQLException {
        try {
            this.prepareCall("CALL EMC.ADDCONTACT(?, ?)");
            DatabaseClassLoadingTest.fail((String)"prepareCall on procedure with path to class");
        }
        catch (SQLException e) {
            DatabaseClassLoadingTest.assertSQLState("42X51", e);
        }
        try {
            this.prepareStatement("VALUES EMC.GETARTICLE(?)");
            DatabaseClassLoadingTest.fail((String)"prepareCall on function with path to class");
        }
        catch (SQLException e) {
            DatabaseClassLoadingTest.assertSQLState("42X51", e);
        }
    }

    public void testJarHandling() throws SQLException, MalformedURLException {
        this.installJar("dcl_emc1.jar", "EMC.MAIL_APP_JHT");
        this.replaceJar("dcl_emc2.jar", "EMC.MAIL_APP_JHT");
        this.removeJar("EMC.MAIL_APP_JHT");
    }

    public void testWithNoClasspath() throws SQLException, MalformedURLException {
        this.installJar("dcl_emc1.jar", "EMC.MAIL_APP");
        this.testWithNoInstalledJars();
    }

    public void testSetClasspath() throws SQLException {
        this.setDBClasspath("EMC.MAIL_APP");
        CallableStatement cs = this.prepareCall("CALL EMC.ADDCONTACT(?, ?)");
        cs.setInt(1, 0);
        cs.setString(2, "now@classpathchange.com");
        cs.executeUpdate();
        cs.close();
        this.derby2035Workaround();
    }

    public void testAddContact() throws SQLException {
        CallableStatement cs = this.prepareCall("CALL EMC.ADDCONTACT(?, ?)");
        cs.setInt(1, 1);
        cs.setString(2, "bill@ruletheworld.com");
        cs.executeUpdate();
        cs.setInt(1, 2);
        cs.setString(2, "penguin@antartic.com");
        cs.executeUpdate();
        cs.close();
        Statement s = this.createStatement();
        ResultSet rs = s.executeQuery("SELECT id, e_mail from EMC.CONTACTS ORDER BY 1");
        JDBC.assertFullResultSet(rs, new String[][]{{"0", "now@classpathchange.com"}, {"1", "bill@ruletheworld.com"}, {"2", "penguin@antartic.com"}});
        s.close();
    }

    public void testGetResource() throws SQLException {
        DatabaseClassLoadingTest.getResourceTests(this.getConnection());
    }

    private static void getResourceTests(Connection conn) throws SQLException {
        PreparedStatement ps = conn.prepareStatement("VALUES EMC.GETARTICLE(?)");
        ps.setString(1, "graduate.txt");
        JDBC.assertSingleValueResultSet(ps.executeQuery(), "The Apache Foundation has released the first version of the open-source Derby database, which also gained support from Sun Microsystems.");
        ps.setString(1, "/article/release.txt");
        JDBC.assertSingleValueResultSet(ps.executeQuery(), "The Apache Derby development community is pleased to announce its first release after graduating from the Apache Incubator, Apache Derby 10.1.1.0.");
        ps.setString(1, "barney.txt");
        JDBC.assertSingleValueResultSet(ps.executeQuery(), null);
        ps.setString(1, "/article/fred.txt");
        JDBC.assertSingleValueResultSet(ps.executeQuery(), null);
        ps.setString(1, "emc.class");
        JDBC.assertSingleValueResultSet(ps.executeQuery(), null);
        ps.setString(1, "/org/apache/derbyTesting/databaseclassloader/emc.class");
        JDBC.assertSingleValueResultSet(ps.executeQuery(), null);
        ps.close();
    }

    public void testAlterTable() throws SQLException {
        Statement s = this.createStatement();
        s.executeUpdate("ALTER TABLE EMC.CONTACTS ADD COLUMN OK SMALLINT");
        JDBC.assertFullResultSet(s.executeQuery("SELECT id, e_mail, ok from EMC.CONTACTS ORDER BY 1"), new String[][]{{"0", "now@classpathchange.com", null}, {"1", "bill@ruletheworld.com", null}, {"2", "penguin@antartic.com", null}});
        CallableStatement cs = this.prepareCall("CALL EMC.ADDCONTACT(?, ?)");
        cs.setInt(1, 3);
        cs.setString(2, "big@blue.com");
        cs.executeUpdate();
        cs.close();
        JDBC.assertFullResultSet(s.executeQuery("SELECT id, e_mail, ok from EMC.CONTACTS ORDER BY 1"), new String[][]{{"0", "now@classpathchange.com", null}, {"1", "bill@ruletheworld.com", null}, {"2", "penguin@antartic.com", null}, {"3", "big@blue.com", null}});
        s.close();
    }

    public void testClassPathRollback() throws SQLException, MalformedURLException {
        this.getConnection().setAutoCommit(false);
        this.replaceJar("dcl_emc2.jar", "EMC.MAIL_APP");
        CallableStatement cs = this.prepareCall("CALL EMC.ADDCONTACT(?, ?)");
        cs.setInt(1, 99);
        cs.setString(2, "wormspam@soil.com");
        cs.executeUpdate();
        Statement s = this.createStatement();
        JDBC.assertFullResultSet(s.executeQuery("SELECT id, e_mail, ok from EMC.CONTACTS WHERE ID = 99"), new String[][]{{"99", "wormspam@soil.com", "0"}});
        this.rollback();
        this.getConnection().setAutoCommit(true);
        cs.executeUpdate();
        cs.close();
        JDBC.assertFullResultSet(s.executeQuery("SELECT id, e_mail, ok from EMC.CONTACTS WHERE ID = 99"), new String[][]{{"99", "wormspam@soil.com", null}});
        s.executeUpdate("DELETE FROM EMC.CONTACTS WHERE ID = 99");
        s.close();
    }

    public void testReplaceJar() throws SQLException, MalformedURLException {
        this.replaceJar("dcl_emc2.jar", "EMC.MAIL_APP");
    }

    public void testReplacedClass() throws SQLException {
        CallableStatement cs = this.prepareCall("CALL EMC.ADDCONTACT(?, ?)");
        cs.setInt(1, 4);
        cs.setString(2, "spammer@ripoff.com");
        cs.executeUpdate();
        cs.setInt(1, 5);
        cs.setString(2, "open@source.org");
        cs.executeUpdate();
        Statement s = this.createStatement();
        JDBC.assertFullResultSet(s.executeQuery("SELECT id, e_mail, ok from EMC.CONTACTS ORDER BY 1"), new String[][]{{"0", "now@classpathchange.com", null}, {"1", "bill@ruletheworld.com", null}, {"2", "penguin@antartic.com", null}, {"3", "big@blue.com", null}, {"4", "spammer@ripoff.com", "0"}, {"5", "open@source.org", "1"}});
        s.close();
    }

    public void testSecondJar() throws SQLException, MalformedURLException {
        this.installJar("dcl_emcaddon.jar", "\"emcAddOn\".\"MailAddOn\"");
        this.setDBClasspath("EMC.MAIL_APP:\"emcAddOn\".\"MailAddOn\"");
        Statement s = this.createStatement();
        JDBC.assertFullResultSet(s.executeQuery("SELECT E_MAIL, \"emcAddOn\".VALIDCONTACT(E_MAIL) FROM EMC.CONTACTS ORDER BY 1"), new String[][]{{"big@blue.com", "0"}, {"bill@ruletheworld.com", "0"}, {"now@classpathchange.com", "0"}, {"open@source.org", "1"}, {"penguin@antartic.com", "0"}, {"spammer@ripoff.com", "0"}});
        s.close();
    }

    public void testSignedJar() throws SQLException, MalformedURLException {
        PreparedStatement ps = this.prepareStatement("VALUES EMC.GETSIGNERS(?)");
        ps.setString(1, "org.apache.derbyTesting.databaseclassloader.emc");
        JDBC.assertSingleValueResultSet(ps.executeQuery(), null);
        this.replaceJar("dcl_emc2s.jar", "EMC.MAIL_APP");
        ps.close();
        DatabaseClassLoadingTest.signersTests(this.getConnection());
    }

    private static void signersTests(Connection conn) throws SQLException {
        PreparedStatement ps = conn.prepareStatement("VALUES EMC.GETSIGNERS(?)");
        ps.setString(1, "org.apache.derbyTesting.databaseclassloader.emc");
        JDBC.assertSingleValueResultSet(ps.executeQuery(), "CN=EMC CTO, OU=EMC APP, O=Easy Mail Company, C=US");
        ps.setString(1, "org.apache.derbyTesting.databaseclassloader.addon.vendor.util");
        JDBC.assertSingleValueResultSet(ps.executeQuery(), null);
        ps.close();
    }

    public void testHackedJarReplacedClass() throws SQLException, MalformedURLException {
        this.replaceJar("dcl_emc2sm.jar", "EMC.MAIL_APP");
        try {
            CallableStatement cs = this.prepareCall("CALL EMC.ADDCONTACT(?, ?)");
            cs.setInt(1, 99);
            cs.setString(2, "spamking@cracker.org");
            cs.executeUpdate();
            cs.close();
            DatabaseClassLoadingTest.fail((String)"procedure call worked on hacked jar");
        }
        catch (SQLException e) {
            DatabaseClassLoadingTest.assertSQLState("Class load should fail due to invalid signature", "42X51", e);
        }
    }

    public void testInvalidJar() throws SQLException, MalformedURLException {
        this.replaceJar("dcl_emc2l.jar", "EMC.MAIL_APP");
        try {
            CallableStatement cs = this.prepareCall("CALL EMC.ADDCONTACT(?, ?)");
            cs.setInt(1, 999);
            cs.setString(2, "spamking2@cracker.org");
            cs.executeUpdate();
            cs.close();
            DatabaseClassLoadingTest.fail((String)"procedure call worked on invalid jar");
        }
        catch (SQLException e) {
            DatabaseClassLoadingTest.assertSQLState("Class load should fail due to invalid jar", "42X51", e);
        }
    }

    public void testRemoveJar() throws SQLException {
        CallableStatement cs = this.prepareCall("CALL SQLJ.REMOVE_JAR(?, 0)");
        cs.setString(1, "EMC.MAIL_APP");
        try {
            cs.executeUpdate();
            DatabaseClassLoadingTest.fail((String)"REMOVE_JAR on jar in derby.database.classpath worked");
        }
        catch (SQLException e) {
            DatabaseClassLoadingTest.assertSQLState("X0X07", e);
        }
        this.setDBClasspath("\"emcAddOn\".\"MailAddOn\"");
        this.testWithNoInstalledJars();
        cs.executeUpdate();
        this.testWithNoInstalledJars();
        this.setDBClasspath(null);
        cs.setString(1, "\"emcAddOn\".\"MailAddOn\"");
        cs.executeUpdate();
        cs.close();
    }

    public void testCreateDatabaseJar() throws Exception {
        CallableStatement cs = this.prepareCall("CALL SYSCS_UTIL.SYSCS_CHECKPOINT_DATABASE()");
        cs.executeUpdate();
        cs.close();
        cs = this.prepareCall("CALL SYSCS_UTIL.SYSCS_BACKUP_DATABASE_NOWAIT(?)");
        final File backupDir = SupportFilesSetup.getReadWrite("dbreadonly");
        cs.setString(1, backupDir.getPath());
        cs.executeUpdate();
        cs.close();
        final String db = this.getTestConfiguration().getDefaultDatabaseName();
        AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                DatabaseClassLoadingTest.createArchive("dclt.jar", new File(backupDir, db), "dbro");
                return null;
            }
        });
    }

    public void testDatabaseInJar() throws SQLException {
        File jarFile = SupportFilesSetup.getReadOnly("dclt.jar");
        String dbName = "jar:(" + jarFile.getAbsolutePath() + ")dbro";
        DataSource ds = JDBCDataSource.getDataSource(dbName);
        DatabaseClassLoadingTest.readOnlyTest(ds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDatabaseInClasspath() throws SQLException, MalformedURLException {
        String dbName = "classpath:dbro";
        DataSource ds = JDBCDataSource.getDataSource(dbName);
        try {
            ds.getConnection();
            DatabaseClassLoadingTest.fail((String)"opened database before it was on classpath");
        }
        catch (SQLException e) {
            DatabaseClassLoadingTest.assertSQLState("XJ004", e);
        }
        URL jarURL = SupportFilesSetup.getReadOnlyURL("dclt.jar");
    }

    public void testLoadJavaClassIndirectly() throws SQLException, MalformedURLException {
        this.loadJavaClass("org.apache.derbyTesting.databaseclassloader.cracker.C1.simple", "38000");
    }

    public void testLoadJavaClassDirectly() throws SQLException, MalformedURLException {
        this.loadJavaClass("java.sql.J1.simple", "XJ001");
    }

    public void testLoadJavaClassDirectly2() throws SQLException, MalformedURLException {
        this.loadJavaClass("java.derby99.J2.simple", "XJ001");
    }

    public void testLoadJavaClassDirectly3() throws SQLException, MalformedURLException {
        this.loadJavaClass("javax.derby99.J3.simple", "XJ001");
    }

    public void testLoadDerbyClassIndirectly() throws SQLException, MalformedURLException {
        this.loadJavaClass("org.apache.derbyTesting.databaseclassloader.cracker.C1.derby", "38000");
    }

    private void loadJavaClass(String method, String expectedSQLState) throws SQLException, MalformedURLException {
        String jarName = "EMC.MY_JAVA";
        this.installJar("dcl_java.jar", jarName);
        this.setDBClasspath(jarName);
        Statement s = this.createStatement();
        s.execute("CREATE PROCEDURE C1() LANGUAGE JAVA PARAMETER STYLE JAVA NO SQL EXTERNAL NAME '" + method + "'");
        try {
            s.execute("CALL C1()");
            DatabaseClassLoadingTest.fail((String)"Call to procedure loading java class from installed jar");
        }
        catch (SQLException sqle) {
            DatabaseClassLoadingTest.assertSQLState(expectedSQLState, sqle);
        }
        s.execute("DROP PROCEDURE C1");
        s.close();
        this.setDBClasspath(null);
        this.removeJar(jarName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readOnlyTest(DataSource ds) throws SQLException {
        try {
            Connection conn = ds.getConnection();
            Statement s = conn.createStatement();
            JDBC.assertFullResultSet(s.executeQuery("SELECT id, e_mail, ok from EMC.CONTACTS ORDER BY 1"), new String[][]{{"0", "now@classpathchange.com", null}, {"1", "bill@ruletheworld.com", null}, {"2", "penguin@antartic.com", null}, {"3", "big@blue.com", null}, {"4", "spammer@ripoff.com", "0"}, {"5", "open@source.org", "1"}});
            JDBC.assertFullResultSet(s.executeQuery("SELECT id, e_mail, \"emcAddOn\".VALIDCONTACT(e_mail) from EMC.CONTACTS ORDER BY 1"), new String[][]{{"0", "now@classpathchange.com", "0"}, {"1", "bill@ruletheworld.com", "0"}, {"2", "penguin@antartic.com", "0"}, {"3", "big@blue.com", "0"}, {"4", "spammer@ripoff.com", "0"}, {"5", "open@source.org", "1"}});
            DatabaseClassLoadingTest.assertStatementError("25502", s, "INSERT INTO EMC.CONTACTS values(3, 'no@is_read_only.gov', NULL)");
            DatabaseClassLoadingTest.assertStatementError("25502", s, "CALL EMC.ADDCONTACT(3, 'really@is_read_only.gov')");
            DatabaseClassLoadingTest.getResourceTests(conn);
            conn.setAutoCommit(false);
            JDBC.assertDrainResults(s.executeQuery("select * from EMC.CONTACTS WITH RR"));
            JDBC.assertFullResultSet(s.executeQuery("select TYPE, MODE, TABLENAME from syscs_diag.lock_table"), new String[][]{{"TABLE", "S", "CONTACTS"}});
            s.close();
            conn.rollback();
            conn.setAutoCommit(true);
            conn.close();
        }
        finally {
            JDBCDataSource.shutdownDatabase(ds);
        }
    }

    public void testClassLoadOrdering() throws SQLException, MalformedURLException {
        Statement s = this.createStatement();
        s.executeUpdate("CREATE SCHEMA OT");
        s.execute("create function OT.WHICH_LOADER1(classname VARCHAR(256)) RETURNS VARCHAR(10) NO SQL external name 'org.apache.derbyTesting.databaseclassloader.ot.OrderTest1.whichLoader' language java parameter style java");
        s.execute("create function OT.WHICH_LOADER2(classname VARCHAR(256)) RETURNS VARCHAR(10) NO SQL external name 'org.apache.derbyTesting.databaseclassloader.ot.OrderTest2.whichLoader' language java parameter style java");
        s.execute("create function OT.WHICH_LOADER3(classname VARCHAR(256)) RETURNS VARCHAR(10) NO SQL external name 'org.apache.derbyTesting.databaseclassloader.ot.OrderTest3.whichLoader' language java parameter style java");
        this.installJar("dcl_ot1.jar", "OT.OT1");
        this.installJar("dcl_ot2.jar", "OT.OT2");
        this.installJar("dcl_ot3.jar", "OT.OT3");
        this.checkLoading("123");
        this.checkLoading("132");
        this.checkLoading("213");
        this.checkLoading("231");
        this.checkLoading("321");
        this.checkLoading("312");
        s.close();
    }

    private void checkLoading(String order) throws SQLException {
        this.setDBClasspath("OT.OT1:OT.OT2:OT.OT3");
        PreparedStatement ps1 = this.prepareStatement("VALUES OT.WHICH_LOADER" + order.charAt(0) + "(?)");
        PreparedStatement ps2 = this.prepareStatement("VALUES OT.WHICH_LOADER" + order.charAt(1) + "(?)");
        PreparedStatement ps3 = this.prepareStatement("VALUES OT.WHICH_LOADER" + order.charAt(2) + "(?)");
        this.checkCorrectLoader("OrderTest1", ps1, ps2, ps3);
        this.checkCorrectLoader("OrderTest2", ps1, ps2, ps3);
        this.checkCorrectLoader("OrderTest3", ps1, ps2, ps3);
        this.checkCorrectLoader("OrderLoad1", ps1, ps2, ps3);
        this.checkCorrectLoader("OrderLoad2", ps1, ps2, ps3);
        this.checkCorrectLoader("OrderLoad3", ps1, ps2, ps3);
        this.checkCorrectLoader("OrderObject1", ps1, ps2, ps3);
        this.checkCorrectLoader("OrderObject2", ps1, ps2, ps3);
        this.checkCorrectLoader("OrderObject3", ps1, ps2, ps3);
        ps1.close();
        ps2.close();
        ps3.close();
        this.setDBClasspath(null);
    }

    private void checkCorrectLoader(String className, PreparedStatement ps1, PreparedStatement ps2, PreparedStatement ps3) throws SQLException {
        className = "org.apache.derbyTesting.databaseclassloader.ot." + className;
        String expectedLoader = "\"OT\".\"OT" + className.charAt(className.length() - 1) + "\"";
        ps1.setString(1, className);
        JDBC.assertSingleValueResultSet(ps1.executeQuery(), expectedLoader);
        ps2.setString(1, className);
        JDBC.assertSingleValueResultSet(ps2.executeQuery(), expectedLoader);
        ps3.setString(1, className);
        JDBC.assertSingleValueResultSet(ps3.executeQuery(), expectedLoader);
    }

    public void testIndirectLoading() throws SQLException, MalformedURLException {
        Statement s = this.createStatement();
        s.executeUpdate("CREATE SCHEMA ID");
        this.installJar("dcl_id.jar", "ID.IDCODE");
        this.setDBClasspath("ID.IDCODE");
        s.execute("CREATE PROCEDURE ID.SETDB(pkey VARCHAR(256), pvalue VARCHAR(256)) NO SQL external name 'org.apache.derbyTesting.databaseclassloader.id.IndirectLoad.setDB' language java parameter style java");
        CallableStatement ps = this.prepareCall("CALL ID.SETDB(?, ?)");
        ps.close();
        this.setDBClasspath(null);
        s.close();
    }

    public void testTableFunctionInJar() throws SQLException, MalformedURLException {
        if (JVMInfo.J2ME || JVMInfo.JDK_ID < 6) {
            return;
        }
        String jarName = "EMC.DUMMY_VTI";
        this.installJar("dummy_vti.jar", jarName);
        this.setDBClasspath(jarName);
        Statement s = this.createStatement();
        s.executeUpdate("create function reciprocal( original double ) returns double\nlanguage java\nparameter style java\nno sql\nexternal name 'DummyVTI.reciprocal'");
        s.executeUpdate("create function dummyVTI()\nreturns table( tablename varchar( 128 ) )\nlanguage java\nparameter style DERBY_JDBC_RESULT_SET\nreads sql data\nexternal name 'DummyVTI.dummyVTI'\n");
        s.executeUpdate("create function dummyVTI2()\nreturns table( tablename varchar( 128 ) )\nlanguage java\nparameter style DERBY_JDBC_RESULT_SET\nreads sql data\nexternal name 'DummyVTI2.dummyVTI'\n");
        JDBC.assertFullResultSet(s.executeQuery("values ( reciprocal( 2.0 ) )"), new String[][]{{"0.5"}});
        JDBC.assertFullResultSet(s.executeQuery("select * from table( dummyVTI() ) s where tablename='SYSTABLES'"), new String[][]{{"SYSTABLES"}});
        try {
            s.executeQuery("select * from table( dummyVTI2() ) s where tablename='SYSTABLES'");
            DatabaseClassLoadingTest.fail((String)"Should have seen a ClassNotFoundException.");
        }
        catch (SQLException e) {
            DatabaseClassLoadingTest.assertSQLState("XJ001", e);
        }
        this.setDBClasspath(null);
        s.close();
    }

    private void installJar(String resource, String jarName) throws SQLException, MalformedURLException {
        URL jar = SupportFilesSetup.getReadOnlyURL(resource);
        DatabaseClassLoadingTest.assertNotNull((String)resource, (Object)jar);
        CallableStatement cs = this.prepareCall("CALL SQLJ.INSTALL_JAR(?, ?, 0)");
        cs.setString(1, jar.toExternalForm());
        cs.setString(2, jarName);
        cs.executeUpdate();
        cs.close();
    }

    private void replaceJar(String resource, String jarName) throws SQLException, MalformedURLException {
        URL jar = SupportFilesSetup.getReadOnlyURL(resource);
        DatabaseClassLoadingTest.assertNotNull((String)resource, (Object)jar);
        CallableStatement cs = this.prepareCall("CALL SQLJ.REPLACE_JAR(?, ?)");
        cs.setString(1, jar.toExternalForm());
        cs.setString(2, jarName);
        cs.executeUpdate();
        cs.close();
    }

    private void removeJar(String jarName) throws SQLException {
        CallableStatement cs = this.prepareCall("CALL SQLJ.REMOVE_JAR(?, 0)");
        cs.setString(1, jarName);
        cs.executeUpdate();
        cs.close();
    }

    private void setDBClasspath(String cp) throws SQLException {
        CallableStatement cs = this.prepareCall("CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.database.classpath', ?)");
        cs.setString(1, cp);
        cs.executeUpdate();
        cs.close();
    }

    private void derby2035Workaround() throws SQLException {
        this.getConnection().close();
        this.getTestConfiguration().shutdownDatabase();
    }

    private static void createArchive(String jarName, File dbDir, String dbName) throws Exception {
        DatabaseClassLoadingTest.assertTrue((boolean)dbDir.isDirectory());
        File jarFile = SupportFilesSetup.getReadOnly(jarName);
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(jarFile));
        DatabaseClassLoadingTest.addEntries(zos, dbDir, dbName, dbDir.getPath().length());
        zos.close();
    }

    static void addEntries(ZipOutputStream zos, File dir, String dbName, int old) throws Exception {
        String[] list = dir.list();
        for (int i = 0; i < list.length; ++i) {
            File f = new File(dir, list[i]);
            if (f.isDirectory()) {
                DatabaseClassLoadingTest.addEntries(zos, f, dbName, old);
                continue;
            }
            DatabaseClassLoadingTest.addFile(zos, f, dbName, old);
        }
    }

    private static void addFile(ZipOutputStream zos, File f, String dbName, int old) throws IOException {
        int read;
        String s = f.getPath().replace(File.separatorChar, '/');
        s = s.substring(old);
        s = dbName.concat(s);
        ZipEntry ze = new ZipEntry(s);
        ze.setTime(f.lastModified());
        zos.putNextEntry(ze);
        byte[] buf = new byte[4096];
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(f));
        while ((read = in.read(buf)) != -1) {
            zos.write(buf, 0, read);
        }
        in.close();
        zos.closeEntry();
    }

    private static void setContextClassLoader(final URL url) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                URLClassLoader cl = url == null ? null : new URLClassLoader(new URL[]{url});
                Thread.currentThread().setContextClassLoader(cl);
                return null;
            }
        });
    }
}

