/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SecurityManagerSetup;

public class DBInJarTest
extends BaseJDBCTestCase {
    public DBInJarTest(String name) {
        super(name);
    }

    public void testConnectDBInJar() throws SQLException {
        Connection beforejarconn = DriverManager.getConnection("jdbc:derby:testjardb;create=true");
        Statement bjstmt = beforejarconn.createStatement();
        bjstmt.executeUpdate("CREATE TABLE TAB (I INT)");
        bjstmt.executeUpdate("INSERT INTO TAB VALUES(1)");
        this.shutdownDB("jdbc:derby:testjardb;shutdown=true");
        Statement stmt = this.createStatement();
        stmt.executeUpdate("CALL CREATEARCHIVE('testjardb.jar', 'testjardb','testjardb')");
        Connection jarconn = DriverManager.getConnection("jdbc:derby:jar:(testjardb.jar)testjardb");
        Statement s = jarconn.createStatement();
        ResultSet rs = s.executeQuery("SELECT * from TAB");
        JDBC.assertSingleValueResultSet(rs, "1");
        rs = jarconn.getMetaData().getSchemas();
        String[][] expectedRows = new String[][]{{"APP", null}, {"NULLID", null}, {"SQLJ", null}, {"SYS", null}, {"SYSCAT", null}, {"SYSCS_DIAG", null}, {"SYSCS_UTIL", null}, {"SYSFUN", null}, {"SYSIBM", null}, {"SYSPROC", null}, {"SYSSTAT", null}};
        JDBC.assertFullResultSet(rs, expectedRows);
        this.shutdownDB("jdbc:derby:jar:(testjardb.jar)testjardb;shutdown=true");
        File jarreddb = new File(System.getProperty("derby.system.home") + "/testjardb.jar");
        DBInJarTest.assertTrue((String)("failed deleting " + jarreddb.getPath()), (boolean)jarreddb.delete());
        DBInJarTest.removeDirectory(new File(System.getProperty("derby.system.home") + "/testjardb"));
    }

    private void shutdownDB(String url) {
        try {
            DriverManager.getConnection(url);
            DBInJarTest.fail((String)"Expected exception on shutdown");
        }
        catch (SQLException se) {
            DBInJarTest.assertSQLState("08006", se);
        }
    }

    protected static Test baseSuite(String name) {
        TestSuite suite = new TestSuite(name);
        suite.addTestSuite(DBInJarTest.class);
        return new CleanDatabaseTestSetup(SecurityManagerSetup.noSecurityManager((Test)suite)){

            protected void decorateSQL(Statement stmt) throws SQLException {
                stmt.execute("create procedure CREATEARCHIVE(jarName VARCHAR(20) , path VARCHAR(20), dbName VARCHAR(20)) LANGUAGE JAVA PARAMETER STYLE JAVA NO SQL EXTERNAL NAME 'org.apache.derbyTesting.functionTests.tests.lang.dbjarUtil.createArchive'");
            }
        };
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("DBInJarTest");
        suite.addTest(DBInJarTest.baseSuite("DBInJarTest:embedded"));
        return suite;
    }
}

