/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public final class CommentTest
extends BaseJDBCTestCase {
    public CommentTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestConfiguration.embeddedSuite(CommentTest.class);
    }

    public void testBracketedComments() throws Exception {
        Statement stmt = this.createStatement();
        JDBC.assertFullResultSet(stmt.executeQuery("/* a comment */ VALUES 1"), new String[][]{{"1"}});
        JDBC.assertFullResultSet(stmt.executeQuery("VALUES 1 /* a comment */"), new String[][]{{"1"}});
        JDBC.assertFullResultSet(stmt.executeQuery("VALUES /* a comment */ 1"), new String[][]{{"1"}});
        JDBC.assertFullResultSet(stmt.executeQuery("VALUES /* a comment \n with newline */ 1"), new String[][]{{"1"}});
        JDBC.assertFullResultSet(stmt.executeQuery("VALUES /* SELECT * from FOO */ 1"), new String[][]{{"1"}});
        JDBC.assertFullResultSet(stmt.executeQuery("VALUES /* a comment /* nested comment */ */ 1"), new String[][]{{"1"}});
        JDBC.assertFullResultSet(stmt.executeQuery("VALUES /*/* XXX /*/*/* deeply nested comment */*/*/YYY*/*/ 1"), new String[][]{{"1"}});
        JDBC.assertFullResultSet(stmt.executeQuery("VALUES 1 --/*/* XXX /*/*/* deeply nested comment */*/*/YYY*/*/ 1"), new String[][]{{"1"}});
        JDBC.assertFullResultSet(stmt.executeQuery("VALUES 1 --/*/* XXX /*/*/* deeply nested comment */*/*/YYY*/*/ 1--/*"), new String[][]{{"1"}});
        JDBC.assertFullResultSet(stmt.executeQuery("VALUES /* a comment --\n with newline */ 1"), new String[][]{{"1"}});
        JDBC.assertFullResultSet(stmt.executeQuery("VALUES /* a comment -- */ 1"), new String[][]{{"1"}});
        JDBC.assertFullResultSet(stmt.executeQuery("VALUES /* a comment \n-- */ 1"), new String[][]{{"1"}});
        JDBC.assertFullResultSet(stmt.executeQuery("VALUES '/* a comment \n-- */'"), new String[][]{{"/* a comment \n-- */"}});
        this.assertCompileError("42X02", "VALUES 1 /*");
        this.assertCompileError("42X02", "VALUES 1 /* comment");
        this.assertCompileError("42X02", "VALUES 1 /* comment /*");
        this.assertCompileError("42X02", "VALUES 1 /* comment /* nested */");
        this.assertCompileError("42X01", "/* this is a comment */");
        this.assertCompileError("42X01", "-- this is a comment \n");
    }

    protected void initializeConnection(Connection conn) throws SQLException {
        conn.setAutoCommit(false);
    }
}

