/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class Bug5054Test
extends BaseJDBCTestCase {
    public Bug5054Test(String name) {
        super(name);
    }

    protected void initializeConnection(Connection conn) throws SQLException {
        conn.setAutoCommit(false);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("Bug5054Test");
        CleanDatabaseTestSetup test = new CleanDatabaseTestSetup(TestConfiguration.embeddedSuite(Bug5054Test.class)){

            protected void decorateSQL(Statement stmt) throws SQLException {
                stmt.executeUpdate("CREATE TABLE T1 (a integer, b integer)");
                stmt.executeUpdate("INSERT INTO T1 VALUES(1, 1)");
                stmt.executeUpdate("INSERT INTO T1 VALUES(2, 2)");
            }
        };
        suite.addTest((Test)test);
        suite.addTest(TestConfiguration.clientServerDecorator((Test)test));
        return suite;
    }

    public void testBugBug5054() throws SQLException {
        Statement stmt1 = this.createStatement();
        stmt1.setCursorName("aBc");
        ResultSet rs = stmt1.executeQuery("select * from t1 for update");
        rs.next();
        Statement stmt2 = this.createStatement();
        stmt2.execute("update t1 set b=11 where current of \"" + rs.getCursorName() + "\"");
        Statement stmt3 = this.createStatement();
        rs = stmt3.executeQuery("SELECT * FROM T1");
        JDBC.assertFullResultSet(rs, new String[][]{{"1", "11"}, {"2", "2"}});
        rs.close();
    }
}

