/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetReader;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetStream;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.TestConfiguration;

public class StreamTest
extends BaseJDBCTestCase {
    private static final String LANG_STREAM_RETRIEVED_ALREADY = "XCL18";

    public StreamTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.getConnection().setAutoCommit(false);
    }

    protected void tearDown() throws Exception {
        this.rollback();
        super.tearDown();
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(StreamTest.class);
    }

    public void testGetStreamTwiceSmallBlob() throws SQLException, IOException {
        this.insertBlobData(512);
        this.runGetStreamTwiceTest();
    }

    public void testGetStreamTwiceLargeBlob() throws SQLException, IOException {
        this.insertBlobData(524288);
        this.runGetStreamTwiceTest();
    }

    public void testGetReaderTwiceSmallClob() throws SQLException, IOException {
        this.insertClobData(512);
        this.runGetReaderTwiceTest();
    }

    public void testGetReaderTwiceLargeClob() throws SQLException, IOException {
        this.insertClobData(524288);
        this.runGetReaderTwiceTest();
    }

    private void insertBlobData(int blobSize) throws SQLException {
        Statement stmt = this.createStatement();
        stmt.executeUpdate("CREATE TABLE testLob  (b blob(" + blobSize + "))");
        stmt.close();
        PreparedStatement ps = this.prepareStatement("insert into testLob values(?)");
        LoopingAlphabetStream stream = new LoopingAlphabetStream(blobSize);
        ps.setBinaryStream(1, (InputStream)stream, blobSize);
        ps.executeUpdate();
        ps.close();
    }

    private void insertClobData(int clobSize) throws SQLException {
        Statement stmt = this.createStatement();
        stmt.executeUpdate("CREATE TABLE testLob  (c clob(" + clobSize + "))");
        stmt.close();
        PreparedStatement ps = this.prepareStatement("insert into testLob values(?)");
        LoopingAlphabetReader reader = new LoopingAlphabetReader(clobSize);
        ps.setCharacterStream(1, (Reader)reader, clobSize);
        ps.executeUpdate();
        ps.close();
    }

    private void runGetStreamTwiceTest() throws SQLException, IOException {
        InputStream is = null;
        Statement st = this.createStatement();
        ResultSet rs = st.executeQuery("select * from testLob");
        StreamTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        StreamTest.println("get stream from testLob ...");
        is = rs.getBinaryStream(1);
        is.close();
        try {
            StreamTest.println("get stream from testLob again ...");
            is = rs.getBinaryStream(1);
            StreamTest.fail((String)"FAIL - Expected exception did not happen.");
        }
        catch (SQLException se) {
            StreamTest.assertSQLState(LANG_STREAM_RETRIEVED_ALREADY, se);
        }
        rs.close();
        st.close();
    }

    public void runGetReaderTwiceTest() throws SQLException, IOException {
        Reader reader = null;
        Statement st = this.createStatement();
        ResultSet rs = st.executeQuery("select * from testLob");
        StreamTest.assertTrue((String)"FAIL - row not found", (boolean)rs.next());
        StreamTest.println("get reader from testLob ...");
        reader = rs.getCharacterStream(1);
        reader.close();
        try {
            StreamTest.println("get reader from testLob again ...");
            reader = rs.getCharacterStream(1);
            StreamTest.fail((String)"FAIL - Expected exception did not happen.");
        }
        catch (SQLException se) {
            StreamTest.assertSQLState(LANG_STREAM_RETRIEVED_ALREADY, se);
        }
        rs.close();
        st.close();
    }
}

