/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ProcedureTest
extends BaseJDBCTestCase {
    private static final String[] PROCEDURES = new String[]{"CREATE PROCEDURE RETRIEVE_DYNAMIC_RESULTS(number INT) LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + ProcedureTest.class.getName() + ".retrieveDynamicResults' " + "DYNAMIC RESULT SETS 4", "CREATE PROCEDURE RETRIEVE_CLOSED_RESULT() LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + ProcedureTest.class.getName() + ".retrieveClosedResult' " + "DYNAMIC RESULT SETS 1", "CREATE PROCEDURE RETRIEVE_EXTERNAL_RESULT(DBNAME VARCHAR(128), DBUSER VARCHAR(128), DBPWD VARCHAR(128)) LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + ProcedureTest.class.getName() + ".retrieveExternalResult' " + "DYNAMIC RESULT SETS 1", "CREATE PROCEDURE PROC_WITH_SIDE_EFFECTS(ret INT) LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + ProcedureTest.class.getName() + ".procWithSideEffects' " + "DYNAMIC RESULT SETS 2", "CREATE PROCEDURE NESTED_RESULT_SETS(proctext VARCHAR(128)) LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + ProcedureTest.class.getName() + ".nestedDynamicResultSets' " + "DYNAMIC RESULT SETS 6"};
    private static final String[][] TABLES = new String[][]{{"SIMPLE_TABLE", "CREATE TABLE SIMPLE_TABLE (id INT)"}};

    public ProcedureTest(String name) {
        super(name);
    }

    public void testExecuteQueryWithNoDynamicResultSets() throws SQLException {
        Statement stmt = this.createStatement();
        try {
            stmt.executeQuery("CALL RETRIEVE_DYNAMIC_RESULTS(0)");
            ProcedureTest.fail((String)"executeQuery() didn't fail.");
        }
        catch (SQLException sqle) {
            this.assertNoResultSetFromExecuteQuery(sqle);
        }
    }

    public void testExecuteQueryWithOneDynamicResultSet() throws SQLException {
        Statement stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery("CALL RETRIEVE_DYNAMIC_RESULTS(1)");
        ProcedureTest.assertNotNull((String)"executeQuery() returned null.", (Object)rs);
        ProcedureTest.assertSame((Object)stmt, (Object)rs.getStatement());
        JDBC.assertDrainResultsHasData(rs);
    }

    public void testExecuteQueryWithMoreThanOneDynamicResultSet() throws SQLException {
        Statement stmt = this.createStatement();
        try {
            stmt.executeQuery("CALL RETRIEVE_DYNAMIC_RESULTS(2)");
            ProcedureTest.fail((String)"executeQuery() didn't fail.");
        }
        catch (SQLException sqle) {
            this.assertMultipleResultsFromExecuteQuery(sqle);
        }
    }

    public void testExecuteUpdateWithNoDynamicResultSets() throws SQLException {
        Statement stmt = this.createStatement();
        ProcedureTest.assertUpdateCount(stmt, 0, "CALL RETRIEVE_DYNAMIC_RESULTS(0)");
        JDBC.assertNoMoreResults(stmt);
    }

    public void testExecuteUpdateWithOneDynamicResultSet() throws SQLException {
        Statement stmt = this.createStatement();
        try {
            stmt.executeUpdate("CALL RETRIEVE_DYNAMIC_RESULTS(1)");
            ProcedureTest.fail((String)"executeUpdate() didn't fail.");
        }
        catch (SQLException sqle) {
            this.assertResultsFromExecuteUpdate(sqle);
        }
    }

    public void testExecuteQueryWithNoDynamicResultSets_prepared() throws SQLException {
        PreparedStatement ps = this.prepareStatement("CALL RETRIEVE_DYNAMIC_RESULTS(?)");
        ps.setInt(1, 0);
        try {
            ps.executeQuery();
            ProcedureTest.fail((String)"executeQuery() didn't fail.");
        }
        catch (SQLException sqle) {
            this.assertNoResultSetFromExecuteQuery(sqle);
        }
    }

    public void testExecuteQueryWithOneDynamicResultSet_prepared() throws SQLException {
        PreparedStatement ps = this.prepareStatement("CALL RETRIEVE_DYNAMIC_RESULTS(?)");
        ps.setInt(1, 1);
        ResultSet rs = ps.executeQuery();
        ProcedureTest.assertNotNull((String)"executeQuery() returned null.", (Object)rs);
        ProcedureTest.assertSame((Object)ps, (Object)rs.getStatement());
        JDBC.assertDrainResultsHasData(rs);
    }

    public void testExecuteQueryWithMoreThanOneDynamicResultSet_prepared() throws SQLException {
        PreparedStatement ps = this.prepareStatement("CALL RETRIEVE_DYNAMIC_RESULTS(?)");
        ps.setInt(1, 2);
        try {
            ps.executeQuery();
            ProcedureTest.fail((String)"executeQuery() didn't fail.");
        }
        catch (SQLException sqle) {
            this.assertMultipleResultsFromExecuteQuery(sqle);
        }
    }

    public void testExecuteUpdateWithNoDynamicResultSets_prepared() throws SQLException {
        PreparedStatement ps = this.prepareStatement("CALL RETRIEVE_DYNAMIC_RESULTS(?)");
        ps.setInt(1, 0);
        ProcedureTest.assertUpdateCount(ps, 0);
        JDBC.assertNoMoreResults(ps);
    }

    public void testExecuteUpdateWithOneDynamicResultSet_prepared() throws SQLException {
        PreparedStatement ps = this.prepareStatement("CALL RETRIEVE_DYNAMIC_RESULTS(?)");
        ps.setInt(1, 1);
        try {
            ps.executeUpdate();
            ProcedureTest.fail((String)"executeUpdate() didn't fail.");
        }
        catch (SQLException sqle) {
            this.assertResultsFromExecuteUpdate(sqle);
        }
    }

    public void testExecuteQueryWithNoDynamicResultSets_callable() throws SQLException {
        CallableStatement cs = this.prepareCall("CALL RETRIEVE_DYNAMIC_RESULTS(?)");
        cs.setInt(1, 0);
        try {
            cs.executeQuery();
            ProcedureTest.fail((String)"executeQuery() didn't fail.");
        }
        catch (SQLException sqle) {
            this.assertNoResultSetFromExecuteQuery(sqle);
        }
    }

    public void testExecuteQueryWithOneDynamicResultSet_callable() throws SQLException {
        CallableStatement cs = this.prepareCall("CALL RETRIEVE_DYNAMIC_RESULTS(?)");
        cs.setInt(1, 1);
        ResultSet rs = cs.executeQuery();
        ProcedureTest.assertNotNull((String)"executeQuery() returned null.", (Object)rs);
        ProcedureTest.assertSame((Object)cs, (Object)rs.getStatement());
        JDBC.assertDrainResultsHasData(rs);
    }

    public void testExecuteQueryWithMoreThanOneDynamicResultSet_callable() throws SQLException {
        CallableStatement cs = this.prepareCall("CALL RETRIEVE_DYNAMIC_RESULTS(?)");
        cs.setInt(1, 2);
        try {
            cs.executeQuery();
            ProcedureTest.fail((String)"executeQuery() didn't fail.");
        }
        catch (SQLException sqle) {
            this.assertMultipleResultsFromExecuteQuery(sqle);
        }
    }

    public void testExecuteUpdateWithNoDynamicResultSets_callable() throws SQLException {
        CallableStatement cs = this.prepareCall("CALL RETRIEVE_DYNAMIC_RESULTS(?)");
        cs.setInt(1, 0);
        ProcedureTest.assertUpdateCount(cs, 0);
        JDBC.assertNoMoreResults(cs);
    }

    public void testExecuteUpdateWithOneDynamicResultSet_callable() throws SQLException {
        CallableStatement cs = this.prepareCall("CALL RETRIEVE_DYNAMIC_RESULTS(?)");
        cs.setInt(1, 1);
        try {
            cs.executeUpdate();
            ProcedureTest.fail((String)"executeUpdate() didn't fail.");
        }
        catch (SQLException sqle) {
            this.assertResultsFromExecuteUpdate(sqle);
        }
    }

    public void testRollbackStoredProcWithExecuteQuery() throws SQLException {
        Statement stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery("CALL PROC_WITH_SIDE_EFFECTS(1)");
        rs.close();
        this.rollback();
        JDBC.assertEmpty(stmt.executeQuery("SELECT * FROM SIMPLE_TABLE"));
    }

    public void testRollbackStoredProcWithExecuteUpdate() throws SQLException {
        Statement stmt = this.createStatement();
        stmt.executeUpdate("CALL PROC_WITH_SIDE_EFFECTS(0)");
        this.rollback();
        JDBC.assertEmpty(stmt.executeQuery("SELECT * FROM SIMPLE_TABLE"));
    }

    public void testRollbackStoredProcWhenExecuteQueryReturnsNothing() throws SQLException {
        Connection conn = this.getConnection();
        conn.setAutoCommit(true);
        Statement stmt = this.createStatement();
        try {
            stmt.executeQuery("CALL PROC_WITH_SIDE_EFFECTS(0)");
            ProcedureTest.fail((String)"executeQuery() didn't fail.");
        }
        catch (SQLException sqle) {
            this.assertNoResultSetFromExecuteQuery(sqle);
        }
        JDBC.assertEmpty(stmt.executeQuery("SELECT * FROM SIMPLE_TABLE"));
    }

    public void testRollbackStoredProcWhenExecuteQueryReturnsTooMuch() throws SQLException {
        Connection conn = this.getConnection();
        conn.setAutoCommit(true);
        Statement stmt = this.createStatement();
        try {
            stmt.executeQuery("CALL PROC_WITH_SIDE_EFFECTS(2)");
            ProcedureTest.fail((String)"executeQuery() didn't fail.");
        }
        catch (SQLException sqle) {
            this.assertMultipleResultsFromExecuteQuery(sqle);
        }
        JDBC.assertEmpty(stmt.executeQuery("SELECT * FROM SIMPLE_TABLE"));
    }

    public void testRollbackStoredProcWhenExecuteUpdateReturnsResults() throws SQLException {
        Connection conn = this.getConnection();
        conn.setAutoCommit(true);
        Statement stmt = this.createStatement();
        try {
            stmt.executeUpdate("CALL PROC_WITH_SIDE_EFFECTS(1)");
            ProcedureTest.fail((String)"executeUpdate() didn't fail.");
        }
        catch (SQLException sqle) {
            this.assertResultsFromExecuteUpdate(sqle);
        }
        JDBC.assertEmpty(stmt.executeQuery("SELECT * FROM SIMPLE_TABLE"));
    }

    public void testRollbackStoredProcWhenExecuteQueryReturnsNothing_prepared() throws SQLException {
        Connection conn = this.getConnection();
        conn.setAutoCommit(true);
        PreparedStatement ps = this.prepareStatement("CALL PROC_WITH_SIDE_EFFECTS(?)");
        ps.setInt(1, 0);
        try {
            ps.executeQuery();
            ProcedureTest.fail((String)"executeQuery() didn't fail.");
        }
        catch (SQLException sqle) {
            this.assertNoResultSetFromExecuteQuery(sqle);
        }
        Statement stmt = this.createStatement();
        JDBC.assertEmpty(stmt.executeQuery("SELECT * FROM SIMPLE_TABLE"));
    }

    public void testRollbackStoredProcWhenExecuteQueryReturnsTooMuch_prepared() throws SQLException {
        Connection conn = this.getConnection();
        conn.setAutoCommit(true);
        PreparedStatement ps = this.prepareStatement("CALL PROC_WITH_SIDE_EFFECTS(?)");
        ps.setInt(1, 2);
        try {
            ps.executeQuery();
            ProcedureTest.fail((String)"executeQuery() didn't fail.");
        }
        catch (SQLException sqle) {
            this.assertMultipleResultsFromExecuteQuery(sqle);
        }
        Statement stmt = this.createStatement();
        JDBC.assertEmpty(stmt.executeQuery("SELECT * FROM SIMPLE_TABLE"));
    }

    public void testRollbackStoredProcWhenExecuteUpdateReturnsResults_prepared() throws SQLException {
        Connection conn = this.getConnection();
        conn.setAutoCommit(true);
        PreparedStatement ps = this.prepareStatement("CALL PROC_WITH_SIDE_EFFECTS(?)");
        ps.setInt(1, 1);
        try {
            ps.executeUpdate();
            ProcedureTest.fail((String)"executeUpdate() didn't fail.");
        }
        catch (SQLException sqle) {
            this.assertResultsFromExecuteUpdate(sqle);
        }
        Statement stmt = this.createStatement();
        JDBC.assertEmpty(stmt.executeQuery("SELECT * FROM SIMPLE_TABLE"));
    }

    public void testClosedDynamicResultSetsFromExecuteQuery() throws SQLException {
        Statement stmt = this.createStatement();
        try {
            ResultSet rs = stmt.executeQuery("CALL RETRIEVE_CLOSED_RESULT()");
            ProcedureTest.fail((String)"executeQuery() didn't fail.");
        }
        catch (SQLException sqle) {
            this.assertNoResultSetFromExecuteQuery(sqle);
        }
    }

    public void testClosedDynamicResultSetsFromExecuteUpdate() throws SQLException {
        Statement stmt = this.createStatement();
        stmt.executeUpdate("CALL RETRIEVE_CLOSED_RESULT()");
        JDBC.assertNoMoreResults(stmt);
    }

    public void testDynamicResultSetsFromOtherConnectionWithExecuteQuery() throws SQLException {
        PreparedStatement ps = this.prepareStatement("CALL RETRIEVE_EXTERNAL_RESULT(?,?,?)");
        ps.setString(1, this.getTestConfiguration().getDefaultDatabaseName());
        ps.setString(2, this.getTestConfiguration().getUserName());
        ps.setString(3, this.getTestConfiguration().getUserPassword());
        try {
            ps.executeQuery();
            ProcedureTest.fail((String)"executeQuery() didn't fail.");
        }
        catch (SQLException sqle) {
            this.assertNoResultSetFromExecuteQuery(sqle);
        }
    }

    public void testDynamicResultSetsFromOtherConnectionWithExecuteUpdate() throws SQLException {
        PreparedStatement ps = this.prepareStatement("CALL RETRIEVE_EXTERNAL_RESULT(?,?,?)");
        ps.setString(1, this.getTestConfiguration().getDefaultDatabaseName());
        ps.setString(2, this.getTestConfiguration().getUserName());
        ps.setString(3, this.getTestConfiguration().getUserPassword());
        ps.executeUpdate();
        JDBC.assertNoMoreResults(ps);
    }

    private void assertNoResultSetFromExecuteQuery(SQLException sqle) {
        if (ProcedureTest.usingDB2Client()) {
            ProcedureTest.assertNull((String)"Unexpected SQL state.", (Object)sqle.getSQLState());
        } else {
            ProcedureTest.assertSQLState("Unexpected SQL state.", "X0Y78", sqle);
        }
    }

    private void assertMultipleResultsFromExecuteQuery(SQLException sqle) {
        if (ProcedureTest.usingDB2Client()) {
            ProcedureTest.assertNull((String)"Unexpected SQL state.", (Object)sqle.getSQLState());
        } else {
            ProcedureTest.assertSQLState("Unexpected SQL state.", "X0Y78", sqle);
        }
    }

    private void assertResultsFromExecuteUpdate(SQLException sqle) {
        if (ProcedureTest.usingDB2Client()) {
            ProcedureTest.assertNull((String)"Unexpected SQL state.", (Object)sqle.getSQLState());
        } else {
            ProcedureTest.assertSQLState("Unexpected SQL state.", "X0Y79", sqle);
        }
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("ProcedureTest");
        suite.addTest(ProcedureTest.baseSuite("ProcedureTest:embedded"));
        suite.addTest(TestConfiguration.clientServerDecorator(ProcedureTest.baseSuite("ProcedureTest:client")));
        return suite;
    }

    private static Test baseSuite(String name) {
        TestSuite suite = new TestSuite(name);
        if (!JDBC.vmSupportsJDBC3()) {
            return suite;
        }
        suite.addTestSuite(ProcedureTest.class);
        return new CleanDatabaseTestSetup((Test)suite){

            protected void decorateSQL(Statement s) throws SQLException {
                int i;
                for (i = 0; i < PROCEDURES.length; ++i) {
                    s.execute(PROCEDURES[i]);
                }
                for (i = 0; i < TABLES.length; ++i) {
                    s.execute(TABLES[i][1]);
                }
            }
        };
    }

    public void setUp() throws SQLException {
        Connection conn = this.getConnection();
        conn.setAutoCommit(false);
        Statement s = this.createStatement();
        for (int i = 0; i < TABLES.length; ++i) {
            s.execute("DELETE FROM " + TABLES[i][0]);
        }
        this.commit();
    }

    public static void retrieveDynamicResults(int number, ResultSet[] rs1, ResultSet[] rs2, ResultSet[] rs3, ResultSet[] rs4) throws SQLException {
        Connection c = DriverManager.getConnection("jdbc:default:connection");
        if (number > 0) {
            rs1[0] = c.createStatement().executeQuery("VALUES(1)");
        }
        if (number > 1) {
            rs2[0] = c.createStatement().executeQuery("VALUES(1)");
        }
        if (number > 2) {
            rs3[0] = c.createStatement().executeQuery("VALUES(1)");
        }
        if (number > 3) {
            rs4[0] = c.createStatement().executeQuery("VALUES(1)");
        }
        c.close();
    }

    public static void retrieveClosedResult(ResultSet[] closed) throws SQLException {
        Connection c = DriverManager.getConnection("jdbc:default:connection");
        closed[0] = c.createStatement().executeQuery("VALUES(1)");
        closed[0].close();
        c.close();
    }

    public static void retrieveExternalResult(String dbName, String user, String password, ResultSet[] external) throws SQLException {
        String url = "jdbc:derby:" + dbName;
        Connection conn = DriverManager.getConnection(url, user, password);
        external[0] = conn.createStatement().executeQuery("VALUES(1)");
    }

    public static void procWithSideEffects(int returnResults, ResultSet[] rs1, ResultSet[] rs2) throws SQLException {
        Connection c = DriverManager.getConnection("jdbc:default:connection");
        Statement stmt = c.createStatement();
        stmt.executeUpdate("INSERT INTO SIMPLE_TABLE VALUES (42)");
        if (returnResults > 0) {
            rs1[0] = c.createStatement().executeQuery("VALUES(1)");
        }
        if (returnResults > 1) {
            rs2[0] = c.createStatement().executeQuery("VALUES(1)");
        }
        c.close();
    }

    public static void nestedDynamicResultSets(String procedureText, ResultSet[] rs1, ResultSet[] rs2, ResultSet[] rs3, ResultSet[] rs4, ResultSet[] rs5, ResultSet[] rs6) throws SQLException {
        Connection c = DriverManager.getConnection("jdbc:default:connection");
        CallableStatement cs = c.prepareCall("CALL " + procedureText);
        cs.execute();
        rs6[0] = cs.getResultSet();
        if (!cs.getMoreResults(2)) {
            return;
        }
        rs3[0] = cs.getResultSet();
        if (!cs.getMoreResults(2)) {
            return;
        }
        rs4[0] = cs.getResultSet();
        if (!cs.getMoreResults(2)) {
            return;
        }
        rs2[0] = cs.getResultSet();
        if (!cs.getMoreResults(2)) {
            return;
        }
        rs1[0] = cs.getResultSet();
        if (!cs.getMoreResults(2)) {
            return;
        }
        rs5[0] = cs.getResultSet();
    }

    public void testGetMoreResults() throws SQLException {
        Statement s = this.createStatement();
        s.executeUpdate("create table MRS.FIVERS(i integer)");
        PreparedStatement ps = this.prepareStatement("insert into MRS.FIVERS values (?)");
        for (int i = 1; i <= 20; ++i) {
            ps.setInt(1, i);
            ps.executeUpdate();
        }
        s.executeUpdate("create procedure MRS.FIVEJP() parameter style JAVA READS SQL DATA dynamic result sets 5 language java external name 'org.apache.derbyTesting.functionTests.util.ProcedureTest.fivejp'");
        CallableStatement cs = this.prepareCall("CALL MRS.FIVEJP()");
        Object[] allRS = new ResultSet[5];
        this.defaultGetMoreResults(cs, (ResultSet[])allRS);
        Arrays.fill(allRS, null);
        this.closeCurrentGetMoreResults(cs, (ResultSet[])allRS);
        Arrays.fill(allRS, null);
        this.keepCurrentGetMoreResults(cs, (ResultSet[])allRS);
        Arrays.fill(allRS, null);
        this.mixedGetMoreResults(cs, (ResultSet[])allRS);
        Arrays.fill(allRS, null);
        this.checkExecuteClosesResults(cs, (ResultSet[])allRS);
        Arrays.fill(allRS, null);
        this.checkCSCloseClosesResults(cs, (ResultSet[])allRS);
        Arrays.fill(allRS, null);
        CallableStatement nestedCs = this.prepareCall("CALL NESTED_RESULT_SETS('MRS.FIVEJP()')");
        this.defaultGetMoreResults(nestedCs, (ResultSet[])allRS);
    }

    private void checkExecuteClosesResults(CallableStatement cs, ResultSet[] allRS) throws SQLException {
        int i;
        cs.execute();
        int pass = 0;
        do {
            allRS[pass++] = cs.getResultSet();
            ProcedureTest.assertSame((Object)cs, (Object)allRS[pass - 1].getStatement());
        } while (cs.getMoreResults(2));
        for (i = 0; i < 5; ++i) {
            JDBC.assertDrainResults(allRS[i]);
        }
        cs.execute();
        for (i = 0; i < 5; ++i) {
            JDBC.assertClosed(allRS[i]);
        }
    }

    private void checkCSCloseClosesResults(CallableStatement cs, ResultSet[] allRS) throws SQLException {
        int i;
        cs.execute();
        int pass = 0;
        do {
            allRS[pass++] = cs.getResultSet();
            ProcedureTest.assertSame((Object)cs, (Object)allRS[pass - 1].getStatement());
        } while (cs.getMoreResults(2));
        for (i = 0; i < 5; ++i) {
            JDBC.assertDrainResults(allRS[i]);
        }
        cs.close();
        for (i = 0; i < 5; ++i) {
            JDBC.assertClosed(allRS[i]);
        }
    }

    private void mixedGetMoreResults(CallableStatement cs, ResultSet[] allRS) throws SQLException {
        cs.execute();
        allRS[0] = cs.getResultSet();
        ProcedureTest.assertSame((Object)cs, (Object)allRS[0].getStatement());
        boolean moreRS = cs.getMoreResults(2);
        if (!moreRS) {
            ProcedureTest.fail((String)"FAIL - no second result set");
        }
        allRS[1] = cs.getResultSet();
        ProcedureTest.assertSame((Object)cs, (Object)allRS[1].getStatement());
        allRS[0].next();
        ProcedureTest.assertEquals((int)2, (int)allRS[0].getInt(1));
        allRS[1].next();
        ProcedureTest.assertEquals((int)3, (int)allRS[1].getInt(1));
        moreRS = cs.getMoreResults(1);
        if (!moreRS) {
            ProcedureTest.fail((String)"FAIL - no third result set");
        }
        allRS[2] = cs.getResultSet();
        ProcedureTest.assertSame((Object)cs, (Object)allRS[2].getStatement());
        ProcedureTest.assertEquals((int)2, (int)allRS[0].getInt(1));
        JDBC.assertClosed(allRS[1]);
        allRS[2].next();
        ProcedureTest.assertEquals((int)4, (int)allRS[2].getInt(1));
        moreRS = cs.getMoreResults(2);
        if (!moreRS) {
            ProcedureTest.fail((String)"FAIL - no fourth result set");
        }
        allRS[3] = cs.getResultSet();
        ProcedureTest.assertSame((Object)cs, (Object)allRS[3].getStatement());
        allRS[3].next();
        ProcedureTest.assertEquals((int)2, (int)allRS[0].getInt(1));
        JDBC.assertClosed(allRS[1]);
        ProcedureTest.assertEquals((int)4, (int)allRS[2].getInt(1));
        ProcedureTest.assertEquals((int)5, (int)allRS[3].getInt(1));
        moreRS = cs.getMoreResults(3);
        if (!moreRS) {
            ProcedureTest.fail((String)"FAIL - no fifth result set");
        }
        allRS[4] = cs.getResultSet();
        ProcedureTest.assertSame((Object)cs, (Object)allRS[4].getStatement());
        allRS[4].next();
        JDBC.assertClosed(allRS[0]);
        JDBC.assertClosed(allRS[1]);
        JDBC.assertClosed(allRS[2]);
        JDBC.assertClosed(allRS[3]);
        ProcedureTest.assertEquals((int)6, (int)allRS[4].getInt(1));
        moreRS = cs.getMoreResults(2);
        if (moreRS) {
            ProcedureTest.fail((String)"FAIL - too many result sets");
        }
        JDBC.assertClosed(allRS[0]);
        JDBC.assertClosed(allRS[1]);
        JDBC.assertClosed(allRS[2]);
        JDBC.assertClosed(allRS[3]);
        ProcedureTest.assertEquals((int)6, (int)allRS[4].getInt(1));
        allRS[4].close();
    }

    private void keepCurrentGetMoreResults(CallableStatement cs, ResultSet[] allRS) throws SQLException {
        int i;
        cs.execute();
        for (i = 0; i < 5; ++i) {
            allRS[i] = cs.getResultSet();
            ProcedureTest.assertSame((Object)cs, (Object)allRS[i].getStatement());
            allRS[i].next();
            ProcedureTest.assertEquals((int)(2 + i), (int)allRS[i].getInt(1));
            if (i < 4) {
                ProcedureTest.assertTrue((boolean)cs.getMoreResults(2));
                continue;
            }
            ProcedureTest.assertFalse((boolean)cs.getMoreResults(2));
        }
        for (i = 0; i < 5; ++i) {
            JDBC.assertDrainResults(allRS[i]);
        }
    }

    private void closeCurrentGetMoreResults(CallableStatement cs, ResultSet[] allRS) throws SQLException {
        int i;
        cs.execute();
        for (i = 0; i < 5; ++i) {
            allRS[i] = cs.getResultSet();
            ProcedureTest.assertSame((Object)cs, (Object)allRS[i].getStatement());
            allRS[i].next();
            ProcedureTest.assertEquals((int)(2 + i), (int)allRS[i].getInt(1));
            if (i < 4) {
                ProcedureTest.assertTrue((boolean)cs.getMoreResults(1));
                continue;
            }
            ProcedureTest.assertFalse((boolean)cs.getMoreResults(1));
        }
        for (i = 0; i < 5; ++i) {
            JDBC.assertClosed(allRS[i]);
        }
    }

    private void defaultGetMoreResults(CallableStatement cs, ResultSet[] allRS) throws SQLException {
        int i;
        cs.execute();
        for (i = 0; i < 5; ++i) {
            allRS[i] = cs.getResultSet();
            ProcedureTest.assertSame((Object)cs, (Object)allRS[i].getStatement());
            allRS[i].next();
            ProcedureTest.assertEquals((int)(2 + i), (int)allRS[i].getInt(1));
            if (i < 4) {
                ProcedureTest.assertTrue((boolean)cs.getMoreResults());
                continue;
            }
            ProcedureTest.assertFalse((boolean)cs.getMoreResults());
        }
        for (i = 0; i < 5; ++i) {
            JDBC.assertClosed(allRS[i]);
        }
    }
}

