/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.J2EEDataSource;
import org.apache.derbyTesting.junit.TestConfiguration;

public class InternationalConnectTest
extends BaseJDBCTestCase {
    public InternationalConnectTest(String name) {
        super(name);
    }

    public void testDriverManagerConnect() throws SQLException {
        this.getConnection();
        Connection conn = null;
        String url = null;
        try {
            url = TestConfiguration.getCurrent().getJDBCUrl("\u4e10;create=true");
            conn = DriverManager.getConnection(url);
            conn.close();
        }
        catch (SQLException se) {
            if (InternationalConnectTest.usingEmbedded()) {
                throw se;
            }
            InternationalConnectTest.assertSQLState("22005", se);
        }
        try {
            url = TestConfiguration.getCurrent().getJDBCUrl("\u4e10;user=\u4e10");
            conn = DriverManager.getConnection(url);
            conn.close();
        }
        catch (SQLException se) {
            if (InternationalConnectTest.usingEmbedded()) {
                throw se;
            }
            InternationalConnectTest.assertSQLState("22005", se);
        }
        try {
            url = TestConfiguration.getCurrent().getJDBCUrl("\u4e10");
            conn = DriverManager.getConnection(url, "\u4e10", "pass");
            conn.close();
        }
        catch (SQLException se) {
            if (InternationalConnectTest.usingEmbedded()) {
                throw se;
            }
            InternationalConnectTest.assertSQLState("22005", se);
        }
        try {
            url = TestConfiguration.getCurrent().getJDBCUrl("\u4e10;user=user;password=\u4e10");
            conn = DriverManager.getConnection(url);
            conn.close();
        }
        catch (SQLException se) {
            if (InternationalConnectTest.usingEmbedded()) {
                throw se;
            }
            InternationalConnectTest.assertSQLState("22005", se);
        }
        try {
            url = TestConfiguration.getCurrent().getJDBCUrl("\u4e10");
            conn = DriverManager.getConnection(url, "\u4e10", "\u4e10");
            conn.close();
        }
        catch (SQLException se) {
            if (InternationalConnectTest.usingEmbedded()) {
                throw se;
            }
            InternationalConnectTest.assertSQLState("22005", se);
        }
    }

    public void testXADSConnect() throws SQLException {
        Connection conn;
        XAConnection xaconn;
        XADataSource ds = J2EEDataSource.getXADataSource();
        J2EEDataSource.setBeanProperty(ds, "databaseName", "\u4e10");
        J2EEDataSource.setBeanProperty(ds, "createDatabase", "create");
        try {
            xaconn = ds.getXAConnection();
            conn = xaconn.getConnection();
            conn.close();
        }
        catch (SQLException se) {
            if (InternationalConnectTest.usingEmbedded()) {
                throw se;
            }
            InternationalConnectTest.assertSQLState("22005", se);
        }
        try {
            J2EEDataSource.setBeanProperty(ds, "user", "\u4e10");
            xaconn = ds.getXAConnection();
            conn = xaconn.getConnection();
            conn.close();
        }
        catch (SQLException se) {
            if (InternationalConnectTest.usingEmbedded()) {
                throw se;
            }
            InternationalConnectTest.assertSQLState("22005", se);
        }
        try {
            J2EEDataSource.setBeanProperty(ds, "password", "\u4e10");
            xaconn = ds.getXAConnection();
            conn = xaconn.getConnection();
            conn.close();
        }
        catch (SQLException se) {
            if (InternationalConnectTest.usingEmbedded()) {
                throw se;
            }
            InternationalConnectTest.assertSQLState("22005", se);
        }
    }

    public void testCPDSConnect() throws SQLException {
        Connection conn;
        PooledConnection poolConn;
        ConnectionPoolDataSource ds = J2EEDataSource.getConnectionPoolDataSource();
        J2EEDataSource.setBeanProperty(ds, "databaseName", "\u4e10");
        J2EEDataSource.setBeanProperty(ds, "createDatabase", "create");
        try {
            poolConn = ds.getPooledConnection();
            conn = poolConn.getConnection();
            conn.close();
        }
        catch (SQLException se) {
            if (InternationalConnectTest.usingEmbedded()) {
                throw se;
            }
            InternationalConnectTest.assertSQLState("22005", se);
        }
        try {
            J2EEDataSource.setBeanProperty(ds, "user", "\u4e10");
            poolConn = ds.getPooledConnection();
            conn = poolConn.getConnection();
            conn.close();
        }
        catch (SQLException se) {
            if (InternationalConnectTest.usingEmbedded()) {
                throw se;
            }
            InternationalConnectTest.assertSQLState("22005", se);
        }
        try {
            J2EEDataSource.setBeanProperty(ds, "password", "\u4e10");
            poolConn = ds.getPooledConnection();
            conn = poolConn.getConnection();
            conn.close();
        }
        catch (SQLException se) {
            if (InternationalConnectTest.usingEmbedded()) {
                throw se;
            }
            InternationalConnectTest.assertSQLState("22005", se);
        }
    }

    public void tearDown() throws SQLException {
        String shutdownUrl = TestConfiguration.getCurrent().getJDBCUrl("\u4e10;shutdown=true");
        try {
            DriverManager.getConnection(shutdownUrl);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        InternationalConnectTest.removeDirectory(InternationalConnectTest.getSystemProperty("derby.system.home") + File.separator + "\u4e10");
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(InternationalConnectTest.class);
    }
}

