/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.functionTests.tests.jdbcapi.SURBaseTest;
import org.apache.derbyTesting.functionTests.tests.jdbcapi.SURDataModelSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ConcurrencyTest
extends SURBaseTest {
    public ConcurrencyTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        SURDataModelSetup.createDataModel(SURDataModelSetup.SURDataModel.MODEL_WITH_PK, this.getConnection());
        this.commit();
    }

    public void tearDown() throws Exception {
        this.rollback();
        this.dropTable("T1");
        this.commit();
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUpdateLockDownGrade1() throws SQLException {
        Statement s = this.createStatement(1003, 1008);
        ResultSet rs = s.executeQuery("select * from t1 for update");
        while (rs.next()) {
        }
        Connection con2 = this.openDefaultConnection();
        Statement s2 = con2.createStatement(1003, 1008);
        ResultSet rs2 = s2.executeQuery("select * from t1 for update");
        try {
            rs2.next();
        }
        catch (SQLException e) {
            ConcurrencyTest.assertEquals((String)"Unexpected SQL state", (String)"40XL1", (String)e.getSQLState());
            return;
        }
        finally {
            con2.rollback();
        }
        ConcurrencyTest.assertTrue((String)"Expected Derby to hold updatelocks in RR mode", (boolean)false);
        s2.close();
        con2.close();
        s.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAquireUpdateLock1() throws SQLException {
        Statement s = this.createStatement();
        ResultSet rs = s.executeQuery("select * from t1");
        while (rs.next()) {
        }
        Connection con2 = this.openDefaultConnection();
        Statement s2 = con2.createStatement(1003, 1008);
        ResultSet rs2 = s2.executeQuery("select * from t1 for update");
        try {
            rs2.next();
        }
        finally {
            con2.rollback();
        }
        s2.close();
        con2.close();
        s.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSharedLocks1() throws SQLException {
        Statement s = this.createStatement(1003, 1007);
        ResultSet rs = s.executeQuery("select * from t1");
        this.scrollForward(rs);
        Connection con2 = this.openDefaultConnection();
        Statement s2 = con2.createStatement(1003, 1007);
        try {
            ResultSet rs2 = s2.executeQuery("select * from t1");
            this.scrollForward(rs2);
        }
        finally {
            rs.close();
            con2.rollback();
            con2.close();
        }
        s.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSharedLocks2() throws SQLException {
        Statement s = this.createStatement();
        ResultSet rs = s.executeQuery("select * from t1");
        this.scrollForward(rs);
        Connection con2 = this.openDefaultConnection();
        Statement s2 = con2.createStatement();
        try {
            ResultSet rs2 = s2.executeQuery("select * from t1");
            this.scrollForward(rs2);
        }
        finally {
            rs.close();
            con2.rollback();
            con2.close();
        }
        s.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSharedAndUpdateLocks1() throws SQLException {
        Statement s = this.createStatement(1003, 1008);
        ResultSet rs = s.executeQuery("select * from t1");
        this.scrollForward(rs);
        Connection con2 = this.openDefaultConnection();
        Statement s2 = con2.createStatement(1003, 1007);
        try {
            ResultSet rs2 = s2.executeQuery("select * from t1");
            this.scrollForward(rs2);
        }
        finally {
            rs.close();
            con2.rollback();
            con2.close();
        }
        s.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSharedAndUpdateLocks2() throws SQLException {
        Statement s = this.createStatement(1003, 1008);
        ResultSet rs = s.executeQuery("select * from t1 for update");
        this.scrollForward(rs);
        Connection con2 = this.openDefaultConnection();
        Statement s2 = con2.createStatement(1003, 1007);
        try {
            ResultSet rs2 = s2.executeQuery("select * from t1");
            this.scrollForward(rs2);
        }
        finally {
            rs.close();
            con2.rollback();
            con2.close();
        }
        s.close();
    }

    public void testUpdatePurgedTuple1() throws SQLException {
        this.getConnection().setTransactionIsolation(1);
        Statement s = this.createStatement(1004, 1008);
        ResultSet rs = s.executeQuery("select * from t1");
        rs.next();
        int firstKey = rs.getInt(1);
        ConcurrencyTest.println("T1: Read next Tuple:(" + rs.getInt(1) + "," + rs.getInt(2) + "," + rs.getInt(3) + ")");
        int lastKey = firstKey;
        while (rs.next()) {
            lastKey = rs.getInt(1);
            ConcurrencyTest.println("T1: Read next Tuple:(" + rs.getInt(1) + "," + rs.getInt(2) + "," + rs.getInt(3) + ")");
        }
        Connection con2 = this.openDefaultConnection();
        con2.setTransactionIsolation(2);
        try {
            PreparedStatement ps2 = con2.prepareStatement("delete from t1 where id=? or id=?");
            ps2.setInt(1, firstKey);
            ps2.setInt(2, lastKey);
            ConcurrencyTest.assertEquals((String)"Expected two records to be deleted", (int)2, (int)ps2.executeUpdate());
            ConcurrencyTest.println("T2: Deleted records with id=" + firstKey + " and id=" + lastKey);
            con2.commit();
            ConcurrencyTest.println("T2: commit");
            ps2 = con2.prepareStatement("call SYSCS_UTIL.SYSCS_INPLACE_COMPRESS_TABLE(?,?,?,?,?)");
            ps2.setString(1, "APP");
            ps2.setString(2, "T1");
            ps2.setInt(3, 1);
            ps2.setInt(4, 0);
            ps2.setInt(5, 0);
            ConcurrencyTest.println("T3: call SYSCS_UTIL.SYSCS_INPLACE_COMPRESS_TABLE");
            ConcurrencyTest.println("T3: purges deleted records");
            ps2.executeUpdate();
            con2.commit();
            ConcurrencyTest.println("T3: commit");
        }
        catch (SQLException e) {
            con2.rollback();
            throw e;
        }
        rs.first();
        ConcurrencyTest.println("T1: Read first Tuple:(" + rs.getInt(1) + "," + rs.getInt(2) + "," + rs.getInt(3) + ")");
        rs.updateInt(2, 3);
        ConcurrencyTest.println("T1: updateInt(2, 3);");
        rs.updateRow();
        ConcurrencyTest.println("T1: updateRow()");
        rs.last();
        ConcurrencyTest.println("T1: Read last Tuple:(" + rs.getInt(1) + "," + rs.getInt(2) + "," + rs.getInt(3) + ")");
        rs.updateInt(2, 3);
        ConcurrencyTest.println("T1: updateInt(2, 3);");
        rs.updateRow();
        ConcurrencyTest.println("T1: updateRow()");
        this.commit();
        ConcurrencyTest.println("T1: commit");
        rs = s.executeQuery("select * from t1");
        ConcurrencyTest.println("T3: select * from table");
        while (rs.next()) {
            ConcurrencyTest.println("T3: Read next Tuple:(" + rs.getInt(1) + "," + rs.getInt(2) + "," + rs.getInt(3) + ")");
        }
        con2.close();
        s.close();
    }

    public void testUpdatePurgedTuple2() throws SQLException {
        this.getConnection().setTransactionIsolation(2);
        Statement s = this.createStatement(1004, 1008);
        ResultSet rs = s.executeQuery("select * from t1");
        rs.next();
        ConcurrencyTest.println("T1: Read next Tuple:(" + rs.getInt(1) + "," + rs.getInt(2) + "," + rs.getInt(3) + ")");
        int firstKey = rs.getInt(1);
        rs.next();
        ConcurrencyTest.println("T1: Read next Tuple:(" + rs.getInt(1) + "," + rs.getInt(2) + "," + rs.getInt(3) + ")");
        Connection con2 = this.openDefaultConnection();
        con2.setTransactionIsolation(2);
        try {
            PreparedStatement ps2 = con2.prepareStatement("delete from t1 where id=?");
            ps2.setInt(1, firstKey);
            ConcurrencyTest.assertEquals((String)"Expected one record to be deleted", (int)1, (int)ps2.executeUpdate());
            ConcurrencyTest.println("T2: Deleted record with id=" + firstKey);
            con2.commit();
            ConcurrencyTest.println("T2: commit");
        }
        catch (SQLException e) {
            con2.rollback();
            throw e;
        }
        rs.previous();
        ConcurrencyTest.println("T1: Read previous Tuple:(" + rs.getInt(1) + "," + rs.getInt(2) + "," + rs.getInt(3) + ")");
        PreparedStatement ps = this.prepareStatement("update T1 set a=? where current of " + rs.getCursorName());
        ps.setInt(1, 3);
        int updateCount = ps.executeUpdate();
        ConcurrencyTest.println("T1: update table, set a=3 where current of " + rs.getCursorName());
        ConcurrencyTest.println("T1: commit");
        this.commit();
        rs = s.executeQuery("select * from t1");
        while (rs.next()) {
            ConcurrencyTest.println("T3: Tuple:(" + rs.getInt(1) + "," + rs.getInt(2) + "," + rs.getInt(3) + ")");
        }
        con2.close();
    }

    public void testUpdatePurgedTuple3() throws SQLException {
        this.getConnection().setTransactionIsolation(2);
        Statement s = this.createStatement(1004, 1008);
        ResultSet rs = s.executeQuery("select * from t1");
        rs.next();
        int firstKey = rs.getInt(1);
        ConcurrencyTest.println("T1: read tuple with key " + firstKey);
        rs.next();
        ConcurrencyTest.println("T1: read next tuple");
        Connection con2 = this.openDefaultConnection();
        con2.setTransactionIsolation(2);
        try {
            PreparedStatement ps2 = con2.prepareStatement("delete from t1 where id=?");
            ps2.setInt(1, firstKey);
            ConcurrencyTest.assertEquals((String)"Expected one record to be deleted", (int)1, (int)ps2.executeUpdate());
            ConcurrencyTest.println("T2: Deleted record with id=" + firstKey);
            con2.commit();
            ConcurrencyTest.println("T2: commit");
            ps2 = con2.prepareStatement("call SYSCS_UTIL.SYSCS_INPLACE_COMPRESS_TABLE(?,?,?,?,?)");
            ps2.setString(1, "APP");
            ps2.setString(2, "T1");
            ps2.setInt(3, 1);
            ps2.setInt(4, 0);
            ps2.setInt(5, 0);
            ConcurrencyTest.println("T3: call SYSCS_UTIL.SYSCS_INPLACE_COMPRESS_TABLE");
            ConcurrencyTest.println("T3: purges deleted records");
            ps2.executeUpdate();
            con2.commit();
            ps2 = con2.prepareStatement("insert into t1 values(?,?,?,?)");
            ps2.setInt(1, firstKey);
            ps2.setInt(2, -1);
            ps2.setInt(3, -1);
            ps2.setString(4, "UPDATED TUPLE");
            ConcurrencyTest.assertEquals((String)"Expected one record to be inserted", (int)1, (int)ps2.executeUpdate());
            ConcurrencyTest.println("T4: Inserted record (" + firstKey + ",-1,-1)");
            con2.commit();
            ConcurrencyTest.println("T4: commit");
        }
        catch (SQLException e) {
            con2.rollback();
            throw e;
        }
        ConcurrencyTest.println("T1: read previous tuple");
        rs.previous();
        ConcurrencyTest.println("T1: id=" + rs.getInt(1));
        rs.updateInt(2, 3);
        ConcurrencyTest.println("T1: updateInt(2, 3);");
        rs.updateRow();
        ConcurrencyTest.println("T1: updated column 2, to value=3");
        ConcurrencyTest.println("T1: commit");
        this.commit();
        rs = s.executeQuery("select * from t1");
        while (rs.next()) {
            ConcurrencyTest.println("T5: Read Tuple:(" + rs.getInt(1) + "," + rs.getInt(2) + "," + rs.getInt(3) + ")");
        }
        con2.close();
    }

    public void testUpdatePurgedTuple4() throws SQLException {
        this.getConnection().setTransactionIsolation(2);
        Statement s = this.createStatement(1004, 1008);
        ResultSet rs = s.executeQuery("select * from t1");
        rs.next();
        int firstKey = rs.getInt(1);
        int valA = rs.getInt(2);
        int valB = rs.getInt(3);
        ConcurrencyTest.println("T1: Read next Tuple:(" + rs.getInt(1) + "," + rs.getInt(2) + "," + rs.getInt(3) + ")");
        rs.next();
        ConcurrencyTest.println("T1: Read next Tuple:(" + rs.getInt(1) + "," + rs.getInt(2) + "," + rs.getInt(3) + ")");
        Connection con2 = this.openDefaultConnection();
        con2.setTransactionIsolation(2);
        try {
            PreparedStatement ps2 = con2.prepareStatement("delete from t1 where id=?");
            ps2.setInt(1, firstKey);
            ConcurrencyTest.assertEquals((String)"Expected one record to be deleted", (int)1, (int)ps2.executeUpdate());
            ConcurrencyTest.println("T2: Deleted record with id=" + firstKey);
            con2.commit();
            ConcurrencyTest.println("T2: commit");
            ps2 = con2.prepareStatement("call SYSCS_UTIL.SYSCS_INPLACE_COMPRESS_TABLE(?,?,?,?,?)");
            ps2.setString(1, "APP");
            ps2.setString(2, "T1");
            ps2.setInt(3, 1);
            ps2.setInt(4, 0);
            ps2.setInt(5, 0);
            ConcurrencyTest.println("T3: call SYSCS_UTIL.SYSCS_INPLACE_COMPRESS_TABLE");
            ConcurrencyTest.println("T3: purges deleted records");
            ps2.executeUpdate();
            con2.commit();
            ConcurrencyTest.println("T3: commit");
            ps2 = con2.prepareStatement("insert into t1 values(?,?,?,?)");
            ps2.setInt(1, firstKey);
            ps2.setInt(2, valA);
            ps2.setInt(3, valB);
            ps2.setString(4, "UPDATE TUPLE " + firstKey);
            ConcurrencyTest.assertEquals((String)"Expected one record to be inserted", (int)1, (int)ps2.executeUpdate());
            ConcurrencyTest.println("T4: Inserted record (" + firstKey + "," + valA + "," + valB + ")");
            con2.commit();
            ConcurrencyTest.println("T4: commit");
        }
        catch (SQLException e) {
            con2.rollback();
            throw e;
        }
        rs.previous();
        ConcurrencyTest.println("T1: Read previous Tuple:(" + rs.getInt(1) + "," + rs.getInt(2) + "," + rs.getInt(3) + ")");
        ConcurrencyTest.println("T1: id=" + rs.getInt(1));
        rs.updateInt(2, 3);
        rs.updateRow();
        ConcurrencyTest.println("T1: updated column 2, to value=3");
        ConcurrencyTest.println("T1: commit");
        this.commit();
        rs = s.executeQuery("select * from t1");
        while (rs.next()) {
            ConcurrencyTest.println("T4: Read next Tuple:(" + rs.getInt(1) + "," + rs.getInt(2) + "," + rs.getInt(3) + ")");
        }
        con2.close();
    }

    public void testUpdateModifiedTuple1() throws SQLException {
        this.getConnection().setTransactionIsolation(2);
        Statement s = this.createStatement(1004, 1008);
        ResultSet rs = s.executeQuery("select * from t1");
        rs.next();
        ConcurrencyTest.println("T1: Read next Tuple:(" + rs.getInt(1) + "," + rs.getInt(2) + "," + rs.getInt(3) + ")");
        int firstKey = rs.getInt(1);
        rs.next();
        ConcurrencyTest.println("T1: Read next Tuple:(" + rs.getInt(1) + "," + rs.getInt(2) + "," + rs.getInt(3) + ")");
        Connection con2 = this.openDefaultConnection();
        con2.setTransactionIsolation(2);
        try {
            PreparedStatement ps2 = con2.prepareStatement("update t1 set b=? where id=?");
            ps2.setInt(1, 999);
            ps2.setInt(2, firstKey);
            ConcurrencyTest.assertEquals((String)"Expected one record to be updated", (int)1, (int)ps2.executeUpdate());
            ConcurrencyTest.println("T2: Updated b=999 where id=" + firstKey);
            con2.commit();
            ConcurrencyTest.println("T2: commit");
        }
        catch (SQLException e) {
            con2.rollback();
            throw e;
        }
        rs.previous();
        ConcurrencyTest.println("T1: Read previous Tuple:(" + rs.getInt(1) + "," + rs.getInt(2) + "," + rs.getInt(3) + ")");
        rs.updateInt(2, 3);
        rs.updateRow();
        ConcurrencyTest.println("T1: updated column 2, to value=3");
        this.commit();
        ConcurrencyTest.println("T1: commit");
        rs = s.executeQuery("select * from t1");
        while (rs.next()) {
            ConcurrencyTest.println("T3: Read next Tuple:(" + rs.getInt(1) + "," + rs.getInt(2) + "," + rs.getInt(3) + ")");
        }
        con2.close();
    }

    public void testUpdateModifiedTuple2() throws SQLException {
        this.getConnection().setTransactionIsolation(2);
        Statement s = this.createStatement(1004, 1008);
        ResultSet rs = s.executeQuery("select * from t1");
        rs.next();
        ConcurrencyTest.println("T1: Read next Tuple:(" + rs.getInt(1) + "," + rs.getInt(2) + "," + rs.getInt(3) + ")");
        int firstKey = rs.getInt(1);
        rs.next();
        ConcurrencyTest.println("T1: Read next Tuple:(" + rs.getInt(1) + "," + rs.getInt(2) + "," + rs.getInt(3) + ")");
        Connection con2 = this.openDefaultConnection();
        con2.setTransactionIsolation(2);
        try {
            PreparedStatement ps2 = con2.prepareStatement("update t1 set b=? where id=?");
            ps2.setInt(1, 999);
            ps2.setInt(2, firstKey);
            ConcurrencyTest.assertEquals((String)"Expected one record to be updated", (int)1, (int)ps2.executeUpdate());
            ConcurrencyTest.println("T2: Updated b=999 where id=" + firstKey);
            con2.commit();
            ConcurrencyTest.println("T2: commit");
        }
        catch (SQLException e) {
            con2.rollback();
            throw e;
        }
        rs.previous();
        ConcurrencyTest.println("T1: Read previous Tuple:(" + rs.getInt(1) + "," + rs.getInt(2) + "," + rs.getInt(3) + ")");
        rs.updateInt(3, 9999);
        rs.updateRow();
        ConcurrencyTest.println("T1: updated column 3, to value=9999");
        this.commit();
        ConcurrencyTest.println("T1: commit");
        rs = s.executeQuery("select * from t1");
        while (rs.next()) {
            ConcurrencyTest.println("T3: Read next Tuple:(" + rs.getInt(1) + "," + rs.getInt(2) + "," + rs.getInt(3) + ")");
        }
        con2.close();
    }

    public void testTableIntentLock1() throws SQLException {
        this.getConnection().setTransactionIsolation(1);
        Statement s = this.createStatement(1004, 1008);
        ConcurrencyTest.println("T1: select * from t1");
        ResultSet rs = s.executeQuery("select * from t1 for update");
        while (rs.next()) {
            ConcurrencyTest.println("T1: Read next Tuple:(" + rs.getInt(1) + "," + rs.getInt(2) + "," + rs.getInt(3) + ")");
        }
        Connection con2 = this.openDefaultConnection();
        con2.setTransactionIsolation(2);
        PreparedStatement ps2 = con2.prepareStatement("call SYSCS_UTIL.SYSCS_COMPRESS_TABLE(?, ?, ?)");
        ps2.setString(1, "APP");
        ps2.setString(2, "T1");
        ps2.setInt(3, 0);
        ConcurrencyTest.println("T2: call SYSCS_UTIL.SYSCS_COMPRESS_TABLE(APP, T1, 0)");
        try {
            ps2.executeUpdate();
            ConcurrencyTest.fail((String)"Expected T2 to hang");
        }
        catch (SQLException e) {
            ConcurrencyTest.println("T2: Got exception:" + e.getMessage());
            ConcurrencyTest.assertSQLState("38000", e);
        }
        ps2.close();
        con2.rollback();
        con2.close();
        s.close();
    }

    public void testUpdateLockInReadUncommitted() throws SQLException {
        this.getConnection().setTransactionIsolation(1);
        Statement s = this.createStatement(1003, 1008);
        ResultSet rs = s.executeQuery("select * from t1");
        rs.next();
        int firstKey = rs.getInt(1);
        ConcurrencyTest.println("T1: Read next Tuple:(" + rs.getInt(1) + "," + rs.getInt(2) + "," + rs.getInt(3) + ")");
        Connection con2 = this.openDefaultConnection();
        con2.setTransactionIsolation(2);
        PreparedStatement ps2 = con2.prepareStatement("delete from t1 where id=?");
        ps2.setInt(1, firstKey);
        try {
            ps2.executeUpdate();
            ConcurrencyTest.fail((String)("expected record with id=" + firstKey + " to be locked"));
        }
        catch (SQLException e) {
            ConcurrencyTest.assertSQLState("40XL1", e);
        }
        ps2.close();
        con2.rollback();
        con2.close();
        s.close();
    }

    public void testDefragmentDuringScan() throws SQLException {
        this.testCompressDuringScan(true, false);
    }

    public void testTruncateDuringScan() throws SQLException {
        this.testCompressDuringScan(false, true);
    }

    private void testCompressDuringScan(boolean testDefragment, boolean testTruncate) throws SQLException {
        this.getConnection().setTransactionIsolation(1);
        Statement delStatement = this.createStatement();
        int deleted = delStatement.executeUpdate("delete from T1 where id>0 and id<" + (this.recordCount - 1));
        int expectedDeleted = this.recordCount - 2;
        ConcurrencyTest.println("T1: delete records");
        ConcurrencyTest.assertEquals((String)"Invalid number of records deleted", (int)expectedDeleted, (int)deleted);
        delStatement.close();
        this.commit();
        ConcurrencyTest.println("T1: commit");
        Statement s = this.createStatement(1004, 1008);
        ResultSet rs = s.executeQuery("select * from t1");
        rs.next();
        int firstKey = rs.getInt(1);
        ConcurrencyTest.println("T2: Read next Tuple:(" + rs.getInt(1) + "," + rs.getInt(2) + "," + rs.getInt(3) + ")");
        int lastKey = firstKey;
        while (rs.next()) {
            lastKey = rs.getInt(1);
            ConcurrencyTest.println("T2: Read next Tuple:(" + rs.getInt(1) + "," + rs.getInt(2) + "," + rs.getInt(3) + ")");
        }
        Connection con2 = this.openDefaultConnection();
        con2.setTransactionIsolation(1);
        PreparedStatement ps2 = con2.prepareStatement("call SYSCS_UTIL.SYSCS_INPLACE_COMPRESS_TABLE(?,?,?,?,?)");
        ps2.setString(1, "APP");
        ps2.setString(2, "T1");
        ps2.setInt(3, 0);
        int defragment = testDefragment ? 1 : 0;
        int truncate = testTruncate ? 1 : 0;
        ps2.setInt(4, defragment);
        ps2.setInt(5, truncate);
        ConcurrencyTest.println("T3: call SYSCS_UTIL.SYSCS_INPLACE_COMPRESS_TABLE");
        ConcurrencyTest.println("T3: defragmenting rows");
        try {
            ps2.executeUpdate();
            con2.commit();
            ConcurrencyTest.println("T3: commit");
            ConcurrencyTest.fail((String)"Expected T3 to hang waiting for Table lock");
        }
        catch (SQLException e) {
            ConcurrencyTest.println("T3: got expected exception");
            con2.rollback();
        }
        ps2.close();
        rs.first();
        ConcurrencyTest.println("T1: Read first Tuple:(" + rs.getInt(1) + "," + rs.getInt(2) + "," + rs.getInt(3) + ")");
        rs.updateInt(2, 3);
        ConcurrencyTest.println("T1: updateInt(2, 3);");
        rs.updateRow();
        ConcurrencyTest.println("T1: updateRow()");
        rs.last();
        ConcurrencyTest.println("T1: Read last Tuple:(" + rs.getInt(1) + "," + rs.getInt(2) + "," + rs.getInt(3) + ")");
        rs.updateInt(2, 3);
        ConcurrencyTest.println("T1: updateInt(2, 3);");
        rs.updateRow();
        ConcurrencyTest.println("T1: updateRow()");
        this.commit();
        ConcurrencyTest.println("T1: commit");
        rs = s.executeQuery("select * from t1");
        ConcurrencyTest.println("T4: select * from table");
        while (rs.next()) {
            ConcurrencyTest.println("T4: Read next Tuple:(" + rs.getInt(1) + "," + rs.getInt(2) + "," + rs.getInt(3) + ")");
        }
        con2.close();
        s.close();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("ConcurrencyTest");
        suite.addTest(ConcurrencyTest.baseSuite("ConcurrencyTest:embedded", true));
        suite.addTest(TestConfiguration.clientServerDecorator(ConcurrencyTest.baseSuite("ConcurrencyTest:client", false)));
        return DatabasePropertyTestSetup.setLockTimeouts((Test)suite, -1, 4);
    }

    private static Test baseSuite(String name, boolean embedded) {
        TestSuite suite = new TestSuite(name);
        suite.addTest((Test)new ConcurrencyTest("testSharedLocks2"));
        if (JDBC.vmSupportsJDBC3() || JDBC.vmSupportsJSR169()) {
            suite.addTest((Test)new ConcurrencyTest("testUpdateLockDownGrade1"));
            suite.addTest((Test)new ConcurrencyTest("testAquireUpdateLock1"));
            suite.addTest((Test)new ConcurrencyTest("testSharedLocks1"));
            suite.addTest((Test)new ConcurrencyTest("testSharedAndUpdateLocks1"));
            suite.addTest((Test)new ConcurrencyTest("testSharedAndUpdateLocks2"));
            if (!ConcurrencyTest.usingDB2Client()) {
                suite.addTest((Test)new ConcurrencyTest("testUpdatePurgedTuple2"));
                suite.addTest((Test)new ConcurrencyTest("testUpdatePurgedTuple3"));
                suite.addTest((Test)new ConcurrencyTest("testUpdatePurgedTuple4"));
                suite.addTest((Test)new ConcurrencyTest("testUpdateModifiedTuple1"));
                suite.addTest((Test)new ConcurrencyTest("testUpdateModifiedTuple2"));
                suite.addTest((Test)new ConcurrencyTest("testTableIntentLock1"));
                suite.addTest((Test)new ConcurrencyTest("testUpdateLockInReadUncommitted"));
                suite.addTest((Test)new ConcurrencyTest("testDefragmentDuringScan"));
                suite.addTest((Test)new ConcurrencyTest("testTruncateDuringScan"));
                if (embedded) {
                    suite.addTest((Test)new ConcurrencyTest("testUpdatePurgedTuple1"));
                }
            }
        }
        return suite;
    }
}

