/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.sql.CallableStatement;
import java.sql.SQLException;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ClobStoredProcedureTest
extends BaseJDBCTestCase {
    final String testStr = "I am a simple derby test case";
    final long testStrLength = "I am a simple derby test case".length();

    public ClobStoredProcedureTest(String name) {
        super(name);
    }

    public static Test suite() {
        if (JDBC.vmSupportsJSR169()) {
            return new TestSuite("empty: client not supported on JSR169; procs use DriverMgr");
        }
        return TestConfiguration.defaultSuite(ClobStoredProcedureTest.class);
    }

    public void setUp() throws Exception {
        int locator = 0;
        this.getConnection().setAutoCommit(false);
        CallableStatement cs = this.prepareCall("? = CALL SYSIBM.CLOBCREATELOCATOR()");
        cs.registerOutParameter(1, 4);
        cs.executeUpdate();
        locator = cs.getInt(1);
        cs.close();
        cs = this.prepareCall("CALL SYSIBM.CLOBSETSTRING(?,?,?,?)");
        cs.setInt(1, locator);
        cs.setInt(2, 1);
        cs.setLong(3, this.testStrLength);
        cs.setString(4, "I am a simple derby test case");
        cs.execute();
        cs.close();
    }

    public void tearDown() throws Exception {
        this.commit();
        super.tearDown();
    }

    public void testGetSubStringSP() throws SQLException {
        CallableStatement cs = this.prepareCall("? = CALL SYSIBM.CLOBGETSUBSTRING(?,?,?)");
        cs.registerOutParameter(1, 12);
        cs.setInt(2, 1);
        cs.setLong(3, 1L);
        cs.setInt(4, 10);
        cs.executeUpdate();
        String retVal = cs.getString(1);
        if ("I am a simple derby test case".substring(0, 10).compareTo(retVal) != 0) {
            ClobStoredProcedureTest.fail((String)"Error SYSIBM.CLOBGETSUBSTRING returns the wrong string");
        }
        cs.close();
    }

    public void testClobCreateLocatorSP() throws SQLException {
        int locator = -1;
        CallableStatement cs = this.prepareCall("? = CALL SYSIBM.CLOBCREATELOCATOR()");
        cs.registerOutParameter(1, 4);
        cs.executeUpdate();
        locator = cs.getInt(1);
        ClobStoredProcedureTest.assertEquals((String)"The locator values returned by SYSIBM.CLOBCREATELOCATOR() are incorrect", (int)2, (int)locator);
        cs.close();
    }

    public void testClobReleaseLocatorSP() throws SQLException {
        CallableStatement cs = this.prepareCall("CALL SYSIBM.CLOBRELEASELOCATOR(?)");
        cs.setInt(1, 1);
        cs.execute();
        cs.close();
        cs = this.prepareCall("? = CALL SYSIBM.CLOBGETLENGTH(?)");
        cs.registerOutParameter(1, -5);
        cs.setInt(2, 1);
        try {
            cs.executeUpdate();
        }
        catch (SQLException sqle) {
            return;
        }
        ClobStoredProcedureTest.fail((String)"Error the locator was not released by SYSIBM.CLOBRELEASELOCATOR");
        cs.close();
    }

    public void testClobGetLengthSP() throws SQLException {
        CallableStatement cs = this.prepareCall("? = CALL SYSIBM.CLOBGETLENGTH(?)");
        cs.registerOutParameter(1, -5);
        cs.setInt(2, 1);
        cs.executeUpdate();
        ClobStoredProcedureTest.assertEquals((String)"Error SYSIBM.CLOBGETLENGTH returns the wrong value for the length of the Clob", (long)this.testStrLength, (long)cs.getLong(1));
        cs.close();
    }

    public void testClobGetPositionFromStringSP() throws SQLException {
        CallableStatement cs = this.prepareCall("? = CALL SYSIBM.CLOBGETPOSITIONFROMSTRING(?,?,?)");
        cs.registerOutParameter(1, -5);
        cs.setInt(2, 1);
        cs.setString(3, new String("simple"));
        cs.setLong(4, 1L);
        cs.executeUpdate();
        ClobStoredProcedureTest.assertEquals((String)"Error SYSIBM.CLOBGETPOSITIONFROMSTRING returns the wrong value for the position of the SUBSTRING", (long)("I am a simple derby test case".indexOf("simple") + 1), (long)cs.getLong(1));
        cs.close();
    }

    public void testClobSetStringSP() throws SQLException {
        String newString = "123456789012345";
        int locator = -1;
        CallableStatement cs = this.prepareCall("? = CALL SYSIBM.CLOBCREATELOCATOR()");
        cs.registerOutParameter(1, 4);
        cs.executeUpdate();
        locator = cs.getInt(1);
        cs.close();
        cs = this.prepareCall("CALL SYSIBM.CLOBSETSTRING(?,?,?,?)");
        cs.setInt(1, locator);
        cs.setInt(2, 1);
        cs.setLong(3, (long)newString.length());
        cs.setString(4, newString);
        cs.execute();
        cs.close();
        cs = this.prepareCall("? = CALL SYSIBM.CLOBGETSUBSTRING(?,?,?)");
        cs.registerOutParameter(1, 12);
        cs.setInt(2, locator);
        cs.setLong(3, 1L);
        cs.setInt(4, newString.length());
        cs.executeUpdate();
        String retVal = cs.getString(1);
        if (newString.compareTo(retVal) != 0) {
            ClobStoredProcedureTest.fail((String)"SYSIBM.CLOBSETSTRING does not insert the right value");
        }
        cs.close();
    }

    public void testClobTruncateSP() throws SQLException {
        CallableStatement cs = this.prepareCall("CALL SYSIBM.CLOBTRUNCATE(?,?)");
        cs.setInt(1, 1);
        cs.setLong(2, 10L);
        try {
            cs.execute();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        cs.close();
    }

    public void testClobGetPositionFromLocatorSP() throws SQLException {
        int locator = 0;
        String newStr = "simple";
        CallableStatement cs = this.prepareCall("? = CALL SYSIBM.CLOBCREATELOCATOR()");
        cs.registerOutParameter(1, 4);
        cs.executeUpdate();
        locator = cs.getInt(1);
        cs.close();
        cs = this.prepareCall("CALL SYSIBM.CLOBSETSTRING(?,?,?,?)");
        cs.setInt(1, locator);
        cs.setInt(2, 1);
        cs.setLong(3, (long)newStr.length());
        cs.setString(4, newStr);
        cs.execute();
        cs.close();
        cs = this.prepareCall("? = CALL SYSIBM.CLOBGETPOSITIONFROMLOCATOR(?,?,?)");
        cs.registerOutParameter(1, -5);
        cs.setInt(2, 1);
        cs.setInt(3, locator);
        cs.setLong(4, 1L);
        cs.executeUpdate();
        ClobStoredProcedureTest.assertEquals((String)"Error SYSIBM.CLOBGETPOSITIONFROMLOCATOR returns the wrong value for the position of the Clob", (long)8L, (long)cs.getLong(1));
        cs.close();
    }
}

