/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derby.drda.NetworkServerControl;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.Derby;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.NetworkServerTestSetup;
import org.apache.derbyTesting.junit.SecurityManagerSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class AutoloadTest
extends BaseJDBCTestCase {
    public AutoloadTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite;
        if (!JDBC.vmSupportsJDBC2()) {
            return new TestSuite("empty: no java.sql.DriverManager");
        }
        boolean embeddedAutoLoad = false;
        boolean clientAutoLoad = false;
        boolean jdbc4Autoload = false;
        if (JDBC.vmSupportsJDBC4() && TestConfiguration.loadingFromJars()) {
            jdbc4Autoload = true;
        }
        try {
            String jdbcDrivers = AutoloadTest.getSystemProperty("jdbc.drivers");
            if (jdbcDrivers == null) {
                jdbcDrivers = "";
            }
            embeddedAutoLoad = jdbcDrivers.indexOf("org.apache.derby.jdbc.EmbeddedDriver") != -1;
            clientAutoLoad = jdbcDrivers.indexOf("org.apache.derby.jdbc.ClientDriver") != -1;
        }
        catch (SecurityException se) {
            // empty catch block
        }
        if (jdbc4Autoload || embeddedAutoLoad || clientAutoLoad) {
            suite = new TestSuite("AutoloadTest");
            if (jdbc4Autoload && !embeddedAutoLoad) {
                suite.addTest(SecurityManagerSetup.noSecurityManager((Test)new AutoloadTest("testEmbeddedNotStarted")));
            }
            if (jdbc4Autoload || embeddedAutoLoad) {
                suite.addTest(AutoloadTest.baseAutoLoadSuite("embedded"));
            }
            if (jdbc4Autoload || clientAutoLoad) {
                suite.addTest(TestConfiguration.clientServerDecorator(AutoloadTest.baseAutoLoadSuite("client")));
            }
            if (jdbc4Autoload || embeddedAutoLoad) {
                suite.addTest((Test)new AutoloadTest("testShutdownDeRegister"));
                suite.addTest((Test)new AutoloadTest("testExplicitReload"));
            }
            return suite;
        }
        suite = new TestSuite("AutoloadTest: no autoloading expected");
        suite.addTest(SecurityManagerSetup.noSecurityManager((Test)new AutoloadTest("testEmbeddedNotStarted")));
        suite.addTest((Test)new AutoloadTest("noloadTestNodriverLoaded"));
        suite.addTest(TestConfiguration.clientServerDecorator((Test)new AutoloadTest("noloadTestNodriverLoaded")));
        return suite;
    }

    private static Test baseAutoLoadSuite(String which) {
        TestSuite suite = new TestSuite("AutoloadTest: " + which);
        suite.addTest((Test)new AutoloadTest("testRegisteredDriver"));
        if ("embedded".equals(which) && Derby.hasServer()) {
            suite.addTest((Test)new AutoloadTest("testAutoNetworkServerBoot"));
        }
        suite.addTest((Test)new AutoloadTest("testSuccessfulConnect"));
        if ("embedded".equals(which)) {
            suite.addTest(SecurityManagerSetup.noSecurityManager((Test)new AutoloadTest("testEmbeddedStarted")));
        }
        suite.addTest((Test)new AutoloadTest("testUnsuccessfulConnect"));
        suite.addTest((Test)new AutoloadTest("testExplicitLoad"));
        return suite;
    }

    public void testRegisteredDriver() throws SQLException {
        String protocol = this.getTestConfiguration().getJDBCClient().getUrlBase();
        Driver driver = DriverManager.getDriver(protocol);
        AutoloadTest.assertNotNull((String)"Expected registered driver", (Object)driver);
    }

    public void testShutdownDeRegister() throws SQLException {
        AutoloadTest.assertTrue((boolean)this.isEmbeddedDriverRegistered());
        TestConfiguration.getCurrent().shutdownEngine();
    }

    private boolean isEmbeddedDriverRegistered() {
        Enumeration<Driver> e = DriverManager.getDrivers();
        while (e.hasMoreElements()) {
            Driver d = e.nextElement();
            String driverClass = d.getClass().getName();
            if (!driverClass.startsWith("org.apache.derby.") || driverClass.equals("org.apache.derby.jdbc.ClientDriver")) continue;
            return true;
        }
        return false;
    }

    public void testSuccessfulConnect() throws SQLException {
        AutoloadTest.println("We ARE autoloading...");
        String url = this.getTestConfiguration().getJDBCUrl();
        url = url.concat(";create=true");
        String user = this.getTestConfiguration().getUserName();
        String password = this.getTestConfiguration().getUserPassword();
        DriverManager.getConnection(url, user, password).close();
    }

    public void testUnsuccessfulConnect() throws SQLException {
        String url = this.getTestConfiguration().getJDBCUrl("nonexistentDatabase");
        String user = this.getTestConfiguration().getUserName();
        String password = this.getTestConfiguration().getUserPassword();
        try {
            DriverManager.getConnection(url, user, password).close();
            AutoloadTest.fail((String)"connected to nonexistentDatabase");
        }
        catch (SQLException e) {
            String expectedError = AutoloadTest.usingEmbedded() ? "XJ004" : "08004";
            AutoloadTest.assertSQLState(expectedError, e);
        }
    }

    public void testExplicitLoad() throws Exception {
        this.explicitLoad(false);
    }

    public void testExplicitReload() throws Exception {
        this.explicitLoad(true);
    }

    private void explicitLoad(boolean instanceOnly) throws Exception {
        String driverClass = this.getTestConfiguration().getJDBCClient().getJDBCDriverName();
        if (!instanceOnly) {
            Class.forName(driverClass);
            this.testSuccessfulConnect();
            this.testUnsuccessfulConnect();
        }
        Class.forName(driverClass).newInstance();
        this.testSuccessfulConnect();
        this.testUnsuccessfulConnect();
    }

    public void noloadTestNodriverLoaded() {
        try {
            this.testRegisteredDriver();
            AutoloadTest.fail((String)"Derby junit setup code is loading driver!");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void testAutoNetworkServerBoot() throws Exception {
        boolean nsAutoBoot = "true".equalsIgnoreCase(AutoloadTest.getSystemProperty("derby.drda.startNetworkServer"));
        boolean serverShouldBeUp = nsAutoBoot && this.fullEngineAutoBoot();
        String user = this.getTestConfiguration().getUserName();
        String pw = this.getTestConfiguration().getUserPassword();
        NetworkServerControl control = new NetworkServerControl(user, pw);
        boolean isServerUp = NetworkServerTestSetup.pingForServerStart(control);
        AutoloadTest.assertEquals((String)"Network Server state incorrect", (boolean)serverShouldBeUp, (boolean)isServerUp);
        if (isServerUp) {
            control.shutdown();
        }
    }

    private boolean fullEngineAutoBoot() {
        String jdbcDrivers = AutoloadTest.getSystemProperty("jdbc.drivers");
        return jdbcDrivers.indexOf("org.apache.derby.jdbc.EmbeddedDriver") != -1;
    }

    public void testEmbeddedNotStarted() {
        AutoloadTest.assertFalse((boolean)this.hasDerbyThreadGroup());
    }

    public void testEmbeddedStarted() {
        AutoloadTest.assertTrue((boolean)this.hasDerbyThreadGroup());
    }

    private boolean hasDerbyThreadGroup() {
        int actual;
        ThreadGroup tg = Thread.currentThread().getThreadGroup();
        while (tg.getParent() != null) {
            tg = tg.getParent();
        }
        ThreadGroup[] allGroups = new ThreadGroup[tg.activeGroupCount()];
        while ((actual = tg.enumerate(allGroups, true)) >= allGroups.length) {
            allGroups = new ThreadGroup[allGroups.length * 2];
        }
        for (int i = 0; i < actual; ++i) {
            if (!allGroups[i].getName().startsWith("derby.")) continue;
            return true;
        }
        return false;
    }
}

