/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbc4;

import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.TestUtil;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.J2EEDataSource;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.TestConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnsupportedVetter
extends BaseJDBCTestCase {
    public static final String SQL_PACKAGE_NAME = "java.sql";
    private static final boolean STRICT_ENFORCEMENT = false;
    private static Exclusions[] rawExcludables = new Exclusions[]{new Exclusions(Connection.class, new MD[]{new MD("createArrayOf", new Class[]{String.class, Object[].class}), new MD("createNClob", new Class[0]), new MD("createSQLXML", new Class[0]), new MD("createStruct", new Class[]{String.class, Object[].class}), new MD("getTypeMap", new Class[0]), new MD("prepareStatement", new Class[]{String.class, int[].class}), new MD("prepareStatement", new Class[]{String.class, String[].class}), new MD("setTypeMap", new Class[]{Map.class})}), new Exclusions(Statement.class, new MD[]{new MD("cancel", new Class[0]), new MD("execute", new Class[]{String.class, int[].class}), new MD("execute", new Class[]{String.class, String[].class}), new MD("executeUpdate", new Class[]{String.class, int[].class}), new MD("executeUpdate", new Class[]{String.class, String[].class})}), new Exclusions(PreparedStatement.class, new MD[]{new MD("setArray", new Class[]{Integer.TYPE, Array.class}), new MD("setNCharacterStream", new Class[]{Integer.TYPE, Reader.class}), new MD("setNCharacterStream", new Class[]{Integer.TYPE, Reader.class, Long.TYPE}), new MD("setNClob", new Class[]{Integer.TYPE, NClob.class}), new MD("setNClob", new Class[]{Integer.TYPE, Reader.class}), new MD("setNClob", new Class[]{Integer.TYPE, Reader.class, Long.TYPE}), new MD("setNString", new Class[]{Integer.TYPE, String.class}), new MD("setRef", new Class[]{Integer.TYPE, Ref.class}), new MD("setRowId", new Class[]{Integer.TYPE, RowId.class}), new MD("setSQLXML", new Class[]{Integer.TYPE, SQLXML.class}), new MD("setURL", new Class[]{Integer.TYPE, URL.class}), new MD("setNull", new Class[]{Integer.TYPE, Integer.TYPE, String.class}), new MD("setUnicodeStream", new Class[]{Integer.TYPE, InputStream.class, Integer.TYPE})}), new Exclusions(CallableStatement.class, new MD[]{new FD("getBlob", new Class[]{Integer.TYPE}), new FD("getClob", new Class[]{Integer.TYPE}), new MD("getArray", new Class[]{Integer.TYPE}), new MD("getArray", new Class[]{String.class}), new MD("getBigDecimal", new Class[]{String.class}), new MD("getBoolean", new Class[]{String.class}), new MD("getBlob", new Class[]{String.class}), new MD("getBoolean", new Class[]{String.class}), new MD("getByte", new Class[]{String.class}), new MD("getBytes", new Class[]{String.class}), new MD("getCharacterStream", new Class[]{String.class}), new MD("getClob", new Class[]{String.class}), new MD("getDate", new Class[]{String.class}), new MD("getDate", new Class[]{String.class, Calendar.class}), new MD("getDouble", new Class[]{String.class}), new MD("getFloat", new Class[]{String.class}), new MD("getInt", new Class[]{String.class}), new MD("getLong", new Class[]{String.class}), new MD("getNCharacterStream", new Class[]{Integer.TYPE}), new MD("getNCharacterStream", new Class[]{String.class}), new MD("getNClob", new Class[]{Integer.TYPE}), new MD("getNClob", new Class[]{String.class}), new MD("getNString", new Class[]{Integer.TYPE}), new MD("getNString", new Class[]{String.class}), new MD("getObject", new Class[]{String.class}), new MD("getRef", new Class[]{Integer.TYPE}), new MD("getRef", new Class[]{String.class}), new MD("getRowId", new Class[]{Integer.TYPE}), new MD("getRowId", new Class[]{String.class}), new MD("getShort", new Class[]{String.class}), new MD("getSQLXML", new Class[]{Integer.TYPE}), new MD("getSQLXML", new Class[]{String.class}), new MD("getString", new Class[]{String.class}), new MD("getTime", new Class[]{String.class}), new MD("getTime", new Class[]{String.class, Calendar.class}), new MD("getTimestamp", new Class[]{String.class}), new MD("getTimestamp", new Class[]{String.class, Calendar.class}), new MD("getURL", new Class[]{Integer.TYPE}), new MD("getURL", new Class[]{String.class}), new MD("registerOutParameter", new Class[]{String.class, Integer.TYPE}), new MD("registerOutParameter", new Class[]{String.class, Integer.TYPE, Integer.TYPE}), new MD("registerOutParameter", new Class[]{String.class, Integer.TYPE, String.class}), new MD("registerOutParameter", new Class[]{Integer.TYPE, Integer.TYPE, String.class}), new MD("setArray", new Class[]{Integer.TYPE, Array.class}), new MD("setAsciiStream", new Class[]{String.class, InputStream.class}), new MD("setAsciiStream", new Class[]{String.class, InputStream.class, Integer.TYPE}), new MD("setAsciiStream", new Class[]{String.class, InputStream.class, Long.TYPE}), new MD("setBigDecimal", new Class[]{String.class, BigDecimal.class}), new MD("setBinaryStream", new Class[]{String.class, InputStream.class}), new MD("setBinaryStream", new Class[]{String.class, InputStream.class, Integer.TYPE}), new MD("setBinaryStream", new Class[]{String.class, InputStream.class, Long.TYPE}), new MD("setBlob", new Class[]{String.class, InputStream.class}), new MD("setBlob", new Class[]{String.class, InputStream.class, Long.TYPE}), new MD("setBlob", new Class[]{String.class, Blob.class}), new MD("setBoolean", new Class[]{String.class, Boolean.TYPE}), new MD("setByte", new Class[]{String.class, Byte.TYPE}), new MD("setBytes", new Class[]{String.class, byte[].class}), new MD("setCharacterStream", new Class[]{String.class, Reader.class}), new MD("setCharacterStream", new Class[]{String.class, Reader.class, Integer.TYPE}), new MD("setCharacterStream", new Class[]{String.class, Reader.class, Long.TYPE}), new MD("setClob", new Class[]{String.class, Reader.class}), new MD("setClob", new Class[]{String.class, Reader.class, Long.TYPE}), new MD("setClob", new Class[]{String.class, Clob.class}), new MD("setDate", new Class[]{String.class, Date.class}), new MD("setDate", new Class[]{String.class, Date.class, Calendar.class}), new MD("setDouble", new Class[]{String.class, Double.TYPE}), new MD("setFloat", new Class[]{String.class, Float.TYPE}), new MD("setInt", new Class[]{String.class, Integer.TYPE}), new MD("setLong", new Class[]{String.class, Long.TYPE}), new MD("setNCharacterStream", new Class[]{Integer.TYPE, Reader.class, Long.TYPE}), new MD("setNCharacterStream", new Class[]{String.class, Reader.class}), new MD("setNCharacterStream", new Class[]{String.class, Reader.class, Long.TYPE}), new MD("setNClob", new Class[]{Integer.TYPE, Reader.class, Long.TYPE}), new MD("setNClob", new Class[]{Integer.TYPE, NClob.class}), new MD("setNClob", new Class[]{String.class, Reader.class}), new MD("setNClob", new Class[]{String.class, Reader.class, Long.TYPE}), new MD("setNClob", new Class[]{String.class, NClob.class}), new MD("setNString", new Class[]{Integer.TYPE, String.class}), new MD("setNString", new Class[]{String.class, String.class}), new MD("setNull", new Class[]{String.class, Integer.TYPE}), new MD("setNull", new Class[]{String.class, Integer.TYPE, String.class}), new MD("setObject", new Class[]{String.class, Object.class}), new MD("setObject", new Class[]{String.class, Object.class, Integer.TYPE}), new MD("setObject", new Class[]{String.class, Object.class, Integer.TYPE, Integer.TYPE}), new MD("setRef", new Class[]{Integer.TYPE, Ref.class}), new MD("setRowId", new Class[]{Integer.TYPE, RowId.class}), new MD("setRowId", new Class[]{String.class, RowId.class}), new MD("setSQLXML", new Class[]{Integer.TYPE, SQLXML.class}), new MD("setSQLXML", new Class[]{String.class, SQLXML.class}), new MD("setShort", new Class[]{String.class, Short.TYPE}), new MD("setString", new Class[]{String.class, String.class}), new MD("setTime", new Class[]{String.class, Time.class}), new MD("setTime", new Class[]{String.class, Time.class, Calendar.class}), new MD("setTimestamp", new Class[]{String.class, Timestamp.class}), new MD("setTimestamp", new Class[]{String.class, Timestamp.class, Calendar.class}), new MD("setURL", new Class[]{Integer.TYPE, URL.class}), new MD("setURL", new Class[]{String.class, URL.class})}), new Exclusions(ResultSet.class, new MD[]{new FD("updateBlob", new Class[]{Integer.TYPE, Blob.class}), new FD("updateBlob", new Class[]{String.class, Blob.class}), new FD("updateBlob", new Class[]{Integer.TYPE, InputStream.class, Long.TYPE}), new FD("updateBlob", new Class[]{String.class, InputStream.class, Long.TYPE}), new FD("updateClob", new Class[]{Integer.TYPE, Clob.class}), new FD("updateClob", new Class[]{String.class, Clob.class}), new FD("updateClob", new Class[]{Integer.TYPE, Reader.class, Long.TYPE}), new FD("updateClob", new Class[]{String.class, Reader.class, Long.TYPE}), new FD("updateNClob", new Class[]{Integer.TYPE, Reader.class, Long.TYPE}), new FD("updateNClob", new Class[]{String.class, Reader.class, Long.TYPE}), new MD("getNCharacterStream", new Class[]{Integer.TYPE}), new MD("getNCharacterStream", new Class[]{String.class}), new MD("getNString", new Class[]{Integer.TYPE}), new MD("getNString", new Class[]{String.class}), new MD("getURL", new Class[]{Integer.TYPE}), new MD("getURL", new Class[]{String.class}), new MD("getArray", new Class[]{Integer.TYPE}), new MD("getArray", new Class[]{String.class}), new MD("getNClob", new Class[]{Integer.TYPE}), new MD("getNClob", new Class[]{String.class}), new MD("getRef", new Class[]{Integer.TYPE}), new MD("getRef", new Class[]{String.class}), new MD("getRowId", new Class[]{Integer.TYPE}), new MD("getRowId", new Class[]{String.class}), new MD("getSQLXML", new Class[]{Integer.TYPE}), new MD("getSQLXML", new Class[]{String.class}), new MD("getUnicodeStream", new Class[]{Integer.TYPE}), new MD("getUnicodeStream", new Class[]{String.class}), new MD("refreshRow", new Class[0]), new MD("updateArray", new Class[]{Integer.TYPE, Array.class}), new MD("updateArray", new Class[]{String.class, Array.class}), new MD("updateNCharacterStream", new Class[]{Integer.TYPE, Reader.class}), new MD("updateNCharacterStream", new Class[]{Integer.TYPE, Reader.class, Long.TYPE}), new MD("updateNCharacterStream", new Class[]{String.class, Reader.class}), new MD("updateNCharacterStream", new Class[]{String.class, Reader.class, Long.TYPE}), new MD("updateNClob", new Class[]{Integer.TYPE, NClob.class}), new MD("updateNClob", new Class[]{Integer.TYPE, Reader.class}), new MD("updateNClob", new Class[]{String.class, NClob.class}), new MD("updateNClob", new Class[]{String.class, Reader.class}), new MD("updateNString", new Class[]{Integer.TYPE, String.class}), new MD("updateNString", new Class[]{String.class, String.class}), new MD("updateRef", new Class[]{Integer.TYPE, Ref.class}), new MD("updateRef", new Class[]{String.class, Ref.class}), new MD("updateRowId", new Class[]{Integer.TYPE, RowId.class}), new MD("updateRowId", new Class[]{String.class, RowId.class}), new MD("updateSQLXML", new Class[]{Integer.TYPE, SQLXML.class}), new MD("updateSQLXML", new Class[]{String.class, SQLXML.class})}), new Exclusions(Blob.class, new MD[]{new FD("getBinaryStream", new Class[]{Long.TYPE, Long.TYPE}), new FD("setBinaryStream", new Class[]{Long.TYPE}), new FD("setBytes", new Class[]{Long.TYPE, byte[].class}), new FD("setBytes", new Class[]{Long.TYPE, byte[].class, Integer.TYPE, Integer.TYPE}), new FD("truncate", new Class[]{Long.TYPE})}), new Exclusions(Clob.class, new MD[]{new FD("getCharacterStream", new Class[]{Long.TYPE, Long.TYPE}), new FD("setAsciiStream", new Class[]{Long.TYPE}), new FD("setCharacterStream", new Class[]{Long.TYPE}), new FD("setString", new Class[]{Long.TYPE, String.class}), new FD("setString", new Class[]{Long.TYPE, String.class, Integer.TYPE, Integer.TYPE}), new FD("truncate", new Class[]{Long.TYPE})})};
    private static Hashtable<Class, HashSet<Method>> excludableMap;
    private boolean savedVerbosity;

    public UnsupportedVetter() {
        super("UnsupportedVetter");
    }

    public void testSupportedMethods() throws Exception {
        this.getTestConfiguration().setVerbosity(true);
        HashSet<String> vanishedMethodList = new HashSet<String>();
        HashSet<String> unsupportedList = new HashSet<String>();
        HashSet<String> notUnderstoodList = new HashSet<String>();
        this.initializeExcludableMap(vanishedMethodList);
        this.vetDataSource(unsupportedList, notUnderstoodList);
        this.vetConnectionPooledDataSource(unsupportedList, notUnderstoodList);
        this.vetXADataSource(unsupportedList, notUnderstoodList);
        this.printVanishedMethodList(vanishedMethodList);
        this.printUnsupportedList(unsupportedList);
        this.printNotUnderstoodList(notUnderstoodList);
        int actualErrorCount = vanishedMethodList.size() + unsupportedList.size() + notUnderstoodList.size();
        UnsupportedVetter.assertEquals((String)"Unexpected discrepancies.", (int)0, (int)actualErrorCount);
    }

    private void vetDataSource(HashSet<String> unsupportedList, HashSet<String> notUnderstoodList) throws Exception {
        DataSource ds = JDBCDataSource.getDataSource();
        Connection conn = ds.getConnection();
        this.vetObject(ds, unsupportedList, notUnderstoodList);
        this.connectionWorkhorse(conn, unsupportedList, notUnderstoodList);
    }

    private void vetConnectionPooledDataSource(HashSet<String> unsupportedList, HashSet<String> notUnderstoodList) throws Exception {
        ConnectionPoolDataSource ds = J2EEDataSource.getConnectionPoolDataSource();
        PooledConnection pc = ds.getPooledConnection(this.getTestConfiguration().getUserName(), this.getTestConfiguration().getUserPassword());
        Connection conn = pc.getConnection();
        this.vetObject(ds, unsupportedList, notUnderstoodList);
        this.vetObject(pc, unsupportedList, notUnderstoodList);
        this.connectionWorkhorse(conn, unsupportedList, notUnderstoodList);
    }

    private void vetXADataSource(HashSet<String> unsupportedList, HashSet<String> notUnderstoodList) throws Exception {
        XADataSource ds = J2EEDataSource.getXADataSource();
        XAConnection xaconn = ds.getXAConnection(this.getTestConfiguration().getUserName(), this.getTestConfiguration().getUserPassword());
        Connection conn = xaconn.getConnection();
        this.vetObject(ds, unsupportedList, notUnderstoodList);
        this.vetObject(xaconn, unsupportedList, notUnderstoodList);
        this.connectionWorkhorse(conn, unsupportedList, notUnderstoodList);
    }

    private void connectionWorkhorse(Connection conn, HashSet<String> unsupportedList, HashSet<String> notUnderstoodList) throws Exception {
        this.vetSavepoint(conn, unsupportedList, notUnderstoodList);
        this.vetLargeObjects(conn, unsupportedList, notUnderstoodList);
        DatabaseMetaData dbmd = conn.getMetaData();
        PreparedStatement ps = conn.prepareStatement("select * from sys.systables where tablename = ?");
        ps.setString(1, "foo");
        ParameterMetaData parameterMetaData = ps.getParameterMetaData();
        ResultSet rs = ps.executeQuery();
        ResultSetMetaData rsmd = rs.getMetaData();
        Statement stmt = conn.createStatement();
        CallableStatement cs = conn.prepareCall("CALL SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(0)");
        ParameterMetaData csmd = cs.getParameterMetaData();
        this.vetObject(dbmd, unsupportedList, notUnderstoodList);
        this.vetObject(stmt, unsupportedList, notUnderstoodList);
        this.vetObject(csmd, unsupportedList, notUnderstoodList);
        this.vetObject(cs, unsupportedList, notUnderstoodList);
        this.vetObject(rsmd, unsupportedList, notUnderstoodList);
        this.vetObject(rs, unsupportedList, notUnderstoodList);
        this.vetObject(parameterMetaData, unsupportedList, notUnderstoodList);
        this.vetObject(ps, unsupportedList, notUnderstoodList);
        this.vetObject(conn, unsupportedList, notUnderstoodList);
    }

    private void vetSavepoint(Connection conn, HashSet<String> unsupportedList, HashSet<String> notUnderstoodList) throws Exception {
        conn.setAutoCommit(false);
        Savepoint sp = conn.setSavepoint();
        this.vetObject(sp, unsupportedList, notUnderstoodList);
        conn.releaseSavepoint(sp);
    }

    private void vetLargeObjects(Connection conn, HashSet<String> unsupportedList, HashSet<String> notUnderstoodList) throws Exception {
        Statement stmt = conn.createStatement();
        stmt.execute("CREATE TABLE t (id INT PRIMARY KEY, b BLOB(10), c CLOB(10))");
        stmt.execute("INSERT INTO t (id, b, c) VALUES (1, CAST (" + TestUtil.stringToHexLiteral("101010001101") + "AS BLOB(10)), CAST ('hello' AS CLOB(10)))");
        ResultSet rs = stmt.executeQuery("SELECT id, b, c FROM t");
        rs.next();
        Blob blob = rs.getBlob(2);
        Clob clob = rs.getClob(3);
        this.vetObject(blob, unsupportedList, notUnderstoodList);
        this.vetObject(clob, unsupportedList, notUnderstoodList);
        stmt.close();
        conn.rollback();
    }

    private void initializeExcludableMap(HashSet<String> vanishedMethodList) throws Exception {
        excludableMap = new Hashtable();
        for (Exclusions exclusions : rawExcludables) {
            Class iface = exclusions.getInterface();
            MD[] mds = exclusions.getExcludedMethods();
            int exclusionCount = mds.length;
            HashSet<Method> excludedMethodSet = new HashSet<Method>();
            for (int j = 0; j < exclusionCount; ++j) {
                MD md = mds[j];
                Method method = null;
                try {
                    method = iface.getMethod(md.getMethodName(), md.getArgTypes());
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
                if (method == null) {
                    vanishedMethodList.add("Method has vanished from SQL interface: " + iface.getName() + "." + md);
                }
                excludedMethodSet.add(method);
            }
            excludableMap.put(iface, excludedMethodSet);
        }
    }

    private void vetObject(Object candidate, HashSet<String> unsupportedList, HashSet<String> notUnderstoodList) throws Exception {
        Class<?> myClass = candidate.getClass();
        this.vetInterfaces(candidate, myClass, unsupportedList, notUnderstoodList);
    }

    private void vetInterfaces(Object candidate, Class myClass, HashSet<String> unsupportedList, HashSet<String> notUnderstoodList) throws Exception {
        Class superClass = myClass.getSuperclass();
        if (superClass != null) {
            this.vetInterfaces(candidate, superClass, unsupportedList, notUnderstoodList);
        }
        for (Class<?> iface : myClass.getInterfaces()) {
            if (iface.getPackage().getName().equals(SQL_PACKAGE_NAME)) {
                this.vetInterfaceMethods(candidate, iface, unsupportedList, notUnderstoodList);
            }
            this.vetInterfaces(candidate, iface, unsupportedList, notUnderstoodList);
        }
    }

    private void vetInterfaceMethods(Object candidate, Class iface, HashSet<String> unsupportedList, HashSet<String> notUnderstoodList) throws Exception {
        for (Method method : this.sortMethods(iface)) {
            this.vetMethod(candidate, iface, method, unsupportedList, notUnderstoodList);
        }
    }

    private Method[] sortMethods(Class iface) throws Exception {
        int i;
        Method[] raw = iface.getMethods();
        int count = raw.length;
        Method[] cooked = new Method[count];
        Object[] sortables = new MethodSortable[count];
        for (i = 0; i < count; ++i) {
            sortables[i] = new MethodSortable(raw[i]);
        }
        Arrays.sort(sortables);
        for (i = 0; i < count; ++i) {
            cooked[i] = ((MethodSortable)sortables[i]).getMethod();
        }
        return cooked;
    }

    private void vetMethod(Object candidate, Class iface, Method method, HashSet<String> unsupportedList, HashSet<String> notUnderstoodList) throws Exception {
        block8: {
            try {
                method.invoke(candidate, this.getNullArguments(method.getParameterTypes()));
            }
            catch (Throwable e) {
                if (!(e instanceof InvocationTargetException)) {
                    this.recordUnexpectedError(candidate, iface, method, notUnderstoodList, e);
                }
                Throwable cause = e.getCause();
                if (cause instanceof SQLFeatureNotSupportedException) {
                    boolean isExcludable = this.isExcludable(method);
                    if (!isExcludable) {
                        int i;
                        StackTraceElement[] stack = cause.getStackTrace();
                        for (i = 0; i < stack.length && !stack[i].getMethodName().equals("notImplemented"); ++i) {
                        }
                        while (i < stack.length && stack[i].getMethodName().equals("notImplemented")) {
                            ++i;
                        }
                        if (i == stack.length) {
                            // empty if block
                        }
                        unsupportedList.add(candidate.getClass().getName() + ": " + method + "@" + (i == stack.length ? "no source" : cause.getStackTrace()[i]));
                    }
                }
                if (cause instanceof SQLException || cause instanceof NullPointerException || cause instanceof ArrayIndexOutOfBoundsException) break block8;
                this.recordUnexpectedError(candidate, iface, method, notUnderstoodList, cause);
            }
        }
    }

    private void recordUnexpectedError(Object candidate, Class iface, Method method, HashSet<String> notUnderstoodList, Throwable cause) throws Exception {
        notUnderstoodList.add(candidate.getClass().getName() + " " + method + " raises " + cause);
    }

    private boolean isExcludable(Method method) throws Exception {
        Class<?> iface = method.getDeclaringClass();
        HashSet<Method> excludableMethods = excludableMap.get(iface);
        if (excludableMethods == null) {
            return false;
        }
        return excludableMethods.contains(method);
    }

    private Object[] getNullArguments(Class[] params) {
        Object[] args = new Object[params.length];
        for (int i = 0; i < params.length; ++i) {
            args[i] = this.getNullValueForType(params[i]);
        }
        return args;
    }

    private Object getNullValueForType(Class type) {
        if (!type.isPrimitive()) {
            return null;
        }
        if (type == Boolean.TYPE) {
            return Boolean.FALSE;
        }
        if (type == Character.TYPE) {
            return new Character('\u0000');
        }
        if (type == Byte.TYPE) {
            return new Byte(0);
        }
        if (type == Short.TYPE) {
            return new Short(0);
        }
        if (type == Integer.TYPE) {
            return new Integer(0);
        }
        if (type == Long.TYPE) {
            return new Long(0L);
        }
        if (type == Float.TYPE) {
            return new Float(0.0f);
        }
        if (type == Double.TYPE) {
            return new Double(0.0);
        }
        UnsupportedVetter.fail((String)("Don't know how to handle type " + type));
        return null;
    }

    private void printUnsupportedList(HashSet<String> unsupportedList) {
        int count = unsupportedList.size();
        if (count == 0) {
            return;
        }
        UnsupportedVetter.println("--------------- UNSUPPORTED METHODS ------------------");
        UnsupportedVetter.println("--");
        Object[] result = new String[count];
        unsupportedList.toArray(result);
        Arrays.sort(result);
        for (int i = 0; i < count; ++i) {
            UnsupportedVetter.println((String)result[i]);
        }
    }

    private void printVanishedMethodList(HashSet<String> vanishedMethodList) {
        int count = vanishedMethodList.size();
        if (count == 0) {
            return;
        }
        UnsupportedVetter.println("--------------- VANISHED METHODS ------------------");
        UnsupportedVetter.println("--");
        Object[] result = new String[count];
        vanishedMethodList.toArray(result);
        Arrays.sort(result);
        for (int i = 0; i < count; ++i) {
            UnsupportedVetter.println((String)result[i]);
        }
    }

    private void printNotUnderstoodList(HashSet<String> notUnderstoodList) {
        int count = notUnderstoodList.size();
        if (count == 0) {
            return;
        }
        UnsupportedVetter.println("\n\n");
        UnsupportedVetter.println("--------------- NOT UNDERSTOOD METHODS ------------------");
        UnsupportedVetter.println("--");
        Object[] result = new String[count];
        notUnderstoodList.toArray(result);
        Arrays.sort(result);
        for (int i = 0; i < count; ++i) {
            UnsupportedVetter.println((String)result[i]);
        }
    }

    protected void setUp() {
        this.savedVerbosity = this.getTestConfiguration().isVerbose();
    }

    @Override
    protected void tearDown() throws Exception {
        this.getTestConfiguration().setVerbosity(this.savedVerbosity);
        super.tearDown();
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(UnsupportedVetter.class);
    }

    public static final class MethodSortable
    implements Comparable {
        private Method _method;

        public MethodSortable(Method method) {
            this._method = method;
        }

        public Method getMethod() {
            return this._method;
        }

        public int compareTo(Object other) {
            MethodSortable that = (MethodSortable)other;
            boolean thisIsClose = this.isCloseMethod();
            boolean thatIsClose = that.isCloseMethod();
            if (thisIsClose) {
                if (thatIsClose) {
                    return 0;
                }
                return 1;
            }
            if (thatIsClose) {
                return -1;
            }
            return this.toString().compareTo(that.toString());
        }

        public String toString() {
            return this._method.toString();
        }

        private boolean isCloseMethod() {
            return this.toString().startsWith("close()");
        }
    }

    public static final class Exclusions {
        private Class _class;
        private MD[] _excludedMethods;

        public Exclusions(Class theInterface, MD[] excludedMethods) {
            this._class = theInterface;
            this._excludedMethods = excludedMethods;
        }

        public Class getInterface() {
            return this._class;
        }

        public MD[] getExcludedMethods() {
            return this._excludedMethods;
        }
    }

    public static final class FD
    extends MD {
        private String _methodName;
        private Class[] _argTypes;

        public FD(String methodName, Class[] argTypes) {
            super(methodName, argTypes);
        }

        public boolean isOptional() {
            return false;
        }
    }

    public static class MD {
        private String _methodName;
        private Class[] _argTypes;

        public MD(String methodName, Class[] argTypes) {
            this._methodName = methodName;
            this._argTypes = argTypes;
        }

        public String getMethodName() {
            return this._methodName;
        }

        public Class[] getArgTypes() {
            return this._argTypes;
        }

        public boolean isOptional() {
            return true;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append(this._methodName);
            buffer.append("( ");
            if (this._argTypes != null) {
                int count = this._argTypes.length;
                for (int i = 0; i < count; ++i) {
                    if (i > 0) {
                        buffer.append(", ");
                    }
                    buffer.append(this._argTypes[i].getName());
                }
            }
            buffer.append(" )");
            return buffer.toString();
        }
    }
}

