/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbc4;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.functionTests.tests.jdbc4.StatementTestSetup;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.TestConfiguration;

public class StatementTest
extends BaseJDBCTestCase {
    private Statement stmt = null;

    public StatementTest(String name) {
        super(name);
    }

    protected void setUp() throws SQLException {
        this.getConnection().setAutoCommit(false);
        this.stmt = this.createStatement();
        StatementTest.assertFalse((String)"First statement must be open initially", (boolean)this.stmt.isClosed());
    }

    protected void tearDown() throws Exception {
        if (this.stmt != null) {
            this.stmt.close();
            this.stmt = null;
        }
        super.tearDown();
    }

    public void testIsClosedBasic() throws SQLException {
        ResultSet rs = this.stmt.executeQuery("select count(*) from stmtTable");
        StatementTest.assertFalse((String)"Statement should still be open", (boolean)this.stmt.isClosed());
        rs.close();
        StatementTest.assertFalse((String)"Statement should be open after ResultSet has been closed", (boolean)this.stmt.isClosed());
        this.stmt.close();
        StatementTest.assertTrue((String)"Statement should be closed, close() has been called", (boolean)this.stmt.isClosed());
    }

    public void testIsClosedWithTwoStatementsOnSameConnection() throws SQLException {
        Statement stmt2 = this.createStatement();
        StatementTest.assertFalse((String)"Second statement must be open initially", (boolean)stmt2.isClosed());
        StatementTest.assertFalse((String)"First statement should not be closed when creating a second statement", (boolean)this.stmt.isClosed());
        ResultSet rs = stmt2.executeQuery("select count(*) from stmtTable");
        StatementTest.assertFalse((String)"Second statement should be open after call to execute()", (boolean)stmt2.isClosed());
        StatementTest.assertFalse((String)"First statement should be open after call to second statment's execute()", (boolean)this.stmt.isClosed());
        stmt2.close();
        StatementTest.assertTrue((String)"Second statement should be closed, close() has been called!", (boolean)stmt2.isClosed());
        StatementTest.assertFalse((String)"First statement should be open after call to second statment's close()", (boolean)this.stmt.isClosed());
    }

    public void testIsClosedWhenClosingConnection() throws SQLException {
        Statement stmt2 = this.createStatement();
        StatementTest.assertFalse((String)"Second statement must be open initially", (boolean)stmt2.isClosed());
        stmt2.execute("select count(*) from stmtTable");
        StatementTest.assertFalse((String)"Second statement should be open after call to execute()", (boolean)stmt2.isClosed());
        this.rollback();
        Connection con = this.getConnection();
        con.close();
        StatementTest.assertTrue((String)"Connection should be closed after close()", (boolean)con.isClosed());
        StatementTest.assertTrue((String)"First statement should be closed, as parent connection has been closed", (boolean)this.stmt.isClosed());
        StatementTest.assertTrue((String)"Second statement should be closed, as parent connection has been closed", (boolean)stmt2.isClosed());
    }

    public void testIsClosedWhenClosingConnectionInInvalidState() throws SQLException {
        this.stmt.executeQuery("select count(*) from stmtTable");
        Connection con = this.stmt.getConnection();
        try {
            con.close();
            StatementTest.fail((String)"Invalid transaction state exception was not thrown");
        }
        catch (SQLException sqle) {
            String expectedState = "25001";
            StatementTest.assertSQLState(expectedState, sqle);
        }
        StatementTest.assertFalse((String)"Statement should still be open, because Connection.close() failed", (boolean)this.stmt.isClosed());
        StatementTest.assertFalse((String)"Connection should still be open", (boolean)con.isClosed());
        con.commit();
        con.close();
        StatementTest.assertTrue((String)"Connection should be closed after close()", (boolean)con.isClosed());
        StatementTest.assertTrue((String)"Statement should be closed, because the connection has been closed", (boolean)this.stmt.isClosed());
        this.stmt.close();
        StatementTest.assertTrue((String)"Statement should still be closed", (boolean)this.stmt.isClosed());
    }

    public void testStatementExecuteAfterConnectionClose() throws SQLException {
        Connection con = this.stmt.getConnection();
        con.close();
        StatementTest.assertTrue((String)"Connection should be closed after close()", (boolean)con.isClosed());
        try {
            this.stmt.executeQuery("select count(*) from stmtTable");
        }
        catch (SQLException sqle) {
            StatementTest.assertEquals((String)"Unexpected SQL state for performing operations on a closed statement.", (String)"08003", (String)sqle.getSQLState());
        }
        StatementTest.assertTrue((String)"Statement should be closed, because the connection has been closed", (boolean)this.stmt.isClosed());
    }

    public void testIsWrapperForStatement() throws SQLException {
        StatementTest.assertTrue((boolean)this.stmt.isWrapperFor(Statement.class));
    }

    public void testIsNotWrapperForPreparedStatement() throws SQLException {
        StatementTest.assertFalse((boolean)this.stmt.isWrapperFor(PreparedStatement.class));
    }

    public void testIsNotWrapperForCallableStatement() throws SQLException {
        StatementTest.assertFalse((boolean)this.stmt.isWrapperFor(CallableStatement.class));
    }

    public void testIsNotWrapperForResultSet() throws SQLException {
        StatementTest.assertFalse((boolean)this.stmt.isWrapperFor(ResultSet.class));
    }

    public void testUnwrapStatement() throws SQLException {
        Statement stmt2 = this.stmt.unwrap(Statement.class);
        StatementTest.assertSame((String)"Unwrap returned wrong object.", (Object)this.stmt, (Object)stmt2);
    }

    public void testUnwrapPreparedStatement() {
        try {
            PreparedStatement ps = this.stmt.unwrap(PreparedStatement.class);
            StatementTest.fail((String)"Unwrap didn't fail.");
        }
        catch (SQLException e) {
            StatementTest.assertSQLState("XJ128", e);
        }
    }

    public void testUnwrapCallableStatement() {
        try {
            CallableStatement cs = this.stmt.unwrap(CallableStatement.class);
            StatementTest.fail((String)"Unwrap didn't fail.");
        }
        catch (SQLException e) {
            StatementTest.assertSQLState("XJ128", e);
        }
    }

    public void testUnwrapResultSet() throws SQLException {
        try {
            ResultSet rs = this.stmt.unwrap(ResultSet.class);
            StatementTest.fail((String)"Unwrap didn't fail.");
        }
        catch (SQLException e) {
            StatementTest.assertSQLState("XJ128", e);
        }
    }

    public void testPoolable() throws SQLException {
        StatementTest.assertFalse((String)"Statement cannot be poolable by default", (boolean)this.stmt.isPoolable());
        this.stmt.setPoolable(true);
        StatementTest.assertTrue((String)"Statement must be poolable", (boolean)this.stmt.isPoolable());
        this.stmt.setPoolable(false);
        StatementTest.assertFalse((String)"Statement cannot be poolable", (boolean)this.stmt.isPoolable());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("StatementTest suite");
        suite.addTest((Test)new StatementTestSetup((Test)new TestSuite(StatementTest.class)));
        suite.addTest(TestConfiguration.clientServerDecorator((Test)new StatementTestSetup((Test)new TestSuite(StatementTest.class))));
        return suite;
    }
}

