/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbc4;

import java.sql.Blob;
import java.sql.ClientInfoStatus;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ConnectionTest
extends BaseJDBCTestCase {
    public ConnectionTest(String name) {
        super(name);
    }

    public void embeddedCreateBlob() throws SQLException {
        Blob blob = this.getConnection().createBlob();
        if (blob.length() > 0L) {
            ConnectionTest.fail((String)"The new Blob should not have more than zero bytes contained in it");
        }
    }

    public void embeddedCreateClob() throws SQLException {
        Clob clob = this.getConnection().createClob();
        if (clob.length() > 0L) {
            ConnectionTest.fail((String)"The new Clob should not have a length of greater than zero");
        }
    }

    public void testCreateArrayNotImplemented() throws SQLException {
        try {
            this.getConnection().createArrayOf(null, null);
            ConnectionTest.fail((String)"createArrayOf(String,Object[]) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testCreateNClobNotImplemented() throws SQLException {
        try {
            this.getConnection().createNClob();
            ConnectionTest.fail((String)"createNClob() should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testCreateSQLXMLNotImplemented() throws SQLException {
        try {
            this.getConnection().createSQLXML();
            ConnectionTest.fail((String)"createSQLXML() should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testCreateStructNotImplemented() throws SQLException {
        try {
            this.getConnection().createStruct(null, null);
            ConnectionTest.fail((String)"createStruct(String,Object[]) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testGetClientInfo() throws SQLException {
        ConnectionTest.assertTrue((String)"getClientInfo() must return an empty Properties object", (boolean)this.getConnection().getClientInfo().isEmpty());
    }

    public void testGetClientInfoString() throws SQLException {
        ConnectionTest.assertNull((String)"getClientInfo(null) must return null", (Object)this.getConnection().getClientInfo(null));
        ConnectionTest.assertNull((String)"getClientInfo(\"someProperty\") must return null", (Object)this.getConnection().getClientInfo("someProperty"));
    }

    public void testIsValidImplemented() throws SQLException {
        ConnectionTest.assertTrue((boolean)this.getConnection().isValid(0));
        ConnectionTest.assertTrue((boolean)this.getConnection().isValid(1));
        try {
            this.getConnection().isValid(-1);
        }
        catch (SQLException sqle) {
            ConnectionTest.assertSQLState("Incorrect SQL state when calling isValid(-1)", "XJ081", sqle);
        }
    }

    public void testGetTypeMapReturnsEmptyMap() throws SQLException {
        ConnectionTest.assertTrue((boolean)this.getConnection().getTypeMap().isEmpty());
    }

    public void testIsWrapperReturnsFalse() throws SQLException {
        ConnectionTest.assertFalse((boolean)this.getConnection().isWrapperFor(ResultSet.class));
    }

    public void testIsWrapperReturnsTrue() throws SQLException {
        ConnectionTest.assertTrue((boolean)this.getConnection().isWrapperFor(Connection.class));
    }

    public void testSetClientInfoProperties() throws SQLException {
        this.getConnection().setClientInfo(null);
        Properties p = new Properties();
        this.getConnection().setClientInfo(p);
        p.setProperty("prop1", "val1");
        p.setProperty("prop2", "val2");
        try {
            this.getConnection().setClientInfo(p);
            ConnectionTest.fail((String)"setClientInfo(String,String) should throw SQLClientInfoException");
        }
        catch (SQLClientInfoException cie) {
            ConnectionTest.assertSQLState("SQLStates must match", "XCY02", cie);
            ConnectionTest.assertTrue((String)"Setting property 'prop1' must fail with REASON_UNKNOWN_PROPERTY", (boolean)cie.getFailedProperties().get("prop1").equals((Object)ClientInfoStatus.REASON_UNKNOWN_PROPERTY));
            ConnectionTest.assertTrue((String)"Setting property 'prop2' must fail with REASON_UNKNOWN_PROPERTY", (boolean)cie.getFailedProperties().get("prop2").equals((Object)ClientInfoStatus.REASON_UNKNOWN_PROPERTY));
        }
    }

    public void testSetClientInfoString() throws SQLException {
        this.getConnection().setClientInfo(null, null);
        try {
            this.getConnection().setClientInfo("foo", null);
            ConnectionTest.fail((String)"setClientInfo(String, null) should throw NullPointerException");
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        try {
            this.getConnection().setClientInfo("name", "value");
            ConnectionTest.fail((String)"setClientInfo(String,String) should throw SQLClientInfoException");
        }
        catch (SQLClientInfoException cie) {
            ConnectionTest.assertSQLState("SQLState must match 'unsupported'", "XCY02", cie);
            ConnectionTest.assertTrue((String)"Setting property 'name' must fail with REASON_UNKNOWN_PROPERTY", (boolean)cie.getFailedProperties().get("name").equals((Object)ClientInfoStatus.REASON_UNKNOWN_PROPERTY));
        }
    }

    public void testUnwrapValid() throws SQLException {
        Connection unwrappedCon = this.getConnection().unwrap(Connection.class);
        ConnectionTest.assertSame((String)"Unwrap returned wrong object.", (Object)this.getConnection(), (Object)unwrappedCon);
    }

    public void testUnwrapInvalid() throws SQLException {
        try {
            ResultSet unwrappedRs = this.getConnection().unwrap(ResultSet.class);
            ConnectionTest.fail((String)"unwrap should have thrown an exception");
        }
        catch (SQLException sqle) {
            ConnectionTest.assertSQLState("Incorrect SQL state when unable to unwrap", "XJ128", sqle);
        }
    }

    private static TestSuite clientSuite(String name) {
        TestSuite clientSuite = new TestSuite(name);
        return clientSuite;
    }

    private static TestSuite embeddedSuite(String name) {
        TestSuite embeddedSuite = new TestSuite(name);
        embeddedSuite.addTest((Test)new ConnectionTest("embeddedCreateBlob"));
        embeddedSuite.addTest((Test)new ConnectionTest("embeddedCreateClob"));
        return embeddedSuite;
    }

    public static Test suite() {
        TestSuite connSuite = new TestSuite("ConnectionTest suite");
        TestSuite embedded = new TestSuite("ConnectionTest:embedded");
        embedded.addTestSuite(ConnectionTest.class);
        embedded.addTest((Test)ConnectionTest.embeddedSuite("ConnectionTest:embedded-only"));
        connSuite.addTest((Test)embedded);
        embedded = new TestSuite("ConnectionTest:embedded XADataSource");
        embedded.addTestSuite(ConnectionTest.class);
        embedded.addTest((Test)ConnectionTest.embeddedSuite("ConnectionTest:embedded-only XADataSource"));
        connSuite.addTest((Test)TestConfiguration.connectionXADecorator((Test)embedded));
        TestSuite client = new TestSuite("ConnectionTest:client");
        client.addTestSuite(ConnectionTest.class);
        client.addTest((Test)ConnectionTest.clientSuite("ConnectionTest:client-only"));
        connSuite.addTest(TestConfiguration.clientServerDecorator((Test)client));
        client = new TestSuite("ConnectionTest:client XADataSource");
        client.addTestSuite(ConnectionTest.class);
        client.addTest((Test)ConnectionTest.clientSuite("ConnectionTest:client-only XADataSource"));
        connSuite.addTest(TestConfiguration.clientServerDecorator((Test)TestConfiguration.connectionXADecorator((Test)client)));
        return connSuite;
    }
}

