/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.i18n;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.SQLException;
import java.util.Locale;
import org.apache.derby.iapi.db.Factory;

public class DefaultLocale {
    static String savedLocale = Locale.getDefault().toString();

    public static void checkDefaultLocale() throws SQLException {
        String defLocale = Locale.getDefault().toString();
        if (!defLocale.equals("rr_TT")) {
            throw new SQLException("wrong_locale");
        }
    }

    public static void checkRDefaultLocale() throws SQLException {
        String dbLocale = Factory.getDatabaseOfConnection().getLocale().toString();
        if (!savedLocale.equals(dbLocale)) {
            throw new SQLException("wrong_locale");
        }
    }

    public static void checkDatabaseLocale(String Locale2) throws SQLException {
        String dbLocale = Factory.getDatabaseOfConnection().getLocale().toString();
        if (!dbLocale.toUpperCase().equals(Locale2.toUpperCase().trim())) {
            throw new SQLException("wrong locale");
        }
    }

    public static void setDefaultLocale(final String Locale2, final String Code) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Locale.setDefault(new Locale(Locale2.trim(), Code.trim()));
                return null;
            }
        });
    }

    static {
        DefaultLocale.setDefaultLocale("rr", "TT");
    }
}

