/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.derbynet;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.BatchUpdateException;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetStream;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class PrepareStatementTest
extends BaseJDBCTestCase {
    public PrepareStatementTest(String name) {
        super(name);
    }

    public static Test suite() {
        if (JDBC.vmSupportsJSR169()) {
            return new TestSuite("empty PrepareStatementTest - client not supported on JSR169");
        }
        return TestConfiguration.defaultSuite(PrepareStatementTest.class);
    }

    public void testBasicPrepare() throws Exception {
        ResultSet rs;
        PreparedStatement pSt = this.prepareStatement("create table t1(c1 int, c2 int, c3 int)");
        PrepareStatementTest.assertUpdateCount(pSt, 0);
        pSt.close();
        Object[][] t1_rows = new Integer[][]{{new Integer(99), new Integer(5), new Integer(9)}, {new Integer(2), new Integer(6), new Integer(10)}, {new Integer(7), new Integer(5), new Integer(8)}};
        pSt = this.prepareStatement("insert into t1 values (?, " + t1_rows[0][1] + ", ?)");
        pSt.setInt(1, t1_rows[0][0]);
        pSt.setInt(2, t1_rows[0][2]);
        PrepareStatementTest.assertUpdateCount(pSt, 1);
        pSt.close();
        pSt = this.prepareStatement("insert into t1 values (" + t1_rows[1][0] + ", " + t1_rows[1][1] + ", ?), (?, " + t1_rows[2][1] + ", " + t1_rows[2][2] + ")");
        pSt.setInt(1, t1_rows[1][2]);
        pSt.setInt(2, t1_rows[2][0]);
        boolean hasResultSet = pSt.execute();
        while (hasResultSet) {
            rs = pSt.getResultSet();
            PrepareStatementTest.assertFalse((boolean)rs.next());
            rs.close();
            hasResultSet = pSt.getMoreResults();
        }
        PrepareStatementTest.assertEquals((int)2, (int)pSt.getUpdateCount());
        pSt.close();
        pSt = this.prepareStatement("select * from t1");
        rs = pSt.executeQuery();
        JDBC.assertFullResultSet(rs, t1_rows, false);
        rs.close();
        pSt.close();
        Object[][] t1filter_rows = new Integer[2][];
        int j = 0;
        for (int i = 0; i < t1_rows.length; ++i) {
            if ((Integer)t1_rows[i][1] != 5) continue;
            t1filter_rows[j++] = t1_rows[i];
        }
        pSt = this.prepareStatement("select * from t1 where c2 = ?");
        pSt.setInt(1, 5);
        rs = pSt.executeQuery();
        JDBC.assertFullResultSet(rs, t1filter_rows, false);
        rs.close();
        pSt.close();
        pSt = this.prepareStatement("select * from t1 where c2 = ?");
        pSt.setInt(1, 5);
        PrepareStatementTest.assertTrue((boolean)pSt.execute());
        rs = pSt.getResultSet();
        JDBC.assertFullResultSet(rs, t1filter_rows, false);
        rs.close();
        PrepareStatementTest.assertFalse((boolean)pSt.getMoreResults());
        PrepareStatementTest.assertEquals((int)-1, (int)pSt.getUpdateCount());
        pSt.close();
    }

    public void testParameterTypes() throws Exception {
        PreparedStatement pSt = this.prepareStatement("create table t2(si smallint,i int, bi bigint, r real, f float, d double precision, n5_2 numeric(5,2), dec10_3 decimal(10,3), ch20 char(20),vc varchar(20), lvc long varchar, b20 char(23) for bit data, vb varchar(23) for bit data, lvb long varchar for bit data,  dt date, tm time, ts timestamp not null)");
        PrepareStatementTest.assertUpdateCount(pSt, 0);
        pSt.close();
        byte[] ba = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19};
        byte[] bapad = new byte[23];
        System.arraycopy(ba, 0, bapad, 0, ba.length);
        Arrays.fill(bapad, ba.length, bapad.length, (byte)32);
        Object[][] t2_rows = new Object[][]{{new Integer(1), new Integer(2), new Long(3L), new Float(4.0), new Double(5.0), new Double(6.0), new BigDecimal("77.77"), new BigDecimal("8.100"), "column9string       ", "column10vcstring", "column11lvcstring", bapad, ba, ba, Date.valueOf("2002-04-12"), Time.valueOf("11:44:30"), Timestamp.valueOf("2002-04-12 11:44:30.000000000")}, {new Integer(1), new Integer(2), new Long(3L), new Float(4.0), new Double(5.0), new Double(6.0), new BigDecimal("77.77"), new BigDecimal("8.100"), "column11string      ", "column10vcstring", "column11lvcstring", bapad, ba, ba, Date.valueOf("2002-04-12"), Time.valueOf("11:44:30"), Timestamp.valueOf("2002-04-12 11:44:30.000000000")}, {null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, Timestamp.valueOf("2002-04-12 11:44:31.000000000")}};
        pSt = this.prepareStatement("insert into t2 values (?, ?, ?, ?,  ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? ,? , ?)");
        pSt.setShort(1, ((Integer)t2_rows[0][0]).shortValue());
        pSt.setInt(2, (Integer)t2_rows[0][1]);
        pSt.setLong(3, (Long)t2_rows[0][2]);
        pSt.setFloat(4, ((Float)t2_rows[0][3]).floatValue());
        pSt.setDouble(5, (Double)t2_rows[0][4]);
        pSt.setDouble(6, (Double)t2_rows[0][5]);
        pSt.setBigDecimal(7, (BigDecimal)t2_rows[0][6]);
        pSt.setBigDecimal(8, new BigDecimal("8.1"));
        pSt.setString(9, "column9string");
        byte[] c10ba = ((String)t2_rows[0][9]).getBytes("UTF-8");
        int len = c10ba.length;
        pSt.setAsciiStream(10, (InputStream)new ByteArrayInputStream(c10ba), len);
        byte[] c11ba = ((String)t2_rows[0][10]).getBytes("UTF-8");
        len = c11ba.length;
        pSt.setCharacterStream(11, (Reader)new InputStreamReader((InputStream)new ByteArrayInputStream(c11ba), "UTF-8"), len);
        pSt.setBytes(12, ba);
        pSt.setBinaryStream(13, (InputStream)new ByteArrayInputStream(ba), ba.length);
        pSt.setBytes(14, ba);
        pSt.setDate(15, (Date)t2_rows[0][14]);
        pSt.setTime(16, (Time)t2_rows[0][15]);
        pSt.setTimestamp(17, (Timestamp)t2_rows[0][16]);
        PrepareStatementTest.assertUpdateCount(pSt, 1);
        for (int i = 0; i < 17; ++i) {
            pSt.setObject(i + 1, t2_rows[1][i]);
        }
        PrepareStatementTest.assertUpdateCount(pSt, 1);
        pSt.setNull(1, 5);
        pSt.setNull(2, 4);
        pSt.setNull(3, -5);
        pSt.setNull(4, 7);
        pSt.setNull(5, 6);
        pSt.setNull(6, 8);
        pSt.setNull(7, 2);
        pSt.setNull(8, 3);
        pSt.setNull(9, 1);
        pSt.setNull(10, 12);
        pSt.setNull(11, -1);
        pSt.setNull(12, -2);
        pSt.setNull(13, -3);
        pSt.setNull(14, -4);
        pSt.setNull(15, 91);
        pSt.setNull(16, 92);
        pSt.setTimestamp(17, (Timestamp)t2_rows[2][16]);
        PrepareStatementTest.assertFalse((boolean)pSt.execute());
        PrepareStatementTest.assertEquals((int)1, (int)pSt.getUpdateCount());
        pSt.close();
        pSt = this.prepareStatement("select * from t2");
        ResultSet rs = pSt.executeQuery();
        JDBC.assertFullResultSet(rs, t2_rows, false);
        rs.close();
        pSt.close();
        try {
            pSt = this.prepareStatement("select * from t2 where i = ?");
            rs = pSt.executeQuery();
            PrepareStatementTest.fail((String)"Exception expected above!");
        }
        catch (SQLException e) {
            PrepareStatementTest.assertSQLState("07000", e);
        }
        rs.close();
        pSt.close();
        try {
            pSt = this.prepareStatement("insert into t2 values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            pSt.executeUpdate();
            PrepareStatementTest.fail((String)"Exception expected above!");
        }
        catch (SQLException e) {
            PrepareStatementTest.assertSQLState("07000", e);
        }
        pSt.close();
        pSt = this.prepareStatement("create table d2558 (i int)");
        PrepareStatementTest.assertUpdateCount(pSt, 0);
        pSt.close();
        pSt = this.prepareStatement("insert into d2558 values (3), (4)");
        PrepareStatementTest.assertUpdateCount(pSt, 2);
        pSt.close();
        pSt = this.prepareStatement("select * from d2558 where i = ?");
        pSt.setObject(1, (Object)new Integer(3), 4, 0);
        try {
            pSt.setObject(2, (Object)new Integer(4), 4, 0);
            rs = pSt.executeQuery();
            rs.close();
            PrepareStatementTest.fail((String)"Exception expected above!");
        }
        catch (SQLException e) {
            PrepareStatementTest.assertSQLState("XCL13", e);
        }
        pSt.close();
    }

    public void testBigTable() throws Exception {
        int tabSize = 1000;
        StringBuffer createBigTabSql = new StringBuffer("create table bigtab (");
        for (int i = 1; i <= tabSize; ++i) {
            createBigTabSql.append("c");
            createBigTabSql.append(i);
            createBigTabSql.append(" int");
            createBigTabSql.append(i != tabSize ? ", " : " )");
        }
        PreparedStatement pSt = this.prepareStatement(createBigTabSql.toString());
        PrepareStatementTest.assertUpdateCount(pSt, 0);
        pSt.close();
        this.insertTab("bigtab", 50);
        this.insertTab("bigtab", 200);
        this.insertTab("bigtab", 300);
        this.insertTab("bigtab", 500);
        this.insertTab("bigtab", 1000);
        this.selectFromBigTab();
        try {
            this.insertTab("bigtab", 1001);
            PrepareStatementTest.fail((String)"Exception expected above!");
        }
        catch (SQLException e) {
            PrepareStatementTest.assertSQLState("42X14", e);
        }
        try {
            this.insertTab("bigtab", 0);
            PrepareStatementTest.fail((String)"Exception expected above!");
        }
        catch (SQLException e) {
            PrepareStatementTest.assertSQLState("42X01", e);
        }
        try {
            this.insertTab("wrongtab", 1000);
            PrepareStatementTest.fail((String)"Exception expected above!");
        }
        catch (SQLException e) {
            PrepareStatementTest.assertSQLState("42X05", e);
        }
    }

    private void insertTab(String tabName, int numCols) throws SQLException {
        int i;
        StringBuffer insertSql = new StringBuffer("insert into " + tabName + "(");
        for (i = 1; i <= numCols; ++i) {
            insertSql.append(" c");
            insertSql.append(i);
            insertSql.append(i != numCols ? ", " : ")");
        }
        insertSql.append("  values (");
        for (i = 1; i <= numCols; ++i) {
            insertSql.append("?");
            insertSql.append(i != numCols ? ", " : " )");
        }
        PreparedStatement pSt = this.prepareStatement(insertSql.toString());
        for (int i2 = 1; i2 <= numCols; ++i2) {
            pSt.setInt(i2, i2);
        }
        PrepareStatementTest.assertUpdateCount(pSt, 1);
        pSt.close();
    }

    private void selectFromBigTab() throws SQLException {
        String selectSQL = "select * from bigtab";
        PreparedStatement pSt = this.prepareStatement(selectSQL);
        ResultSet rs = pSt.executeQuery();
        int i = 0;
        block5: while (rs.next()) {
            switch (++i) {
                case 1: 
                case 2: 
                case 3: {
                    PrepareStatementTest.assertNull((Object)rs.getObject(500));
                    PrepareStatementTest.assertNull((Object)rs.getObject(1000));
                    continue block5;
                }
                case 4: {
                    PrepareStatementTest.assertEquals((int)rs.getInt(500), (int)500);
                    PrepareStatementTest.assertNull((Object)rs.getObject(1000));
                    continue block5;
                }
                case 5: {
                    PrepareStatementTest.assertEquals((int)rs.getInt(500), (int)500);
                    PrepareStatementTest.assertEquals((int)rs.getInt(1000), (int)1000);
                    continue block5;
                }
            }
            PrepareStatementTest.fail((String)"Too many rows in bigTab");
        }
        PrepareStatementTest.assertEquals((int)i, (int)5);
        rs.close();
        pSt.close();
    }

    public void testBigDecimalSetObject() throws SQLException {
        this.getConnection().setAutoCommit(false);
        String sql = "CREATE TABLE doubletab (i int, doubleVal DOUBLE)";
        Statement stmt = this.createStatement();
        PrepareStatementTest.assertUpdateCount(stmt, 0, sql);
        stmt.close();
        this.commit();
        double[] doubleVals = new double[]{1.0E-130, 1.0E125, 0.0, -1.0E124};
        BigDecimal[] bigDecimalVals = new BigDecimal[]{new BigDecimal(1.0E-130), new BigDecimal(1.0E125), new BigDecimal(-1.0E124), new BigDecimal("12345678901234567890123456789012"), new BigDecimal("1.2345678901234567890123456789012")};
        String isql = "INSERT INTO doubletab VALUES (?, ?)";
        PreparedStatement insPs = this.prepareStatement(isql);
        String ssql = "SELECT doubleVal FROM doubletab";
        PreparedStatement selPs = this.prepareStatement(ssql);
        String dsql = "DELETE FROM doubletab";
        PreparedStatement delPs = this.prepareStatement(dsql);
        for (int i = 0; i < bigDecimalVals.length; ++i) {
            BigDecimal bd = bigDecimalVals[i];
            insPs.setInt(1, i);
            insPs.setObject(2, (Object)bd, 8);
            PrepareStatementTest.assertUpdateCount(insPs, 1);
            ResultSet rs = selPs.executeQuery();
            rs.next();
            PrepareStatementTest.assertEquals((double)bd.doubleValue(), (double)rs.getDouble(1), (double)0.0);
            rs.close();
            PrepareStatementTest.assertUpdateCount(delPs, 1);
        }
        insPs.close();
        selPs.close();
        delPs.close();
        this.commit();
    }

    public void testBigDecimalSetObjectWithScale() throws Exception {
        this.getConnection().setAutoCommit(false);
        String sql = "CREATE TABLE numtab (num NUMERIC(10,6))";
        Statement stmt = this.createStatement();
        PrepareStatementTest.assertUpdateCount(stmt, 0, sql);
        stmt.close();
        this.commit();
        BigDecimal bdFromString = new BigDecimal("2.33333333");
        sql = "INSERT INTO  numtab  VALUES(?)";
        PreparedStatement ps = this.prepareStatement(sql);
        int scale = 2;
        ps.setObject(1, (Object)bdFromString, 3, scale);
        PrepareStatementTest.assertUpdateCount(ps, 1);
        ps.close();
        sql = "SELECT num FROM numtab";
        stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        rs.next();
        BigDecimal expected = bdFromString.setScale(scale, 1);
        BigDecimal actual = (BigDecimal)rs.getObject(1);
        PrepareStatementTest.assertEquals((String)("Actual value: " + actual + "does not match expected value: " + expected), (int)expected.compareTo(actual), (int)0);
        rs.close();
        stmt.close();
        this.commit();
    }

    public void testVaryingClientParameterTypeBatch() throws Exception {
        Statement stmt = this.createStatement();
        String createSql = "create table varcharclobtab (c1 varchar(100), c2 clob)";
        PrepareStatementTest.assertUpdateCount(stmt, 0, createSql);
        stmt.close();
        PreparedStatement pStmt = this.prepareStatement("insert into varcharclobtab VALUES(?,?)");
        pStmt.setNull(1, 12);
        pStmt.setString(2, "clob");
        pStmt.addBatch();
        pStmt.setString(1, "varchar");
        pStmt.setNull(2, 2005);
        pStmt.addBatch();
        pStmt.executeBatch();
        pStmt.close();
    }

    public void testSmallBigDecimal() throws Exception {
        Statement stmt = this.createStatement();
        String createTableSQL = "create table Numeric_Tab (MAX_VAL NUMERIC(30,15), MIN_VAL NUMERIC(30,15), NULL_VAL NUMERIC(30,15) DEFAULT NULL)";
        PrepareStatementTest.assertUpdateCount(stmt, 0, createTableSQL);
        String insertSQL = "insert into Numeric_Tab values(999999999999999, 0.000000000000001, null)";
        PrepareStatementTest.assertUpdateCount(stmt, 1, insertSQL);
        String sminBigDecimalVal = "0.000000000000001";
        BigDecimal minBigDecimalVal = new BigDecimal(sminBigDecimalVal);
        String sPrepStmt = "update Numeric_Tab set NULL_VAL=?";
        PreparedStatement pstmt = this.prepareStatement(sPrepStmt);
        pstmt.setObject(1, minBigDecimalVal);
        pstmt.executeUpdate();
        pstmt.close();
        String Null_Val_Query = "Select NULL_VAL from Numeric_Tab";
        ResultSet rs = stmt.executeQuery(Null_Val_Query);
        rs.next();
        BigDecimal rBigDecimalVal = (BigDecimal)rs.getObject(1);
        PrepareStatementTest.assertEquals((Object)rBigDecimalVal, (Object)minBigDecimalVal);
        rs.close();
        stmt.close();
    }

    public void testManyPreparedStatements() throws Exception {
        int i;
        int numOfPreparedStatement = 500;
        PreparedStatement[] tempPreparedStatement = new PreparedStatement[numOfPreparedStatement];
        for (i = 0; i < numOfPreparedStatement; ++i) {
            tempPreparedStatement[i] = this.getConnection().prepareStatement("SELECT COUNT(*) from SYS.SYSTABLES", 1004, 1007);
            ResultSet rs = tempPreparedStatement[i].executeQuery();
            rs.close();
        }
        for (i = 0; i < numOfPreparedStatement; ++i) {
            tempPreparedStatement[i].close();
        }
    }

    public void testInvalidTimestamp() throws Exception {
        Statement stmt = this.createStatement();
        PrepareStatementTest.assertUpdateCount(stmt, 0, "CREATE TABLE TSTAB (I int, STATUS_TS  Timestamp,  PROPERTY_TS Timestamp)");
        PrepareStatementTest.assertUpdateCount(stmt, 1, "INSERT INTO TSTAB VALUES(1 , '2003-08-15 21:20:00',       '2003-08-15 21:20:00')");
        PrepareStatementTest.assertUpdateCount(stmt, 1, "INSERT INTO TSTAB VALUES(2 ,'1969-12-31 16:00:00.0',       '2003-08-15 21:20:00')");
        stmt.close();
        String timestamp = "20";
        String query = "select STATUS_TS from TSTAB where  (STATUS_TS >= ? or PROPERTY_TS < ?)";
        PreparedStatement ps = this.prepareStatement(query);
        try {
            ps.setString(1, timestamp);
            ps.setString(2, timestamp);
            ResultSet rs = ps.executeQuery();
            rs.close();
            PrepareStatementTest.fail((String)"Exception expected above!");
        }
        catch (SQLException e) {
            PrepareStatementTest.assertSQLState("22007", e);
        }
        ps.close();
    }

    public void testSplitQRYDTABlock() throws Exception {
        PreparedStatement ps = this.prepareStatement("create table jira614 (c1 varchar(10000))");
        PrepareStatementTest.assertUpdateCount(ps, 0);
        ps.close();
        String workString = PrepareStatementTest.genString("a", 150);
        ps = this.prepareStatement("insert into jira614 values (?)");
        ps.setString(1, workString);
        for (int row = 0; row < 210; ++row) {
            ps.executeUpdate();
        }
        workString = PrepareStatementTest.genString("b", 10000);
        ps.setString(1, workString);
        ps.executeUpdate();
        ps.close();
        ps = this.prepareStatement("select * from jira614");
        ResultSet rs = ps.executeQuery();
        int rowNum = 0;
        while (rs.next() && ++rowNum != 26) {
        }
        rs.close();
        ps.close();
    }

    private static String genString(String c, int howMany) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < howMany; ++i) {
            buf.append(c);
        }
        return buf.toString();
    }

    public void testServerStatementCleanUp() throws Exception {
        Statement stmt = this.createStatement();
        stmt.execute("create table jira614_a (c1 int)");
        PreparedStatement ps = this.prepareStatement("insert into jira614_a values (?)");
        for (int row = 1; row <= 5; ++row) {
            ps.setInt(1, row);
            ps.executeUpdate();
        }
        ResultSet rs = stmt.executeQuery("select * from jira614");
        int rowNum = 0;
        while (rs.next() && ++rowNum != 26) {
        }
        stmt.close();
        stmt = this.createStatement();
        rs = stmt.executeQuery("select * from jira614_a");
        while (rs.next()) {
        }
        ps.close();
        rs.close();
        stmt.close();
    }

    public void testExcpetionWithBigParameter() throws Exception {
        char[] cData = new char[1000000];
        for (int i = 0; i < cData.length; ++i) {
            cData[i] = Character.forDigit(i % 10, 10);
        }
        PreparedStatement ps = null;
        try {
            ps = this.prepareStatement("insert into jira170 values (?)");
            ps.setString(1, new String(cData));
            ps.execute();
            ps.close();
            PrepareStatementTest.fail((String)"No exception when executing a failed prepare with an enormous parameter");
        }
        catch (SQLException e) {
            PrepareStatementTest.assertSQLState("42X05", e);
        }
    }

    public void testLargeReplies() throws Exception {
        this.jira125Test_a();
        this.jira125Test_b();
    }

    private void jira125Test_a() throws Exception {
        StringBuffer id = new StringBuffer();
        for (int i = 0; i < 49; ++i) {
            id.append("id");
        }
        id.append("i");
        StringBuffer tabName = new StringBuffer("jira");
        for (int i = 0; i < 31; ++i) {
            tabName.append("125");
        }
        Statement stmt = this.createStatement();
        stmt.execute("create table " + tabName.toString() + " (" + id.toString() + " integer)");
        stmt.execute("insert into " + tabName.toString() + " values 1, 2, 3");
        stmt.close();
        StringBuffer buf = new StringBuffer();
        buf.append("SELECT " + id.toString() + " FROM " + tabName.toString() + " WHERE " + id.toString() + " IN ( ");
        int nCols = 554;
        for (int i = 0; i < nCols; ++i) {
            buf.append("?,");
        }
        buf.append("?)");
        PreparedStatement ps = this.prepareStatement(buf.toString());
        for (int i = 0; i <= nCols; ++i) {
            ps.setInt(i + 1, 1);
        }
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
        }
        rs.close();
        ps.close();
    }

    private void jira125Test_b() throws Exception {
        Statement stmt = this.createStatement();
        stmt.execute("create table jira125 (id integer)");
        stmt.execute("insert into jira125 values 1, 2, 3");
        StringBuffer buf = new StringBuffer();
        buf.append("SELECT id FROM jira125 WHERE id IN ( ");
        int nCols = 556;
        for (int i = 0; i < nCols; ++i) {
            buf.append("?,");
        }
        buf.append("?)");
        PreparedStatement ps = this.prepareStatement(buf.toString());
        for (int i = 0; i <= nCols; ++i) {
            ps.setInt(i + 1, 1);
        }
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
        }
        rs.close();
        ps.close();
    }

    public void testAlternatingLobValuesAndNull() throws Exception {
        this.getConnection().setAutoCommit(false);
        Statement st = this.createStatement();
        st.execute("create table tt1 (CLICOL01 smallint not null)");
        st.execute("alter table tt1 add clicol02 smallint");
        st.execute("alter table tt1 add clicol03 int not null default 1");
        st.execute("alter table tt1 add clicol04 int");
        st.execute("alter table tt1 add clicol05 decimal(10,0) not null default 1");
        st.execute("alter table tt1 add clicol51 blob(1G)");
        st.execute("alter table tt1 add clicol52 blob(50)");
        st.execute("alter table tt1 add clicol53 clob(2G) not null default ''");
        st.execute("alter table tt1 add clicol54 clob(60)");
        this.commit();
        PreparedStatement pSt = this.prepareStatement("insert into tt1 values (?,?,?,?,?,?,?,?,?)");
        pSt.setShort(1, (short)500);
        pSt.setShort(2, (short)501);
        pSt.setInt(3, 496);
        pSt.setInt(4, 497);
        pSt.setDouble(5, 484.0);
        pSt.setBytes(6, "404 bit".getBytes());
        pSt.setBytes(7, "405 bit".getBytes());
        pSt.setString(8, "408 bit");
        pSt.setString(9, "409 bit");
        PrepareStatementTest.assertUpdateCount(pSt, 1);
        pSt.setNull(2, 5);
        pSt.setNull(4, 8);
        pSt.setNull(7, 2004);
        pSt.setNull(9, 2005);
        PrepareStatementTest.assertUpdateCount(pSt, 1);
        ResultSet rs = st.executeQuery("select * from tt1");
        rs.next();
        pSt.setShort(1, rs.getShort(1));
        pSt.setShort(2, rs.getShort(2));
        pSt.setInt(3, rs.getInt(3));
        pSt.setInt(4, rs.getInt(4));
        pSt.setDouble(5, rs.getDouble(5));
        pSt.setBlob(6, rs.getBlob(6));
        pSt.setBlob(7, rs.getBlob(7));
        pSt.setClob(8, rs.getClob(8));
        pSt.setClob(9, rs.getClob(9));
        pSt.execute();
        rs.next();
        pSt.setNull(2, 5);
        pSt.setNull(4, 8);
        pSt.setBlob(6, rs.getBlob(6));
        pSt.setNull(7, 2004);
        pSt.setClob(8, rs.getClob(8));
        pSt.setNull(9, 2005);
        pSt.execute();
        rs.close();
        pSt.close();
        this.commit();
    }

    public void testLargeBatch() throws Exception {
        int i;
        Statement stmt = this.createStatement();
        stmt.execute("create table jira428 (i integer)");
        this.getConnection().setAutoCommit(false);
        PreparedStatement ps = this.prepareStatement("insert into jira428 values (?)");
        for (i = 0; i < 32765; ++i) {
            ps.setInt(1, i);
            ps.addBatch();
        }
        ps.executeBatch();
        ps.close();
        this.commit();
        ps = this.prepareStatement("insert into jira428 values (?)");
        for (i = 0; i < 100000; ++i) {
            ps.setInt(1, i);
            ps.addBatch();
        }
        try {
            ps.executeBatch();
            PrepareStatementTest.assertFalse((String)"Expected exception when >65534 statements per batch", (boolean)PrepareStatementTest.usingDerbyNetClient());
        }
        catch (BatchUpdateException bue) {
            PrepareStatementTest.assertSQLState("XJ116", bue);
            PrepareStatementTest.assertFalse((String)"Unexpected exception in embedded framework", (boolean)PrepareStatementTest.usingEmbedded());
        }
        ps.close();
        this.commit();
    }

    public void testDSSLength() throws Exception {
        Statement st = this.createStatement();
        st.execute("create table jira1454(c1 varchar(20000), c2 varchar(30000))");
        st.close();
        this.tickleDSSLength(12748);
        this.tickleDSSLength(12750);
        this.tickleDSSLength(12749);
    }

    private void tickleDSSLength(int c2Len) throws Exception {
        char[] c1 = new char[20000];
        for (int i = 0; i < c1.length; ++i) {
            c1[i] = Character.forDigit(i % 10, 10);
        }
        char[] c2 = new char[30000];
        for (int i = 0; i < c2Len; ++i) {
            c2[i] = Character.forDigit(i % 10, 10);
        }
        PreparedStatement pSt = this.prepareStatement("insert into jira1454 values (?,?)");
        pSt.setString(1, new String(c1));
        pSt.setString(2, new String(c2, 0, c2Len));
        pSt.execute();
        pSt.close();
        Statement st = this.createStatement();
        ResultSet rs = st.executeQuery("select * from jira1454");
        while (rs.next()) {
            PrepareStatementTest.assertEquals((int)rs.getString("c2").length(), (int)c2Len);
        }
        rs.close();
        st.execute("delete from jira1454");
        st.close();
    }

    public void testVariationOfSetObject() throws Exception {
        Statement stmt = this.createStatement();
        String createString = "CREATE TABLE WISH_LIST  (WISH_ID INT NOT NULL GENERATED ALWAYS AS IDENTITY    CONSTRAINT WISH_PK PRIMARY KEY,  ENTRY_DATE TIMESTAMP DEFAULT CURRENT_TIMESTAMP,  WISH_ITEM VARCHAR(32) NOT NULL) ";
        stmt.executeUpdate(createString);
        PreparedStatement ps = this.prepareStatement("insert into WISH_LIST(WISH_ITEM) values (?)");
        ps.setString(1, "aaa");
        ps.executeUpdate();
        ps = this.prepareStatement("insert into WISH_LIST(WISH_ITEM) values ('bb')");
        try {
            ps.setString(1, "aaa");
            PrepareStatementTest.fail((String)"Exception expected above!");
        }
        catch (SQLException e) {
            if (PrepareStatementTest.usingDerbyNetClient()) {
                PrepareStatementTest.assertSQLState("XCL14", e);
            }
            PrepareStatementTest.assertSQLState("07009", e);
        }
        try {
            ps.setObject(1, (Object)"cc", 12);
            PrepareStatementTest.fail((String)"Exception expected above!");
        }
        catch (SQLException e) {
            PrepareStatementTest.assertSQLState("07009", e);
        }
    }

    public void testLargeParameters_a() throws Exception {
        Statement stmt = this.createStatement();
        stmt.execute("create table jira1533_a (aa BIGINT NOT NULL, bbbbbb BIGINT DEFAULT 0 NOT NULL,cccc  VARCHAR(40), ddddddddddd BIGINT, eeeeee VARCHAR(128), ffffffffffffffffff VARCHAR(128),ggggggggg  BLOB(2G), hhhhhhhhh VARCHAR(128), iiiiiiii VARCHAR(128), jjjjjjjjjjjjjj BIGINT,kkkkkkkk CHAR(1) DEFAULT 'f', llllllll CHAR(1) DEFAULT 'f', mmmmmmmmmmmmm  CHAR(1) DEFAULT 'f')");
        stmt.close();
        PreparedStatement ps = this.prepareStatement("INSERT INTO jira1533_a (aa, bbbbbb, cccc, ddddddddddd, eeeeee,                      ffffffffffffffffff,                      ggggggggg, hhhhhhhhh, iiiiiiii,                       jjjjjjjjjjjjjj, kkkkkkkk,                      llllllll,mmmmmmmmmmmmm)          VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?)");
        String blobStr = PrepareStatementTest.makeString(32584);
        ps.setLong(1, 5L);
        ps.setLong(2, 1L);
        ps.setString(3, "AAAAAAAAAAA");
        ps.setLong(4, 30000L);
        ps.setString(5, "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA");
        ps.setString(6, "AAAAAAAAAAA");
        ps.setBytes(7, blobStr.getBytes());
        ps.setString(8, "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA");
        ps.setString(9, "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA");
        ps.setLong(10, 1L);
        ps.setString(11, "1");
        ps.setString(12, "1");
        ps.setString(13, "1");
        ps.execute();
        ps.close();
    }

    public void testLargeParameters_b() throws Exception {
        Statement stmt = this.createStatement();
        stmt.execute("create table jira1533_b (aa BIGINT NOT NULL, bbbbbb BIGINT DEFAULT 0 NOT NULL, cccc VARCHAR(40), ddddddddddd BIGINT, eeeeee VARCHAR(128), ffffffffffffffffff VARCHAR(128), g1 BLOB(2G), g2 BLOB(2G), g3 BLOB(2G), g4 BLOB(2G), ggggggggg  BLOB(2G), hhhhhhhhh VARCHAR(128), iiiiiiii VARCHAR(128), jjjjjjjjjjjjjj BIGINT,kkkkkkkk CHAR(1) DEFAULT 'f', llllllll CHAR(1) DEFAULT 'f', mmmmmmmmmmmmm  CHAR(1) DEFAULT 'f')");
        stmt.close();
        PreparedStatement ps = this.prepareStatement("INSERT INTO jira1533_b (aa, bbbbbb, cccc, ddddddddddd, eeeeee,                      ffffffffffffffffff,                      g1, g2, g3, g4,                      ggggggggg, hhhhhhhhh, iiiiiiii,                      jjjjjjjjjjjjjj, kkkkkkkk,                      llllllll,mmmmmmmmmmmmm)          VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        String blobStr = PrepareStatementTest.makeString(32584);
        ps.setLong(1, 5L);
        ps.setLong(2, 1L);
        ps.setString(3, "AAAAAAAAAAA");
        ps.setLong(4, 30000L);
        ps.setString(5, "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA");
        ps.setString(6, "AAAAAAAAAAA");
        ps.setBytes(7, blobStr.getBytes());
        ps.setBytes(8, blobStr.getBytes());
        ps.setBytes(9, blobStr.getBytes());
        ps.setBytes(10, blobStr.getBytes());
        ps.setBytes(11, blobStr.getBytes());
        ps.setString(12, "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA");
        ps.setString(13, "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA");
        ps.setLong(14, 1L);
        ps.setString(15, "1");
        ps.setString(16, "1");
        ps.setString(17, "1");
        ps.execute();
        ps.close();
    }

    public void testDerby3230() throws SQLException {
        Statement s = this.createStatement();
        s.executeUpdate("CREATE TABLE TAB (col1 varchar(32672) NOT NULL)");
        PreparedStatement ps = this.prepareStatement("INSERT INTO TAB VALUES(?)");
        ps.setString(1, PrepareStatementTest.makeString(15000));
        ps.executeUpdate();
        ps.setString(1, PrepareStatementTest.makeString(7500));
        ps.executeUpdate();
        ps.setString(1, PrepareStatementTest.makeString(5000));
        ps.executeUpdate();
        ps.setString(1, PrepareStatementTest.makeString(2000));
        ps.executeUpdate();
        ps.setString(1, PrepareStatementTest.makeString(1600));
        ps.executeUpdate();
        ps.setString(1, PrepareStatementTest.makeString(800));
        ps.executeUpdate();
        ps.setString(1, PrepareStatementTest.makeString(400));
        ps.executeUpdate();
        ps.setString(1, PrepareStatementTest.makeString(200));
        ps.executeUpdate();
        ps.setString(1, PrepareStatementTest.makeString(100));
        ps.executeUpdate();
        ps.setString(1, PrepareStatementTest.makeString(56));
        ps.executeUpdate();
        ResultSet rs = s.executeQuery("SELECT * from tab");
        JDBC.assertDrainResults(rs);
    }

    private static String makeString(int length) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            buf.append("X");
        }
        return buf.toString();
    }

    public void testReadBlobCloseToMaxDssLength() throws Exception {
        int length = 32766;
        DataInputStream stream1 = new DataInputStream(new LoopingAlphabetStream(32766L));
        byte[] bytes = new byte[32766];
        stream1.readFully(bytes);
        PreparedStatement ps = this.prepareStatement("values cast(? as blob)");
        ps.setBytes(1, bytes);
        ResultSet rs = ps.executeQuery();
        PrepareStatementTest.assertTrue((String)"empty result set", (boolean)rs.next());
        InputStream stream2 = rs.getBinaryStream(1);
        PrepareStatementTest.assertEquals(new LoopingAlphabetStream(32766L), stream2);
        PrepareStatementTest.assertFalse((String)"too many rows", (boolean)rs.next());
        rs.close();
    }
}

