/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.derbynet;

import java.net.InetAddress;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derby.drda.NetworkServerControl;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.J2EEDataSource;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.NetworkServerTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class NSSecurityMechanismTest
extends BaseJDBCTestCase {
    private static String[] derby_drda_securityMechanisms = new String[]{null, "USER_ONLY_SECURITY", "CLEAR_TEXT_PASSWORD_SECURITY", "ENCRYPTED_USER_AND_PASSWORD_SECURITY", "STRONG_PASSWORD_SUBSTITUTE_SECURITY", "INVALID_VALUE", ""};
    private static String derby_drda_securityMechanism;
    private static String[] USER_ATTRIBUTE;
    private static String[] PWD_ATTRIBUTE;
    static final short SECMEC_EUSRIDPWD = 9;
    static final short SECMEC_USRIDONL = 4;
    static final short SECMEC_USRENCPWD = 7;
    static final short SECMEC_USRIDNWPWD = 5;
    static final short SECMEC_USRIDPWD = 3;
    static final short SECMEC_USRSSBPWD = 8;
    private static short[] SECMEC_ATTRIBUTE;

    public NSSecurityMechanismTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("NSSecurityMechanismTest");
        TestSuite clientSuite = new TestSuite("NSSecurityMechanismTest - client");
        clientSuite.addTest((Test)new NSSecurityMechanismTest("testNetworkServerSecurityMechanism"));
        suite.addTest(TestConfiguration.clientServerDecorator((Test)clientSuite));
        suite.addTest(DatabasePropertyTestSetup.builtinAuthentication((Test)new NSSecurityMechanismTest("testSecurityMechanismOnEmbedded"), new String[]{"calvin"}, "pw"));
        return suite;
    }

    protected void tearDown() throws Exception {
        NSSecurityMechanismTest.removeSystemProperty("derby.drda.securityMechanism");
        super.tearDown();
    }

    public void testNetworkServerSecurityMechanism() throws SQLException, Exception {
        String[][] allDriverManagerExpectedValues = new String[][]{{"null", "OK", "OK", "OK", "OK", "OK", "OK", "?", "OK", "OK"}, {"USER_ONLY_SECURITY", "OK", "OK", "08004", "08004", "08004", "OK", "?", "OK", "08004"}, {"CLEAR_TEXT_PASSWORD_SECURITY", "08004", "08004", "OK", "OK", "08004", "08004", "?", "08004", "08004"}, {"ENCRYPTED_USER_AND_PASSWORD_SECURITY", "08004", "08004", "08004", "08004", "OK", "08004", "?", "08004", "08004"}, {"STRONG_PASSWORD_SUBSTITUTE_SECURITY", "08004", "08004", "08004", "08004", "08004", "08004", "?", "08004", "OK"}};
        String[][] allDataSourceExpectedValues = new String[][]{{null, "OK", "OK", "OK", "OK"}, {"USER_ONLY_SECURITY", "OK", "08004", "08004", "08004"}, {"CLEAR_TEXT_PASSWORD_SECURITY", "08004", "OK", "08004", "08004"}, {"ENCRYPTED_USER_AND_PASSWORD_SECURITY", "08004", "08004", "OK", "08004"}, {"STRONG_PASSWORD_SUBSTITUTE_SECURITY", "08004", "08004", "08004", "OK"}};
        String[] DERBY1080ExpectedValues = new String[]{"OK", "08004", "08004", "OK", "08004"};
        String[][] allUserPwdSecMecExpectedValues = new String[][]{{null}, {"USER_ONLY_SECURITY", "08004", "OK", "08004", "08004", "08004", "OK", "OK", "08001.C.8", "08001.C.8", "08001.C.8", "08004", "OK", "08004", "08004", "08004", "OK", "OK", "08001.C.8", "08001.C.8", "08001.C.8"}, {"CLEAR_TEXT_PASSWORD_SECURITY", "OK", "08004", "OK", "08004", "08004", "08004", "08004", "08001.C.8", "08001.C.8", "08001.C.8", "OK", "08004", "OK", "08004", "08004", "08004", "08004", "08001.C.8", "08001.C.8", "08001.C.8"}, {"ENCRYPTED_USER_AND_PASSWORD_SECURITY", "08004", "08004", "08004", "OK", "08004", "08004", "08004", "08001.C.8", "08001.C.8", "08001.C.8", "08004", "08004", "08004", "OK", "08004", "08004", "08004", "08001.C.8", "08001.C.8", "08001.C.8"}, {"STRONG_PASSWORD_SUBSTITUTE_SECURITY", "08004", "08004", "08004", "08004", "OK", "08004", "08004", "08001.C.8", "08001.C.8", "08001.C.8", "08004", "08004", "08004", "08004", "OK", "08004", "08004", "08001.C.8", "08001.C.8", "08001.C.8"}};
        String[] testDERBY528ExpectedValues = new String[]{null, "08006", "OK", "08004", "08006"};
        this.getConnection().getAutoCommit();
        for (int i = 0; i < derby_drda_securityMechanisms.length; ++i) {
            derby_drda_securityMechanism = derby_drda_securityMechanisms[i];
            if (derby_drda_securityMechanism != null && this.setSecurityMechanism(derby_drda_securityMechanism)) continue;
            this.assertConnectionsUsingDriverManager(allDriverManagerExpectedValues[i]);
            this.assertConnectionUsingDataSource(allDataSourceExpectedValues[i]);
            this.assertDerby1080Fixed(DERBY1080ExpectedValues[i]);
            this.assertAllCombinationsOfUserPasswordSecMecInputOK(allUserPwdSecMecExpectedValues[i]);
            if (derby_drda_securityMechanism == null || derby_drda_securityMechanism.equals("STRONG_PASSWORD_SUBSTITUTE_SECURITY")) {
                this.assertUSRSSBPWD_with_BUILTIN(testDERBY528ExpectedValues);
                continue;
            }
            int secmeccode = 9;
            if (derby_drda_securityMechanism.equals("USER_ONLY_SECURITY")) {
                secmeccode = 4;
            } else if (derby_drda_securityMechanism.equals("CLEAR_TEXT_PASSWORD_SECURITY")) {
                secmeccode = 3;
            }
            this.assertConnectionUsingDriverManager(this.getJDBCUrl("user=APP;password=APP;shutdown=true;securityMechanism=" + secmeccode), " BUILTIN (T5):", "08006");
        }
    }

    public void testSecurityMechanismOnEmbedded() throws SQLException {
        DataSource ds = JDBCDataSource.getDataSource();
        JDBCDataSource.setBeanProperty(ds, "connectionAttributes", "securityMechanism=8");
        Connection c = ds.getConnection("calvin", "calvinpw");
        c.close();
    }

    private boolean setSecurityMechanism(String derby_security_mechanism) throws Exception {
        block6: {
            try {
                TestConfiguration config = TestConfiguration.getCurrent();
                NetworkServerControl server = new NetworkServerControl(InetAddress.getByName(config.getHostName()), config.getPort(), config.getUserName(), config.getUserPassword());
                server.shutdown();
            }
            catch (Exception e) {
                if (e.getMessage().substring(0, 17).equals("DRDA_InvalidValue")) break block6;
                NSSecurityMechanismTest.fail((String)"unexpected error");
            }
        }
        NSSecurityMechanismTest.setSystemProperty("derby.drda.securityMechanism", derby_drda_securityMechanism);
        try {
            NetworkServerControl server2 = new NetworkServerControl(InetAddress.getByName(TestConfiguration.getCurrent().getHostName()), TestConfiguration.getCurrent().getPort());
            server2.start(null);
            NetworkServerTestSetup.waitForServerStart(server2);
            if (derby_drda_securityMechanism.equals("") || derby_drda_securityMechanism.equals("INVALID_VALUE")) {
                NSSecurityMechanismTest.fail((String)"expected server not to start with invalid or empty security mechanism, but passed");
            }
        }
        catch (Exception e) {
            if (derby_drda_securityMechanism.equals("") || derby_drda_securityMechanism.equals("INVALID_VALUE") || derby_drda_securityMechanism.equals("ENCRYPTED_USER_AND_PASSWORD_SECURITY")) {
                NSSecurityMechanismTest.assertEquals((String)"DRDA_InvalidValue", (String)e.getMessage().substring(0, 17));
                return true;
            }
            NSSecurityMechanismTest.fail((String)("got unexpected exception setting the mechanism " + derby_security_mechanism + "; message: " + e.getMessage()));
        }
        return false;
    }

    private void assertConnectionsUsingDriverManager(String[] expectedValues) {
        this.assertConnectionUsingDriverManager(this.getJDBCUrl(null), "T1:", expectedValues[1]);
        this.assertConnectionUsingDriverManager(this.getJDBCUrl("user=max"), "T2:", expectedValues[2]);
        this.assertConnectionUsingDriverManager(this.getJDBCUrl("user=neelima;password=lee"), "T3:", expectedValues[3]);
        this.assertConnectionUsingDriverManager(this.getJDBCUrl("user=neelima;password=lee;securityMechanism=3"), "T4:", expectedValues[4]);
        this.assertConnectionUsingDriverManager(this.getJDBCUrl("user=neelima;password=lee;securityMechanism=9"), "T5:", expectedValues[5]);
        this.assertConnectionUsingDriverManager(this.getJDBCUrl("user=neelima;securityMechanism=4"), "T6:", expectedValues[6]);
        this.assertConnectionUsingDriverManager(this.getJDBCUrl("user=neelima;password=lee;securityMechanism=4"), "T8:", expectedValues[8]);
        this.assertConnectionUsingDriverManager(this.getJDBCUrl("user=neelima;password=lee;securityMechanism=8"), "T9:", expectedValues[9]);
    }

    private void assertConnectionUsingDataSource(String[] expectedValues) {
        if (NSSecurityMechanismTest.usingDerbyNetClient()) {
            this.assertSecurityMechanismOK("sarah", null, new Short(4), "SECMEC_USRIDONL:", expectedValues[1]);
        }
        this.assertSecurityMechanismOK("john", "sarah", new Short(3), "SECMEC_USRIDPWD:", expectedValues[2]);
        if (NSSecurityMechanismTest.usingDerbyNetClient()) {
            this.assertSecurityMechanismOK("john", "sarah", new Short(9), "SECMEC_EUSRIDPWD:", expectedValues[3]);
            this.assertSecurityMechanismOK("john", "sarah", new Short(8), "SECMEC_USRSSBPWD:", expectedValues[4]);
        }
    }

    private void assertSecurityMechanismOK(String user, String password, Short secmec, String msg, String expectedValue) {
        DataSource ds = this.getDS(user, password);
        try {
            JDBCDataSource.setBeanProperty(ds, "SecurityMechanism", secmec);
            Connection conn = ds.getConnection(user, password);
            conn.close();
            if (!secmec.equals(new Short(9)) && !expectedValue.equals("OK")) {
                NSSecurityMechanismTest.fail((String)"should have encountered an Exception");
            }
        }
        catch (SQLException sqle) {
            if (sqle.getSQLState().equals("08001")) {
                if (user == null) {
                    this.assertSQLState08001("08001.C.7", sqle);
                } else {
                    this.assertSQLState08001(expectedValue, sqle);
                }
            } else if (secmec.equals(new Short(9))) {
                if (!sqle.getSQLState().equals("XJ112")) {
                    NSSecurityMechanismTest.assertSQLState(expectedValue, sqle);
                }
            } else {
                NSSecurityMechanismTest.assertSQLState(expectedValue, sqle);
            }
        }
        catch (Exception e) {
            NSSecurityMechanismTest.fail((String)" should not have seen an exception");
        }
    }

    private void assertConnectionUsingDriverManager(String dbUrl, String msg, String expectedValue) {
        try {
            TestConfiguration.getCurrent();
            DriverManager.getConnection(dbUrl).close();
            if (derby_drda_securityMechanism != null && (!derby_drda_securityMechanism.equals("ENCRYPTED_USER_AND_PASSWORD_SECURITY") || msg.indexOf("T5") <= 0 && dbUrl.indexOf("9") <= 0) && !expectedValue.equals("OK")) {
                NSSecurityMechanismTest.fail((String)"should have encountered an Exception");
            }
        }
        catch (SQLException sqle) {
            if (derby_drda_securityMechanism != null && derby_drda_securityMechanism.equals("ENCRYPTED_USER_AND_PASSWORD_SECURITY") && msg.indexOf("T5") > 0) {
                if (!sqle.getSQLState().equals("XJ112")) {
                    NSSecurityMechanismTest.assertSQLState(expectedValue, sqle);
                }
            }
            if (sqle.getSQLState().equals("08001")) {
                this.assertSQLState08001(expectedValue, sqle);
            }
            if (dbUrl.indexOf("9") > 0) {
                if (!sqle.getSQLState().equals("XJ112")) {
                    NSSecurityMechanismTest.assertSQLState(expectedValue, sqle);
                }
            }
            NSSecurityMechanismTest.assertSQLState(expectedValue, sqle);
        }
    }

    private void assertAllCombinationsOfUserPasswordSecMecInputOK(String[] expectedValues) {
        String urlAttributes = null;
        for (int k = 0; k < USER_ATTRIBUTE.length; ++k) {
            for (int j = 0; j < PWD_ATTRIBUTE.length; ++j) {
                urlAttributes = "";
                if (USER_ATTRIBUTE[k] != null) {
                    urlAttributes = urlAttributes + "user=" + USER_ATTRIBUTE[k] + ";";
                }
                if (PWD_ATTRIBUTE[j] != null) {
                    urlAttributes = urlAttributes + "password=" + PWD_ATTRIBUTE[j] + ";";
                }
                if (urlAttributes.length() >= 1) {
                    urlAttributes = urlAttributes.substring(0, urlAttributes.length() - 1);
                }
                this.assertConnectionUsingDriverManager(this.getJDBCUrl(urlAttributes), "Test:", this.getExpectedValueFromAll(expectedValues, k, j, 4));
                this.getDataSourceConnection(USER_ATTRIBUTE[k], PWD_ATTRIBUTE[j], this.getExpectedValueFromAll(expectedValues, k, j, 4));
                for (int i = 0; i < SECMEC_ATTRIBUTE.length; ++i) {
                    this.assertConnectionUsingDriverManager(this.getJDBCUrl(urlAttributes + ";securityMechanism=" + SECMEC_ATTRIBUTE[i]), "#", this.getExpectedValueFromAll(expectedValues, k, j, i));
                    this.assertSecurityMechanismOK(USER_ATTRIBUTE[k], PWD_ATTRIBUTE[j], new Short(SECMEC_ATTRIBUTE[i]), "TEST_DS (" + urlAttributes + ",securityMechanism=" + SECMEC_ATTRIBUTE[i] + ")", this.getExpectedValueFromAll(expectedValues, k, j, i));
                }
            }
        }
    }

    private String getExpectedValueFromAll(String[] expectedValues, int USER_ATTR, int PWD_ATTR, int SECMEC_ATTR) {
        if (derby_drda_securityMechanism == null) {
            return "OK";
        }
        String expectedValue = USER_ATTR == 0 && PWD_ATTR == 0 ? (SECMEC_ATTR == 4 ? expectedValues[1] : expectedValues[2 + SECMEC_ATTR]) : (USER_ATTR == 0 && PWD_ATTR == 1 ? (SECMEC_ATTR == 4 ? expectedValues[6] : expectedValues[7 + SECMEC_ATTR]) : (USER_ATTR == 1 && PWD_ATTR == 0 ? (SECMEC_ATTR == 4 ? expectedValues[11] : expectedValues[12 + SECMEC_ATTR]) : (SECMEC_ATTR == 4 ? expectedValues[16] : expectedValues[17 + SECMEC_ATTR])));
        return expectedValue;
    }

    private void getDataSourceConnection(String user, String password, String expectedValue) {
        DataSource ds = this.getDS(user, password);
        try {
            Connection conn = ds.getConnection(user, password);
            conn.close();
        }
        catch (SQLException sqle) {
            if (user == null && sqle.getSQLState().equals("08001")) {
                this.assertSQLState08001("08001.C.7", sqle);
            } else {
                NSSecurityMechanismTest.assertSQLState(expectedValue, sqle);
            }
        }
        catch (Exception e) {
            NSSecurityMechanismTest.fail((String)"should not have gotten an exception");
        }
    }

    private static void dumpSQLException(SQLException sqle) {
        while (sqle != null) {
            NSSecurityMechanismTest.println("SQLSTATE(" + sqle.getSQLState() + "): " + sqle.getMessage());
            sqle = sqle.getNextException();
        }
    }

    private void assertSecMecWithConnPoolingOK(String user, String password, Short secmec) throws Exception {
        ConnectionPoolDataSource cpds = this.getCPDS(user, password);
        JDBCDataSource.setBeanProperty(cpds, "SecurityMechanism", secmec);
        PooledConnection pc = cpds.getPooledConnection();
        Connection conn = pc.getConnection();
        conn.close();
        conn = pc.getConnection();
        this.assertConnectionOK(conn);
        pc.close();
        conn.close();
    }

    private void assertConnectionOK(Connection conn) throws SQLException {
        Statement stmt = conn.createStatement();
        ResultSet rs = null;
        rs = stmt.executeQuery("select count(*) from sys.systables");
        int updatecount = 0;
        while (rs.next()) {
            rs.getInt(1);
            ++updatecount;
        }
        NSSecurityMechanismTest.assertEquals((int)1, (int)updatecount);
        if (rs != null) {
            rs.close();
        }
        if (stmt != null) {
            stmt.close();
        }
    }

    private void assertDerby1080Fixed(String expectedValue) throws Exception {
        block3: {
            try {
                this.assertSecMecWithConnPoolingOK("peter", "neelima", new Short(9));
                if (!expectedValue.equals("OK")) {
                    NSSecurityMechanismTest.fail((String)"expected SQLException if DERBY-1080 did not regress");
                }
            }
            catch (SQLException sqle) {
                if (sqle.getSQLState().equals("XJ112")) break block3;
                NSSecurityMechanismTest.assertSQLState(expectedValue, sqle);
            }
        }
    }

    private void assertUSRSSBPWD_with_BUILTIN(String[] expectedValues) throws Exception {
        NSSecurityMechanismTest.println("Turning ON Derby BUILTIN authentication");
        Connection conn = this.getDataSourceConnectionWithSecMec("neelima", "lee", new Short(8));
        CallableStatement cs = conn.prepareCall("CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY(?, ?)");
        cs.setString(1, "derby.user.neelima");
        cs.setString(2, "lee");
        cs.execute();
        cs.setString(1, "derby.user.APP");
        cs.setString(2, "APP");
        cs.execute();
        cs.setString(1, "derby.database.fullAccessUsers");
        cs.setString(2, "neelima,APP");
        cs.execute();
        cs.setString(1, "derby.connection.requireAuthentication");
        cs.setString(2, "true");
        cs.execute();
        cs.close();
        cs = null;
        conn.close();
        this.assertConnectionUsingDriverManager(this.getJDBCUrl("user=APP;password=APP;shutdown=true;securityMechanism=8"), "USRSSBPWD (T0):", expectedValues[1]);
        this.assertConnectionUsingDriverManager(this.getJDBCUrl("user=neelima;password=lee;securityMechanism=8"), "USRSSBPWD + BUILTIN (T1):", expectedValues[2]);
        this.assertSecurityMechanismOK("neelima", "lee", new Short(8), "TEST_DS - USRSSBPWD + BUILTIN (T2):", expectedValues[2]);
        this.assertConnectionUsingDriverManager(this.getJDBCUrl("user=invalid;password=user;securityMechanism=8"), "USRSSBPWD + BUILTIN (T3):", expectedValues[3]);
        this.assertSecurityMechanismOK("invalid", "user", new Short(8), "TEST_DS - USRSSBPWD + BUILTIN (T4):", expectedValues[3]);
        conn = this.getDataSourceConnectionWithSecMec("neelima", "lee", new Short(8));
        cs = conn.prepareCall("CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY(?, ?)");
        cs.setString(1, "derby.connection.requireAuthentication");
        cs.setString(2, "false");
        cs.execute();
        cs.close();
        cs = null;
        conn.close();
        this.assertConnectionUsingDriverManager(this.getJDBCUrl("user=APP;password=APP;shutdown=true;securityMechanism=8"), "USRSSBPWD + BUILTIN (T5):", expectedValues[4]);
    }

    private Connection getDataSourceConnectionWithSecMec(String user, String password, Short secMec) throws Exception {
        DataSource ds = this.getDS(user, password);
        JDBCDataSource.setBeanProperty(ds, "SecurityMechanism", secMec);
        return ds.getConnection();
    }

    private String getJDBCUrl(String attrs) {
        String dbName = TestConfiguration.getCurrent().getDefaultDatabaseName();
        String s = TestConfiguration.getCurrent().getJDBCUrl(dbName);
        if (attrs != null) {
            s = NSSecurityMechanismTest.usingDerbyNetClient() ? s + ";" + attrs : s + ":" + attrs + ";";
        }
        return s;
    }

    private DataSource getDS(String user, String password) {
        return this.getDS(user, password, null);
    }

    private DataSource getDS(String user, String password, HashMap attrs) {
        if (attrs == null) {
            attrs = new HashMap();
        }
        if (user != null) {
            attrs.put("user", user);
        }
        if (password != null) {
            attrs.put("password", password);
        }
        attrs = this.addRequiredAttributes(attrs);
        DataSource ds = JDBCDataSource.getDataSource();
        Iterator i = attrs.keySet().iterator();
        while (i.hasNext()) {
            String property = (String)i.next();
            Object value = attrs.get(property);
            JDBCDataSource.setBeanProperty(ds, property, value);
        }
        return ds;
    }

    private HashMap addRequiredAttributes(HashMap attrs) {
        String hostName = "localhost";
        int port = 1527;
        if (NSSecurityMechanismTest.usingDB2Client()) {
            attrs.put("driverType", "4");
            attrs.put("serverName", hostName);
        }
        if (!hostName.equals("localhost")) {
            attrs.put("serverName", hostName);
            attrs.put("portNumber", new Integer(port));
        } else {
            attrs.put("portNumber", new Integer(port));
        }
        return attrs;
    }

    private ConnectionPoolDataSource getCPDS(String user, String password) {
        HashMap attrs = new HashMap();
        if (user != null) {
            attrs.put("user", user);
        }
        if (password != null) {
            attrs.put("password", password);
        }
        attrs = this.addRequiredAttributes(attrs);
        ConnectionPoolDataSource cpds = J2EEDataSource.getConnectionPoolDataSource();
        Iterator i = attrs.keySet().iterator();
        while (i.hasNext()) {
            String property = (String)i.next();
            Object value = attrs.get(property);
            JDBCDataSource.setBeanProperty(cpds, property, value);
        }
        return cpds;
    }

    private void assertSQLState08001(String expectedValue, SQLException sqle) {
        if (expectedValue.equals("08001.C.7")) {
            NSSecurityMechanismTest.assertEquals((String)"User id can not be null.", (String)sqle.getMessage());
        }
        if (expectedValue.equals("08001.C.8")) {
            NSSecurityMechanismTest.assertEquals((String)"Password can not be null.", (String)sqle.getMessage());
        }
    }

    static {
        USER_ATTRIBUTE = new String[]{"calvin", null};
        PWD_ATTRIBUTE = new String[]{"hobbes", null};
        SECMEC_ATTRIBUTE = new short[]{4, 3, 9, 8};
    }
}

