/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;

public class SimpleApp {
    private String framework = "embedded";
    private String driver = "org.apache.derby.jdbc.EmbeddedDriver";
    private String protocol = "jdbc:derby:";

    public static void main(String[] stringArray) {
        new SimpleApp().go(stringArray);
        System.out.println("SimpleApp finished");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void go(String[] stringArray) {
        block36: {
            Object object2222;
            int n;
            this.parseArguments(stringArray);
            System.out.println("SimpleApp starting in " + this.framework + " mode");
            this.loadDriver();
            Connection connection = null;
            ArrayList<Statement> arrayList = new ArrayList<Statement>();
            PreparedStatement preparedStatement = null;
            PreparedStatement preparedStatement2 = null;
            Statement statement = null;
            ResultSet resultSet = null;
            Properties properties = new Properties();
            properties.put("user", "user1");
            properties.put("password", "user1");
            String string = "derbyDB";
            connection = DriverManager.getConnection(this.protocol + string + ";create=true", properties);
            System.out.println("Connected to and created database " + string);
            connection.setAutoCommit(false);
            statement = connection.createStatement();
            arrayList.add(statement);
            statement.execute("create table location(num int, addr varchar(40))");
            System.out.println("Created table location");
            preparedStatement = connection.prepareStatement("insert into location values (?, ?)");
            arrayList.add(preparedStatement);
            preparedStatement.setInt(1, 1956);
            preparedStatement.setString(2, "Webster St.");
            preparedStatement.executeUpdate();
            System.out.println("Inserted 1956 Webster");
            preparedStatement.setInt(1, 1910);
            preparedStatement.setString(2, "Union St.");
            preparedStatement.executeUpdate();
            System.out.println("Inserted 1910 Union");
            preparedStatement2 = connection.prepareStatement("update location set num=?, addr=? where num=?");
            arrayList.add(preparedStatement2);
            preparedStatement2.setInt(1, 180);
            preparedStatement2.setString(2, "Grand Ave.");
            preparedStatement2.setInt(3, 1956);
            preparedStatement2.executeUpdate();
            System.out.println("Updated 1956 Webster to 180 Grand");
            preparedStatement2.setInt(1, 300);
            preparedStatement2.setString(2, "Lakeshore Ave.");
            preparedStatement2.setInt(3, 180);
            preparedStatement2.executeUpdate();
            System.out.println("Updated 180 Grand to 300 Lakeshore");
            resultSet = statement.executeQuery("SELECT num, addr FROM location ORDER BY num");
            boolean bl = false;
            if (!resultSet.next()) {
                bl = true;
                this.reportFailure("No rows in ResultSet");
            }
            if ((n = resultSet.getInt(1)) != 300) {
                bl = true;
                this.reportFailure("Wrong row returned, expected num=300, got " + n);
            }
            if (!resultSet.next()) {
                bl = true;
                this.reportFailure("Too few rows");
            }
            if ((n = resultSet.getInt(1)) != 1910) {
                bl = true;
                this.reportFailure("Wrong row returned, expected num=1910, got " + n);
            }
            if (resultSet.next()) {
                bl = true;
                this.reportFailure("Too many rows");
            }
            if (!bl) {
                System.out.println("Verified the rows");
            }
            statement.execute("drop table location");
            System.out.println("Dropped table location");
            connection.commit();
            System.out.println("Committed the transaction");
            if (this.framework.equals("embedded")) {
                try {
                    DriverManager.getConnection("jdbc:derby:;shutdown=true");
                }
                catch (SQLException sQLException) {
                    if (sQLException.getErrorCode() == 50000 && "XJ015".equals(sQLException.getSQLState())) {
                        System.out.println("Derby shut down normally");
                    }
                    System.err.println("Derby did not shut down normally");
                    SimpleApp.printSQLException(sQLException);
                }
            }
            Object var14_14 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                    resultSet = null;
                }
            }
            catch (SQLException sQLException) {
                SimpleApp.printSQLException(sQLException);
            }
            int n2 = 0;
            while (!arrayList.isEmpty()) {
                object2222 = (Statement)arrayList.remove(n2);
                try {
                    if (object2222 == null) continue;
                    object2222.close();
                    object2222 = null;
                }
                catch (SQLException sQLException) {
                    SimpleApp.printSQLException(sQLException);
                }
            }
            try {
                if (connection != null) {
                    connection.close();
                    connection = null;
                }
                break block36;
            }
            catch (SQLException object2222) {
                SimpleApp.printSQLException((SQLException)object2222);
            }
            break block36;
            {
                catch (SQLException sQLException) {
                    Object object32222;
                    SimpleApp.printSQLException(sQLException);
                    Object var14_15 = null;
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                            resultSet = null;
                        }
                    }
                    catch (SQLException sQLException2) {
                        SimpleApp.printSQLException(sQLException2);
                    }
                    int n3 = 0;
                    while (!arrayList.isEmpty()) {
                        object32222 = (Statement)arrayList.remove(n3);
                        try {
                            if (object32222 == null) continue;
                            object32222.close();
                            object32222 = null;
                        }
                        catch (SQLException sQLException3) {
                            SimpleApp.printSQLException(sQLException3);
                        }
                    }
                    try {
                        if (connection != null) {
                            connection.close();
                            connection = null;
                        }
                        break block36;
                    }
                    catch (SQLException object32222) {
                        SimpleApp.printSQLException((SQLException)object32222);
                    }
                }
            }
            catch (Throwable throwable) {
                Object object42222;
                Object var14_16 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                        resultSet = null;
                    }
                }
                catch (SQLException sQLException) {
                    SimpleApp.printSQLException(sQLException);
                }
                int n4 = 0;
                while (!arrayList.isEmpty()) {
                    object42222 = (Statement)arrayList.remove(n4);
                    try {
                        if (object42222 == null) continue;
                        object42222.close();
                        object42222 = null;
                    }
                    catch (SQLException sQLException) {
                        SimpleApp.printSQLException(sQLException);
                    }
                }
                try {
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                }
                catch (SQLException object42222) {
                    SimpleApp.printSQLException((SQLException)object42222);
                }
                throw throwable;
            }
        }
    }

    private void loadDriver() {
        try {
            Class.forName(this.driver).newInstance();
            System.out.println("Loaded the appropriate driver");
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("\nUnable to load the JDBC driver " + this.driver);
            System.err.println("Please check your CLASSPATH.");
            classNotFoundException.printStackTrace(System.err);
        }
        catch (InstantiationException instantiationException) {
            System.err.println("\nUnable to instantiate the JDBC driver " + this.driver);
            instantiationException.printStackTrace(System.err);
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("\nNot allowed to access the JDBC driver " + this.driver);
            illegalAccessException.printStackTrace(System.err);
        }
    }

    private void reportFailure(String string) {
        System.err.println("\nData verification failed:");
        System.err.println('\t' + string);
    }

    public static void printSQLException(SQLException sQLException) {
        while (sQLException != null) {
            System.err.println("\n----- SQLException -----");
            System.err.println("  SQL State:  " + sQLException.getSQLState());
            System.err.println("  Error Code: " + sQLException.getErrorCode());
            System.err.println("  Message:    " + sQLException.getMessage());
            sQLException = sQLException.getNextException();
        }
    }

    private void parseArguments(String[] stringArray) {
        if (stringArray.length > 0 && stringArray[0].equalsIgnoreCase("derbyclient")) {
            this.framework = "derbyclient";
            this.driver = "org.apache.derby.jdbc.ClientDriver";
            this.protocol = "jdbc:derby://localhost:1527/";
        }
    }
}

