/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.text;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.ui.IEditorPart;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.ICommentsSupport;
import org.jkiss.dbeaver.ui.editors.text.BaseTextEditor;
import org.jkiss.utils.ArrayUtils;

public class TextEditorPropertyTester
extends PropertyTester {
    public static final String NAMESPACE = "org.jkiss.dbeaver.ui.editors.text";
    public static final String PROP_AVAILABLE = "available";
    public static final String PROP_CAN_LOAD = "canLoad";
    public static final String PROP_CAN_SAVE = "canSave";
    public static final String PROP_CAN_COMMENT = "canComment";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        BaseTextEditor editor = BaseTextEditor.getTextEditor((IEditorPart)receiver);
        if (editor == null) {
            return false;
        }
        switch (property) {
            case "available": 
            case "canSave": {
                return true;
            }
            case "canLoad": {
                return !editor.isReadOnly();
            }
            case "canComment": {
                if (editor.isReadOnly() || editor.getSelectionProvider() == null || editor.getSelectionProvider().getSelection() == null || editor.getSelectionProvider().getSelection().isEmpty()) {
                    return false;
                }
                ICommentsSupport commentsSupport = editor.getCommentsSupport();
                if (commentsSupport == null) {
                    return false;
                }
                if ("single".equals(expectedValue)) {
                    return !ArrayUtils.isEmpty((Object[])commentsSupport.getSingleLineComments());
                }
                if (!"multi".equals(expectedValue)) break;
                return commentsSupport.getMultiLineComments() != null;
            }
        }
        return false;
    }

    public static void firePropertyChange(String propName) {
        ActionUtils.evaluatePropertyState((String)("org.jkiss.dbeaver.ui.editors.text." + propName));
    }
}

