/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.macos;

import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSUserDefaults;
import org.jkiss.dbeaver.ModelPreferences;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.runtime.IPluginService;
import org.jkiss.dbeaver.utils.PrefUtils;

public class CocoaUIService
implements IPluginService {
    public static final String PREF_TOOLTIP_DELAY = "macos.tooltip.delay";
    public static final String PREF_TOOLTIP_DELAY_ENABLED = "macos.tooltip.delay.enabled";
    public static final int DEFAULT_TOOLTIP_DELAY = 300;

    public static void updateTooltipDefaults() {
        DBPPreferenceStore store = ModelPreferences.getPreferences();
        boolean isDelaySetEnabled = store.getBoolean(PREF_TOOLTIP_DELAY_ENABLED);
        NSUserDefaults nsUserDefaults = NSUserDefaults.standardUserDefaults();
        if (isDelaySetEnabled) {
            int tooltipDelay = store.getInt(PREF_TOOLTIP_DELAY);
            if (tooltipDelay <= 0) {
                tooltipDelay = 0;
            }
            nsUserDefaults.setInteger((long)tooltipDelay, NSString.stringWith((String)"NSInitialToolTipDelay"));
        } else {
            nsUserDefaults.setValue(null, NSString.stringWith((String)"NSInitialToolTipDelay"));
        }
    }

    public void activateService() {
        DBPPreferenceStore store = ModelPreferences.getPreferences();
        PrefUtils.setDefaultPreferenceValue((DBPPreferenceStore)store, (String)PREF_TOOLTIP_DELAY_ENABLED, (Object)true);
        PrefUtils.setDefaultPreferenceValue((DBPPreferenceStore)store, (String)PREF_TOOLTIP_DELAY, (Object)300);
        CocoaUIService.updateTooltipDefaults();
    }

    public void deactivateService() {
    }
}

