/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.core.subscribers;

import java.util.Collections;
import java.util.HashSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.variants.ResourceVariantByteStore;

public abstract class DescendantResourceVariantByteStore
extends ResourceVariantByteStore {
    ResourceVariantByteStore baseStore;
    ResourceVariantByteStore remoteStore;

    public DescendantResourceVariantByteStore(ResourceVariantByteStore baseCache, ResourceVariantByteStore remoteCache) {
        this.baseStore = baseCache;
        this.remoteStore = remoteCache;
    }

    @Override
    public void dispose() {
        this.remoteStore.dispose();
    }

    @Override
    public byte[] getBytes(IResource resource) throws TeamException {
        byte[] remoteBytes = this.remoteStore.getBytes(resource);
        byte[] baseBytes = this.baseStore.getBytes(resource);
        if (baseBytes == null) {
            return remoteBytes;
        }
        if (remoteBytes == null) {
            if (this.isVariantKnown(resource)) {
                return remoteBytes;
            }
            return baseBytes;
        }
        if (this.isDescendant(resource, baseBytes, remoteBytes)) {
            return remoteBytes;
        }
        return baseBytes;
    }

    @Override
    public boolean setBytes(IResource resource, byte[] bytes) throws TeamException {
        byte[] baseBytes = this.baseStore.getBytes(resource);
        if (baseBytes != null && this.equals(baseBytes, bytes)) {
            return this.remoteStore.flushBytes(resource, 0);
        }
        return this.remoteStore.setBytes(resource, bytes);
    }

    @Override
    public boolean flushBytes(IResource resource, int depth) throws TeamException {
        return this.remoteStore.flushBytes(resource, depth);
    }

    public abstract boolean isVariantKnown(IResource var1) throws TeamException;

    protected abstract boolean isDescendant(IResource var1, byte[] var2, byte[] var3) throws TeamException;

    @Override
    public boolean deleteBytes(IResource resource) throws TeamException {
        return this.remoteStore.deleteBytes(resource);
    }

    protected ResourceVariantByteStore getBaseStore() {
        return this.baseStore;
    }

    protected ResourceVariantByteStore getRemoteStore() {
        return this.remoteStore;
    }

    @Override
    public IResource[] members(IResource resource) throws TeamException {
        IResource[] remoteMembers = this.getRemoteStore().members(resource);
        IResource[] baseMembers = this.getBaseStore().members(resource);
        HashSet<IResource> members = new HashSet<IResource>();
        Collections.addAll(members, remoteMembers);
        IResource[] iResourceArray = baseMembers;
        int n = baseMembers.length;
        int n2 = 0;
        while (n2 < n) {
            IResource member = iResourceArray[n2];
            if (!this.isVariantKnown(member)) {
                members.add(member);
            }
            ++n2;
        }
        return members.toArray(new IResource[members.size()]);
    }

    @Override
    public void run(IResource root, IWorkspaceRunnable runnable, IProgressMonitor monitor) throws TeamException {
        this.remoteStore.run(root, runnable, monitor);
    }
}

