/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.net.ssh;

import com.jcraft.jsch.AgentConnector;
import com.jcraft.jsch.AgentIdentityRepository;
import com.jcraft.jsch.IdentityRepository;
import com.jcraft.jsch.JUnixSocketFactory;
import com.jcraft.jsch.PageantConnector;
import com.jcraft.jsch.SSHAgentConnector;
import com.jcraft.jsch.USocketFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.exec.DBCInvalidatePhase;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.net.ssh.AbstractSession;
import org.jkiss.dbeaver.model.net.ssh.SSHSession;
import org.jkiss.dbeaver.model.net.ssh.SSHSessionController;
import org.jkiss.dbeaver.model.net.ssh.SSHUtils;
import org.jkiss.dbeaver.model.net.ssh.config.SSHHostConfiguration;
import org.jkiss.dbeaver.model.net.ssh.config.SSHPortForwardConfiguration;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public abstract class AbstractSessionController<T extends AbstractSession>
implements SSHSessionController {
    private static final Log log = Log.getLog(AbstractSessionController.class);
    protected final Map<SSHHostConfiguration, ShareableSession<T>> sessions = new ConcurrentHashMap<SSHHostConfiguration, ShareableSession<T>>();
    protected AgentIdentityRepository agentIdentityRepository;

    @Override
    @NotNull
    public SSHSession acquireSession(@NotNull DBRProgressMonitor monitor, @NotNull DBWHandlerConfiguration configuration, @NotNull SSHHostConfiguration destination, @Nullable SSHSession origin, @Nullable SSHPortForwardConfiguration portForward) throws DBException {
        DelegateSession session = origin != null ? this.createJumpSession(this.getDelegateSession(origin), destination, portForward) : this.createDirectSession(configuration, destination, portForward);
        ((AbstractSession)session).connect(monitor, destination, configuration);
        return session;
    }

    @NotNull
    private DirectSession<T> createDirectSession(@NotNull DBWHandlerConfiguration configuration, @NotNull SSHHostConfiguration destination, @Nullable SSHPortForwardConfiguration portForward) {
        ShareableSession<T> session = this.getSharedSession(configuration, destination);
        if (session == null) {
            session = new ShareableSession(this, destination);
        }
        return new DirectSession<T>(session, portForward);
    }

    @NotNull
    private JumpSession<T> createJumpSession(@NotNull DelegateSession origin, @NotNull SSHHostConfiguration destination, @Nullable SSHPortForwardConfiguration portForward) {
        return new JumpSession(this, origin, destination, portForward);
    }

    @Override
    public void release(@NotNull DBRProgressMonitor monitor, @NotNull SSHSession session, @NotNull DBWHandlerConfiguration configuration, long timeout) throws DBException {
        this.getDelegateSession(session).disconnect(monitor, configuration, timeout);
    }

    @Override
    public void invalidate(@NotNull DBRProgressMonitor monitor, @NotNull SSHSession session, @NotNull DBCInvalidatePhase phase, @NotNull DBWHandlerConfiguration configuration, long timeout) throws DBException {
        DelegateSession delegate = this.getDelegateSession(session);
        if (phase == DBCInvalidatePhase.BEFORE_INVALIDATE) {
            this.release(monitor, delegate, configuration, timeout);
        }
        if (phase == DBCInvalidatePhase.INVALIDATE) {
            delegate.connect(monitor, delegate.destination, configuration);
        }
    }

    @Override
    @NotNull
    public SSHSession[] getSessions() {
        return (SSHSession[])this.sessions.values().toArray(SSHSession[]::new);
    }

    @Override
    @NotNull
    public DBPDataSourceContainer[] getDependentDataSources(@NotNull SSHSession session) {
        return this.getDelegateSession(session).getDataSources();
    }

    @NotNull
    protected IdentityRepository createAgentIdentityRepository() throws DBException {
        if (this.agentIdentityRepository == null) {
            PageantConnector connector = null;
            try {
                connector = new PageantConnector();
                log.debug((Object)"SSHSessionController: connected with pageant");
            }
            catch (Exception e) {
                log.debug((Object)"SSHSessionController: pageant connect exception", (Throwable)e);
            }
            if (connector == null) {
                try {
                    connector = new SSHAgentConnector((USocketFactory)new JUnixSocketFactory());
                    log.debug((Object)"SSHSessionController: Connected with ssh-agent");
                }
                catch (Exception e) {
                    log.debug((Object)"SSHSessionController: ssh-agent connection exception", (Throwable)e);
                }
            }
            if (connector == null) {
                throw new DBException("Unable to initialize SSH agent");
            }
            this.agentIdentityRepository = new AgentIdentityRepository((AgentConnector)connector);
        }
        return this.agentIdentityRepository;
    }

    @NotNull
    protected abstract T createSession();

    @NotNull
    protected DelegateSession getDelegateSession(@NotNull SSHSession session) {
        if (session instanceof DelegateSession) {
            DelegateSession delegate = (DelegateSession)session;
            return delegate;
        }
        throw new IllegalStateException("Unexpected session type: " + String.valueOf(session) + " (" + session.getClass().getName() + ")");
    }

    protected void registerSession(@NotNull ShareableSession<T> session, @NotNull DBWHandlerConfiguration configuration) {
        if (AbstractSessionController.canShareSessionForConfiguration(configuration)) {
            this.sessions.put(session.destination, session);
        }
    }

    protected void unregisterSession(@NotNull ShareableSession<T> session, @NotNull DBWHandlerConfiguration configuration) {
        if (AbstractSessionController.canShareSessionForConfiguration(configuration)) {
            this.sessions.remove(session.destination);
        }
    }

    @Nullable
    private ShareableSession<T> getSharedSession(@NotNull DBWHandlerConfiguration configuration, @NotNull SSHHostConfiguration destination) {
        if (AbstractSessionController.canShareSessionForConfiguration(configuration)) {
            return this.sessions.get(destination);
        }
        return null;
    }

    protected static boolean canShareSessionForConfiguration(@NotNull DBWHandlerConfiguration configuration) {
        return !SSHUtils.DISABLE_SESSION_SHARING && configuration.getDataSource() != null && configuration.getBooleanProperty("shareTunnels", true);
    }

    protected static abstract class DelegateSession
    extends AbstractSession {
        protected final SSHHostConfiguration destination;

        public DelegateSession(@NotNull SSHHostConfiguration destination) {
            this.destination = destination;
        }

        @Override
        public void connect(@NotNull DBRProgressMonitor monitor, @NotNull SSHHostConfiguration destination, @NotNull DBWHandlerConfiguration configuration) throws DBException {
            log.debug((Object)("SSHSessionController: Connecting session to " + String.valueOf(destination)));
            this.getSession().connect(monitor, destination, configuration);
        }

        @Override
        public void disconnect(@NotNull DBRProgressMonitor monitor, @NotNull DBWHandlerConfiguration configuration, long timeout) throws DBException {
            log.debug((Object)("SSHSessionController: Disconnecting session to " + String.valueOf(this.destination)));
            this.getSession().disconnect(monitor, configuration, timeout);
        }

        @Override
        @NotNull
        public SSHPortForwardConfiguration setupPortForward(@NotNull SSHPortForwardConfiguration configuration) throws DBException {
            log.debug((Object)("SSHSessionController: Set up port forwarding " + String.valueOf(configuration)));
            return this.getSession().setupPortForward(configuration);
        }

        @Override
        public void removePortForward(@NotNull SSHPortForwardConfiguration configuration) throws DBException {
            log.debug((Object)("SSHSessionController: Remove port forwarding " + String.valueOf(configuration)));
            this.getSession().removePortForward(configuration);
        }

        @Override
        public void getFile(@NotNull String src, @NotNull OutputStream dst, @NotNull DBRProgressMonitor monitor) throws DBException, IOException {
            this.getSession().getFile(src, dst, monitor);
        }

        @Override
        public void putFile(@NotNull InputStream src, @NotNull String dst, @NotNull DBRProgressMonitor monitor) throws DBException, IOException {
            this.getSession().putFile(src, dst, monitor);
        }

        @Override
        @NotNull
        public String getClientVersion() {
            return this.getSession().getClientVersion();
        }

        @Override
        @NotNull
        public String getServerVersion() {
            return this.getSession().getServerVersion();
        }

        @NotNull
        protected abstract AbstractSession getSession();

        @NotNull
        protected abstract DBPDataSourceContainer[] getDataSources();
    }

    protected static class DirectSession<T extends AbstractSession>
    extends WrapperSession<T> {
        private SSHPortForwardConfiguration portForward;

        public DirectSession(@NotNull ShareableSession<T> inner, @Nullable SSHPortForwardConfiguration portForward) {
            super(inner);
            this.portForward = portForward;
        }

        @Override
        public synchronized void connect(@NotNull DBRProgressMonitor monitor, @NotNull SSHHostConfiguration destination, @NotNull DBWHandlerConfiguration configuration) throws DBException {
            super.connect(monitor, destination, configuration);
            if (this.portForward != null) {
                this.portForward = super.setupPortForward(this.portForward);
            }
        }

        @Override
        public synchronized void disconnect(@NotNull DBRProgressMonitor monitor, @NotNull DBWHandlerConfiguration configuration, long timeout) throws DBException {
            if (this.portForward != null) {
                super.removePortForward(this.portForward);
            }
            super.disconnect(monitor, configuration, timeout);
        }
    }

    protected static class JumpSession<T extends AbstractSession>
    extends DelegateSession {
        private final AbstractSessionController<T> controller;
        private final DelegateSession origin;
        private SSHPortForwardConfiguration portForward;
        private DelegateSession jumpDestination;
        private SSHPortForwardConfiguration jumpPortForward;
        private boolean registered;

        public JumpSession(@NotNull AbstractSessionController<T> controller, @NotNull DelegateSession origin, @NotNull SSHHostConfiguration destination, @Nullable SSHPortForwardConfiguration portForward) {
            super(destination);
            this.controller = controller;
            this.origin = origin;
            this.portForward = portForward;
            this.registered = true;
        }

        @Override
        public void connect(@NotNull DBRProgressMonitor monitor, @NotNull SSHHostConfiguration host, @NotNull DBWHandlerConfiguration configuration) throws DBException {
            if (!this.registered) {
                this.origin.connect(monitor, this.origin.destination, configuration);
                this.registered = true;
            }
            this.jumpPortForward = this.origin.setupPortForward(new SSHPortForwardConfiguration("127.0.0.1", 0, host.hostname(), host.port()));
            SSHHostConfiguration jumpHost = new SSHHostConfiguration(host.username(), this.jumpPortForward.localHost(), this.jumpPortForward.localPort(), host.auth());
            this.jumpDestination = this.controller.createDirectSession(configuration, jumpHost, null);
            this.jumpDestination.connect(monitor, jumpHost, configuration);
            if (this.portForward != null) {
                this.portForward = this.jumpDestination.setupPortForward(this.portForward);
            }
        }

        @Override
        public void disconnect(@NotNull DBRProgressMonitor monitor, @NotNull DBWHandlerConfiguration configuration, long timeout) throws DBException {
            if (this.jumpDestination != null) {
                if (this.portForward != null) {
                    this.jumpDestination.removePortForward(this.portForward);
                }
                this.jumpDestination.disconnect(monitor, configuration, timeout);
            }
            if (this.jumpPortForward != null) {
                this.origin.removePortForward(this.jumpPortForward);
            }
            try {
                this.origin.disconnect(monitor, configuration, timeout);
            }
            catch (Exception e) {
                log.debug((Object)"Error during SSH session close", (Throwable)e);
            }
            this.registered = false;
            this.jumpDestination = null;
            this.jumpPortForward = null;
        }

        @Override
        @NotNull
        protected AbstractSession getSession() {
            return this.jumpDestination;
        }

        @Override
        @NotNull
        protected DBPDataSourceContainer[] getDataSources() {
            return this.origin.getDataSources();
        }
    }

    protected static class ShareableSession<T extends AbstractSession>
    extends DelegateSession {
        protected final Map<DBPDataSourceContainer, AtomicInteger> dataSources = new HashMap<DBPDataSourceContainer, AtomicInteger>();
        protected final Map<SSHPortForwardConfiguration, PortForwardInfo> portForwards = new HashMap<SSHPortForwardConfiguration, PortForwardInfo>();
        protected final AbstractSessionController<T> controller;
        protected final T session;

        public ShareableSession(@NotNull AbstractSessionController<T> controller, @NotNull SSHHostConfiguration destination) {
            super(destination);
            this.controller = controller;
            this.session = controller.createSession();
        }

        @Property(viewable=true, order=1, name="Destination")
        public String getDestinationInfo() {
            return this.destination.toDisplayString();
        }

        @Property(viewable=true, order=2, name="Used By")
        public String getConsumerInfo() {
            return this.dataSources.entrySet().stream().map(entry -> "%s (%s)".formatted(entry.getKey(), entry.getValue())).collect(Collectors.joining(", "));
        }

        @Property(viewable=true, order=3, name="Port Forwards")
        public String getPortForwardingInfo() {
            return this.portForwards.values().stream().map(info -> "%s (%d)".formatted(info.resolved.toDisplayString(), info.usages.get())).collect(Collectors.joining(", "));
        }

        @Override
        public synchronized void connect(@NotNull DBRProgressMonitor monitor, @NotNull SSHHostConfiguration destination, @NotNull DBWHandlerConfiguration configuration) throws DBException {
            DBPDataSourceContainer container;
            AtomicInteger counter;
            if (this.dataSources.isEmpty()) {
                log.debug((Object)("SSHSessionController: Creating new session to " + String.valueOf(destination)));
                super.connect(monitor, destination, configuration);
                this.controller.registerSession(this, configuration);
            }
            if ((counter = this.dataSources.get(container = configuration.getDataSource())) == null) {
                this.dataSources.put(container, new AtomicInteger(1));
            } else {
                log.debug((Object)("SSHSessionController: Reusing session to " + String.valueOf(destination) + " for " + String.valueOf(container)));
                counter.incrementAndGet();
            }
        }

        @Override
        public synchronized void disconnect(@NotNull DBRProgressMonitor monitor, @NotNull DBWHandlerConfiguration configuration, long timeout) throws DBException {
            DBPDataSourceContainer container = configuration.getDataSource();
            AtomicInteger counter = this.dataSources.get(container);
            if (counter == null) {
                throw new DBException("Session is not acquired for " + String.valueOf(container));
            }
            if (counter.decrementAndGet() == 0) {
                log.debug((Object)("SSHSessionController: Releasing session for " + String.valueOf(container)));
                this.dataSources.remove(container);
            }
            if (this.dataSources.isEmpty()) {
                this.controller.unregisterSession(this, configuration);
                super.disconnect(monitor, configuration, timeout);
            }
        }

        @Override
        @NotNull
        public synchronized SSHPortForwardConfiguration setupPortForward(@NotNull SSHPortForwardConfiguration configuration) throws DBException {
            PortForwardInfo info = this.portForwards.get(configuration);
            if (info != null) {
                log.debug((Object)("SSHSessionController: Reusing port forward " + String.valueOf(configuration)));
                info.usages.incrementAndGet();
                return info.resolved;
            }
            SSHPortForwardConfiguration resolved = super.setupPortForward(configuration);
            this.portForwards.put(resolved, new PortForwardInfo(resolved, new AtomicInteger(1)));
            return resolved;
        }

        @Override
        public void removePortForward(@NotNull SSHPortForwardConfiguration configuration) throws DBException {
            PortForwardInfo info = this.portForwards.get(configuration);
            if (info == null) {
                log.debug((Object)("SSH port forward is not set up: " + String.valueOf(configuration) + ". Tunnel opening was interrupted?"));
            } else if (info.usages.decrementAndGet() == 0) {
                super.removePortForward(info.resolved);
                this.portForwards.remove(configuration);
            }
        }

        @NotNull
        protected T getSession() {
            return this.session;
        }

        @Override
        @NotNull
        protected DBPDataSourceContainer[] getDataSources() {
            return this.dataSources.keySet().toArray(new DBPDataSourceContainer[0]);
        }

        protected record PortForwardInfo(@NotNull SSHPortForwardConfiguration resolved, @NotNull AtomicInteger usages) {
            static /* synthetic */ SSHPortForwardConfiguration access$6(PortForwardInfo portForwardInfo) {
                return portForwardInfo.resolved;
            }

            static /* synthetic */ AtomicInteger access$7(PortForwardInfo portForwardInfo) {
                return portForwardInfo.usages;
            }
        }
    }

    protected static class WrapperSession<T extends AbstractSession>
    extends DelegateSession {
        protected final ShareableSession<T> inner;

        public WrapperSession(@NotNull ShareableSession<T> inner) {
            super(inner.destination);
            this.inner = inner;
        }

        @Override
        public void connect(@NotNull DBRProgressMonitor monitor, @NotNull SSHHostConfiguration destination, @NotNull DBWHandlerConfiguration configuration) throws DBException {
            this.inner.connect(monitor, destination, configuration);
        }

        @Override
        public void disconnect(@NotNull DBRProgressMonitor monitor, @NotNull DBWHandlerConfiguration configuration, long timeout) throws DBException {
            this.inner.disconnect(monitor, configuration, timeout);
        }

        @Override
        @NotNull
        public SSHPortForwardConfiguration setupPortForward(@NotNull SSHPortForwardConfiguration configuration) throws DBException {
            return this.inner.setupPortForward(configuration);
        }

        @Override
        public void removePortForward(@NotNull SSHPortForwardConfiguration configuration) throws DBException {
            this.inner.removePortForward(configuration);
        }

        @Override
        @NotNull
        protected AbstractSession getSession() {
            return this.inner;
        }

        @Override
        @NotNull
        protected DBPDataSourceContainer[] getDataSources() {
            return this.inner.getDataSources();
        }
    }
}

