/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkingSetFilterActionGroup;

public class WorkingSetMenuContributionItem
extends ContributionItem {
    private Image image;
    private final int id;
    private final IWorkingSet workingSet;
    private final WorkingSetFilterActionGroup actionGroup;

    public static String getId(int id) {
        return WorkingSetMenuContributionItem.class.getName() + "." + id;
    }

    public WorkingSetMenuContributionItem(int id, WorkingSetFilterActionGroup actionGroup, IWorkingSet workingSet) {
        super(WorkingSetMenuContributionItem.getId(id));
        Assert.isNotNull((Object)actionGroup);
        Assert.isNotNull((Object)workingSet);
        this.id = id;
        this.actionGroup = actionGroup;
        this.workingSet = workingSet;
    }

    public void fill(Menu menu, int index) {
        ImageDescriptor imageDescriptor;
        MenuItem mi = new MenuItem(menu, 16, index);
        mi.setText("&" + this.id + " " + this.workingSet.getLabel());
        mi.setSelection(this.workingSet.equals(this.actionGroup.getWorkingSet()));
        mi.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            IWorkingSetManager manager = PlatformUI.getWorkbench().getWorkingSetManager();
            this.actionGroup.setWorkingSet(this.workingSet);
            manager.addRecentWorkingSet(this.workingSet);
        }));
        if (this.image == null && (imageDescriptor = this.workingSet.getImageDescriptor()) != null) {
            this.image = imageDescriptor.createImage();
            mi.addDisposeListener(e -> {
                if (this.image != null && !this.image.isDisposed()) {
                    this.image.dispose();
                }
            });
        }
        mi.setImage(this.image);
    }

    public boolean isDynamic() {
        return true;
    }

    public void dispose() {
        if (this.image != null && !this.image.isDisposed()) {
            this.image.dispose();
        }
        this.image = null;
        super.dispose();
    }
}

