/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.driver.libsql;

import com.dbeaver.jdbc.driver.libsql.LibSqlConnection;
import com.dbeaver.jdbc.driver.libsql.LibSqlException;
import com.dbeaver.jdbc.driver.libsql.LibSqlResultSet;
import com.dbeaver.jdbc.driver.libsql.client.LibSqlExecutionResult;
import com.dbeaver.jdbc.model.AbstractJdbcConnection;
import com.dbeaver.jdbc.model.AbstractJdbcStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;

public class LibSqlStatement
extends AbstractJdbcStatement<LibSqlConnection> {
    protected String queryText;
    protected Map<Object, Object> parameters = new LinkedHashMap<Object, Object>();
    protected LibSqlExecutionResult executionResult;
    protected LibSqlResultSet resultSet;

    public LibSqlStatement(@NotNull LibSqlConnection connection) throws SQLException {
        super((AbstractJdbcConnection)connection);
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        this.executionResult = ((LibSqlConnection)this.connection).getClient().execute(sql, this.parameters);
        return this.getResultSet();
    }

    public ResultSet executeQuery() throws SQLException {
        return this.executeQuery(this.queryText);
    }

    protected boolean execute(@NotNull String sql, @Nullable int[] columnIndexes, @Nullable String[] columnNames, int autoGeneratedKeys) throws SQLException {
        this.executionResult = ((LibSqlConnection)this.connection).getClient().execute(sql, this.parameters);
        return true;
    }

    public boolean execute() throws SQLException {
        this.executionResult = ((LibSqlConnection)this.connection).getClient().execute(this.queryText, this.parameters);
        return true;
    }

    protected int executeUpdate(@NotNull String sql, @Nullable int[] columnIndexes, @Nullable String[] columnNames, int autoGeneratedKeys) throws SQLException {
        this.executionResult = ((LibSqlConnection)this.connection).getClient().execute(sql, this.parameters);
        return (int)this.executionResult.getUpdateCount();
    }

    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        this.executionResult = ((LibSqlConnection)this.connection).getClient().execute(sql, this.parameters);
        return this.executionResult.getUpdateCount();
    }

    public long executeLargeUpdate(String sql) throws SQLException {
        this.executionResult = ((LibSqlConnection)this.connection).getClient().execute(sql, this.parameters);
        return this.executionResult.getUpdateCount();
    }

    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.executionResult = ((LibSqlConnection)this.connection).getClient().execute(sql, this.parameters);
        return this.executionResult.getUpdateCount();
    }

    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.executionResult = ((LibSqlConnection)this.connection).getClient().execute(sql, this.parameters);
        return this.executionResult.getUpdateCount();
    }

    public long executeLargeUpdate() throws SQLException {
        this.executionResult = ((LibSqlConnection)this.connection).getClient().execute(this.queryText, this.parameters);
        return this.executionResult.getUpdateCount();
    }

    public void close() throws SQLException {
    }

    public void cancel() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public ResultSet getResultSet() throws SQLException {
        if (this.resultSet == null) {
            if (this.executionResult == null) {
                throw new SQLException("No result set was returned from server");
            }
            this.resultSet = new LibSqlResultSet(this, this.executionResult);
        }
        return this.resultSet;
    }

    public int getUpdateCount() throws SQLException {
        if (this.executionResult == null) {
            throw new LibSqlException("No update count before statement execute");
        }
        return (int)this.executionResult.getUpdateCount();
    }

    public long getLargeUpdateCount() throws SQLException {
        if (this.executionResult == null) {
            throw new LibSqlException("No update count before statement execute");
        }
        return this.executionResult.getUpdateCount();
    }

    public boolean getMoreResults() throws SQLException {
        return false;
    }

    public void setFetchDirection(int direction) throws SQLException {
    }

    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    public boolean getMoreResults(int current) throws SQLException {
        return false;
    }

    public boolean isClosed() throws SQLException {
        return false;
    }
}

