/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.kingbase.ui.config;

import java.util.Map;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.kingbase.model.KingbaseFunction;
import org.jkiss.dbeaver.ext.kingbase.model.KingbaseProcedure;
import org.jkiss.dbeaver.ext.kingbase.ui.views.CreateFunctionOrProcedurePage;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreLanguage;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreProcedureKind;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectConfigurator;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.ui.UITask;

public class KingbaseFunctionConfigurator
implements DBEObjectConfigurator<KingbaseFunction> {
    protected static final Log log = Log.getLog(KingbaseFunctionConfigurator.class);
    public static boolean isFunction = true;

    public KingbaseFunction configureObject(final DBRProgressMonitor monitor, DBECommandContext commandContext, Object container, final KingbaseFunction newProcedure, Map<String, Object> options) {
        return (KingbaseFunction)new UITask<KingbaseFunction>(){

            protected KingbaseFunction runTask() {
                CreateFunctionOrProcedurePage editPage = new CreateFunctionOrProcedurePage(monitor, (KingbaseProcedure)newProcedure, isFunction);
                if (!editPage.edit()) {
                    return null;
                }
                newProcedure.setKind(PostgreProcedureKind.f);
                newProcedure.setReturnType(editPage.getReturnType());
                newProcedure.setName(editPage.getProcedureName());
                PostgreLanguage language = editPage.getLanguage();
                if (language != null) {
                    newProcedure.setLanguage(language);
                }
                String function = "CREATE [OR REPLACE] FUNCTION " + newProcedure.getFullQualifiedSignature() + " ([ parameter [IN|OUT|INOUT] datatype[,parameter [IN|OUT|INOUT] datatype] ])\r\n RETURNS " + newProcedure.getReturnType().getDefaultValue() + "\r\n LANGUAGE " + language.getName() + "\r\n\r\nAS\r\n\r\n '/*iso file path and name*/',$$/*function name*/$$";
                newProcedure.setObjectDefinitionText(function);
                return newProcedure;
            }
        }.execute();
    }
}

