/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.expression;

import java.util.Objects;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.parser.ASTNodeAccessImpl;

public class IntervalExpression
extends ASTNodeAccessImpl
implements Expression {
    private final boolean intervalKeyword;
    private String parameter = null;
    private String intervalType = null;
    private Expression expression = null;

    public IntervalExpression() {
        this(true);
    }

    public IntervalExpression(boolean intervalKeyword) {
        this.intervalKeyword = intervalKeyword;
    }

    public IntervalExpression(int value, String type) {
        this.parameter = null;
        this.intervalKeyword = true;
        this.expression = new LongValue(value);
        this.intervalType = type;
    }

    public boolean isUsingIntervalKeyword() {
        return this.intervalKeyword;
    }

    public String getParameter() {
        return this.parameter;
    }

    public void setParameter(String parameter) {
        this.parameter = parameter;
    }

    public String getIntervalType() {
        return this.intervalType;
    }

    public void setIntervalType(String intervalType) {
        this.intervalType = intervalType;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    @Override
    public String toString() {
        return (this.intervalKeyword ? "INTERVAL " : "") + Objects.toString(this.expression, this.parameter) + (String)(this.intervalType != null ? " " + this.intervalType : "");
    }

    @Override
    public <T, S> T accept(ExpressionVisitor<T> expressionVisitor, S context) {
        return expressionVisitor.visit(this, context);
    }

    public IntervalExpression withParameter(String parameter) {
        this.setParameter(parameter);
        return this;
    }

    public IntervalExpression withIntervalType(String intervalType) {
        this.setIntervalType(intervalType);
        return this;
    }

    public IntervalExpression withExpression(Expression expression) {
        this.setExpression(expression);
        return this;
    }

    public <E extends Expression> E getExpression(Class<E> type) {
        return (E)((Expression)type.cast(this.getExpression()));
    }
}

