/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.css;

import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.helpers.SWTElementHelpers;
import org.eclipse.e4.ui.css.swt.properties.css2.CSSPropertyBackgroundSWTHandler;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ui.ConComposite;
import org.jkiss.dbeaver.ui.UIStyles;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.css.CSSUtils;
import org.jkiss.dbeaver.ui.css.ICSSBackgroundMimicControl;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import org.w3c.dom.css.CSSValue;

public class ConControlElementHandler
extends CSSPropertyBackgroundSWTHandler {
    private static final Class<?>[] EXCLUDE_CLASSES = new Class[]{Tree.class, Table.class};

    public void applyCSSPropertyBackgroundColor(Object element, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        Color newColor;
        Control ctrl;
        Widget widget = SWTElementHelpers.getWidget((Object)element);
        if (widget instanceof ToolBar) {
            ToolBar toolBar = (ToolBar)widget;
            Color defForeground = UIStyles.getDefaultTextForeground();
            toolBar.setForeground(defForeground);
            Color bgColor = CSSUtils.getCurrentEditorConnectionColor(widget);
            if (bgColor != null) {
                toolBar.setBackground(bgColor);
            }
            return;
        }
        if (widget instanceof Control && !UIUtils.isInDialog(ctrl = (Control)widget) && !ConControlElementHandler.isExcludedFromStyling(ctrl) && this.isOverridesBackground(ctrl) && (newColor = CSSUtils.getCurrentEditorConnectionColor(widget)) != null) {
            ctrl.setBackground(newColor);
            return;
        }
        if (widget instanceof ICSSBackgroundMimicControl) {
            ICSSBackgroundMimicControl textWidget = (ICSSBackgroundMimicControl)widget;
            Color background = textWidget.getOriginWidget().getBackground();
            if (background.getRed() == 255 && background.getGreen() == 255 && background.getBlue() == 255 && UIStyles.isDarkTheme()) {
                return;
            }
            textWidget.setBackground(background);
            return;
        }
        super.applyCSSPropertyBackgroundColor(element, value, pseudo, engine);
    }

    private static boolean isExcludedFromStyling(Control ctrl) {
        if (ArrayUtils.contains((Object[])EXCLUDE_CLASSES, ctrl.getClass()) || CSSUtils.isExcludeFromStyling((Widget)ctrl)) {
            return true;
        }
        if (ctrl instanceof Text || ctrl instanceof StyledText) {
            return CommonUtils.isBitSet((int)ctrl.getStyle(), (int)2048);
        }
        if (ctrl instanceof Button) {
            return !CommonUtils.isBitSet((int)ctrl.getStyle(), (int)32) && !CommonUtils.isBitSet((int)ctrl.getStyle(), (int)16);
        }
        return ctrl instanceof Combo || ctrl instanceof CCombo;
    }

    private boolean isOverridesBackground(@NotNull Control control) {
        while (control != null) {
            if (CSSUtils.isExcludeFromStyling((Widget)control)) {
                return false;
            }
            if (control.getClass().getName().contains("FindReplaceOverlay")) {
                return false;
            }
            if (control instanceof ConComposite || CSSUtils.isDatabaseColored((Widget)control)) {
                return true;
            }
            control = control.getParent();
        }
        return false;
    }
}

