/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.tasks;

import java.util.List;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableBase;
import org.jkiss.dbeaver.ext.oracle.tasks.OracleToolMViewRefreshSettings;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.sql.task.SQLToolExecuteHandler;

public class OracleToolMViewRefresh
extends SQLToolExecuteHandler<OracleTableBase, OracleToolMViewRefreshSettings> {
    public OracleToolMViewRefreshSettings createToolSettings() {
        return new OracleToolMViewRefreshSettings();
    }

    public void generateObjectQueries(DBCSession session, OracleToolMViewRefreshSettings settings, List<DBEPersistAction> queries, OracleTableBase object) throws DBCException {
        Object method = "";
        if (settings.isFast()) {
            method = (String)method + "f";
        }
        if (settings.isForce()) {
            method = (String)method + "?";
        }
        if (settings.isComplete()) {
            method = (String)method + "c";
        }
        if (settings.isAlways()) {
            method = (String)method + "a";
        }
        if (settings.isRecomputed()) {
            method = (String)method + "p";
        }
        String sql = "CALL DBMS_MVIEW.REFRESH('" + object.getFullyQualifiedName(DBPEvaluationContext.DDL) + "','" + (String)method + "')";
        queries.add((DBEPersistAction)new SQLDatabasePersistAction(sql));
    }

    public boolean needsRefreshOnFinish() {
        return true;
    }
}

