/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.ui.refactoring.history;

import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.InvocationTargetException;
import java.text.ChoiceFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.LegacyActionTools;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CheckConditionsOperation;
import org.eclipse.ltk.core.refactoring.CreateChangeOperation;
import org.eclipse.ltk.core.refactoring.PerformChangeOperation;
import org.eclipse.ltk.core.refactoring.PerformRefactoringHistoryOperation;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringContext;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusEntry;
import org.eclipse.ltk.core.refactoring.history.IRefactoringHistoryService;
import org.eclipse.ltk.core.refactoring.history.RefactoringHistory;
import org.eclipse.ltk.internal.core.refactoring.history.RefactoringHistoryImplementation;
import org.eclipse.ltk.internal.core.refactoring.history.RefactoringHistoryManager;
import org.eclipse.ltk.internal.ui.refactoring.ChangeExceptionHandler;
import org.eclipse.ltk.internal.ui.refactoring.ExceptionHandler;
import org.eclipse.ltk.internal.ui.refactoring.IErrorWizardPage;
import org.eclipse.ltk.internal.ui.refactoring.IPreviewWizardPage;
import org.eclipse.ltk.internal.ui.refactoring.Messages;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringHistoryPreviewPage;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringPluginImages;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringPreviewChangeFilter;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringStatusEntryFilter;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIMessages;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIPlugin;
import org.eclipse.ltk.internal.ui.refactoring.UIPerformChangeOperation;
import org.eclipse.ltk.internal.ui.refactoring.WorkbenchRunnableAdapter;
import org.eclipse.ltk.internal.ui.refactoring.history.RefactoringHistoryErrorPage;
import org.eclipse.ltk.internal.ui.refactoring.history.RefactoringHistoryOverviewPage;
import org.eclipse.ltk.ui.refactoring.history.RefactoringHistoryControlConfiguration;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class RefactoringHistoryWizard
extends Wizard {
    private static final String PREFERENCE_DO_NOT_SHOW_APPLY_ERROR = RefactoringUIPlugin.getPluginId() + ".do.not.show.apply.refactoring";
    private static final String PREFERENCE_DO_NOT_SHOW_SKIP = RefactoringUIPlugin.getPluginId() + ".do.not.show.skip.refactoring";
    private static final String PREFERENCE_DO_NOT_WARN_FINISH = RefactoringUIPlugin.getPluginId() + ".do.not.warn.finish.wizard";
    private static final String PREFERENCE_DO_NOT_WARN_UNDO_ON_CANCEL = RefactoringUIPlugin.getPluginId() + ".do.not.warn.undo.on.cancel.refactoring";
    public static final int STATUS_CODE_INTERRUPTED = 10003;
    private boolean fAboutToPerformFired = false;
    private boolean fCancelException = false;
    private RefactoringHistoryControlConfiguration fControlConfiguration;
    private int fCurrentRefactoring = 0;
    private RefactoringDescriptorProxy[] fDescriptorProxies = null;
    private final RefactoringHistoryErrorPage fErrorPage;
    private int fExecutedRefactorings = 0;
    private boolean fHeadlessErrorStatus = false;
    private boolean fInAddPages = false;
    private NoOverviewWizardPage fNoOverviewPage;
    private final String fOverviewDescription;
    private RefactoringHistoryOverviewPage fOverviewPage;
    private final String fOverviewTitle;
    private final RefactoringPreviewChangeFilter fPreviewChangeFilter = new RefactoringPreviewChangeFilter(){

        @Override
        public final boolean select(Change change) {
            return RefactoringHistoryWizard.this.selectPreviewChange(change);
        }
    };
    private final RefactoringHistoryPreviewPage fPreviewPage;
    private RefactoringHistory fRefactoringHistory;
    private final boolean fShowOverview;
    private final RefactoringStatusEntryFilter fStatusEntryFilter = new RefactoringStatusEntryFilter(){

        @Override
        public final boolean select(RefactoringStatusEntry entry) {
            return RefactoringHistoryWizard.this.selectStatusEntry(entry);
        }
    };

    public RefactoringHistoryWizard(boolean overview, String caption, String title, String description) {
        Assert.isNotNull((Object)caption);
        Assert.isNotNull((Object)title);
        Assert.isNotNull((Object)description);
        this.fShowOverview = overview;
        this.fOverviewTitle = title;
        this.fOverviewDescription = description;
        this.fErrorPage = new RefactoringHistoryErrorPage();
        this.fErrorPage.setFilter(this.fStatusEntryFilter);
        this.fPreviewPage = new RefactoringHistoryPreviewPage();
        this.fPreviewPage.setFilter(this.fPreviewChangeFilter);
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(caption);
        this.setDefaultPageImageDescriptor(RefactoringPluginImages.DESC_WIZBAN_REFACTOR);
    }

    public RefactoringHistoryWizard(String caption, String title, String description) {
        this(true, caption, title, description);
    }

    protected RefactoringStatus aboutToPerformHistory(IProgressMonitor monitor) {
        Assert.isNotNull((Object)monitor);
        this.fExecutedRefactorings = 0;
        return new RefactoringStatus();
    }

    protected RefactoringStatus aboutToPerformRefactoring(Refactoring refactoring, RefactoringDescriptor descriptor, IProgressMonitor monitor) {
        Assert.isNotNull((Object)refactoring);
        Assert.isNotNull((Object)descriptor);
        return new RefactoringStatus();
    }

    public final void addPage(IWizardPage page) {
        Assert.isTrue((boolean)this.fInAddPages);
        super.addPage(page);
    }

    public final void addPages() {
        try {
            this.fInAddPages = true;
            this.addUserDefinedPages();
            Assert.isNotNull((Object)this.fRefactoringHistory);
            Assert.isNotNull((Object)this.fControlConfiguration);
            if (this.fShowOverview) {
                this.fOverviewPage = new RefactoringHistoryOverviewPage(this.fRefactoringHistory, this.fOverviewTitle, this.fOverviewDescription, this.fControlConfiguration);
                this.addPage((IWizardPage)this.fOverviewPage);
            } else {
                this.fNoOverviewPage = new NoOverviewWizardPage();
                this.addPage((IWizardPage)this.fNoOverviewPage);
            }
            this.addPage(this.fErrorPage);
            this.addPage(this.fPreviewPage);
        }
        finally {
            this.fInAddPages = false;
        }
    }

    protected void addUserDefinedPages() {
        Assert.isTrue((boolean)this.fInAddPages);
    }

    public boolean canFinish() {
        IWizardPage page = this.getContainer().getCurrentPage();
        if (page == this.fErrorPage) {
            boolean fatal;
            if (this.fHeadlessErrorStatus) {
                return true;
            }
            RefactoringStatus status = this.fErrorPage.getStatus();
            boolean bl = fatal = status != null && status.hasFatalError();
            if (this.isLastRefactoring() && this.fDescriptorProxies.length > 1) {
                if (fatal) {
                    this.fHeadlessErrorStatus = true;
                }
                return true;
            }
            return !fatal;
        }
        return true;
    }

    private RefactoringStatus checkConditions(Refactoring refactoring, IProgressMonitor monitor, int style) throws OperationCanceledException {
        Assert.isNotNull((Object)refactoring);
        Assert.isNotNull((Object)monitor);
        RefactoringStatus status = new RefactoringStatus();
        try {
            CheckConditionsOperation operation = new CheckConditionsOperation(refactoring, style);
            operation.run(monitor);
            status.merge(operation.getStatus());
        }
        catch (CoreException exception) {
            RefactoringUIPlugin.log(exception);
            status.addFatalError(RefactoringUIMessages.RefactoringWizard_internal_error_1);
        }
        return status;
    }

    private Change createChange(Refactoring refactoring, IProgressMonitor monitor) throws OperationCanceledException, CoreException {
        Assert.isNotNull((Object)refactoring);
        Assert.isNotNull((Object)monitor);
        CreateChangeOperation operation = new CreateChangeOperation(refactoring);
        operation.run(monitor);
        return operation.getChange();
    }

    @Deprecated
    protected Refactoring createRefactoring(RefactoringDescriptor descriptor, RefactoringStatus status) throws CoreException {
        Assert.isNotNull((Object)descriptor);
        return descriptor.createRefactoring(status);
    }

    @Deprecated
    protected Refactoring createRefactoring(RefactoringDescriptor descriptor, RefactoringStatus status, IProgressMonitor monitor) throws CoreException {
        Refactoring refactoring = this.createRefactoring(descriptor, status);
        if (refactoring != null) {
            status.merge(this.aboutToPerformRefactoring(refactoring, descriptor, monitor));
            if (!status.hasFatalError()) {
                return refactoring;
            }
        } else {
            status.addFatalError(Messages.format(RefactoringUIMessages.RefactoringHistoryWizard_error_instantiate_refactoring, descriptor.getDescription()));
        }
        return null;
    }

    protected RefactoringContext createRefactoringContext(RefactoringDescriptor descriptor, RefactoringStatus status, IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull((Object)descriptor);
        RefactoringContext context = descriptor.createRefactoringContext(status);
        if (context != null) {
            Refactoring refactoring = context.getRefactoring();
            status.merge(this.aboutToPerformRefactoring(refactoring, descriptor, monitor));
            if (!status.hasFatalError()) {
                return context;
            }
        } else {
            status.addFatalError(Messages.format(RefactoringUIMessages.RefactoringHistoryWizard_error_instantiate_refactoring, descriptor.getDescription()));
        }
        return null;
    }

    public void dispose() {
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void handleException(Throwable exception) {
                RefactoringUIPlugin.log(exception);
            }

            public final void run() throws Exception {
                RefactoringStatusEntry entry;
                if (RefactoringHistoryWizard.this.fAboutToPerformFired && (entry = RefactoringHistoryWizard.this.historyPerformed((IProgressMonitor)new NullProgressMonitor()).getEntryWithHighestSeverity()) != null) {
                    RefactoringUIPlugin.log(entry.toStatus());
                }
            }
        });
        super.dispose();
    }

    private RefactoringStatus fireAboutToPerformHistory(final IProgressMonitor monitor) {
        final RefactoringStatus status = new RefactoringStatus();
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void handleException(Throwable exception) {
                RefactoringUIPlugin.log(exception);
                status.addFatalError(RefactoringUIMessages.RefactoringWizard_unexpected_exception_1);
            }

            public final void run() throws Exception {
                status.merge(RefactoringHistoryWizard.this.aboutToPerformHistory(monitor));
            }
        });
        return status;
    }

    public final IErrorWizardPage getErrorPage() {
        return this.fErrorPage;
    }

    /*
     * Unable to fully structure code
     */
    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.fOverviewPage || page == this.fNoOverviewPage) {
            this.fCurrentRefactoring = 0;
            return this.getRefactoringPage();
        }
        if (page == this.fPreviewPage) {
            ++this.fCurrentRefactoring;
            return this.getRefactoringPage();
        }
        if (page == this.fErrorPage) {
            status = this.fErrorPage.getStatus();
            wizard = this.getContainer();
            if (status.hasFatalError()) {
                store = RefactoringUIPlugin.getDefault().getPreferenceStore();
                message = null;
                key = null;
                if (!RefactoringUIMessages.RefactoringHistoryPreviewPage_apply_error_title.equals(this.fErrorPage.getTitle())) {
                    message = Messages.format(RefactoringUIMessages.RefactoringHistoryWizard_fatal_error_message, this.fErrorPage.getTitle());
                    key = RefactoringHistoryWizard.PREFERENCE_DO_NOT_SHOW_SKIP;
                } else {
                    message = RefactoringUIMessages.RefactoringHistoryWizard_error_applying_changes;
                    key = RefactoringHistoryWizard.PREFERENCE_DO_NOT_SHOW_APPLY_ERROR;
                }
                if (!store.getBoolean(key)) {
                    dialog = new MessageDialogWithToggle(this.getShell(), wizard.getShell().getText(), null, message, 2, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0, RefactoringUIMessages.RefactoringHistoryWizard_do_not_show_message, false);
                    dialog.open();
                    store.setValue(key, dialog.getToggleState());
                    if (dialog.getReturnCode() == 1) {
                        return null;
                    }
                }
                ++this.fCurrentRefactoring;
                return this.getRefactoringPage();
            }
            refactoring = this.fErrorPage.getRefactoring();
            if (refactoring != null) {
                runnable = (IRunnableWithProgress)LambdaMetafactory.metafactory(null, null, null, (Lorg/eclipse/core/runtime/IProgressMonitor;)V, lambda$0(org.eclipse.ltk.core.refactoring.Refactoring org.eclipse.core.runtime.IProgressMonitor ), (Lorg/eclipse/core/runtime/IProgressMonitor;)V)((RefactoringHistoryWizard)this, (Refactoring)refactoring);
                try {
                    wizard.run(true, false, runnable);
                }
                catch (InvocationTargetException exception) {
                    throwable = exception.getTargetException();
                    if (throwable == null) ** GOTO lbl45
                    RefactoringUIPlugin.log(exception);
                    this.fErrorPage.setStatus(RefactoringStatus.createFatalErrorStatus((String)RefactoringUIMessages.RefactoringWizard_unexpected_exception_1));
                    return this.fErrorPage;
                }
                catch (InterruptedException exception) {
                    return this.fErrorPage;
                }
            } else {
                this.fPreviewPage.setRefactoring(null);
                this.fPreviewPage.setChange(null);
            }
lbl45:
            // 3 sources

            descriptor = this.getRefactoringDescriptor();
            if (descriptor != null) {
                this.fPreviewPage.setTitle(descriptor, this.fCurrentRefactoring, this.fDescriptorProxies.length);
            } else {
                this.fPreviewPage.setTitle(RefactoringUIMessages.PreviewWizardPage_changes);
            }
            this.fPreviewPage.setStatus(status);
            this.fPreviewPage.setNextPageDisabled(this.isLastRefactoring());
            return this.fPreviewPage;
        }
        return super.getNextPage(page);
    }

    public final IPreviewWizardPage getPreviewPage() {
        return this.fPreviewPage;
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        if (page == this.fErrorPage || page == this.fPreviewPage) {
            return null;
        }
        return super.getPreviousPage(page);
    }

    private RefactoringDescriptorProxy getRefactoringDescriptor() {
        RefactoringDescriptorProxy[] proxies = this.getRefactoringDescriptors();
        if (this.fCurrentRefactoring >= 0 && this.fCurrentRefactoring < proxies.length) {
            return proxies[this.fCurrentRefactoring];
        }
        return null;
    }

    private RefactoringDescriptorProxy[] getRefactoringDescriptors() {
        if (this.fDescriptorProxies == null) {
            RefactoringDescriptorProxy[] proxies = this.fRefactoringHistory.getDescriptors();
            RefactoringDescriptorProxy[] result = new RefactoringDescriptorProxy[proxies.length];
            System.arraycopy(proxies, 0, result, 0, proxies.length);
            RefactoringHistoryManager.sortRefactoringDescriptorsAscending((RefactoringDescriptorProxy[])result);
            this.fDescriptorProxies = result;
        }
        return this.fDescriptorProxies;
    }

    private IWizardPage getRefactoringPage() {
        IWizardPage[] result = new IWizardPage[1];
        RefactoringStatus status = new RefactoringStatus();
        IWizardContainer wizard = this.getContainer();
        IRunnableWithProgress runnable = monitor -> {
            block27: {
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)RefactoringUIMessages.RefactoringHistoryWizard_preparing_refactoring, (int)220);
                try {
                    try {
                        iWizardPageArray[0] = null;
                        if (!this.fAboutToPerformFired) {
                            try {
                                status.merge(this.fireAboutToPerformHistory((IProgressMonitor)subMonitor.newChild(50, 1)));
                            }
                            finally {
                                this.fAboutToPerformFired = true;
                            }
                        }
                        boolean last = this.isLastRefactoring();
                        RefactoringDescriptorProxy proxy = this.getRefactoringDescriptor();
                        this.preparePreviewPage(status, proxy, last);
                        this.prepareErrorPage(status, proxy, status.hasFatalError(), last || status.hasFatalError());
                        this.fErrorPage.setRefactoring(null);
                        if (!status.isOK()) {
                            iWizardPageArray[0] = this.fErrorPage;
                            break block27;
                        }
                        if (proxy != null) {
                            IRefactoringHistoryService service = RefactoringCore.getHistoryService();
                            try {
                                service.connect();
                                RefactoringDescriptor descriptor = proxy.requestDescriptor((IProgressMonitor)subMonitor.newChild(10, 1));
                                if (descriptor != null) {
                                    RefactoringContext context = this.createRefactoringContext(descriptor, status, (IProgressMonitor)subMonitor.newChild(60, 1));
                                    try {
                                        if (context != null && status.isOK()) {
                                            Refactoring refactoring = context.getRefactoring();
                                            this.fPreviewPage.setRefactoring(refactoring);
                                            this.fErrorPage.setRefactoring(refactoring);
                                            status.merge(this.checkConditions(refactoring, (IProgressMonitor)subMonitor.newChild(20, 1), 2));
                                            if (!status.isOK()) {
                                                this.prepareErrorPage(status, proxy, status.hasFatalError(), last);
                                                iWizardPageArray[0] = this.fErrorPage;
                                            } else {
                                                status.merge(this.checkConditions(refactoring, (IProgressMonitor)subMonitor.newChild(65, 1), 4));
                                                if (!status.isOK()) {
                                                    this.prepareErrorPage(status, proxy, status.hasFatalError(), last);
                                                    iWizardPageArray[0] = this.fErrorPage;
                                                } else {
                                                    Change change = this.createChange(refactoring, (IProgressMonitor)subMonitor.newChild(5, 1));
                                                    this.getShell().getDisplay().syncExec(() -> this.fPreviewPage.setChange(change));
                                                    iWizardPageArray[0] = this.fPreviewPage;
                                                }
                                            }
                                        } else {
                                            this.prepareErrorPage(status, proxy, status.hasFatalError(), last);
                                            iWizardPageArray[0] = this.fErrorPage;
                                        }
                                        break block27;
                                    }
                                    finally {
                                        if (context != null) {
                                            context.dispose();
                                        }
                                    }
                                }
                                status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringUIMessages.RefactoringHistoryWizard_error_resolving_refactoring));
                                this.prepareErrorPage(status, proxy, status.hasFatalError(), last);
                                iWizardPageArray[0] = this.fErrorPage;
                                break block27;
                            }
                            finally {
                                service.disconnect();
                            }
                        }
                        this.prepareErrorPage(status, proxy, status.hasFatalError(), last);
                        iWizardPageArray[0] = this.fErrorPage;
                    }
                    catch (CoreException exception1) {
                        throw new InvocationTargetException(exception1);
                    }
                    catch (OperationCanceledException exception2) {
                        throw new InterruptedException(exception2.getLocalizedMessage());
                    }
                }
                finally {
                    subMonitor.done();
                }
            }
        };
        try {
            wizard.run(true, false, runnable);
        }
        catch (InvocationTargetException exception) {
            RefactoringUIPlugin.log(exception);
            Throwable throwable = exception.getTargetException();
            if (throwable != null) {
                this.fErrorPage.setNextPageDisabled(this.isLastRefactoring());
                this.fErrorPage.setStatus(RefactoringStatus.createFatalErrorStatus((String)RefactoringUIMessages.RefactoringWizard_unexpected_exception_1));
                result[0] = this.fErrorPage;
            }
        }
        catch (InterruptedException exception) {
            result[0] = null;
        }
        this.getContainer().updateButtons();
        return result[0];
    }

    protected RefactoringStatus historyPerformed(IProgressMonitor monitor) {
        Assert.isNotNull((Object)monitor);
        return new RefactoringStatus();
    }

    private boolean isLastRefactoring() {
        return this.fCurrentRefactoring >= this.getRefactoringDescriptors().length - 1;
    }

    private boolean isSecondLastRefactoring() {
        return this.fCurrentRefactoring >= this.getRefactoringDescriptors().length - 2;
    }

    public boolean performCancel() {
        if (this.fExecutedRefactorings > 0 && !this.fCancelException) {
            IPreferenceStore store = RefactoringUIPlugin.getDefault().getPreferenceStore();
            if (!store.getBoolean(PREFERENCE_DO_NOT_WARN_UNDO_ON_CANCEL)) {
                MessageFormat format = new MessageFormat(RefactoringUIMessages.RefactoringHistoryWizard_undo_message_pattern);
                String message = RefactoringUIMessages.RefactoringHistoryWizard_undo_message_explanation;
                String[] messages = new String[]{RefactoringUIMessages.RefactoringHistoryWizard_one_refactoring_undone + message, RefactoringUIMessages.RefactoringHistoryWizard_several_refactorings_undone + message};
                ChoiceFormat choice = new ChoiceFormat(new double[]{1.0, Double.MAX_VALUE}, messages);
                format.setFormatByArgumentIndex(0, choice);
                MessageDialogWithToggle dialog = new MessageDialogWithToggle(this.getShell(), this.getShell().getText(), null, format.format(new Object[]{this.fExecutedRefactorings}), 2, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0, RefactoringUIMessages.RefactoringHistoryWizard_do_not_show_message, false);
                dialog.open();
                store.setValue(PREFERENCE_DO_NOT_WARN_UNDO_ON_CANCEL, dialog.getToggleState());
                if (dialog.getReturnCode() == 1) {
                    return false;
                }
            }
            IRunnableWithProgress runnable = monitor -> {
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)this.fExecutedRefactorings);
                int index = 0;
                while (index < this.fExecutedRefactorings) {
                    try {
                        RefactoringCore.getUndoManager().performUndo(null, (IProgressMonitor)subMonitor.newChild(1));
                        if (this.fExecutedRefactorings > 0) {
                            --this.fExecutedRefactorings;
                        }
                    }
                    catch (CoreException exception) {
                        throw new InvocationTargetException(exception);
                    }
                    ++index;
                }
            };
            try {
                this.getContainer().run(false, false, runnable);
            }
            catch (InvocationTargetException exception) {
                RefactoringUIPlugin.log(exception);
                this.fCancelException = true;
                this.fErrorPage.setStatus(RefactoringStatus.createFatalErrorStatus((String)RefactoringUIMessages.RefactoringHistoryWizard_internal_error));
                this.fErrorPage.setNextPageDisabled(true);
                this.fErrorPage.setTitle(RefactoringUIMessages.RefactoringHistoryWizard_internal_error_title);
                this.fErrorPage.setDescription(RefactoringUIMessages.RefactoringHistoryWizard_internal_error_description);
                this.getContainer().showPage((IWizardPage)this.fErrorPage);
                return false;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return super.performCancel();
    }

    public boolean performFinish() {
        if (this.fHeadlessErrorStatus) {
            return true;
        }
        if (this.fOverviewPage != null) {
            this.fOverviewPage.performFinish();
        }
        IWizardContainer wizard = this.getContainer();
        final RefactoringStatus status = new RefactoringStatus();
        RefactoringDescriptorProxy[] proxies = this.getRefactoringDescriptors();
        ArrayList<RefactoringDescriptorProxy> list = new ArrayList<RefactoringDescriptorProxy>(proxies.length);
        int index = this.fCurrentRefactoring;
        while (index < proxies.length) {
            list.add(proxies[index]);
            ++index;
        }
        RefactoringDescriptorProxy[] descriptors = new RefactoringDescriptorProxy[list.size()];
        list.toArray(descriptors);
        boolean last = this.isLastRefactoring();
        if (wizard.getCurrentPage() == this.fPreviewPage && last) {
            Refactoring refactoring = this.fPreviewPage.getRefactoring();
            Change change = this.fPreviewPage.getChange();
            if (refactoring != null && change != null) {
                status.merge(this.performPreviewChange(change, refactoring));
                if (!status.isOK()) {
                    RefactoringStatusEntry entry = status.getEntryWithHighestSeverity();
                    if (entry.getSeverity() == 1 && entry.getCode() == 10003) {
                        return false;
                    }
                    this.fErrorPage.setStatus(status);
                    this.fErrorPage.setNextPageDisabled(true);
                    this.fErrorPage.setTitle(RefactoringUIMessages.RefactoringHistoryPreviewPage_apply_error_title);
                    this.fErrorPage.setDescription(RefactoringUIMessages.RefactoringHistoryPreviewPage_apply_error);
                    wizard.showPage((IWizardPage)this.fErrorPage);
                    return false;
                }
            }
        } else {
            IPreferenceStore store = RefactoringUIPlugin.getDefault().getPreferenceStore();
            if (!store.getBoolean(PREFERENCE_DO_NOT_WARN_FINISH) && proxies.length > 0) {
                MessageDialogWithToggle dialog = new MessageDialogWithToggle(this.getShell(), wizard.getShell().getText(), null, Messages.format(RefactoringUIMessages.RefactoringHistoryWizard_warning_finish, LegacyActionTools.removeMnemonics((String)IDialogConstants.FINISH_LABEL)), 2, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0, RefactoringUIMessages.RefactoringHistoryWizard_do_not_show_message, false);
                dialog.open();
                store.setValue(PREFERENCE_DO_NOT_WARN_FINISH, dialog.getToggleState());
                if (dialog.getReturnCode() == 1) {
                    return false;
                }
            }
            PerformRefactoringHistoryOperation operation = new PerformRefactoringHistoryOperation((RefactoringHistory)new RefactoringHistoryImplementation(descriptors)){

                protected RefactoringContext createRefactoringContext(RefactoringDescriptor descriptor, RefactoringStatus state, IProgressMonitor monitor) throws CoreException {
                    return RefactoringHistoryWizard.this.createRefactoringContext(descriptor, state, monitor);
                }

                protected void refactoringPerformed(final Refactoring refactoring, final IProgressMonitor monitor) {
                    SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                        public void handleException(Throwable exception) {
                            RefactoringUIPlugin.log(exception);
                        }

                        public final void run() throws Exception {
                            RefactoringHistoryWizard.this.refactoringPerformed(refactoring, monitor);
                        }
                    });
                }

                public void run(IProgressMonitor monitor) throws CoreException {
                    SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)RefactoringUIMessages.RefactoringHistoryWizard_preparing_refactorings, (int)100);
                    try {
                        if (!RefactoringHistoryWizard.this.fAboutToPerformFired) {
                            try {
                                status.merge(RefactoringHistoryWizard.this.fireAboutToPerformHistory((IProgressMonitor)subMonitor.newChild(20, 1)));
                            }
                            finally {
                                RefactoringHistoryWizard.this.fAboutToPerformFired = true;
                            }
                        }
                        if (!status.isOK()) {
                            int severity = status.getSeverity();
                            throw new CoreException((IStatus)new Status(severity != 4 ? severity : 4, RefactoringUIPlugin.getPluginId(), 0, null, null));
                        }
                        super.run((IProgressMonitor)subMonitor.newChild(80, 1));
                    }
                    finally {
                        subMonitor.done();
                    }
                }
            };
            try {
                wizard.run(false, false, (IRunnableWithProgress)new WorkbenchRunnableAdapter((IWorkspaceRunnable)operation, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot()));
            }
            catch (InvocationTargetException exception) {
                RefactoringUIPlugin.log(exception);
                Throwable throwable = exception.getTargetException();
                if (throwable != null) {
                    String message = throwable.getLocalizedMessage();
                    if (message != null && !"".equals(message)) {
                        status.merge(RefactoringStatus.createFatalErrorStatus((String)message));
                    }
                    this.fErrorPage.setStatus(status);
                    this.fErrorPage.setNextPageDisabled(status.hasFatalError());
                    this.fErrorPage.setTitle(RefactoringUIMessages.RefactoringHistoryPreviewPage_apply_error_title);
                    this.fErrorPage.setDescription(RefactoringUIMessages.RefactoringHistoryPreviewPage_apply_error);
                    wizard.showPage((IWizardPage)this.fErrorPage);
                    return false;
                }
            }
            catch (InterruptedException exception) {
                // empty catch block
            }
            RefactoringStatus result = operation.getExecutionStatus();
            if (!result.isOK()) {
                this.fHeadlessErrorStatus = true;
                this.fErrorPage.setStatus(result);
                this.fErrorPage.setNextPageDisabled(true);
                this.fErrorPage.setTitle(RefactoringUIMessages.RefactoringHistoryPreviewPage_finish_error_title);
                this.fErrorPage.setDescription(RefactoringUIMessages.RefactoringHistoryPreviewPage_finish_error_description);
                wizard.showPage((IWizardPage)this.fErrorPage);
                return false;
            }
        }
        return true;
    }

    public final RefactoringStatus performPreviewChange(Change change, final Refactoring refactoring) {
        Assert.isNotNull((Object)change);
        Assert.isNotNull((Object)refactoring);
        UIPerformChangeOperation operation = new UIPerformChangeOperation(this.getShell().getDisplay(), change, this.getContainer()){

            public void run(IProgressMonitor monitor) throws CoreException {
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)RefactoringUIMessages.RefactoringHistoryWizard_preparing_changes, (int)12);
                try {
                    super.run((IProgressMonitor)subMonitor.newChild(10, 1));
                    RefactoringHistoryWizard.this.refactoringPerformed(refactoring, (IProgressMonitor)subMonitor.newChild(2, 1));
                }
                finally {
                    subMonitor.done();
                }
            }
        };
        RefactoringStatus status = this.performPreviewChange(operation, refactoring);
        if (status.isOK()) {
            status.merge(operation.getValidationStatus());
        }
        return status;
    }

    private RefactoringStatus performPreviewChange(PerformChangeOperation operation, Refactoring refactoring) {
        block11: {
            Assert.isNotNull((Object)operation);
            Assert.isNotNull((Object)refactoring);
            operation.setUndoManager(RefactoringCore.getUndoManager(), refactoring.getName());
            IWizardContainer wizard = this.getContainer();
            Shell shell = wizard.getShell();
            try {
                wizard.run(false, false, (IRunnableWithProgress)new WorkbenchRunnableAdapter((IWorkspaceRunnable)operation, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot()));
            }
            catch (InvocationTargetException exception) {
                Throwable throwable = exception.getTargetException();
                if (operation.changeExecutionFailed()) {
                    Change change = operation.getChange();
                    ChangeExceptionHandler handler = new ChangeExceptionHandler(shell, refactoring);
                    if (throwable instanceof RuntimeException) {
                        handler.handle(change, (RuntimeException)throwable);
                    } else if (throwable instanceof CoreException) {
                        handler.handle(change, (CoreException)throwable);
                    }
                }
                ExceptionHandler.handle(exception, shell, RefactoringUIMessages.RefactoringWizard_refactoring, RefactoringUIMessages.RefactoringWizard_unexpected_exception_1);
                this.fPreviewPage.setNextPageDisabled(this.isSecondLastRefactoring());
                this.getContainer().updateButtons();
                break block11;
            }
            catch (InterruptedException exception) {
                try {
                    RefactoringStatus refactoringStatus = RefactoringStatus.create((IStatus)new Status(1, RefactoringUIPlugin.getPluginId(), 10003, exception.getLocalizedMessage(), (Throwable)exception));
                    return refactoringStatus;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    this.fPreviewPage.setNextPageDisabled(this.isSecondLastRefactoring());
                    this.getContainer().updateButtons();
                }
            }
            this.fPreviewPage.setNextPageDisabled(this.isSecondLastRefactoring());
            this.getContainer().updateButtons();
        }
        return new RefactoringStatus();
    }

    private void prepareErrorPage(RefactoringStatus status, RefactoringDescriptorProxy descriptor, boolean fatal, boolean disabled) {
        this.getShell().getDisplay().syncExec(() -> {
            this.fErrorPage.setTitle(descriptor, this.fCurrentRefactoring, this.fDescriptorProxies.length);
            this.fErrorPage.setNextPageDisabled(disabled && fatal);
            this.fErrorPage.setPageComplete(!fatal);
            this.fErrorPage.setStatus(null);
            this.fErrorPage.setStatus(status);
            this.getContainer().updateButtons();
        });
    }

    private void preparePreviewPage(RefactoringStatus status, RefactoringDescriptorProxy descriptor, boolean disabled) {
        this.getShell().getDisplay().syncExec(() -> {
            this.fPreviewPage.setTitle(descriptor, this.fCurrentRefactoring, this.fDescriptorProxies.length);
            this.fPreviewPage.setNextPageDisabled(disabled);
            this.fPreviewPage.setPageComplete(!disabled);
            this.fPreviewPage.setStatus(status);
            this.getContainer().updateButtons();
        });
    }

    protected RefactoringStatus refactoringPerformed(Refactoring refactoring, IProgressMonitor monitor) {
        Assert.isNotNull((Object)refactoring);
        Assert.isNotNull((Object)monitor);
        ++this.fExecutedRefactorings;
        return new RefactoringStatus();
    }

    protected boolean selectPreviewChange(Change change) {
        return true;
    }

    protected boolean selectStatusEntry(RefactoringStatusEntry entry) {
        return true;
    }

    public final void setConfiguration(RefactoringHistoryControlConfiguration configuration) {
        Assert.isNotNull((Object)configuration);
        this.fControlConfiguration = configuration;
    }

    public final void setInput(RefactoringHistory history) {
        Assert.isNotNull((Object)history);
        this.fRefactoringHistory = history;
    }

    private /* synthetic */ void lambda$0(Refactoring refactoring, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        Assert.isNotNull((Object)monitor);
        try {
            try {
                this.fPreviewPage.setRefactoring(refactoring);
                Change change = this.createChange(refactoring, monitor);
                this.getShell().getDisplay().syncExec(() -> this.fPreviewPage.setChange(change));
            }
            catch (CoreException exception1) {
                throw new InvocationTargetException(exception1);
            }
            catch (OperationCanceledException exception2) {
                throw new InterruptedException(exception2.getLocalizedMessage());
            }
        }
        finally {
            monitor.done();
        }
    }

    private final class NoOverviewWizardPage
    extends WizardPage {
        private static final String PAGE_NAME = "NoOverviewWizardPage";

        private NoOverviewWizardPage() {
            super(PAGE_NAME);
            RefactoringDescriptorProxy[] proxies = RefactoringHistoryWizard.this.getRefactoringDescriptors();
            if (proxies.length > 0) {
                this.setTitle(proxies[0], 1, proxies.length);
            } else {
                this.setTitle(RefactoringHistoryWizard.this.fOverviewTitle);
            }
            this.setDescription(RefactoringUIMessages.RefactoringHistoryPreviewPage_description);
        }

        public boolean canFlipToNextPage() {
            return true;
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout());
            composite.setLayoutData((Object)new GridData(272));
            this.setControl((Control)composite);
            Dialog.applyDialogFont((Control)composite);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.jdt.ui.refactoring_preview_wizard_page_context");
        }

        public IWizardPage getNextPage() {
            return this.getWizard().getNextPage((IWizardPage)this);
        }

        public IWizardPage getPreviousPage() {
            return this.getWizard().getPreviousPage((IWizardPage)this);
        }

        public void setPageComplete(boolean complete) {
            super.setPageComplete(true);
        }

        public void setTitle(RefactoringDescriptorProxy descriptor, int current, int total) {
            String message = descriptor != null ? descriptor.getDescription() : RefactoringUIMessages.RefactoringHistoryOverviewPage_title;
            if (total > 1) {
                this.setTitle(Messages.format(RefactoringUIMessages.RefactoringHistoryPreviewPage_refactoring_pattern, new String[]{message, String.valueOf(current + 1), String.valueOf(total)}));
            } else {
                this.setTitle(message);
            }
        }
    }
}

