/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.model.impl.PropertyDescriptor;
import org.jkiss.utils.CommonUtils;

public class PropertyGroupDescriptor<T extends PropertyDescriptor>
extends AbstractDescriptor {
    private final String id;
    private final String label;
    private PropertyGroupDescriptor<T> parentGroup;
    private final List<PropertyGroupDescriptor<T>> subGroups = new ArrayList<PropertyGroupDescriptor<T>>();
    private final List<T> properties = new ArrayList<T>();

    public PropertyGroupDescriptor(IConfigurationElement cfg) {
        super(cfg);
        this.id = cfg.getAttribute("id");
        this.label = cfg.getAttribute("label");
    }

    public void addProperty(@NotNull T setting) {
        this.properties.add(setting);
    }

    public void addSubGroup(@NotNull PropertyGroupDescriptor<T> subGroup) {
        this.subGroups.add(subGroup);
    }

    @NotNull
    public List<T> getSettings() {
        return List.copyOf(this.properties);
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public String getFullId() {
        return (String)(this.getParentGroup() != null ? this.parentGroup.getFullId() + "/" : "") + this.getId();
    }

    @NotNull
    public String getDisplayName() {
        return CommonUtils.isEmpty((String)this.label) ? this.getId() : this.label;
    }

    @NotNull
    public List<PropertyGroupDescriptor<T>> getSubGroups() {
        return this.subGroups;
    }

    @Nullable
    public PropertyGroupDescriptor<T> getParentGroup() {
        return this.parentGroup;
    }

    public void setParentGroup(@NotNull PropertyGroupDescriptor<T> parentGroup) {
        this.parentGroup = parentGroup;
    }
}

