/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.tidb.model.plan;

import org.jkiss.dbeaver.ext.mysql.model.MySQLDataSource;
import org.jkiss.dbeaver.ext.mysql.model.plan.MySQLPlanAbstract;
import org.jkiss.dbeaver.ext.mysql.model.plan.MySQLPlanAnalyser;
import org.jkiss.dbeaver.ext.tidb.model.plan.TiDBPlainClassic;
import org.jkiss.dbeaver.ext.tidb.mysql.model.TiDBMySQLDataSource;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLUtils;

public class TiDBPlanAnalyzer
extends MySQLPlanAnalyser {
    private static final String[] FIRST_KEYWORD_BLOCK_LIST = new String[]{"DESC", "SET", "EXPLAIN"};
    private TiDBMySQLDataSource dataSource;

    public TiDBPlanAnalyzer(TiDBMySQLDataSource dataSource) {
        super((MySQLDataSource)dataSource);
        this.dataSource = dataSource;
    }

    private static boolean block(String firstKeyword) {
        String[] stringArray = FIRST_KEYWORD_BLOCK_LIST;
        int n = FIRST_KEYWORD_BLOCK_LIST.length;
        int n2 = 0;
        while (n2 < n) {
            String blockWord = stringArray[n2];
            if (!blockWord.equalsIgnoreCase(firstKeyword)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public MySQLPlanAbstract explain(JDBCSession session, String query) throws DBCException {
        String plainQuery;
        SQLDialect dialect = SQLUtils.getDialectFromObject((DBPObject)this.dataSource);
        String firstKeyword = SQLUtils.getFirstKeyword((SQLDialect)dialect, (String)(plainQuery = SQLUtils.stripComments((SQLDialect)dialect, (String)query).toUpperCase()));
        if (TiDBPlanAnalyzer.block(firstKeyword)) {
            throw new DBCException("This statement could not produce execution plan");
        }
        return new TiDBPlainClassic(session, query);
    }
}

