/*
 * Copyright 2004-2019 Cray Inc.
 * Other additional copyright holders may be indicated within.
 * 
 * The entirety of this work is licensed under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * 
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef _CHPL_DOMINATOR_H
#define _CHPL_DOMINATOR_H

#include "astutil.h"
#include "bb.h"
#include "bitVec.h"
#include <set>

void computeDominators(std::vector<BitVec*>& dominators, std::vector<BasicBlock*>& basicBlocks);
bool dominates(unsigned a, unsigned b, std::vector<BitVec*> & dominators);
bool strictlyDominates(unsigned a, unsigned b, std::vector<BitVec*> & dominators);

void computeImmediateDominators(std::vector<unsigned>& immediateDominators, std::vector<BitVec*>& dominators);

#endif
