/*   $Source: bitbucket.org:berkeleylab/upc-runtime.git/upcr_geninclude/bupc_atomics.h.in $
 * Description:
 *  Berkeley UPC atomic extensions - prototypes
 *
 * Copyright 2010,  E. O. Lawrence Berekely National Laboratory
 */
#ifndef _BUPC_ATOMIC_EXTENSIONS_H_
#define _BUPC_ATOMIC_EXTENSIONS_H_

#if !defined(__BERKELEY_UPC_FIRST_PREPROCESS__) && !defined(__BERKELEY_UPC_ONLY_PREPROCESS__)
#error This file should only be included via upc.h or bupc_extensions.h
#else

/*---------------------------------------------------------------------------------*/
/* bupc_atomic extensions */

#if UPCRI_LIBWRAP
  UPCRI_LIBWRAP_FN
  void bupc_atomicU64_set_private(void *_ptr, uint64_t _val) {
    _bupc_atomicU64_set_private(_ptr, _val);
  }
  UPCRI_LIBWRAP_FN
  void bupc_atomicU64_set_relaxed(shared void *_sptr, uint64_t _val) {
    _bupc_atomicU64_set_relaxed(upcri_bless_SVP2shared(_sptr), _val);
  }
  UPCRI_LIBWRAP_FN
  void bupc_atomicU64_set_strict(shared void *_sptr, uint64_t _val) {
    _bupc_atomicU64_set_strict(upcri_bless_SVP2shared(_sptr), _val);
  }
  UPCRI_LIBWRAP_FN
  void bupc_atomicI64_set_private(void *_ptr, int64_t _val) {
    _bupc_atomicI64_set_private(_ptr, _val);
  }
  UPCRI_LIBWRAP_FN
  void bupc_atomicI64_set_relaxed(shared void *_sptr, int64_t _val) {
    _bupc_atomicI64_set_relaxed(upcri_bless_SVP2shared(_sptr), _val);
  }
  UPCRI_LIBWRAP_FN
  void bupc_atomicI64_set_strict(shared void *_sptr, int64_t _val) {
    _bupc_atomicI64_set_strict(upcri_bless_SVP2shared(_sptr), _val);
  }
  UPCRI_LIBWRAP_FN
  void bupc_atomicU32_set_private(void *_ptr, uint32_t _val) {
    _bupc_atomicU32_set_private(_ptr, _val);
  }
  UPCRI_LIBWRAP_FN
  void bupc_atomicU32_set_relaxed(shared void *_sptr, uint32_t _val) {
    _bupc_atomicU32_set_relaxed(upcri_bless_SVP2shared(_sptr), _val);
  }
  UPCRI_LIBWRAP_FN
  void bupc_atomicU32_set_strict(shared void *_sptr, uint32_t _val) {
    _bupc_atomicU32_set_strict(upcri_bless_SVP2shared(_sptr), _val);
  }
  UPCRI_LIBWRAP_FN
  void bupc_atomicI32_set_private(void *_ptr, int32_t _val) {
    _bupc_atomicI32_set_private(_ptr, _val);
  }
  UPCRI_LIBWRAP_FN
  void bupc_atomicI32_set_relaxed(shared void *_sptr, int32_t _val) {
    _bupc_atomicI32_set_relaxed(upcri_bless_SVP2shared(_sptr), _val);
  }
  UPCRI_LIBWRAP_FN
  void bupc_atomicI32_set_strict(shared void *_sptr, int32_t _val) {
    _bupc_atomicI32_set_strict(upcri_bless_SVP2shared(_sptr), _val);
  }
  UPCRI_LIBWRAP_FN
  uint64_t bupc_atomicU64_read_private(void *_ptr) {
    return _bupc_atomicU64_read_private(_ptr);
  }
  UPCRI_LIBWRAP_FN
  uint64_t bupc_atomicU64_read_relaxed(shared void *_sptr) {
    return _bupc_atomicU64_read_relaxed(upcri_bless_SVP2shared(_sptr));
  }
  UPCRI_LIBWRAP_FN
  uint64_t bupc_atomicU64_read_strict(shared void *_sptr) {
    return _bupc_atomicU64_read_strict(upcri_bless_SVP2shared(_sptr));
  }
  UPCRI_LIBWRAP_FN
  int64_t bupc_atomicI64_read_private(void *_ptr) {
    return _bupc_atomicI64_read_private(_ptr);
  }
  UPCRI_LIBWRAP_FN
  int64_t bupc_atomicI64_read_relaxed(shared void *_sptr) {
    return _bupc_atomicI64_read_relaxed(upcri_bless_SVP2shared(_sptr));
  }
  UPCRI_LIBWRAP_FN
  int64_t bupc_atomicI64_read_strict(shared void *_sptr) {
    return _bupc_atomicI64_read_strict(upcri_bless_SVP2shared(_sptr));
  }
  UPCRI_LIBWRAP_FN
  uint32_t bupc_atomicU32_read_private(void *_ptr) {
    return _bupc_atomicU32_read_private(_ptr);
  }
  UPCRI_LIBWRAP_FN
  uint32_t bupc_atomicU32_read_relaxed(shared void *_sptr) {
    return _bupc_atomicU32_read_relaxed(upcri_bless_SVP2shared(_sptr));
  }
  UPCRI_LIBWRAP_FN
  uint32_t bupc_atomicU32_read_strict(shared void *_sptr) {
    return _bupc_atomicU32_read_strict(upcri_bless_SVP2shared(_sptr));
  }
  UPCRI_LIBWRAP_FN
  int32_t bupc_atomicI32_read_private(void *_ptr) {
    return _bupc_atomicI32_read_private(_ptr);
  }
  UPCRI_LIBWRAP_FN
  int32_t bupc_atomicI32_read_relaxed(shared void *_sptr) {
    return _bupc_atomicI32_read_relaxed(upcri_bless_SVP2shared(_sptr));
  }
  UPCRI_LIBWRAP_FN
  int32_t bupc_atomicI32_read_strict(shared void *_sptr) {
    return _bupc_atomicI32_read_strict(upcri_bless_SVP2shared(_sptr));
  }
  UPCRI_LIBWRAP_FN
  uint64_t bupc_atomicU64_fetchnot_private(void *_ptr) {
    return _bupc_atomicU64_fetchnot_private(_ptr);
  }
  UPCRI_LIBWRAP_FN
  uint64_t bupc_atomicU64_fetchnot_relaxed(shared void *_sptr) {
    return _bupc_atomicU64_fetchnot_relaxed(upcri_bless_SVP2shared(_sptr));
  }
  UPCRI_LIBWRAP_FN
  uint64_t bupc_atomicU64_fetchnot_strict(shared void *_sptr) {
    return _bupc_atomicU64_fetchnot_strict(upcri_bless_SVP2shared(_sptr));
  }
  UPCRI_LIBWRAP_FN
  int64_t bupc_atomicI64_fetchnot_private(void *_ptr) {
    return _bupc_atomicI64_fetchnot_private(_ptr);
  }
  UPCRI_LIBWRAP_FN
  int64_t bupc_atomicI64_fetchnot_relaxed(shared void *_sptr) {
    return _bupc_atomicI64_fetchnot_relaxed(upcri_bless_SVP2shared(_sptr));
  }
  UPCRI_LIBWRAP_FN
  int64_t bupc_atomicI64_fetchnot_strict(shared void *_sptr) {
    return _bupc_atomicI64_fetchnot_strict(upcri_bless_SVP2shared(_sptr));
  }
  UPCRI_LIBWRAP_FN
  uint32_t bupc_atomicU32_fetchnot_private(void *_ptr) {
    return _bupc_atomicU32_fetchnot_private(_ptr);
  }
  UPCRI_LIBWRAP_FN
  uint32_t bupc_atomicU32_fetchnot_relaxed(shared void *_sptr) {
    return _bupc_atomicU32_fetchnot_relaxed(upcri_bless_SVP2shared(_sptr));
  }
  UPCRI_LIBWRAP_FN
  uint32_t bupc_atomicU32_fetchnot_strict(shared void *_sptr) {
    return _bupc_atomicU32_fetchnot_strict(upcri_bless_SVP2shared(_sptr));
  }
  UPCRI_LIBWRAP_FN
  int32_t bupc_atomicI32_fetchnot_private(void *_ptr) {
    return _bupc_atomicI32_fetchnot_private(_ptr);
  }
  UPCRI_LIBWRAP_FN
  int32_t bupc_atomicI32_fetchnot_relaxed(shared void *_sptr) {
    return _bupc_atomicI32_fetchnot_relaxed(upcri_bless_SVP2shared(_sptr));
  }
  UPCRI_LIBWRAP_FN
  int32_t bupc_atomicI32_fetchnot_strict(shared void *_sptr) {
    return _bupc_atomicI32_fetchnot_strict(upcri_bless_SVP2shared(_sptr));
  }
  UPCRI_LIBWRAP_FN
  uint64_t bupc_atomicU64_fetchadd_private(void *_ptr, uint64_t _op1) {
    return _bupc_atomicU64_fetchadd_private(_ptr, _op1);
  }
  UPCRI_LIBWRAP_FN
  uint64_t bupc_atomicU64_fetchadd_relaxed(shared void *_sptr, uint64_t _op1) {
    return _bupc_atomicU64_fetchadd_relaxed(upcri_bless_SVP2shared(_sptr), _op1);
  }
  UPCRI_LIBWRAP_FN
  uint64_t bupc_atomicU64_fetchadd_strict(shared void *_sptr, uint64_t _op1) {
    return _bupc_atomicU64_fetchadd_strict(upcri_bless_SVP2shared(_sptr), _op1);
  }
  UPCRI_LIBWRAP_FN
  int64_t bupc_atomicI64_fetchadd_private(void *_ptr, int64_t _op1) {
    return _bupc_atomicI64_fetchadd_private(_ptr, _op1);
  }
  UPCRI_LIBWRAP_FN
  int64_t bupc_atomicI64_fetchadd_relaxed(shared void *_sptr, int64_t _op1) {
    return _bupc_atomicI64_fetchadd_relaxed(upcri_bless_SVP2shared(_sptr), _op1);
  }
  UPCRI_LIBWRAP_FN
  int64_t bupc_atomicI64_fetchadd_strict(shared void *_sptr, int64_t _op1) {
    return _bupc_atomicI64_fetchadd_strict(upcri_bless_SVP2shared(_sptr), _op1);
  }
  UPCRI_LIBWRAP_FN
  uint32_t bupc_atomicU32_fetchadd_private(void *_ptr, uint32_t _op1) {
    return _bupc_atomicU32_fetchadd_private(_ptr, _op1);
  }
  UPCRI_LIBWRAP_FN
  uint32_t bupc_atomicU32_fetchadd_relaxed(shared void *_sptr, uint32_t _op1) {
    return _bupc_atomicU32_fetchadd_relaxed(upcri_bless_SVP2shared(_sptr), _op1);
  }
  UPCRI_LIBWRAP_FN
  uint32_t bupc_atomicU32_fetchadd_strict(shared void *_sptr, uint32_t _op1) {
    return _bupc_atomicU32_fetchadd_strict(upcri_bless_SVP2shared(_sptr), _op1);
  }
  UPCRI_LIBWRAP_FN
  int32_t bupc_atomicI32_fetchadd_private(void *_ptr, int32_t _op1) {
    return _bupc_atomicI32_fetchadd_private(_ptr, _op1);
  }
  UPCRI_LIBWRAP_FN
  int32_t bupc_atomicI32_fetchadd_relaxed(shared void *_sptr, int32_t _op1) {
    return _bupc_atomicI32_fetchadd_relaxed(upcri_bless_SVP2shared(_sptr), _op1);
  }
  UPCRI_LIBWRAP_FN
  int32_t bupc_atomicI32_fetchadd_strict(shared void *_sptr, int32_t _op1) {
    return _bupc_atomicI32_fetchadd_strict(upcri_bless_SVP2shared(_sptr), _op1);
  }
  UPCRI_LIBWRAP_FN
  uint64_t bupc_atomicU64_fetchand_private(void *_ptr, uint64_t _op1) {
    return _bupc_atomicU64_fetchand_private(_ptr, _op1);
  }
  UPCRI_LIBWRAP_FN
  uint64_t bupc_atomicU64_fetchand_relaxed(shared void *_sptr, uint64_t _op1) {
    return _bupc_atomicU64_fetchand_relaxed(upcri_bless_SVP2shared(_sptr), _op1);
  }
  UPCRI_LIBWRAP_FN
  uint64_t bupc_atomicU64_fetchand_strict(shared void *_sptr, uint64_t _op1) {
    return _bupc_atomicU64_fetchand_strict(upcri_bless_SVP2shared(_sptr), _op1);
  }
  UPCRI_LIBWRAP_FN
  int64_t bupc_atomicI64_fetchand_private(void *_ptr, int64_t _op1) {
    return _bupc_atomicI64_fetchand_private(_ptr, _op1);
  }
  UPCRI_LIBWRAP_FN
  int64_t bupc_atomicI64_fetchand_relaxed(shared void *_sptr, int64_t _op1) {
    return _bupc_atomicI64_fetchand_relaxed(upcri_bless_SVP2shared(_sptr), _op1);
  }
  UPCRI_LIBWRAP_FN
  int64_t bupc_atomicI64_fetchand_strict(shared void *_sptr, int64_t _op1) {
    return _bupc_atomicI64_fetchand_strict(upcri_bless_SVP2shared(_sptr), _op1);
  }
  UPCRI_LIBWRAP_FN
  uint32_t bupc_atomicU32_fetchand_private(void *_ptr, uint32_t _op1) {
    return _bupc_atomicU32_fetchand_private(_ptr, _op1);
  }
  UPCRI_LIBWRAP_FN
  uint32_t bupc_atomicU32_fetchand_relaxed(shared void *_sptr, uint32_t _op1) {
    return _bupc_atomicU32_fetchand_relaxed(upcri_bless_SVP2shared(_sptr), _op1);
  }
  UPCRI_LIBWRAP_FN
  uint32_t bupc_atomicU32_fetchand_strict(shared void *_sptr, uint32_t _op1) {
    return _bupc_atomicU32_fetchand_strict(upcri_bless_SVP2shared(_sptr), _op1);
  }
  UPCRI_LIBWRAP_FN
  int32_t bupc_atomicI32_fetchand_private(void *_ptr, int32_t _op1) {
    return _bupc_atomicI32_fetchand_private(_ptr, _op1);
  }
  UPCRI_LIBWRAP_FN
  int32_t bupc_atomicI32_fetchand_relaxed(shared void *_sptr, int32_t _op1) {
    return _bupc_atomicI32_fetchand_relaxed(upcri_bless_SVP2shared(_sptr), _op1);
  }
  UPCRI_LIBWRAP_FN
  int32_t bupc_atomicI32_fetchand_strict(shared void *_sptr, int32_t _op1) {
    return _bupc_atomicI32_fetchand_strict(upcri_bless_SVP2shared(_sptr), _op1);
  }
  UPCRI_LIBWRAP_FN
  uint64_t bupc_atomicU64_fetchor_private(void *_ptr, uint64_t _op1) {
    return _bupc_atomicU64_fetchor_private(_ptr, _op1);
  }
  UPCRI_LIBWRAP_FN
  uint64_t bupc_atomicU64_fetchor_relaxed(shared void *_sptr, uint64_t _op1) {
    return _bupc_atomicU64_fetchor_relaxed(upcri_bless_SVP2shared(_sptr), _op1);
  }
  UPCRI_LIBWRAP_FN
  uint64_t bupc_atomicU64_fetchor_strict(shared void *_sptr, uint64_t _op1) {
    return _bupc_atomicU64_fetchor_strict(upcri_bless_SVP2shared(_sptr), _op1);
  }
  UPCRI_LIBWRAP_FN
  int64_t bupc_atomicI64_fetchor_private(void *_ptr, int64_t _op1) {
    return _bupc_atomicI64_fetchor_private(_ptr, _op1);
  }
  UPCRI_LIBWRAP_FN
  int64_t bupc_atomicI64_fetchor_relaxed(shared void *_sptr, int64_t _op1) {
    return _bupc_atomicI64_fetchor_relaxed(upcri_bless_SVP2shared(_sptr), _op1);
  }
  UPCRI_LIBWRAP_FN
  int64_t bupc_atomicI64_fetchor_strict(shared void *_sptr, int64_t _op1) {
    return _bupc_atomicI64_fetchor_strict(upcri_bless_SVP2shared(_sptr), _op1);
  }
  UPCRI_LIBWRAP_FN
  uint32_t bupc_atomicU32_fetchor_private(void *_ptr, uint32_t _op1) {
    return _bupc_atomicU32_fetchor_private(_ptr, _op1);
  }
  UPCRI_LIBWRAP_FN
  uint32_t bupc_atomicU32_fetchor_relaxed(shared void *_sptr, uint32_t _op1) {
    return _bupc_atomicU32_fetchor_relaxed(upcri_bless_SVP2shared(_sptr), _op1);
  }
  UPCRI_LIBWRAP_FN
  uint32_t bupc_atomicU32_fetchor_strict(shared void *_sptr, uint32_t _op1) {
    return _bupc_atomicU32_fetchor_strict(upcri_bless_SVP2shared(_sptr), _op1);
  }
  UPCRI_LIBWRAP_FN
  int32_t bupc_atomicI32_fetchor_private(void *_ptr, int32_t _op1) {
    return _bupc_atomicI32_fetchor_private(_ptr, _op1);
  }
  UPCRI_LIBWRAP_FN
  int32_t bupc_atomicI32_fetchor_relaxed(shared void *_sptr, int32_t _op1) {
    return _bupc_atomicI32_fetchor_relaxed(upcri_bless_SVP2shared(_sptr), _op1);
  }
  UPCRI_LIBWRAP_FN
  int32_t bupc_atomicI32_fetchor_strict(shared void *_sptr, int32_t _op1) {
    return _bupc_atomicI32_fetchor_strict(upcri_bless_SVP2shared(_sptr), _op1);
  }
  UPCRI_LIBWRAP_FN
  uint64_t bupc_atomicU64_fetchxor_private(void *_ptr, uint64_t _op1) {
    return _bupc_atomicU64_fetchxor_private(_ptr, _op1);
  }
  UPCRI_LIBWRAP_FN
  uint64_t bupc_atomicU64_fetchxor_relaxed(shared void *_sptr, uint64_t _op1) {
    return _bupc_atomicU64_fetchxor_relaxed(upcri_bless_SVP2shared(_sptr), _op1);
  }
  UPCRI_LIBWRAP_FN
  uint64_t bupc_atomicU64_fetchxor_strict(shared void *_sptr, uint64_t _op1) {
    return _bupc_atomicU64_fetchxor_strict(upcri_bless_SVP2shared(_sptr), _op1);
  }
  UPCRI_LIBWRAP_FN
  int64_t bupc_atomicI64_fetchxor_private(void *_ptr, int64_t _op1) {
    return _bupc_atomicI64_fetchxor_private(_ptr, _op1);
  }
  UPCRI_LIBWRAP_FN
  int64_t bupc_atomicI64_fetchxor_relaxed(shared void *_sptr, int64_t _op1) {
    return _bupc_atomicI64_fetchxor_relaxed(upcri_bless_SVP2shared(_sptr), _op1);
  }
  UPCRI_LIBWRAP_FN
  int64_t bupc_atomicI64_fetchxor_strict(shared void *_sptr, int64_t _op1) {
    return _bupc_atomicI64_fetchxor_strict(upcri_bless_SVP2shared(_sptr), _op1);
  }
  UPCRI_LIBWRAP_FN
  uint32_t bupc_atomicU32_fetchxor_private(void *_ptr, uint32_t _op1) {
    return _bupc_atomicU32_fetchxor_private(_ptr, _op1);
  }
  UPCRI_LIBWRAP_FN
  uint32_t bupc_atomicU32_fetchxor_relaxed(shared void *_sptr, uint32_t _op1) {
    return _bupc_atomicU32_fetchxor_relaxed(upcri_bless_SVP2shared(_sptr), _op1);
  }
  UPCRI_LIBWRAP_FN
  uint32_t bupc_atomicU32_fetchxor_strict(shared void *_sptr, uint32_t _op1) {
    return _bupc_atomicU32_fetchxor_strict(upcri_bless_SVP2shared(_sptr), _op1);
  }
  UPCRI_LIBWRAP_FN
  int32_t bupc_atomicI32_fetchxor_private(void *_ptr, int32_t _op1) {
    return _bupc_atomicI32_fetchxor_private(_ptr, _op1);
  }
  UPCRI_LIBWRAP_FN
  int32_t bupc_atomicI32_fetchxor_relaxed(shared void *_sptr, int32_t _op1) {
    return _bupc_atomicI32_fetchxor_relaxed(upcri_bless_SVP2shared(_sptr), _op1);
  }
  UPCRI_LIBWRAP_FN
  int32_t bupc_atomicI32_fetchxor_strict(shared void *_sptr, int32_t _op1) {
    return _bupc_atomicI32_fetchxor_strict(upcri_bless_SVP2shared(_sptr), _op1);
  }
  UPCRI_LIBWRAP_FN
  uint64_t bupc_atomicU64_swap_private(void *_ptr, uint64_t _op1) {
    return _bupc_atomicU64_swap_private(_ptr, _op1);
  }
  UPCRI_LIBWRAP_FN
  uint64_t bupc_atomicU64_swap_relaxed(shared void *_sptr, uint64_t _op1) {
    return _bupc_atomicU64_swap_relaxed(upcri_bless_SVP2shared(_sptr), _op1);
  }
  UPCRI_LIBWRAP_FN
  uint64_t bupc_atomicU64_swap_strict(shared void *_sptr, uint64_t _op1) {
    return _bupc_atomicU64_swap_strict(upcri_bless_SVP2shared(_sptr), _op1);
  }
  UPCRI_LIBWRAP_FN
  int64_t bupc_atomicI64_swap_private(void *_ptr, int64_t _op1) {
    return _bupc_atomicI64_swap_private(_ptr, _op1);
  }
  UPCRI_LIBWRAP_FN
  int64_t bupc_atomicI64_swap_relaxed(shared void *_sptr, int64_t _op1) {
    return _bupc_atomicI64_swap_relaxed(upcri_bless_SVP2shared(_sptr), _op1);
  }
  UPCRI_LIBWRAP_FN
  int64_t bupc_atomicI64_swap_strict(shared void *_sptr, int64_t _op1) {
    return _bupc_atomicI64_swap_strict(upcri_bless_SVP2shared(_sptr), _op1);
  }
  UPCRI_LIBWRAP_FN
  uint32_t bupc_atomicU32_swap_private(void *_ptr, uint32_t _op1) {
    return _bupc_atomicU32_swap_private(_ptr, _op1);
  }
  UPCRI_LIBWRAP_FN
  uint32_t bupc_atomicU32_swap_relaxed(shared void *_sptr, uint32_t _op1) {
    return _bupc_atomicU32_swap_relaxed(upcri_bless_SVP2shared(_sptr), _op1);
  }
  UPCRI_LIBWRAP_FN
  uint32_t bupc_atomicU32_swap_strict(shared void *_sptr, uint32_t _op1) {
    return _bupc_atomicU32_swap_strict(upcri_bless_SVP2shared(_sptr), _op1);
  }
  UPCRI_LIBWRAP_FN
  int32_t bupc_atomicI32_swap_private(void *_ptr, int32_t _op1) {
    return _bupc_atomicI32_swap_private(_ptr, _op1);
  }
  UPCRI_LIBWRAP_FN
  int32_t bupc_atomicI32_swap_relaxed(shared void *_sptr, int32_t _op1) {
    return _bupc_atomicI32_swap_relaxed(upcri_bless_SVP2shared(_sptr), _op1);
  }
  UPCRI_LIBWRAP_FN
  int32_t bupc_atomicI32_swap_strict(shared void *_sptr, int32_t _op1) {
    return _bupc_atomicI32_swap_strict(upcri_bless_SVP2shared(_sptr), _op1);
  }
  UPCRI_LIBWRAP_FN
  uint64_t bupc_atomicU64_cswap_private(void *_ptr, uint64_t _op1, uint64_t _op2) {
    return _bupc_atomicU64_cswap_private(_ptr, _op1, _op2);
  }
  UPCRI_LIBWRAP_FN
  uint64_t bupc_atomicU64_cswap_relaxed(shared void *_sptr, uint64_t _op1, uint64_t _op2) {
    return _bupc_atomicU64_cswap_relaxed(upcri_bless_SVP2shared(_sptr), _op1, _op2);
  }
  UPCRI_LIBWRAP_FN
  uint64_t bupc_atomicU64_cswap_strict(shared void *_sptr, uint64_t _op1, uint64_t _op2) {
    return _bupc_atomicU64_cswap_strict(upcri_bless_SVP2shared(_sptr), _op1, _op2);
  }
  UPCRI_LIBWRAP_FN
  int64_t bupc_atomicI64_cswap_private(void *_ptr, int64_t _op1, int64_t _op2) {
    return _bupc_atomicI64_cswap_private(_ptr, _op1, _op2);
  }
  UPCRI_LIBWRAP_FN
  int64_t bupc_atomicI64_cswap_relaxed(shared void *_sptr, int64_t _op1, int64_t _op2) {
    return _bupc_atomicI64_cswap_relaxed(upcri_bless_SVP2shared(_sptr), _op1, _op2);
  }
  UPCRI_LIBWRAP_FN
  int64_t bupc_atomicI64_cswap_strict(shared void *_sptr, int64_t _op1, int64_t _op2) {
    return _bupc_atomicI64_cswap_strict(upcri_bless_SVP2shared(_sptr), _op1, _op2);
  }
  UPCRI_LIBWRAP_FN
  uint32_t bupc_atomicU32_cswap_private(void *_ptr, uint32_t _op1, uint32_t _op2) {
    return _bupc_atomicU32_cswap_private(_ptr, _op1, _op2);
  }
  UPCRI_LIBWRAP_FN
  uint32_t bupc_atomicU32_cswap_relaxed(shared void *_sptr, uint32_t _op1, uint32_t _op2) {
    return _bupc_atomicU32_cswap_relaxed(upcri_bless_SVP2shared(_sptr), _op1, _op2);
  }
  UPCRI_LIBWRAP_FN
  uint32_t bupc_atomicU32_cswap_strict(shared void *_sptr, uint32_t _op1, uint32_t _op2) {
    return _bupc_atomicU32_cswap_strict(upcri_bless_SVP2shared(_sptr), _op1, _op2);
  }
  UPCRI_LIBWRAP_FN
  int32_t bupc_atomicI32_cswap_private(void *_ptr, int32_t _op1, int32_t _op2) {
    return _bupc_atomicI32_cswap_private(_ptr, _op1, _op2);
  }
  UPCRI_LIBWRAP_FN
  int32_t bupc_atomicI32_cswap_relaxed(shared void *_sptr, int32_t _op1, int32_t _op2) {
    return _bupc_atomicI32_cswap_relaxed(upcri_bless_SVP2shared(_sptr), _op1, _op2);
  }
  UPCRI_LIBWRAP_FN
  int32_t bupc_atomicI32_cswap_strict(shared void *_sptr, int32_t _op1, int32_t _op2) {
    return _bupc_atomicI32_cswap_strict(upcri_bless_SVP2shared(_sptr), _op1, _op2);
  }
  UPCRI_LIBWRAP_FN
  uint64_t bupc_atomicU64_mswap_private(void *_ptr, uint64_t _op1, uint64_t _op2) {
    return _bupc_atomicU64_mswap_private(_ptr, _op1, _op2);
  }
  UPCRI_LIBWRAP_FN
  uint64_t bupc_atomicU64_mswap_relaxed(shared void *_sptr, uint64_t _op1, uint64_t _op2) {
    return _bupc_atomicU64_mswap_relaxed(upcri_bless_SVP2shared(_sptr), _op1, _op2);
  }
  UPCRI_LIBWRAP_FN
  uint64_t bupc_atomicU64_mswap_strict(shared void *_sptr, uint64_t _op1, uint64_t _op2) {
    return _bupc_atomicU64_mswap_strict(upcri_bless_SVP2shared(_sptr), _op1, _op2);
  }
  UPCRI_LIBWRAP_FN
  int64_t bupc_atomicI64_mswap_private(void *_ptr, int64_t _op1, int64_t _op2) {
    return _bupc_atomicI64_mswap_private(_ptr, _op1, _op2);
  }
  UPCRI_LIBWRAP_FN
  int64_t bupc_atomicI64_mswap_relaxed(shared void *_sptr, int64_t _op1, int64_t _op2) {
    return _bupc_atomicI64_mswap_relaxed(upcri_bless_SVP2shared(_sptr), _op1, _op2);
  }
  UPCRI_LIBWRAP_FN
  int64_t bupc_atomicI64_mswap_strict(shared void *_sptr, int64_t _op1, int64_t _op2) {
    return _bupc_atomicI64_mswap_strict(upcri_bless_SVP2shared(_sptr), _op1, _op2);
  }
  UPCRI_LIBWRAP_FN
  uint32_t bupc_atomicU32_mswap_private(void *_ptr, uint32_t _op1, uint32_t _op2) {
    return _bupc_atomicU32_mswap_private(_ptr, _op1, _op2);
  }
  UPCRI_LIBWRAP_FN
  uint32_t bupc_atomicU32_mswap_relaxed(shared void *_sptr, uint32_t _op1, uint32_t _op2) {
    return _bupc_atomicU32_mswap_relaxed(upcri_bless_SVP2shared(_sptr), _op1, _op2);
  }
  UPCRI_LIBWRAP_FN
  uint32_t bupc_atomicU32_mswap_strict(shared void *_sptr, uint32_t _op1, uint32_t _op2) {
    return _bupc_atomicU32_mswap_strict(upcri_bless_SVP2shared(_sptr), _op1, _op2);
  }
  UPCRI_LIBWRAP_FN
  int32_t bupc_atomicI32_mswap_private(void *_ptr, int32_t _op1, int32_t _op2) {
    return _bupc_atomicI32_mswap_private(_ptr, _op1, _op2);
  }
  UPCRI_LIBWRAP_FN
  int32_t bupc_atomicI32_mswap_relaxed(shared void *_sptr, int32_t _op1, int32_t _op2) {
    return _bupc_atomicI32_mswap_relaxed(upcri_bless_SVP2shared(_sptr), _op1, _op2);
  }
  UPCRI_LIBWRAP_FN
  int32_t bupc_atomicI32_mswap_strict(shared void *_sptr, int32_t _op1, int32_t _op2) {
    return _bupc_atomicI32_mswap_strict(upcri_bless_SVP2shared(_sptr), _op1, _op2);
  }
#else
  void bupc_atomicU64_set_private(void *_ptr, uint64_t _val);
  void bupc_atomicU64_set_relaxed(shared void *_sptr, uint64_t _val);
  void bupc_atomicU64_set_strict(shared void *_sptr, uint64_t _val);
  void bupc_atomicI64_set_private(void *_ptr, int64_t _val);
  void bupc_atomicI64_set_relaxed(shared void *_sptr, int64_t _val);
  void bupc_atomicI64_set_strict(shared void *_sptr, int64_t _val);
  void bupc_atomicU32_set_private(void *_ptr, uint32_t _val);
  void bupc_atomicU32_set_relaxed(shared void *_sptr, uint32_t _val);
  void bupc_atomicU32_set_strict(shared void *_sptr, uint32_t _val);
  void bupc_atomicI32_set_private(void *_ptr, int32_t _val);
  void bupc_atomicI32_set_relaxed(shared void *_sptr, int32_t _val);
  void bupc_atomicI32_set_strict(shared void *_sptr, int32_t _val);
  uint64_t bupc_atomicU64_read_private(void *_ptr);
  uint64_t bupc_atomicU64_read_relaxed(shared void *_sptr);
  uint64_t bupc_atomicU64_read_strict(shared void *_sptr);
  int64_t bupc_atomicI64_read_private(void *_ptr);
  int64_t bupc_atomicI64_read_relaxed(shared void *_sptr);
  int64_t bupc_atomicI64_read_strict(shared void *_sptr);
  uint32_t bupc_atomicU32_read_private(void *_ptr);
  uint32_t bupc_atomicU32_read_relaxed(shared void *_sptr);
  uint32_t bupc_atomicU32_read_strict(shared void *_sptr);
  int32_t bupc_atomicI32_read_private(void *_ptr);
  int32_t bupc_atomicI32_read_relaxed(shared void *_sptr);
  int32_t bupc_atomicI32_read_strict(shared void *_sptr);
  uint64_t bupc_atomicU64_fetchnot_private(void *_ptr);
  uint64_t bupc_atomicU64_fetchnot_relaxed(shared void *_sptr);
  uint64_t bupc_atomicU64_fetchnot_strict(shared void *_sptr);
  int64_t bupc_atomicI64_fetchnot_private(void *_ptr);
  int64_t bupc_atomicI64_fetchnot_relaxed(shared void *_sptr);
  int64_t bupc_atomicI64_fetchnot_strict(shared void *_sptr);
  uint32_t bupc_atomicU32_fetchnot_private(void *_ptr);
  uint32_t bupc_atomicU32_fetchnot_relaxed(shared void *_sptr);
  uint32_t bupc_atomicU32_fetchnot_strict(shared void *_sptr);
  int32_t bupc_atomicI32_fetchnot_private(void *_ptr);
  int32_t bupc_atomicI32_fetchnot_relaxed(shared void *_sptr);
  int32_t bupc_atomicI32_fetchnot_strict(shared void *_sptr);
  uint64_t bupc_atomicU64_fetchadd_private(void *_ptr, uint64_t _op1);
  uint64_t bupc_atomicU64_fetchadd_relaxed(shared void *_sptr, uint64_t _op1);
  uint64_t bupc_atomicU64_fetchadd_strict(shared void *_sptr, uint64_t _op1);
  int64_t bupc_atomicI64_fetchadd_private(void *_ptr, int64_t _op1);
  int64_t bupc_atomicI64_fetchadd_relaxed(shared void *_sptr, int64_t _op1);
  int64_t bupc_atomicI64_fetchadd_strict(shared void *_sptr, int64_t _op1);
  uint32_t bupc_atomicU32_fetchadd_private(void *_ptr, uint32_t _op1);
  uint32_t bupc_atomicU32_fetchadd_relaxed(shared void *_sptr, uint32_t _op1);
  uint32_t bupc_atomicU32_fetchadd_strict(shared void *_sptr, uint32_t _op1);
  int32_t bupc_atomicI32_fetchadd_private(void *_ptr, int32_t _op1);
  int32_t bupc_atomicI32_fetchadd_relaxed(shared void *_sptr, int32_t _op1);
  int32_t bupc_atomicI32_fetchadd_strict(shared void *_sptr, int32_t _op1);
  uint64_t bupc_atomicU64_fetchand_private(void *_ptr, uint64_t _op1);
  uint64_t bupc_atomicU64_fetchand_relaxed(shared void *_sptr, uint64_t _op1);
  uint64_t bupc_atomicU64_fetchand_strict(shared void *_sptr, uint64_t _op1);
  int64_t bupc_atomicI64_fetchand_private(void *_ptr, int64_t _op1);
  int64_t bupc_atomicI64_fetchand_relaxed(shared void *_sptr, int64_t _op1);
  int64_t bupc_atomicI64_fetchand_strict(shared void *_sptr, int64_t _op1);
  uint32_t bupc_atomicU32_fetchand_private(void *_ptr, uint32_t _op1);
  uint32_t bupc_atomicU32_fetchand_relaxed(shared void *_sptr, uint32_t _op1);
  uint32_t bupc_atomicU32_fetchand_strict(shared void *_sptr, uint32_t _op1);
  int32_t bupc_atomicI32_fetchand_private(void *_ptr, int32_t _op1);
  int32_t bupc_atomicI32_fetchand_relaxed(shared void *_sptr, int32_t _op1);
  int32_t bupc_atomicI32_fetchand_strict(shared void *_sptr, int32_t _op1);
  uint64_t bupc_atomicU64_fetchor_private(void *_ptr, uint64_t _op1);
  uint64_t bupc_atomicU64_fetchor_relaxed(shared void *_sptr, uint64_t _op1);
  uint64_t bupc_atomicU64_fetchor_strict(shared void *_sptr, uint64_t _op1);
  int64_t bupc_atomicI64_fetchor_private(void *_ptr, int64_t _op1);
  int64_t bupc_atomicI64_fetchor_relaxed(shared void *_sptr, int64_t _op1);
  int64_t bupc_atomicI64_fetchor_strict(shared void *_sptr, int64_t _op1);
  uint32_t bupc_atomicU32_fetchor_private(void *_ptr, uint32_t _op1);
  uint32_t bupc_atomicU32_fetchor_relaxed(shared void *_sptr, uint32_t _op1);
  uint32_t bupc_atomicU32_fetchor_strict(shared void *_sptr, uint32_t _op1);
  int32_t bupc_atomicI32_fetchor_private(void *_ptr, int32_t _op1);
  int32_t bupc_atomicI32_fetchor_relaxed(shared void *_sptr, int32_t _op1);
  int32_t bupc_atomicI32_fetchor_strict(shared void *_sptr, int32_t _op1);
  uint64_t bupc_atomicU64_fetchxor_private(void *_ptr, uint64_t _op1);
  uint64_t bupc_atomicU64_fetchxor_relaxed(shared void *_sptr, uint64_t _op1);
  uint64_t bupc_atomicU64_fetchxor_strict(shared void *_sptr, uint64_t _op1);
  int64_t bupc_atomicI64_fetchxor_private(void *_ptr, int64_t _op1);
  int64_t bupc_atomicI64_fetchxor_relaxed(shared void *_sptr, int64_t _op1);
  int64_t bupc_atomicI64_fetchxor_strict(shared void *_sptr, int64_t _op1);
  uint32_t bupc_atomicU32_fetchxor_private(void *_ptr, uint32_t _op1);
  uint32_t bupc_atomicU32_fetchxor_relaxed(shared void *_sptr, uint32_t _op1);
  uint32_t bupc_atomicU32_fetchxor_strict(shared void *_sptr, uint32_t _op1);
  int32_t bupc_atomicI32_fetchxor_private(void *_ptr, int32_t _op1);
  int32_t bupc_atomicI32_fetchxor_relaxed(shared void *_sptr, int32_t _op1);
  int32_t bupc_atomicI32_fetchxor_strict(shared void *_sptr, int32_t _op1);
  uint64_t bupc_atomicU64_swap_private(void *_ptr, uint64_t _op1);
  uint64_t bupc_atomicU64_swap_relaxed(shared void *_sptr, uint64_t _op1);
  uint64_t bupc_atomicU64_swap_strict(shared void *_sptr, uint64_t _op1);
  int64_t bupc_atomicI64_swap_private(void *_ptr, int64_t _op1);
  int64_t bupc_atomicI64_swap_relaxed(shared void *_sptr, int64_t _op1);
  int64_t bupc_atomicI64_swap_strict(shared void *_sptr, int64_t _op1);
  uint32_t bupc_atomicU32_swap_private(void *_ptr, uint32_t _op1);
  uint32_t bupc_atomicU32_swap_relaxed(shared void *_sptr, uint32_t _op1);
  uint32_t bupc_atomicU32_swap_strict(shared void *_sptr, uint32_t _op1);
  int32_t bupc_atomicI32_swap_private(void *_ptr, int32_t _op1);
  int32_t bupc_atomicI32_swap_relaxed(shared void *_sptr, int32_t _op1);
  int32_t bupc_atomicI32_swap_strict(shared void *_sptr, int32_t _op1);
  uint64_t bupc_atomicU64_cswap_private(void *_ptr, uint64_t _op1, uint64_t _op2);
  uint64_t bupc_atomicU64_cswap_relaxed(shared void *_sptr, uint64_t _op1, uint64_t _op2);
  uint64_t bupc_atomicU64_cswap_strict(shared void *_sptr, uint64_t _op1, uint64_t _op2);
  int64_t bupc_atomicI64_cswap_private(void *_ptr, int64_t _op1, int64_t _op2);
  int64_t bupc_atomicI64_cswap_relaxed(shared void *_sptr, int64_t _op1, int64_t _op2);
  int64_t bupc_atomicI64_cswap_strict(shared void *_sptr, int64_t _op1, int64_t _op2);
  uint32_t bupc_atomicU32_cswap_private(void *_ptr, uint32_t _op1, uint32_t _op2);
  uint32_t bupc_atomicU32_cswap_relaxed(shared void *_sptr, uint32_t _op1, uint32_t _op2);
  uint32_t bupc_atomicU32_cswap_strict(shared void *_sptr, uint32_t _op1, uint32_t _op2);
  int32_t bupc_atomicI32_cswap_private(void *_ptr, int32_t _op1, int32_t _op2);
  int32_t bupc_atomicI32_cswap_relaxed(shared void *_sptr, int32_t _op1, int32_t _op2);
  int32_t bupc_atomicI32_cswap_strict(shared void *_sptr, int32_t _op1, int32_t _op2);
  uint64_t bupc_atomicU64_mswap_private(void *_ptr, uint64_t _op1, uint64_t _op2);
  uint64_t bupc_atomicU64_mswap_relaxed(shared void *_sptr, uint64_t _op1, uint64_t _op2);
  uint64_t bupc_atomicU64_mswap_strict(shared void *_sptr, uint64_t _op1, uint64_t _op2);
  int64_t bupc_atomicI64_mswap_private(void *_ptr, int64_t _op1, int64_t _op2);
  int64_t bupc_atomicI64_mswap_relaxed(shared void *_sptr, int64_t _op1, int64_t _op2);
  int64_t bupc_atomicI64_mswap_strict(shared void *_sptr, int64_t _op1, int64_t _op2);
  uint32_t bupc_atomicU32_mswap_private(void *_ptr, uint32_t _op1, uint32_t _op2);
  uint32_t bupc_atomicU32_mswap_relaxed(shared void *_sptr, uint32_t _op1, uint32_t _op2);
  uint32_t bupc_atomicU32_mswap_strict(shared void *_sptr, uint32_t _op1, uint32_t _op2);
  int32_t bupc_atomicI32_mswap_private(void *_ptr, int32_t _op1, int32_t _op2);
  int32_t bupc_atomicI32_mswap_relaxed(shared void *_sptr, int32_t _op1, int32_t _op2);
  int32_t bupc_atomicI32_mswap_strict(shared void *_sptr, int32_t _op1, int32_t _op2);
#endif

/* Map I and UI to appropriate fixed-width size */
#if (SIZEOF_INT == 4)
  #define bupc_atomicI_set_relaxed   bupc_atomicI32_set_relaxed
  #define bupc_atomicI_set_strict    bupc_atomicI32_set_strict
  #define bupc_atomicI_set_private   bupc_atomicI32_set_private
  #define bupc_atomicUI_set_relaxed   bupc_atomicU32_set_relaxed
  #define bupc_atomicUI_set_strict    bupc_atomicU32_set_strict
  #define bupc_atomicUI_set_private   bupc_atomicU32_set_private
  #define bupc_atomicI_read_relaxed  bupc_atomicI32_read_relaxed
  #define bupc_atomicI_read_strict   bupc_atomicI32_read_strict
  #define bupc_atomicI_read_private  bupc_atomicI32_read_private
  #define bupc_atomicUI_read_relaxed  bupc_atomicU32_read_relaxed
  #define bupc_atomicUI_read_strict   bupc_atomicU32_read_strict
  #define bupc_atomicUI_read_private  bupc_atomicU32_read_private
  #define bupc_atomicI_fetchadd_relaxed  bupc_atomicI32_fetchadd_relaxed
  #define bupc_atomicI_fetchadd_strict   bupc_atomicI32_fetchadd_strict
  #define bupc_atomicI_fetchadd_private  bupc_atomicI32_fetchadd_private
  #define bupc_atomicUI_fetchadd_relaxed  bupc_atomicU32_fetchadd_relaxed
  #define bupc_atomicUI_fetchadd_strict   bupc_atomicU32_fetchadd_strict
  #define bupc_atomicUI_fetchadd_private  bupc_atomicU32_fetchadd_private
  #define bupc_atomicI_fetchand_relaxed  bupc_atomicI32_fetchand_relaxed
  #define bupc_atomicI_fetchand_strict   bupc_atomicI32_fetchand_strict
  #define bupc_atomicI_fetchand_private  bupc_atomicI32_fetchand_private
  #define bupc_atomicUI_fetchand_relaxed  bupc_atomicU32_fetchand_relaxed
  #define bupc_atomicUI_fetchand_strict   bupc_atomicU32_fetchand_strict
  #define bupc_atomicUI_fetchand_private  bupc_atomicU32_fetchand_private
  #define bupc_atomicI_fetchor_relaxed  bupc_atomicI32_fetchor_relaxed
  #define bupc_atomicI_fetchor_strict   bupc_atomicI32_fetchor_strict
  #define bupc_atomicI_fetchor_private  bupc_atomicI32_fetchor_private
  #define bupc_atomicUI_fetchor_relaxed  bupc_atomicU32_fetchor_relaxed
  #define bupc_atomicUI_fetchor_strict   bupc_atomicU32_fetchor_strict
  #define bupc_atomicUI_fetchor_private  bupc_atomicU32_fetchor_private
  #define bupc_atomicI_fetchxor_relaxed  bupc_atomicI32_fetchxor_relaxed
  #define bupc_atomicI_fetchxor_strict   bupc_atomicI32_fetchxor_strict
  #define bupc_atomicI_fetchxor_private  bupc_atomicI32_fetchxor_private
  #define bupc_atomicUI_fetchxor_relaxed  bupc_atomicU32_fetchxor_relaxed
  #define bupc_atomicUI_fetchxor_strict   bupc_atomicU32_fetchxor_strict
  #define bupc_atomicUI_fetchxor_private  bupc_atomicU32_fetchxor_private
  #define bupc_atomicI_swap_relaxed  bupc_atomicI32_swap_relaxed
  #define bupc_atomicI_swap_strict   bupc_atomicI32_swap_strict
  #define bupc_atomicI_swap_private  bupc_atomicI32_swap_private
  #define bupc_atomicUI_swap_relaxed  bupc_atomicU32_swap_relaxed
  #define bupc_atomicUI_swap_strict   bupc_atomicU32_swap_strict
  #define bupc_atomicUI_swap_private  bupc_atomicU32_swap_private
  #define bupc_atomicI_fetchnot_relaxed  bupc_atomicI32_fetchnot_relaxed
  #define bupc_atomicI_fetchnot_strict   bupc_atomicI32_fetchnot_strict
  #define bupc_atomicI_fetchnot_private  bupc_atomicI32_fetchnot_private
  #define bupc_atomicUI_fetchnot_relaxed  bupc_atomicU32_fetchnot_relaxed
  #define bupc_atomicUI_fetchnot_strict   bupc_atomicU32_fetchnot_strict
  #define bupc_atomicUI_fetchnot_private  bupc_atomicU32_fetchnot_private
  #define bupc_atomicI_cswap_relaxed  bupc_atomicI32_cswap_relaxed
  #define bupc_atomicI_cswap_strict   bupc_atomicI32_cswap_strict
  #define bupc_atomicI_cswap_private  bupc_atomicI32_cswap_private
  #define bupc_atomicUI_cswap_relaxed  bupc_atomicU32_cswap_relaxed
  #define bupc_atomicUI_cswap_strict   bupc_atomicU32_cswap_strict
  #define bupc_atomicUI_cswap_private  bupc_atomicU32_cswap_private
  #define bupc_atomicI_mswap_relaxed  bupc_atomicI32_mswap_relaxed
  #define bupc_atomicI_mswap_strict   bupc_atomicI32_mswap_strict
  #define bupc_atomicI_mswap_private  bupc_atomicI32_mswap_private
  #define bupc_atomicUI_mswap_relaxed  bupc_atomicU32_mswap_relaxed
  #define bupc_atomicUI_mswap_strict   bupc_atomicU32_mswap_strict
  #define bupc_atomicUI_mswap_private  bupc_atomicU32_mswap_private
#elif (SIZEOF_INT == 8)
  #define bupc_atomicI_set_relaxed   bupc_atomicI64_set_relaxed
  #define bupc_atomicI_set_strict    bupc_atomicI64_set_strict
  #define bupc_atomicI_set_private   bupc_atomicI64_set_private
  #define bupc_atomicUI_set_relaxed   bupc_atomicU64_set_relaxed
  #define bupc_atomicUI_set_strict    bupc_atomicU64_set_strict
  #define bupc_atomicUI_set_private   bupc_atomicU64_set_private
  #define bupc_atomicI_read_relaxed  bupc_atomicI64_read_relaxed
  #define bupc_atomicI_read_strict   bupc_atomicI64_read_strict
  #define bupc_atomicI_read_private  bupc_atomicI64_read_private
  #define bupc_atomicUI_read_relaxed  bupc_atomicU64_read_relaxed
  #define bupc_atomicUI_read_strict   bupc_atomicU64_read_strict
  #define bupc_atomicUI_read_private  bupc_atomicU64_read_private
  #define bupc_atomicI_fetchadd_relaxed  bupc_atomicI64_fetchadd_relaxed
  #define bupc_atomicI_fetchadd_strict   bupc_atomicI64_fetchadd_strict
  #define bupc_atomicI_fetchadd_private  bupc_atomicI64_fetchadd_private
  #define bupc_atomicUI_fetchadd_relaxed  bupc_atomicU64_fetchadd_relaxed
  #define bupc_atomicUI_fetchadd_strict   bupc_atomicU64_fetchadd_strict
  #define bupc_atomicUI_fetchadd_private  bupc_atomicU64_fetchadd_private
  #define bupc_atomicI_fetchand_relaxed  bupc_atomicI64_fetchand_relaxed
  #define bupc_atomicI_fetchand_strict   bupc_atomicI64_fetchand_strict
  #define bupc_atomicI_fetchand_private  bupc_atomicI64_fetchand_private
  #define bupc_atomicUI_fetchand_relaxed  bupc_atomicU64_fetchand_relaxed
  #define bupc_atomicUI_fetchand_strict   bupc_atomicU64_fetchand_strict
  #define bupc_atomicUI_fetchand_private  bupc_atomicU64_fetchand_private
  #define bupc_atomicI_fetchor_relaxed  bupc_atomicI64_fetchor_relaxed
  #define bupc_atomicI_fetchor_strict   bupc_atomicI64_fetchor_strict
  #define bupc_atomicI_fetchor_private  bupc_atomicI64_fetchor_private
  #define bupc_atomicUI_fetchor_relaxed  bupc_atomicU64_fetchor_relaxed
  #define bupc_atomicUI_fetchor_strict   bupc_atomicU64_fetchor_strict
  #define bupc_atomicUI_fetchor_private  bupc_atomicU64_fetchor_private
  #define bupc_atomicI_fetchxor_relaxed  bupc_atomicI64_fetchxor_relaxed
  #define bupc_atomicI_fetchxor_strict   bupc_atomicI64_fetchxor_strict
  #define bupc_atomicI_fetchxor_private  bupc_atomicI64_fetchxor_private
  #define bupc_atomicUI_fetchxor_relaxed  bupc_atomicU64_fetchxor_relaxed
  #define bupc_atomicUI_fetchxor_strict   bupc_atomicU64_fetchxor_strict
  #define bupc_atomicUI_fetchxor_private  bupc_atomicU64_fetchxor_private
  #define bupc_atomicI_swap_relaxed  bupc_atomicI64_swap_relaxed
  #define bupc_atomicI_swap_strict   bupc_atomicI64_swap_strict
  #define bupc_atomicI_swap_private  bupc_atomicI64_swap_private
  #define bupc_atomicUI_swap_relaxed  bupc_atomicU64_swap_relaxed
  #define bupc_atomicUI_swap_strict   bupc_atomicU64_swap_strict
  #define bupc_atomicUI_swap_private  bupc_atomicU64_swap_private
  #define bupc_atomicI_fetchnot_relaxed  bupc_atomicI64_fetchnot_relaxed
  #define bupc_atomicI_fetchnot_strict   bupc_atomicI64_fetchnot_strict
  #define bupc_atomicI_fetchnot_private  bupc_atomicI64_fetchnot_private
  #define bupc_atomicUI_fetchnot_relaxed  bupc_atomicU64_fetchnot_relaxed
  #define bupc_atomicUI_fetchnot_strict   bupc_atomicU64_fetchnot_strict
  #define bupc_atomicUI_fetchnot_private  bupc_atomicU64_fetchnot_private
  #define bupc_atomicI_cswap_relaxed  bupc_atomicI64_cswap_relaxed
  #define bupc_atomicI_cswap_strict   bupc_atomicI64_cswap_strict
  #define bupc_atomicI_cswap_private  bupc_atomicI64_cswap_private
  #define bupc_atomicUI_cswap_relaxed  bupc_atomicU64_cswap_relaxed
  #define bupc_atomicUI_cswap_strict   bupc_atomicU64_cswap_strict
  #define bupc_atomicUI_cswap_private  bupc_atomicU64_cswap_private
  #define bupc_atomicI_mswap_relaxed  bupc_atomicI64_mswap_relaxed
  #define bupc_atomicI_mswap_strict   bupc_atomicI64_mswap_strict
  #define bupc_atomicI_mswap_private  bupc_atomicI64_mswap_private
  #define bupc_atomicUI_mswap_relaxed  bupc_atomicU64_mswap_relaxed
  #define bupc_atomicUI_mswap_strict   bupc_atomicU64_mswap_strict
  #define bupc_atomicUI_mswap_private  bupc_atomicU64_mswap_private
#else
  #define bupc_atomicI_set_relaxed   ERROR__no_atomics_for_type_I
  #define bupc_atomicI_set_strict    ERROR__no_atomics_for_type_I
  #define bupc_atomicI_set_private   ERROR__no_atomics_for_type_I
  #define bupc_atomicUI_set_relaxed   ERROR__no_atomics_for_type_UI
  #define bupc_atomicUI_set_strict    ERROR__no_atomics_for_type_UI
  #define bupc_atomicUI_set_private   ERROR__no_atomics_for_type_UI
  #define bupc_atomicI_read_relaxed  ERROR__no_atomics_for_type_I
  #define bupc_atomicI_read_strict   ERROR__no_atomics_for_type_I
  #define bupc_atomicI_read_private  ERROR__no_atomics_for_type_I
  #define bupc_atomicUI_read_relaxed  ERROR__no_atomics_for_type_UI
  #define bupc_atomicUI_read_strict   ERROR__no_atomics_for_type_UI
  #define bupc_atomicUI_read_private  ERROR__no_atomics_for_type_UI
  #define bupc_atomicI_fetchadd_relaxed  ERROR__no_atomics_for_type_I
  #define bupc_atomicI_fetchadd_strict   ERROR__no_atomics_for_type_I
  #define bupc_atomicI_fetchadd_private  ERROR__no_atomics_for_type_I
  #define bupc_atomicUI_fetchadd_relaxed  ERROR__no_atomics_for_type_UI
  #define bupc_atomicUI_fetchadd_strict   ERROR__no_atomics_for_type_UI
  #define bupc_atomicUI_fetchadd_private  ERROR__no_atomics_for_type_UI
  #define bupc_atomicI_fetchand_relaxed  ERROR__no_atomics_for_type_I
  #define bupc_atomicI_fetchand_strict   ERROR__no_atomics_for_type_I
  #define bupc_atomicI_fetchand_private  ERROR__no_atomics_for_type_I
  #define bupc_atomicUI_fetchand_relaxed  ERROR__no_atomics_for_type_UI
  #define bupc_atomicUI_fetchand_strict   ERROR__no_atomics_for_type_UI
  #define bupc_atomicUI_fetchand_private  ERROR__no_atomics_for_type_UI
  #define bupc_atomicI_fetchor_relaxed  ERROR__no_atomics_for_type_I
  #define bupc_atomicI_fetchor_strict   ERROR__no_atomics_for_type_I
  #define bupc_atomicI_fetchor_private  ERROR__no_atomics_for_type_I
  #define bupc_atomicUI_fetchor_relaxed  ERROR__no_atomics_for_type_UI
  #define bupc_atomicUI_fetchor_strict   ERROR__no_atomics_for_type_UI
  #define bupc_atomicUI_fetchor_private  ERROR__no_atomics_for_type_UI
  #define bupc_atomicI_fetchxor_relaxed  ERROR__no_atomics_for_type_I
  #define bupc_atomicI_fetchxor_strict   ERROR__no_atomics_for_type_I
  #define bupc_atomicI_fetchxor_private  ERROR__no_atomics_for_type_I
  #define bupc_atomicUI_fetchxor_relaxed  ERROR__no_atomics_for_type_UI
  #define bupc_atomicUI_fetchxor_strict   ERROR__no_atomics_for_type_UI
  #define bupc_atomicUI_fetchxor_private  ERROR__no_atomics_for_type_UI
  #define bupc_atomicI_swap_relaxed  ERROR__no_atomics_for_type_I
  #define bupc_atomicI_swap_strict   ERROR__no_atomics_for_type_I
  #define bupc_atomicI_swap_private  ERROR__no_atomics_for_type_I
  #define bupc_atomicUI_swap_relaxed  ERROR__no_atomics_for_type_UI
  #define bupc_atomicUI_swap_strict   ERROR__no_atomics_for_type_UI
  #define bupc_atomicUI_swap_private  ERROR__no_atomics_for_type_UI
  #define bupc_atomicI_fetchnot_relaxed  ERROR__no_atomics_for_type_I
  #define bupc_atomicI_fetchnot_strict   ERROR__no_atomics_for_type_I
  #define bupc_atomicI_fetchnot_private  ERROR__no_atomics_for_type_I
  #define bupc_atomicUI_fetchnot_relaxed  ERROR__no_atomics_for_type_UI
  #define bupc_atomicUI_fetchnot_strict   ERROR__no_atomics_for_type_UI
  #define bupc_atomicUI_fetchnot_private  ERROR__no_atomics_for_type_UI
  #define bupc_atomicI_cswap_relaxed  ERROR__no_atomics_for_type_I
  #define bupc_atomicI_cswap_strict   ERROR__no_atomics_for_type_I
  #define bupc_atomicI_cswap_private  ERROR__no_atomics_for_type_I
  #define bupc_atomicUI_cswap_relaxed  ERROR__no_atomics_for_type_UI
  #define bupc_atomicUI_cswap_strict   ERROR__no_atomics_for_type_UI
  #define bupc_atomicUI_cswap_private  ERROR__no_atomics_for_type_UI
  #define bupc_atomicI_mswap_relaxed  ERROR__no_atomics_for_type_I
  #define bupc_atomicI_mswap_strict   ERROR__no_atomics_for_type_I
  #define bupc_atomicI_mswap_private  ERROR__no_atomics_for_type_I
  #define bupc_atomicUI_mswap_relaxed  ERROR__no_atomics_for_type_UI
  #define bupc_atomicUI_mswap_strict   ERROR__no_atomics_for_type_UI
  #define bupc_atomicUI_mswap_private  ERROR__no_atomics_for_type_UI
#endif

/* Map L and UL to appropriate fixed-width size */
#if (SIZEOF_LONG == 4)
  #define bupc_atomicL_set_relaxed   bupc_atomicI32_set_relaxed
  #define bupc_atomicL_set_strict    bupc_atomicI32_set_strict
  #define bupc_atomicL_set_private   bupc_atomicI32_set_private
  #define bupc_atomicUL_set_relaxed   bupc_atomicU32_set_relaxed
  #define bupc_atomicUL_set_strict    bupc_atomicU32_set_strict
  #define bupc_atomicUL_set_private   bupc_atomicU32_set_private
  #define bupc_atomicL_read_relaxed  bupc_atomicI32_read_relaxed
  #define bupc_atomicL_read_strict   bupc_atomicI32_read_strict
  #define bupc_atomicL_read_private  bupc_atomicI32_read_private
  #define bupc_atomicUL_read_relaxed  bupc_atomicU32_read_relaxed
  #define bupc_atomicUL_read_strict   bupc_atomicU32_read_strict
  #define bupc_atomicUL_read_private  bupc_atomicU32_read_private
  #define bupc_atomicL_fetchadd_relaxed  bupc_atomicI32_fetchadd_relaxed
  #define bupc_atomicL_fetchadd_strict   bupc_atomicI32_fetchadd_strict
  #define bupc_atomicL_fetchadd_private  bupc_atomicI32_fetchadd_private
  #define bupc_atomicUL_fetchadd_relaxed  bupc_atomicU32_fetchadd_relaxed
  #define bupc_atomicUL_fetchadd_strict   bupc_atomicU32_fetchadd_strict
  #define bupc_atomicUL_fetchadd_private  bupc_atomicU32_fetchadd_private
  #define bupc_atomicL_fetchand_relaxed  bupc_atomicI32_fetchand_relaxed
  #define bupc_atomicL_fetchand_strict   bupc_atomicI32_fetchand_strict
  #define bupc_atomicL_fetchand_private  bupc_atomicI32_fetchand_private
  #define bupc_atomicUL_fetchand_relaxed  bupc_atomicU32_fetchand_relaxed
  #define bupc_atomicUL_fetchand_strict   bupc_atomicU32_fetchand_strict
  #define bupc_atomicUL_fetchand_private  bupc_atomicU32_fetchand_private
  #define bupc_atomicL_fetchor_relaxed  bupc_atomicI32_fetchor_relaxed
  #define bupc_atomicL_fetchor_strict   bupc_atomicI32_fetchor_strict
  #define bupc_atomicL_fetchor_private  bupc_atomicI32_fetchor_private
  #define bupc_atomicUL_fetchor_relaxed  bupc_atomicU32_fetchor_relaxed
  #define bupc_atomicUL_fetchor_strict   bupc_atomicU32_fetchor_strict
  #define bupc_atomicUL_fetchor_private  bupc_atomicU32_fetchor_private
  #define bupc_atomicL_fetchxor_relaxed  bupc_atomicI32_fetchxor_relaxed
  #define bupc_atomicL_fetchxor_strict   bupc_atomicI32_fetchxor_strict
  #define bupc_atomicL_fetchxor_private  bupc_atomicI32_fetchxor_private
  #define bupc_atomicUL_fetchxor_relaxed  bupc_atomicU32_fetchxor_relaxed
  #define bupc_atomicUL_fetchxor_strict   bupc_atomicU32_fetchxor_strict
  #define bupc_atomicUL_fetchxor_private  bupc_atomicU32_fetchxor_private
  #define bupc_atomicL_swap_relaxed  bupc_atomicI32_swap_relaxed
  #define bupc_atomicL_swap_strict   bupc_atomicI32_swap_strict
  #define bupc_atomicL_swap_private  bupc_atomicI32_swap_private
  #define bupc_atomicUL_swap_relaxed  bupc_atomicU32_swap_relaxed
  #define bupc_atomicUL_swap_strict   bupc_atomicU32_swap_strict
  #define bupc_atomicUL_swap_private  bupc_atomicU32_swap_private
  #define bupc_atomicL_fetchnot_relaxed  bupc_atomicI32_fetchnot_relaxed
  #define bupc_atomicL_fetchnot_strict   bupc_atomicI32_fetchnot_strict
  #define bupc_atomicL_fetchnot_private  bupc_atomicI32_fetchnot_private
  #define bupc_atomicUL_fetchnot_relaxed  bupc_atomicU32_fetchnot_relaxed
  #define bupc_atomicUL_fetchnot_strict   bupc_atomicU32_fetchnot_strict
  #define bupc_atomicUL_fetchnot_private  bupc_atomicU32_fetchnot_private
  #define bupc_atomicL_cswap_relaxed  bupc_atomicI32_cswap_relaxed
  #define bupc_atomicL_cswap_strict   bupc_atomicI32_cswap_strict
  #define bupc_atomicL_cswap_private  bupc_atomicI32_cswap_private
  #define bupc_atomicUL_cswap_relaxed  bupc_atomicU32_cswap_relaxed
  #define bupc_atomicUL_cswap_strict   bupc_atomicU32_cswap_strict
  #define bupc_atomicUL_cswap_private  bupc_atomicU32_cswap_private
  #define bupc_atomicL_mswap_relaxed  bupc_atomicI32_mswap_relaxed
  #define bupc_atomicL_mswap_strict   bupc_atomicI32_mswap_strict
  #define bupc_atomicL_mswap_private  bupc_atomicI32_mswap_private
  #define bupc_atomicUL_mswap_relaxed  bupc_atomicU32_mswap_relaxed
  #define bupc_atomicUL_mswap_strict   bupc_atomicU32_mswap_strict
  #define bupc_atomicUL_mswap_private  bupc_atomicU32_mswap_private
#elif (SIZEOF_LONG == 8)
  #define bupc_atomicL_set_relaxed   bupc_atomicI64_set_relaxed
  #define bupc_atomicL_set_strict    bupc_atomicI64_set_strict
  #define bupc_atomicL_set_private   bupc_atomicI64_set_private
  #define bupc_atomicUL_set_relaxed   bupc_atomicU64_set_relaxed
  #define bupc_atomicUL_set_strict    bupc_atomicU64_set_strict
  #define bupc_atomicUL_set_private   bupc_atomicU64_set_private
  #define bupc_atomicL_read_relaxed  bupc_atomicI64_read_relaxed
  #define bupc_atomicL_read_strict   bupc_atomicI64_read_strict
  #define bupc_atomicL_read_private  bupc_atomicI64_read_private
  #define bupc_atomicUL_read_relaxed  bupc_atomicU64_read_relaxed
  #define bupc_atomicUL_read_strict   bupc_atomicU64_read_strict
  #define bupc_atomicUL_read_private  bupc_atomicU64_read_private
  #define bupc_atomicL_fetchadd_relaxed  bupc_atomicI64_fetchadd_relaxed
  #define bupc_atomicL_fetchadd_strict   bupc_atomicI64_fetchadd_strict
  #define bupc_atomicL_fetchadd_private  bupc_atomicI64_fetchadd_private
  #define bupc_atomicUL_fetchadd_relaxed  bupc_atomicU64_fetchadd_relaxed
  #define bupc_atomicUL_fetchadd_strict   bupc_atomicU64_fetchadd_strict
  #define bupc_atomicUL_fetchadd_private  bupc_atomicU64_fetchadd_private
  #define bupc_atomicL_fetchand_relaxed  bupc_atomicI64_fetchand_relaxed
  #define bupc_atomicL_fetchand_strict   bupc_atomicI64_fetchand_strict
  #define bupc_atomicL_fetchand_private  bupc_atomicI64_fetchand_private
  #define bupc_atomicUL_fetchand_relaxed  bupc_atomicU64_fetchand_relaxed
  #define bupc_atomicUL_fetchand_strict   bupc_atomicU64_fetchand_strict
  #define bupc_atomicUL_fetchand_private  bupc_atomicU64_fetchand_private
  #define bupc_atomicL_fetchor_relaxed  bupc_atomicI64_fetchor_relaxed
  #define bupc_atomicL_fetchor_strict   bupc_atomicI64_fetchor_strict
  #define bupc_atomicL_fetchor_private  bupc_atomicI64_fetchor_private
  #define bupc_atomicUL_fetchor_relaxed  bupc_atomicU64_fetchor_relaxed
  #define bupc_atomicUL_fetchor_strict   bupc_atomicU64_fetchor_strict
  #define bupc_atomicUL_fetchor_private  bupc_atomicU64_fetchor_private
  #define bupc_atomicL_fetchxor_relaxed  bupc_atomicI64_fetchxor_relaxed
  #define bupc_atomicL_fetchxor_strict   bupc_atomicI64_fetchxor_strict
  #define bupc_atomicL_fetchxor_private  bupc_atomicI64_fetchxor_private
  #define bupc_atomicUL_fetchxor_relaxed  bupc_atomicU64_fetchxor_relaxed
  #define bupc_atomicUL_fetchxor_strict   bupc_atomicU64_fetchxor_strict
  #define bupc_atomicUL_fetchxor_private  bupc_atomicU64_fetchxor_private
  #define bupc_atomicL_swap_relaxed  bupc_atomicI64_swap_relaxed
  #define bupc_atomicL_swap_strict   bupc_atomicI64_swap_strict
  #define bupc_atomicL_swap_private  bupc_atomicI64_swap_private
  #define bupc_atomicUL_swap_relaxed  bupc_atomicU64_swap_relaxed
  #define bupc_atomicUL_swap_strict   bupc_atomicU64_swap_strict
  #define bupc_atomicUL_swap_private  bupc_atomicU64_swap_private
  #define bupc_atomicL_fetchnot_relaxed  bupc_atomicI64_fetchnot_relaxed
  #define bupc_atomicL_fetchnot_strict   bupc_atomicI64_fetchnot_strict
  #define bupc_atomicL_fetchnot_private  bupc_atomicI64_fetchnot_private
  #define bupc_atomicUL_fetchnot_relaxed  bupc_atomicU64_fetchnot_relaxed
  #define bupc_atomicUL_fetchnot_strict   bupc_atomicU64_fetchnot_strict
  #define bupc_atomicUL_fetchnot_private  bupc_atomicU64_fetchnot_private
  #define bupc_atomicL_cswap_relaxed  bupc_atomicI64_cswap_relaxed
  #define bupc_atomicL_cswap_strict   bupc_atomicI64_cswap_strict
  #define bupc_atomicL_cswap_private  bupc_atomicI64_cswap_private
  #define bupc_atomicUL_cswap_relaxed  bupc_atomicU64_cswap_relaxed
  #define bupc_atomicUL_cswap_strict   bupc_atomicU64_cswap_strict
  #define bupc_atomicUL_cswap_private  bupc_atomicU64_cswap_private
  #define bupc_atomicL_mswap_relaxed  bupc_atomicI64_mswap_relaxed
  #define bupc_atomicL_mswap_strict   bupc_atomicI64_mswap_strict
  #define bupc_atomicL_mswap_private  bupc_atomicI64_mswap_private
  #define bupc_atomicUL_mswap_relaxed  bupc_atomicU64_mswap_relaxed
  #define bupc_atomicUL_mswap_strict   bupc_atomicU64_mswap_strict
  #define bupc_atomicUL_mswap_private  bupc_atomicU64_mswap_private
#else
  #define bupc_atomicL_set_relaxed   ERROR__no_atomics_for_type_L
  #define bupc_atomicL_set_strict    ERROR__no_atomics_for_type_L
  #define bupc_atomicL_set_private   ERROR__no_atomics_for_type_L
  #define bupc_atomicUL_set_relaxed   ERROR__no_atomics_for_type_UL
  #define bupc_atomicUL_set_strict    ERROR__no_atomics_for_type_UL
  #define bupc_atomicUL_set_private   ERROR__no_atomics_for_type_UL
  #define bupc_atomicL_read_relaxed  ERROR__no_atomics_for_type_L
  #define bupc_atomicL_read_strict   ERROR__no_atomics_for_type_L
  #define bupc_atomicL_read_private  ERROR__no_atomics_for_type_L
  #define bupc_atomicUL_read_relaxed  ERROR__no_atomics_for_type_UL
  #define bupc_atomicUL_read_strict   ERROR__no_atomics_for_type_UL
  #define bupc_atomicUL_read_private  ERROR__no_atomics_for_type_UL
  #define bupc_atomicL_fetchadd_relaxed  ERROR__no_atomics_for_type_L
  #define bupc_atomicL_fetchadd_strict   ERROR__no_atomics_for_type_L
  #define bupc_atomicL_fetchadd_private  ERROR__no_atomics_for_type_L
  #define bupc_atomicUL_fetchadd_relaxed  ERROR__no_atomics_for_type_UL
  #define bupc_atomicUL_fetchadd_strict   ERROR__no_atomics_for_type_UL
  #define bupc_atomicUL_fetchadd_private  ERROR__no_atomics_for_type_UL
  #define bupc_atomicL_fetchand_relaxed  ERROR__no_atomics_for_type_L
  #define bupc_atomicL_fetchand_strict   ERROR__no_atomics_for_type_L
  #define bupc_atomicL_fetchand_private  ERROR__no_atomics_for_type_L
  #define bupc_atomicUL_fetchand_relaxed  ERROR__no_atomics_for_type_UL
  #define bupc_atomicUL_fetchand_strict   ERROR__no_atomics_for_type_UL
  #define bupc_atomicUL_fetchand_private  ERROR__no_atomics_for_type_UL
  #define bupc_atomicL_fetchor_relaxed  ERROR__no_atomics_for_type_L
  #define bupc_atomicL_fetchor_strict   ERROR__no_atomics_for_type_L
  #define bupc_atomicL_fetchor_private  ERROR__no_atomics_for_type_L
  #define bupc_atomicUL_fetchor_relaxed  ERROR__no_atomics_for_type_UL
  #define bupc_atomicUL_fetchor_strict   ERROR__no_atomics_for_type_UL
  #define bupc_atomicUL_fetchor_private  ERROR__no_atomics_for_type_UL
  #define bupc_atomicL_fetchxor_relaxed  ERROR__no_atomics_for_type_L
  #define bupc_atomicL_fetchxor_strict   ERROR__no_atomics_for_type_L
  #define bupc_atomicL_fetchxor_private  ERROR__no_atomics_for_type_L
  #define bupc_atomicUL_fetchxor_relaxed  ERROR__no_atomics_for_type_UL
  #define bupc_atomicUL_fetchxor_strict   ERROR__no_atomics_for_type_UL
  #define bupc_atomicUL_fetchxor_private  ERROR__no_atomics_for_type_UL
  #define bupc_atomicL_swap_relaxed  ERROR__no_atomics_for_type_L
  #define bupc_atomicL_swap_strict   ERROR__no_atomics_for_type_L
  #define bupc_atomicL_swap_private  ERROR__no_atomics_for_type_L
  #define bupc_atomicUL_swap_relaxed  ERROR__no_atomics_for_type_UL
  #define bupc_atomicUL_swap_strict   ERROR__no_atomics_for_type_UL
  #define bupc_atomicUL_swap_private  ERROR__no_atomics_for_type_UL
  #define bupc_atomicL_fetchnot_relaxed  ERROR__no_atomics_for_type_L
  #define bupc_atomicL_fetchnot_strict   ERROR__no_atomics_for_type_L
  #define bupc_atomicL_fetchnot_private  ERROR__no_atomics_for_type_L
  #define bupc_atomicUL_fetchnot_relaxed  ERROR__no_atomics_for_type_UL
  #define bupc_atomicUL_fetchnot_strict   ERROR__no_atomics_for_type_UL
  #define bupc_atomicUL_fetchnot_private  ERROR__no_atomics_for_type_UL
  #define bupc_atomicL_cswap_relaxed  ERROR__no_atomics_for_type_L
  #define bupc_atomicL_cswap_strict   ERROR__no_atomics_for_type_L
  #define bupc_atomicL_cswap_private  ERROR__no_atomics_for_type_L
  #define bupc_atomicUL_cswap_relaxed  ERROR__no_atomics_for_type_UL
  #define bupc_atomicUL_cswap_strict   ERROR__no_atomics_for_type_UL
  #define bupc_atomicUL_cswap_private  ERROR__no_atomics_for_type_UL
  #define bupc_atomicL_mswap_relaxed  ERROR__no_atomics_for_type_L
  #define bupc_atomicL_mswap_strict   ERROR__no_atomics_for_type_L
  #define bupc_atomicL_mswap_private  ERROR__no_atomics_for_type_L
  #define bupc_atomicUL_mswap_relaxed  ERROR__no_atomics_for_type_UL
  #define bupc_atomicUL_mswap_strict   ERROR__no_atomics_for_type_UL
  #define bupc_atomicUL_mswap_private  ERROR__no_atomics_for_type_UL
#endif

/* Optionally map bupc_atomic* extensions into upc_* namespace */
#ifdef BUPC_USE_UPC_NAMESPACE
  #define upc_atomicU64_set_relaxed   bupc_atomicU64_set_relaxed
  #define upc_atomicU64_set_strict    bupc_atomicU64_set_strict
  #define upc_atomicU64_set_private   bupc_atomicU64_set_private
  #define upc_atomicI64_set_relaxed   bupc_atomicI64_set_relaxed
  #define upc_atomicI64_set_strict    bupc_atomicI64_set_strict
  #define upc_atomicI64_set_private   bupc_atomicI64_set_private
  #define upc_atomicU32_set_relaxed   bupc_atomicU32_set_relaxed
  #define upc_atomicU32_set_strict    bupc_atomicU32_set_strict
  #define upc_atomicU32_set_private   bupc_atomicU32_set_private
  #define upc_atomicI32_set_relaxed   bupc_atomicI32_set_relaxed
  #define upc_atomicI32_set_strict    bupc_atomicI32_set_strict
  #define upc_atomicI32_set_private   bupc_atomicI32_set_private
  #define upc_atomicI_set_relaxed   bupc_atomicI_set_relaxed
  #define upc_atomicI_set_strict    bupc_atomicI_set_strict
  #define upc_atomicI_set_private   bupc_atomicI_set_private
  #define upc_atomicUI_set_relaxed   bupc_atomicUI_set_relaxed
  #define upc_atomicUI_set_strict    bupc_atomicUI_set_strict
  #define upc_atomicUI_set_private   bupc_atomicUI_set_private
  #define upc_atomicL_set_relaxed   bupc_atomicL_set_relaxed
  #define upc_atomicL_set_strict    bupc_atomicL_set_strict
  #define upc_atomicL_set_private   bupc_atomicL_set_private
  #define upc_atomicUL_set_relaxed   bupc_atomicUL_set_relaxed
  #define upc_atomicUL_set_strict    bupc_atomicUL_set_strict
  #define upc_atomicUL_set_private   bupc_atomicUL_set_private
  #define upc_atomicU64_read_relaxed  bupc_atomicU64_read_relaxed
  #define upc_atomicU64_read_strict   bupc_atomicU64_read_strict
  #define upc_atomicU64_read_private  bupc_atomicU64_read_private
  #define upc_atomicI64_read_relaxed  bupc_atomicI64_read_relaxed
  #define upc_atomicI64_read_strict   bupc_atomicI64_read_strict
  #define upc_atomicI64_read_private  bupc_atomicI64_read_private
  #define upc_atomicU32_read_relaxed  bupc_atomicU32_read_relaxed
  #define upc_atomicU32_read_strict   bupc_atomicU32_read_strict
  #define upc_atomicU32_read_private  bupc_atomicU32_read_private
  #define upc_atomicI32_read_relaxed  bupc_atomicI32_read_relaxed
  #define upc_atomicI32_read_strict   bupc_atomicI32_read_strict
  #define upc_atomicI32_read_private  bupc_atomicI32_read_private
  #define upc_atomicI_read_relaxed  bupc_atomicI_read_relaxed
  #define upc_atomicI_read_strict   bupc_atomicI_read_strict
  #define upc_atomicI_read_private  bupc_atomicI_read_private
  #define upc_atomicUI_read_relaxed  bupc_atomicUI_read_relaxed
  #define upc_atomicUI_read_strict   bupc_atomicUI_read_strict
  #define upc_atomicUI_read_private  bupc_atomicUI_read_private
  #define upc_atomicL_read_relaxed  bupc_atomicL_read_relaxed
  #define upc_atomicL_read_strict   bupc_atomicL_read_strict
  #define upc_atomicL_read_private  bupc_atomicL_read_private
  #define upc_atomicUL_read_relaxed  bupc_atomicUL_read_relaxed
  #define upc_atomicUL_read_strict   bupc_atomicUL_read_strict
  #define upc_atomicUL_read_private  bupc_atomicUL_read_private
  #define upc_atomicU64_fetchadd_relaxed  bupc_atomicU64_fetchadd_relaxed
  #define upc_atomicU64_fetchadd_strict   bupc_atomicU64_fetchadd_strict
  #define upc_atomicU64_fetchadd_private  bupc_atomicU64_fetchadd_private
  #define upc_atomicI64_fetchadd_relaxed  bupc_atomicI64_fetchadd_relaxed
  #define upc_atomicI64_fetchadd_strict   bupc_atomicI64_fetchadd_strict
  #define upc_atomicI64_fetchadd_private  bupc_atomicI64_fetchadd_private
  #define upc_atomicU32_fetchadd_relaxed  bupc_atomicU32_fetchadd_relaxed
  #define upc_atomicU32_fetchadd_strict   bupc_atomicU32_fetchadd_strict
  #define upc_atomicU32_fetchadd_private  bupc_atomicU32_fetchadd_private
  #define upc_atomicI32_fetchadd_relaxed  bupc_atomicI32_fetchadd_relaxed
  #define upc_atomicI32_fetchadd_strict   bupc_atomicI32_fetchadd_strict
  #define upc_atomicI32_fetchadd_private  bupc_atomicI32_fetchadd_private
  #define upc_atomicI_fetchadd_relaxed  bupc_atomicI_fetchadd_relaxed
  #define upc_atomicI_fetchadd_strict   bupc_atomicI_fetchadd_strict
  #define upc_atomicI_fetchadd_private  bupc_atomicI_fetchadd_private
  #define upc_atomicUI_fetchadd_relaxed  bupc_atomicUI_fetchadd_relaxed
  #define upc_atomicUI_fetchadd_strict   bupc_atomicUI_fetchadd_strict
  #define upc_atomicUI_fetchadd_private  bupc_atomicUI_fetchadd_private
  #define upc_atomicL_fetchadd_relaxed  bupc_atomicL_fetchadd_relaxed
  #define upc_atomicL_fetchadd_strict   bupc_atomicL_fetchadd_strict
  #define upc_atomicL_fetchadd_private  bupc_atomicL_fetchadd_private
  #define upc_atomicUL_fetchadd_relaxed  bupc_atomicUL_fetchadd_relaxed
  #define upc_atomicUL_fetchadd_strict   bupc_atomicUL_fetchadd_strict
  #define upc_atomicUL_fetchadd_private  bupc_atomicUL_fetchadd_private
  #define upc_atomicU64_fetchand_relaxed  bupc_atomicU64_fetchand_relaxed
  #define upc_atomicU64_fetchand_strict   bupc_atomicU64_fetchand_strict
  #define upc_atomicU64_fetchand_private  bupc_atomicU64_fetchand_private
  #define upc_atomicI64_fetchand_relaxed  bupc_atomicI64_fetchand_relaxed
  #define upc_atomicI64_fetchand_strict   bupc_atomicI64_fetchand_strict
  #define upc_atomicI64_fetchand_private  bupc_atomicI64_fetchand_private
  #define upc_atomicU32_fetchand_relaxed  bupc_atomicU32_fetchand_relaxed
  #define upc_atomicU32_fetchand_strict   bupc_atomicU32_fetchand_strict
  #define upc_atomicU32_fetchand_private  bupc_atomicU32_fetchand_private
  #define upc_atomicI32_fetchand_relaxed  bupc_atomicI32_fetchand_relaxed
  #define upc_atomicI32_fetchand_strict   bupc_atomicI32_fetchand_strict
  #define upc_atomicI32_fetchand_private  bupc_atomicI32_fetchand_private
  #define upc_atomicI_fetchand_relaxed  bupc_atomicI_fetchand_relaxed
  #define upc_atomicI_fetchand_strict   bupc_atomicI_fetchand_strict
  #define upc_atomicI_fetchand_private  bupc_atomicI_fetchand_private
  #define upc_atomicUI_fetchand_relaxed  bupc_atomicUI_fetchand_relaxed
  #define upc_atomicUI_fetchand_strict   bupc_atomicUI_fetchand_strict
  #define upc_atomicUI_fetchand_private  bupc_atomicUI_fetchand_private
  #define upc_atomicL_fetchand_relaxed  bupc_atomicL_fetchand_relaxed
  #define upc_atomicL_fetchand_strict   bupc_atomicL_fetchand_strict
  #define upc_atomicL_fetchand_private  bupc_atomicL_fetchand_private
  #define upc_atomicUL_fetchand_relaxed  bupc_atomicUL_fetchand_relaxed
  #define upc_atomicUL_fetchand_strict   bupc_atomicUL_fetchand_strict
  #define upc_atomicUL_fetchand_private  bupc_atomicUL_fetchand_private
  #define upc_atomicU64_fetchor_relaxed  bupc_atomicU64_fetchor_relaxed
  #define upc_atomicU64_fetchor_strict   bupc_atomicU64_fetchor_strict
  #define upc_atomicU64_fetchor_private  bupc_atomicU64_fetchor_private
  #define upc_atomicI64_fetchor_relaxed  bupc_atomicI64_fetchor_relaxed
  #define upc_atomicI64_fetchor_strict   bupc_atomicI64_fetchor_strict
  #define upc_atomicI64_fetchor_private  bupc_atomicI64_fetchor_private
  #define upc_atomicU32_fetchor_relaxed  bupc_atomicU32_fetchor_relaxed
  #define upc_atomicU32_fetchor_strict   bupc_atomicU32_fetchor_strict
  #define upc_atomicU32_fetchor_private  bupc_atomicU32_fetchor_private
  #define upc_atomicI32_fetchor_relaxed  bupc_atomicI32_fetchor_relaxed
  #define upc_atomicI32_fetchor_strict   bupc_atomicI32_fetchor_strict
  #define upc_atomicI32_fetchor_private  bupc_atomicI32_fetchor_private
  #define upc_atomicI_fetchor_relaxed  bupc_atomicI_fetchor_relaxed
  #define upc_atomicI_fetchor_strict   bupc_atomicI_fetchor_strict
  #define upc_atomicI_fetchor_private  bupc_atomicI_fetchor_private
  #define upc_atomicUI_fetchor_relaxed  bupc_atomicUI_fetchor_relaxed
  #define upc_atomicUI_fetchor_strict   bupc_atomicUI_fetchor_strict
  #define upc_atomicUI_fetchor_private  bupc_atomicUI_fetchor_private
  #define upc_atomicL_fetchor_relaxed  bupc_atomicL_fetchor_relaxed
  #define upc_atomicL_fetchor_strict   bupc_atomicL_fetchor_strict
  #define upc_atomicL_fetchor_private  bupc_atomicL_fetchor_private
  #define upc_atomicUL_fetchor_relaxed  bupc_atomicUL_fetchor_relaxed
  #define upc_atomicUL_fetchor_strict   bupc_atomicUL_fetchor_strict
  #define upc_atomicUL_fetchor_private  bupc_atomicUL_fetchor_private
  #define upc_atomicU64_fetchxor_relaxed  bupc_atomicU64_fetchxor_relaxed
  #define upc_atomicU64_fetchxor_strict   bupc_atomicU64_fetchxor_strict
  #define upc_atomicU64_fetchxor_private  bupc_atomicU64_fetchxor_private
  #define upc_atomicI64_fetchxor_relaxed  bupc_atomicI64_fetchxor_relaxed
  #define upc_atomicI64_fetchxor_strict   bupc_atomicI64_fetchxor_strict
  #define upc_atomicI64_fetchxor_private  bupc_atomicI64_fetchxor_private
  #define upc_atomicU32_fetchxor_relaxed  bupc_atomicU32_fetchxor_relaxed
  #define upc_atomicU32_fetchxor_strict   bupc_atomicU32_fetchxor_strict
  #define upc_atomicU32_fetchxor_private  bupc_atomicU32_fetchxor_private
  #define upc_atomicI32_fetchxor_relaxed  bupc_atomicI32_fetchxor_relaxed
  #define upc_atomicI32_fetchxor_strict   bupc_atomicI32_fetchxor_strict
  #define upc_atomicI32_fetchxor_private  bupc_atomicI32_fetchxor_private
  #define upc_atomicI_fetchxor_relaxed  bupc_atomicI_fetchxor_relaxed
  #define upc_atomicI_fetchxor_strict   bupc_atomicI_fetchxor_strict
  #define upc_atomicI_fetchxor_private  bupc_atomicI_fetchxor_private
  #define upc_atomicUI_fetchxor_relaxed  bupc_atomicUI_fetchxor_relaxed
  #define upc_atomicUI_fetchxor_strict   bupc_atomicUI_fetchxor_strict
  #define upc_atomicUI_fetchxor_private  bupc_atomicUI_fetchxor_private
  #define upc_atomicL_fetchxor_relaxed  bupc_atomicL_fetchxor_relaxed
  #define upc_atomicL_fetchxor_strict   bupc_atomicL_fetchxor_strict
  #define upc_atomicL_fetchxor_private  bupc_atomicL_fetchxor_private
  #define upc_atomicUL_fetchxor_relaxed  bupc_atomicUL_fetchxor_relaxed
  #define upc_atomicUL_fetchxor_strict   bupc_atomicUL_fetchxor_strict
  #define upc_atomicUL_fetchxor_private  bupc_atomicUL_fetchxor_private
  #define upc_atomicU64_swap_relaxed  bupc_atomicU64_swap_relaxed
  #define upc_atomicU64_swap_strict   bupc_atomicU64_swap_strict
  #define upc_atomicU64_swap_private  bupc_atomicU64_swap_private
  #define upc_atomicI64_swap_relaxed  bupc_atomicI64_swap_relaxed
  #define upc_atomicI64_swap_strict   bupc_atomicI64_swap_strict
  #define upc_atomicI64_swap_private  bupc_atomicI64_swap_private
  #define upc_atomicU32_swap_relaxed  bupc_atomicU32_swap_relaxed
  #define upc_atomicU32_swap_strict   bupc_atomicU32_swap_strict
  #define upc_atomicU32_swap_private  bupc_atomicU32_swap_private
  #define upc_atomicI32_swap_relaxed  bupc_atomicI32_swap_relaxed
  #define upc_atomicI32_swap_strict   bupc_atomicI32_swap_strict
  #define upc_atomicI32_swap_private  bupc_atomicI32_swap_private
  #define upc_atomicI_swap_relaxed  bupc_atomicI_swap_relaxed
  #define upc_atomicI_swap_strict   bupc_atomicI_swap_strict
  #define upc_atomicI_swap_private  bupc_atomicI_swap_private
  #define upc_atomicUI_swap_relaxed  bupc_atomicUI_swap_relaxed
  #define upc_atomicUI_swap_strict   bupc_atomicUI_swap_strict
  #define upc_atomicUI_swap_private  bupc_atomicUI_swap_private
  #define upc_atomicL_swap_relaxed  bupc_atomicL_swap_relaxed
  #define upc_atomicL_swap_strict   bupc_atomicL_swap_strict
  #define upc_atomicL_swap_private  bupc_atomicL_swap_private
  #define upc_atomicUL_swap_relaxed  bupc_atomicUL_swap_relaxed
  #define upc_atomicUL_swap_strict   bupc_atomicUL_swap_strict
  #define upc_atomicUL_swap_private  bupc_atomicUL_swap_private
  #define upc_atomicU64_fetchnot_relaxed  bupc_atomicU64_fetchnot_relaxed
  #define upc_atomicU64_fetchnot_strict   bupc_atomicU64_fetchnot_strict
  #define upc_atomicU64_fetchnot_private  bupc_atomicU64_fetchnot_private
  #define upc_atomicI64_fetchnot_relaxed  bupc_atomicI64_fetchnot_relaxed
  #define upc_atomicI64_fetchnot_strict   bupc_atomicI64_fetchnot_strict
  #define upc_atomicI64_fetchnot_private  bupc_atomicI64_fetchnot_private
  #define upc_atomicU32_fetchnot_relaxed  bupc_atomicU32_fetchnot_relaxed
  #define upc_atomicU32_fetchnot_strict   bupc_atomicU32_fetchnot_strict
  #define upc_atomicU32_fetchnot_private  bupc_atomicU32_fetchnot_private
  #define upc_atomicI32_fetchnot_relaxed  bupc_atomicI32_fetchnot_relaxed
  #define upc_atomicI32_fetchnot_strict   bupc_atomicI32_fetchnot_strict
  #define upc_atomicI32_fetchnot_private  bupc_atomicI32_fetchnot_private
  #define upc_atomicI_fetchnot_relaxed  bupc_atomicI_fetchnot_relaxed
  #define upc_atomicI_fetchnot_strict   bupc_atomicI_fetchnot_strict
  #define upc_atomicI_fetchnot_private  bupc_atomicI_fetchnot_private
  #define upc_atomicUI_fetchnot_relaxed  bupc_atomicUI_fetchnot_relaxed
  #define upc_atomicUI_fetchnot_strict   bupc_atomicUI_fetchnot_strict
  #define upc_atomicUI_fetchnot_private  bupc_atomicUI_fetchnot_private
  #define upc_atomicL_fetchnot_relaxed  bupc_atomicL_fetchnot_relaxed
  #define upc_atomicL_fetchnot_strict   bupc_atomicL_fetchnot_strict
  #define upc_atomicL_fetchnot_private  bupc_atomicL_fetchnot_private
  #define upc_atomicUL_fetchnot_relaxed  bupc_atomicUL_fetchnot_relaxed
  #define upc_atomicUL_fetchnot_strict   bupc_atomicUL_fetchnot_strict
  #define upc_atomicUL_fetchnot_private  bupc_atomicUL_fetchnot_private
  #define upc_atomicU64_cswap_relaxed  bupc_atomicU64_cswap_relaxed
  #define upc_atomicU64_cswap_strict   bupc_atomicU64_cswap_strict
  #define upc_atomicU64_cswap_private  bupc_atomicU64_cswap_private
  #define upc_atomicI64_cswap_relaxed  bupc_atomicI64_cswap_relaxed
  #define upc_atomicI64_cswap_strict   bupc_atomicI64_cswap_strict
  #define upc_atomicI64_cswap_private  bupc_atomicI64_cswap_private
  #define upc_atomicU32_cswap_relaxed  bupc_atomicU32_cswap_relaxed
  #define upc_atomicU32_cswap_strict   bupc_atomicU32_cswap_strict
  #define upc_atomicU32_cswap_private  bupc_atomicU32_cswap_private
  #define upc_atomicI32_cswap_relaxed  bupc_atomicI32_cswap_relaxed
  #define upc_atomicI32_cswap_strict   bupc_atomicI32_cswap_strict
  #define upc_atomicI32_cswap_private  bupc_atomicI32_cswap_private
  #define upc_atomicI_cswap_relaxed  bupc_atomicI_cswap_relaxed
  #define upc_atomicI_cswap_strict   bupc_atomicI_cswap_strict
  #define upc_atomicI_cswap_private  bupc_atomicI_cswap_private
  #define upc_atomicUI_cswap_relaxed  bupc_atomicUI_cswap_relaxed
  #define upc_atomicUI_cswap_strict   bupc_atomicUI_cswap_strict
  #define upc_atomicUI_cswap_private  bupc_atomicUI_cswap_private
  #define upc_atomicL_cswap_relaxed  bupc_atomicL_cswap_relaxed
  #define upc_atomicL_cswap_strict   bupc_atomicL_cswap_strict
  #define upc_atomicL_cswap_private  bupc_atomicL_cswap_private
  #define upc_atomicUL_cswap_relaxed  bupc_atomicUL_cswap_relaxed
  #define upc_atomicUL_cswap_strict   bupc_atomicUL_cswap_strict
  #define upc_atomicUL_cswap_private  bupc_atomicUL_cswap_private
  #define upc_atomicU64_mswap_relaxed  bupc_atomicU64_mswap_relaxed
  #define upc_atomicU64_mswap_strict   bupc_atomicU64_mswap_strict
  #define upc_atomicU64_mswap_private  bupc_atomicU64_mswap_private
  #define upc_atomicI64_mswap_relaxed  bupc_atomicI64_mswap_relaxed
  #define upc_atomicI64_mswap_strict   bupc_atomicI64_mswap_strict
  #define upc_atomicI64_mswap_private  bupc_atomicI64_mswap_private
  #define upc_atomicU32_mswap_relaxed  bupc_atomicU32_mswap_relaxed
  #define upc_atomicU32_mswap_strict   bupc_atomicU32_mswap_strict
  #define upc_atomicU32_mswap_private  bupc_atomicU32_mswap_private
  #define upc_atomicI32_mswap_relaxed  bupc_atomicI32_mswap_relaxed
  #define upc_atomicI32_mswap_strict   bupc_atomicI32_mswap_strict
  #define upc_atomicI32_mswap_private  bupc_atomicI32_mswap_private
  #define upc_atomicI_mswap_relaxed  bupc_atomicI_mswap_relaxed
  #define upc_atomicI_mswap_strict   bupc_atomicI_mswap_strict
  #define upc_atomicI_mswap_private  bupc_atomicI_mswap_private
  #define upc_atomicUI_mswap_relaxed  bupc_atomicUI_mswap_relaxed
  #define upc_atomicUI_mswap_strict   bupc_atomicUI_mswap_strict
  #define upc_atomicUI_mswap_private  bupc_atomicUI_mswap_private
  #define upc_atomicL_mswap_relaxed  bupc_atomicL_mswap_relaxed
  #define upc_atomicL_mswap_strict   bupc_atomicL_mswap_strict
  #define upc_atomicL_mswap_private  bupc_atomicL_mswap_private
  #define upc_atomicUL_mswap_relaxed  bupc_atomicUL_mswap_relaxed
  #define upc_atomicUL_mswap_strict   bupc_atomicUL_mswap_strict
  #define upc_atomicUL_mswap_private  bupc_atomicUL_mswap_private
#endif

#endif /* first/only preprocess */
#endif /* _BUPC_ATOMIC_EXTENSIONS_H_ */
