#include <upc_relaxed.h>
#include <stdio.h>
#define TOTALSIZE 16

//==> declare the x, x_new and b arrays in the shared space with size of TOTALSIZE*THREADS and with blocking size of TOTALSIZE
shared [...] double x[...];
shared [...] double x_new[...];
shared [...] double b[...];

void init();

int main()
{
	int  j;

	init();

	//==> insert a upc_forall statement to do work sharing with respecting the affinity of the x_new array
	upc_forall( j=...; j<(...)-1; j++; ...)
	{
		x_new[j] = 0.5*( x[(j-1)]+x[(j+1)]+b[j] );
	}

	if( MYTHREAD == 0)
	{
		for( j=0; j<(TOTALSIZE*THREADS); j++ )
			printf("%f\n", x_new[j]);
	}

	return 0;
}

void init()
{
	int i;

	if( MYTHREAD == 0 )
	{
		b[1] = 1.0; b[(TOTALSIZE*THREADS)-2] = 1.0;
	}
	upc_barrier;
}
