/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.var;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryFocus;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.ann.Annotation;
import org.basex.query.expr.Expr;
import org.basex.query.func.fn.FnError;
import org.basex.query.scope.StaticDecl;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.util.list.AnnList;
import org.basex.query.value.Value;
import org.basex.query.var.Var;
import org.basex.query.var.VarScope;
import org.basex.util.Strings;
import org.basex.util.Token;

public final class StaticVar
extends StaticDecl {
    public final boolean external;
    private final boolean lazy;

    StaticVar(Var var, Expr expr, AnnList anns, boolean external, VarScope vs, String doc) {
        super(var.name, var.declType, anns, vs, var.info, doc);
        this.expr = expr;
        this.external = external;
        this.lazy = anns.contains(Annotation._BASEX_LAZY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Expr compile(CompileContext cc) throws QueryException {
        block12: {
            if (this.expr == null) {
                throw QueryError.VAREMPTY_X.get(this.info, this.name());
            }
            if (!this.compiled) {
                this.dontEnter = true;
                this.compiled = true;
                QueryFocus focus = StaticVar.pushFocus(cc.qc);
                cc.pushScope(this.vs);
                try {
                    this.expr = this.expr.compile(cc);
                }
                catch (QueryException ex) {
                    if (!this.lazy) {
                        throw ex.notCatchable();
                    }
                    this.expr = FnError.get(ex, this.expr);
                }
                finally {
                    cc.removeScope(this);
                    cc.qc.focus = focus;
                    this.dontEnter = false;
                }
                if (this.expr instanceof Value || cc.dynamic && !this.lazy) {
                    try {
                        cc.replaceWith(this.expr, this.value(cc.qc));
                    }
                    catch (QueryException ex) {
                        if (ex.error() == QueryError.NOCTX_X) break block12;
                        throw ex;
                    }
                }
            }
        }
        return null;
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        if (this.dontEnter) {
            throw QueryError.CIRCVAR_X.get(this.info, this.name());
        }
        if (!this.lazy && this.expr == null) {
            throw QueryError.VAREMPTY_X.get(this.info, this.name());
        }
        if (this.value == null) {
            this.dontEnter = true;
            QueryFocus focus = StaticVar.pushFocus(qc);
            try {
                super.value(qc);
            }
            catch (QueryException ex) {
                if (this.lazy) {
                    ex.notCatchable();
                }
                throw ex;
            }
            finally {
                qc.focus = focus;
                this.dontEnter = false;
            }
        }
        return this.value;
    }

    void checkUp() throws QueryException {
        if (this.expr != null && this.expr.has(Flag.UPD)) {
            throw QueryError.UPNOT_X.get(this.info, this.description());
        }
    }

    void bind(Value val, QueryContext qc, boolean cast) throws QueryException {
        if (this.external && !this.compiled) {
            this.value = this.declType == null || this.declType.instance(val) ? val : (cast ? this.declType.cast(val, true, qc, this.info) : this.declType.coerce(val, this.name, qc, null, this.info));
            this.expr = this.value;
        }
    }

    @Override
    public boolean visit(ASTVisitor visitor) {
        return this.expr == null || this.expr.accept(visitor);
    }

    public String name() {
        return Strings.concat(Token.cpToken(36), this.name.string());
    }

    boolean has(Flag ... flags) {
        if (this.dontEnter || this.expr == null) {
            return false;
        }
        this.dontEnter = true;
        boolean has = this.expr.has(flags);
        this.dontEnter = false;
        return has;
    }

    private static QueryFocus pushFocus(QueryContext qc) {
        QueryFocus focus = qc.focus;
        QueryFocus qf = new QueryFocus();
        qf.value = qc.finalContext ? qc.contextValue.value : null;
        qc.focus = qf;
        return focus;
    }

    @Override
    public String description() {
        return "variable declaration";
    }

    @Override
    public void toXml(QueryPlan plan) {
        plan.add(plan.create(this, "name", this.name.string()), this.expr);
    }

    @Override
    public void toString(QueryString qs) {
        qs.token("declare").token(this.anns).token("variable").token(this.name());
        if (this.declType != null) {
            qs.token("as").token(this.declType);
        }
        if (this.external) {
            qs.token("external");
        }
        if (this.expr != null) {
            qs.token(":=").token(this.expr);
        }
        qs.token(';');
    }
}

