/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.db;

import java.io.IOException;
import java.util.Date;
import org.basex.core.Context;
import org.basex.core.users.Perm;
import org.basex.data.Data;
import org.basex.data.MetaData;
import org.basex.index.resource.ResourceType;
import org.basex.io.IOFile;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.func.db.DbAccessFn;
import org.basex.query.func.db.DbList;
import org.basex.query.iter.BasicIter;
import org.basex.query.iter.Iter;
import org.basex.query.value.Value;
import org.basex.query.value.node.FBuilder;
import org.basex.query.value.node.FElem;
import org.basex.query.value.node.FNode;
import org.basex.util.DateTime;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.list.IntList;
import org.basex.util.list.StringList;

public final class DbListDetails
extends DbList {
    @Override
    public Iter iter(QueryContext qc) throws QueryException {
        return this.defined(0) ? this.resources(qc) : DbListDetails.list(qc);
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        return this.iter(qc).value(qc, this);
    }

    private static Iter list(final QueryContext qc) {
        final Context ctx = qc.context;
        final StringList dbs = ctx.databases.list(qc.user, null);
        return new BasicIter<FNode>((long)dbs.size()){

            @Override
            public FNode get(long i) {
                String name = (String)dbs.get((int)i);
                FBuilder database = FElem.build(DbAccessFn.Q_DATABASE);
                MetaData meta = new MetaData(name, ctx.options, ctx.soptions);
                try {
                    meta.read();
                    int binaries = meta.dir(ResourceType.BINARY).descendants().size();
                    int values = meta.dir(ResourceType.VALUE).descendants().size();
                    database.add(DbAccessFn.Q_RESOURCES, meta.ndocs + binaries + values);
                    database.add(DbAccessFn.Q_MODIFIED_DATE, DateTime.format(new Date(meta.dbTime())));
                    database.add(DbAccessFn.Q_SIZE, meta.dbSize());
                    if (qc.user.has(Perm.CREATE, name)) {
                        database.add(DbAccessFn.Q_PATH, meta.original);
                    }
                }
                catch (IOException ex) {
                    Util.debug(ex);
                }
                return database.add(name).finish();
            }
        };
    }

    private Iter resources(QueryContext qc) throws QueryException {
        final Data data = this.toData(qc);
        String path = this.defined(1) ? this.toString(this.arg(1), qc) : "";
        final IntList docs = data.resources.docs(path);
        final StringList binaries = data.resources.paths(path, ResourceType.BINARY);
        final StringList values = data.resources.paths(path, ResourceType.VALUE);
        final int ds = docs.size();
        final int bs = ds + binaries.size();
        int size = bs + values.size();
        return new BasicIter<FNode>((long)size){

            @Override
            public FNode get(long i) {
                long sz;
                long mdate;
                String pt;
                ResourceType type;
                if (i >= this.size) {
                    return null;
                }
                if (i < (long)ds) {
                    int pre = docs.get((int)i);
                    type = ResourceType.XML;
                    pt = Token.string(data.text(pre, true));
                    mdate = data.meta.time;
                    sz = data.size(pre, 0);
                } else {
                    type = i >= (long)bs ? ResourceType.VALUE : ResourceType.BINARY;
                    pt = type == ResourceType.VALUE ? (String)values.get((int)i - bs) : (String)binaries.get((int)i - ds);
                    IOFile bin = type.filePath(data.meta.dir(type), pt);
                    mdate = bin.timeStamp();
                    sz = bin.length();
                }
                return DbList.resource(pt, mdate, sz, type);
            }
        };
    }
}

