/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import org.basex.query.value.Value;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.Itr;

public final class HofArgs {
    private final Value[] args;
    private final int posParam;
    private int pos;

    public HofArgs(int arity) {
        this.args = new Value[arity];
        this.posParam = -1;
    }

    public HofArgs(int arity, FItem ... items) {
        Boolean p = null;
        for (FItem item : items) {
            if (item == null) continue;
            if (item.arity() == arity) {
                p = Boolean.TRUE;
                continue;
            }
            if (p != null) continue;
            p = Boolean.FALSE;
        }
        this.args = new Value[p == Boolean.FALSE ? arity - 1 : arity];
        this.posParam = p == Boolean.FALSE ? -1 : arity - 1;
    }

    public HofArgs(Value ... args) {
        this.args = args;
        this.posParam = -1;
    }

    public Value[] get() {
        return this.args;
    }

    public Value get(int index) {
        return this.args[index];
    }

    public HofArgs set(int index, Value value) {
        this.args[index] = value;
        return this;
    }

    public int pos() {
        return this.pos;
    }

    public HofArgs inc() {
        int pp = this.posParam;
        int p = this.pos + 1;
        if (pp != -1) {
            this.set(pp, Itr.get(p));
        }
        this.pos = p;
        return this;
    }
}

