/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view.map;

import org.basex.gui.view.ViewRect;
import org.basex.query.util.ft.FTPos;

final class MapRect
extends ViewRect
implements Comparable<MapRect> {
    boolean thumb;
    FTPos pos;
    byte thumbal;
    byte thumbfh;
    byte thumblh;
    double thumbf;
    double thumbsw;

    MapRect(int xx, int yy, int ww, int hh) {
        super(xx, yy, ww, hh);
    }

    MapRect(int xx, int yy, int ww, int hh, int p, int l) {
        this(xx, yy, ww, hh);
        this.pre = p;
        this.level = l;
    }

    MapRect(ViewRect r, int p) {
        this(r.x, r.y, r.w, r.h, p, r.level);
    }

    boolean contains(MapRect r) {
        return r.x >= this.x && r.y >= this.y && r.x + r.w <= this.x + this.w && r.y + r.h <= this.y + this.h;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof MapRect)) return false;
        MapRect rect = (MapRect)obj;
        if (rect.pre != this.pre) return false;
        return true;
    }

    @Override
    public int compareTo(MapRect r) {
        return this.pre - r.pre;
    }

    public int hashCode() {
        return this.pre;
    }
}

