/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import org.basex.core.Context;
import org.basex.core.Databases;
import org.basex.core.Text;
import org.basex.data.MetaData;
import org.basex.gui.GUIConstants;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXTextField;
import org.basex.util.Util;
import org.basex.util.list.StringList;

final class DialogInput
extends BaseXDialog {
    private final BaseXTextField input;
    private final BaseXBack buttons;
    private final BaseXLabel info;
    private final StringList databases;
    private final Action action;

    DialogInput(String old, BaseXDialog dialog, Action action) {
        super(dialog, action.title);
        this.action = action;
        Context ctx = dialog.gui().context;
        this.databases = ctx.databases.list();
        this.set(new BaseXLabel(action.label + ":", false, true).border(0, 0, 6, 0), "North");
        this.input = new BaseXTextField(this, old);
        this.info = new BaseXLabel(" ");
        BaseXBack p = new BaseXBack(new BorderLayout(0, 8));
        p.add((Component)this.input, "North");
        p.add((Component)this.info, "Center");
        this.set(p, "Center");
        this.buttons = this.newButtons(Text.B_OK, Text.B_CANCEL);
        this.set(this.buttons, "South");
        this.action(null);
        this.finish();
    }

    String input() {
        return this.input.getText().trim();
    }

    @Override
    public void action(Object cmp) {
        String in = this.input();
        String inf = null;
        GUIConstants.Msg icon = GUIConstants.Msg.ERROR;
        if (this.action == Action.RENAME_DOCUMENT) {
            boolean bl = this.ok = !in.isEmpty() && MetaData.normPath(in) != null;
            if (!this.ok) {
                inf = Util.info(Text.INVALID_X, Text.PATH);
            }
        } else if (this.action == Action.CREATE_BACKUP) {
            this.ok = true;
        } else {
            this.ok = Databases.validName(in);
            if (!this.ok) {
                inf = Util.info(Text.INVALID_X, Text.NAME);
            } else if (this.databases.contains(in)) {
                inf = Util.info(Text.DB_EXISTS_X, in);
                icon = GUIConstants.Msg.WARN;
            }
        }
        this.info.setText(inf, icon);
        DialogInput.enableOK(this.buttons, Text.B_OK, this.ok);
    }

    @Override
    public void close() {
        if (this.ok) {
            super.close();
        }
    }

    static enum Action {
        RENAME_DOCUMENT(Text.RENAME, Text.TARGET_PATH),
        ALTER_DATABASE(Text.RENAME_DB, Text.NAME_OF_DB),
        COPY_DATABASE(Text.COPY_DB, Text.NAME_OF_DB_COPY),
        CREATE_BACKUP(Text.COMMENT, Text.COMMENT);

        final String title;
        final String label;

        private Action(String title, String label) {
            this.title = title;
            this.label = label;
        }
    }
}

