/*
 * Decompiled with CFR 0.152.
 */
package de.bottlecaps.markup.blitz.transform;

import de.bottlecaps.markup.blitz.codepoints.Codepoint;
import de.bottlecaps.markup.blitz.codepoints.RangeSet;
import de.bottlecaps.markup.blitz.grammar.Alt;
import de.bottlecaps.markup.blitz.grammar.Alts;
import de.bottlecaps.markup.blitz.grammar.Charset;
import de.bottlecaps.markup.blitz.grammar.Control;
import de.bottlecaps.markup.blitz.grammar.Grammar;
import de.bottlecaps.markup.blitz.grammar.Insertion;
import de.bottlecaps.markup.blitz.grammar.Node;
import de.bottlecaps.markup.blitz.grammar.Occurrence;
import de.bottlecaps.markup.blitz.grammar.Rule;
import de.bottlecaps.markup.blitz.grammar.Term;
import de.bottlecaps.markup.blitz.transform.Visitor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class GenerateAdditionalNames
extends Visitor {
    private static final Pattern nameCharPattern = Pattern.compile("^([-_.\u00b7\u203f\u2040]|\\p{L}|\\p{Nd}|\\p{Mn})$");
    private final Grammar grammar;
    private final Set<String> names;
    private final Map<Alts, String> nameByRhs;
    private final String additionalNamePrefix;
    private final Map<RangeSet, String> smallestContext;

    public GenerateAdditionalNames(Grammar grammar) {
        String prefix;
        this.grammar = grammar;
        this.nameByRhs = new HashMap<Alts, String>();
        this.names = new HashSet<String>(grammar.getRules().keySet());
        grammar.getRules().values().forEach(rule -> this.nameByRhs.put(rule.getAlts(), rule.getName()));
        StringBuilder sb = new StringBuilder();
        while (true) {
            prefix = sb.toString();
            if (this.names.stream().allMatch(name -> !name.startsWith(prefix))) break;
            sb.append("_");
        }
        this.additionalNamePrefix = prefix;
        this.addAdditionalNames(Charset.END, this.additionalNamePrefix + "end");
        this.addAdditionalNames(Term.START, this.additionalNamePrefix + "start");
        CharsetOrigin charsetOrigin = new CharsetOrigin();
        charsetOrigin.visit(grammar);
        this.smallestContext = charsetOrigin.smallestContext;
    }

    @Override
    public void visit(Alts a) {
        super.visit(a);
        if (!(a.getParent() instanceof Rule) && a.getAlts().size() > 1) {
            this.addAdditionalNames(a, this.getAdditionalName(a.getRule().getName(), a, "choice"));
        }
    }

    private void addAdditionalNames(Term t, String ... names) {
        this.grammar.getAdditionalNames().putIfAbsent(t, names);
    }

    @Override
    public void visit(Charset c) {
        if (this.needsProposalForName(c)) {
            String suffix = c.isDeleted() ? "deleted_chars" : "preserved_chars";
            String origin = this.smallestContext.get(c.getRangeSet());
            if (origin == null) {
                origin = c.getRule().getName();
            }
            String additionalName = this.getAdditionalName(origin, c, suffix);
            this.addAdditionalNames(c, additionalName);
        }
    }

    @Override
    public void visit(Insertion i) {
        String additionalName = this.getAdditionalName(i.getRule().getName(), i, "insertion");
        this.addAdditionalNames(i, additionalName);
    }

    @Override
    public void visit(Control c) {
        super.visit(c);
        switch (c.getOccurrence()) {
            case ONE_OR_MORE: {
                this.addAdditionalNames(c, this.getAdditionalName(c.getRule().getName(), c, "list"));
                break;
            }
            case ZERO_OR_MORE: {
                String name0 = this.getAdditionalName(c.getRule().getName(), c, "list_option");
                if (c.getSeparator() != null) {
                    Control list = new Control(Occurrence.ONE_OR_MORE, c.getTerm(), c.getSeparator());
                    String name1 = this.getAdditionalName(c.getRule().getName(), list, "list");
                    this.addAdditionalNames(c, name0, name1);
                    break;
                }
                this.addAdditionalNames(c, name0);
                break;
            }
            case ZERO_OR_ONE: {
                this.addAdditionalNames(c, this.getAdditionalName(c.getRule().getName(), c, "option"));
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    public String getAdditionalName(String proposal, Term term, String suffix) {
        Alts alts;
        if (term instanceof Alts) {
            alts = (Alts)term;
        } else {
            Alt alt = new Alt();
            alt.getTerms().add(term);
            alts = new Alts();
            alts.addAlt(alt);
            term = alts;
        }
        String name = this.nameByRhs.get(alts);
        if (name == null) {
            name = this.getAdditionalName(proposal, suffix);
            this.nameByRhs.put(alts, name);
        }
        return name;
    }

    public String getAdditionalName(String proposal, String suffix) {
        StringBuilder sb = new StringBuilder();
        char last = '_';
        char[] cArray = proposal.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character chr = Character.valueOf(cArray[i]);
            if (chr.charValue() == '-' || !nameCharPattern.matcher(String.valueOf(chr)).matches()) {
                chr = Character.valueOf('_');
            }
            if (chr.charValue() == '_' && last == '_') continue;
            last = chr.charValue();
            sb.append(last);
        }
        if (sb.length() != 0 && sb.charAt(sb.length() - 1) != '_') {
            sb.append("_");
        }
        sb.append(suffix);
        int i = 0;
        while (true) {
            String name;
            if (!this.names.contains(name = this.additionalNamePrefix + sb.toString() + (String)(i == 0 && sb.length() > 0 ? "" : "_" + i))) {
                this.names.add(name);
                return name;
            }
            ++i;
        }
    }

    private boolean needsProposalForName(Charset c) {
        if (this.grammar.getAdditionalNames().containsKey(c)) {
            return false;
        }
        RangeSet rangeSet = c.getRangeSet();
        return !rangeSet.isSingleton() || !Codepoint.isAscii(rangeSet.iterator().next().getFirstCodepoint());
    }

    private class CharsetOrigin
    extends Visitor {
        Map<RangeSet, String> smallestContext = new HashMap<RangeSet, String>();
        Map<RangeSet, Integer> smallestContextSize = new HashMap<RangeSet, Integer>();

        private CharsetOrigin() {
        }

        @Override
        public void visit(Charset c) {
            if (GenerateAdditionalNames.this.needsProposalForName(c)) {
                Integer minContextSize;
                int contextSize;
                if (GenerateAdditionalNames.this.grammar.getAdditionalNames().containsKey(c)) {
                    return;
                }
                RangeSet rangeSet = c.getRangeSet();
                if (rangeSet.isSingleton() && Codepoint.isAscii(rangeSet.iterator().next().getFirstCodepoint())) {
                    return;
                }
                Node parent = c.getParent();
                Alts alts = null;
                if (parent instanceof Alt && ((Alt)parent).getTerms().size() == 1) {
                    contextSize = 0;
                    alts = (Alts)parent.getParent();
                    for (Alt a : alts.getAlts()) {
                        if (a.getTerms().size() != 1 || !(a.getTerms().get(0) instanceof Charset)) continue;
                        contextSize += ((Charset)a.getTerms().get(0)).getRangeSet().charCount();
                    }
                } else {
                    contextSize = rangeSet.charCount();
                }
                if ((minContextSize = this.smallestContextSize.get(rangeSet)) == null || minContextSize > contextSize) {
                    String name = GenerateAdditionalNames.this.grammar.getAdditionalNames().containsKey(alts) ? GenerateAdditionalNames.this.grammar.getAdditionalNames().get(alts)[0] : c.getRule().getName();
                    this.smallestContext.put(rangeSet, name);
                    this.smallestContextSize.put(rangeSet, contextSize);
                }
            }
        }
    }
}

