/*
 * Decompiled with CFR 0.152.
 */
package de.bottlecaps.markup.blitz.transform;

import de.bottlecaps.markup.blitz.transform.TileIterator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.TreeMap;
import java.util.function.Function;

public class CompressedMap {
    private int[] data;
    private int[] shift;

    public int[] data() {
        return this.data;
    }

    public int[] shift() {
        return this.shift;
    }

    public CompressedMap(Function<Integer, TileIterator> iteratorSupplier, int maxDepth) {
        this(iteratorSupplier, maxDepth, false);
    }

    private CompressedMap(Function<Integer, TileIterator> iteratorSupplier, int maxDepth, boolean isNested) {
        int[] bestShift = null;
        int[] bestTiles = null;
        int tileIndexBits = 2;
        while (true) {
            this.create(iteratorSupplier.apply(tileIndexBits), maxDepth, isNested);
            if (bestTiles != null && bestTiles.length <= this.data.length) break;
            bestTiles = this.data;
            bestShift = this.shift;
            ++tileIndexBits;
        }
        this.data = bestTiles;
        this.shift = bestShift;
    }

    private void create(TileIterator it, int maxDepth, boolean isNested) {
        Function<Integer, TileIterator> indexIterator;
        CompressedMap nestedMap;
        int count;
        int numberOfTiles;
        int tileSize = it.tileSize();
        int end = numberOfTiles = it.numberOfTiles();
        int idOffset = 0;
        this.data = new int[end + tileSize + 1];
        Comparator indexComparator = (lhs, rhs) -> Arrays.compare(this.data, (int)lhs, lhs + tileSize, this.data, (int)rhs, rhs + tileSize);
        TreeMap<Integer, Integer> distinctTiles = new TreeMap<Integer, Integer>(indexComparator);
        while ((count = it.next(this.data, end)) != 0) {
            Integer id = distinctTiles.putIfAbsent(end, end);
            if (id == null) {
                id = end;
                if ((end += tileSize) + tileSize > this.data.length) {
                    this.data = Arrays.copyOf(this.data, this.data.length << 1);
                }
            }
            for (int i = 0; i < count; ++i) {
                this.data[idOffset++] = id;
            }
        }
        distinctTiles = null;
        int distinctTileSize = end - numberOfTiles;
        this.shift = new int[]{it.tileIndexBits()};
        if (maxDepth > 1 && (nestedMap = new CompressedMap(indexIterator = bits -> TileIterator.of(this.data, numberOfTiles, (int)bits, 0), maxDepth - 1, true)).data().length <= numberOfTiles >> 1) {
            this.shift = Arrays.copyOf(this.shift, nestedMap.shift().length + 1);
            System.arraycopy(nestedMap.shift(), 0, this.shift, 1, nestedMap.shift().length);
            System.arraycopy(nestedMap.data(), 0, this.data, 0, nestedMap.data().length);
            System.arraycopy(this.data, numberOfTiles, this.data, nestedMap.data().length, distinctTileSize);
            end = nestedMap.data().length + distinctTileSize;
        }
        if (isNested) {
            int displacement = end - it.end();
            int i = end - distinctTileSize;
            while (i < end) {
                int n = i++;
                this.data[n] = this.data[n] + displacement;
            }
        }
        this.data = Arrays.copyOf(this.data, end);
    }

    public int get(int i0) {
        switch (this.shift.length) {
            case 1: {
                return this.data[(i0 & (1 << this.shift[0]) - 1) + this.data[i0 >> this.shift[0]]];
            }
            case 2: {
                int i1 = i0 >> this.shift[0];
                return this.data[(i0 & (1 << this.shift[0]) - 1) + this.data[(i1 & (1 << this.shift[1]) - 1) + this.data[i1 >> this.shift[1]]]];
            }
            case 3: {
                int i1 = i0 >> this.shift[0];
                int i2 = i1 >> this.shift[1];
                return this.data[(i0 & (1 << this.shift[0]) - 1) + this.data[(i1 & (1 << this.shift[1]) - 1) + this.data[(i2 & (1 << this.shift[2]) - 1) + this.data[i2 >> this.shift[2]]]]];
            }
            case 4: {
                int i1 = i0 >> this.shift[0];
                int i2 = i1 >> this.shift[1];
                int i3 = i2 >> this.shift[2];
                return this.data[(i0 & (1 << this.shift[0]) - 1) + this.data[(i1 & (1 << this.shift[1]) - 1) + this.data[(i2 & (1 << this.shift[2]) - 1) + this.data[(i3 & (1 << this.shift[3]) - 1) + this.data[i3 >> this.shift[3]]]]]];
            }
            case 5: {
                int i1 = i0 >> this.shift[0];
                int i2 = i1 >> this.shift[1];
                int i3 = i2 >> this.shift[2];
                int i4 = i3 >> this.shift[3];
                return this.data[(i0 & (1 << this.shift[0]) - 1) + this.data[(i1 & (1 << this.shift[1]) - 1) + this.data[(i2 & (1 << this.shift[2]) - 1) + this.data[(i3 & (1 << this.shift[3]) - 1) + this.data[(i4 & (1 << this.shift[4]) - 1) + this.data[i4 >> this.shift[4]]]]]]];
            }
            case 6: {
                int i1 = i0 >> this.shift[0];
                int i2 = i1 >> this.shift[1];
                int i3 = i2 >> this.shift[2];
                int i4 = i3 >> this.shift[3];
                int i5 = i4 >> this.shift[4];
                return this.data[(i0 & (1 << this.shift[0]) - 1) + this.data[(i1 & (1 << this.shift[1]) - 1) + this.data[(i2 & (1 << this.shift[2]) - 1) + this.data[(i3 & (1 << this.shift[3]) - 1) + this.data[(i4 & (1 << this.shift[4]) - 1) + this.data[(i5 & (1 << this.shift[5]) - 1) + this.data[i5 >> this.shift[5]]]]]]]];
            }
        }
        int length = this.shift.length;
        int[] index = new int[length];
        index[0] = i0;
        for (int i = 1; i < length; ++i) {
            index[i] = index[i - 1] >> this.shift[i - 1];
        }
        int value = this.data[index[length - 1] >> this.shift[length - 1]];
        for (int i = length - 1; i >= 0; --i) {
            value = this.data[value + (index[i] & (1 << this.shift[i]) - 1)];
        }
        return value;
    }
}

