/*
 * Decompiled with CFR 0.152.
 */
package de.bottlecaps.markup.blitz;

import de.bottlecaps.markup.Blitz;
import de.bottlecaps.markup.BlitzException;
import de.bottlecaps.markup.BlitzIxmlException;
import de.bottlecaps.markup.BlitzParseException;
import de.bottlecaps.markup.blitz.Errors;
import de.bottlecaps.markup.blitz.codepoints.Codepoint;
import de.bottlecaps.markup.blitz.codepoints.Range;
import de.bottlecaps.markup.blitz.codepoints.RangeSet;
import de.bottlecaps.markup.blitz.codepoints.UnicodeCategory;
import de.bottlecaps.markup.blitz.grammar.Mark;
import de.bottlecaps.markup.blitz.parser.ReduceArgument;
import de.bottlecaps.markup.blitz.transform.CompressedMap;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.stream.Stream;

public class Parser {
    public static final String IXML_NAMESPACE = "http://invisiblexml.org/NS";
    private static final int STALL_THRESHOLD = 8;
    private final Set<Blitz.Option> defaultOptions;
    private final int[] asciiMap;
    private final CompressedMap bmpMap;
    private final int[] smpMap;
    private final CompressedMap terminalTransitions;
    private final int numberOfTokens;
    private final CompressedMap nonterminalTransitions;
    private final int numberOfNonterminals;
    private final ReduceArgument[] reduceArguments;
    private final String[] nonterminal;
    private final RangeSet[] terminal;
    private final int[] forks;
    private final BitSet[] expectedTokens;
    private final boolean isVersionMismatch;
    private final boolean normalizeEol;
    private Writer err = new OutputStreamWriter((OutputStream)System.err, StandardCharsets.UTF_8);

    public Parser(Set<Blitz.Option> defaultOptions, int[] asciiMap, CompressedMap bmpMap, int[] smpMap, CompressedMap terminalTransitions, int numberOfTokens, CompressedMap nonterminalTransitions, int numberOfNonterminals, ReduceArgument[] reduceArguments, String[] nonterminal, RangeSet[] terminal, int[] forks, BitSet[] expectedTokens, boolean isVersionMismatch, boolean normalizeEol) {
        this.defaultOptions = defaultOptions;
        this.asciiMap = asciiMap;
        this.bmpMap = bmpMap;
        this.smpMap = smpMap;
        this.terminalTransitions = terminalTransitions;
        this.numberOfTokens = numberOfTokens;
        this.nonterminalTransitions = nonterminalTransitions;
        this.numberOfNonterminals = numberOfNonterminals;
        this.reduceArguments = reduceArguments;
        this.nonterminal = nonterminal;
        this.terminal = terminal;
        this.forks = forks;
        this.expectedTokens = expectedTokens;
        this.isVersionMismatch = isVersionMismatch;
        this.normalizeEol = normalizeEol;
    }

    public String parse(String input, Blitz.Option ... options) {
        return new ParsingContext(input).parse(options);
    }

    public void setTraceWriter(Writer w) {
        this.err = w;
    }

    private void writeTrace(String content) {
        try {
            this.err.write(content);
        }
        catch (IOException e) {
            throw new BlitzException(e);
        }
    }

    private String[] getExpectedTokenSet(ParseException e) {
        BitSet tokens = this.expectedTokens[e.getState()];
        RangeSet.Builder ranges = RangeSet.builder();
        int i = tokens.nextSetBit(0);
        while (i >= 0) {
            ranges.add(this.terminal[i]);
            i = tokens.nextSetBit(i + 1);
        }
        ArrayList<Object> expected = new ArrayList<Object>();
        for (Range range : ranges.build()) {
            int last = range.getLastCodepoint();
            for (int codepoint = range.getFirstCodepoint(); codepoint <= last && codepoint >= 0; ++codepoint) {
                if (Parser.printRange(codepoint) && codepoint + 2 <= last && Parser.printRange(codepoint + 2)) {
                    int endRange = codepoint + 2;
                    while (endRange + 1 <= last && Parser.printRange(endRange + 1)) {
                        ++endRange;
                    }
                    expected.add(Codepoint.toString(codepoint) + "-" + Codepoint.toString(endRange));
                    codepoint = endRange;
                    continue;
                }
                expected.add(Codepoint.toString(codepoint));
            }
        }
        return (String[])expected.toArray(String[]::new);
    }

    private static boolean printRange(int chr) {
        return chr >= 48 && chr <= 57 || chr >= 65 && chr <= 90 || chr >= 97 && chr <= 122 || !Codepoint.isAscii(chr) && chr <= 0x10FFFF;
    }

    private static String xmlEscape(String s) {
        StringBuilder sb = new StringBuilder();
        block5: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block5;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block5;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block5;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    private class ParsingContext {
        private String input = null;
        private ParseTreeBuilder eventHandler;
        private int size = 0;
        private int maxId = 0;
        private boolean trace;

        public ParsingContext(String input) {
            this.input = input;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String parse(Blitz.Option ... options) {
            long t0 = System.currentTimeMillis();
            Set<Blitz.Option> currentOptions = options.length == 0 ? Parser.this.defaultOptions : Set.of(options);
            StringBuilder w = new StringBuilder();
            XmlSerializer s = new XmlSerializer(w, currentOptions.contains((Object)Blitz.Option.INDENT));
            this.eventHandler = new ParseTreeBuilder();
            try {
                ParsingThread thread;
                this.trace = currentOptions.contains((Object)Blitz.Option.TRACE);
                if (this.trace) {
                    Parser.this.writeTrace("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<trace>\n");
                }
                this.size = this.input.length();
                this.maxId = 0;
                try {
                    thread = this.parse();
                }
                catch (ParseException pe) {
                    int begin = pe.getBegin();
                    String prefix = this.input.substring(0, begin);
                    String[] tokenSet = Parser.this.getExpectedTokenSet(pe);
                    int line = prefix.replaceAll("[^\n]+", "").length() + 1;
                    int column = prefix.length() - prefix.lastIndexOf(10);
                    throw new BlitzParseException("Failed to parse input:\n" + this.getErrorMessage(pe, tokenSet), (String)(begin < this.input.length() ? "'" + Character.toString(this.input.codePointAt(begin)) + "'" : Codepoint.toString(Integer.MAX_VALUE)), tokenSet, line, column);
                }
                finally {
                    if (this.trace) {
                        Parser.this.writeTrace("</trace>\n");
                        try {
                            Parser.this.err.flush();
                        }
                        catch (IOException iOException) {}
                    }
                }
                Nonterminal startSymbol = (Nonterminal)this.eventHandler.stack[0];
                if (startSymbol.children == null || startSymbol.children.length == 0) {
                    Errors.D01.thro(new String[0]);
                }
                if (!(startSymbol.children[0] instanceof Nonterminal)) {
                    Errors.D06.thro(new String[0]);
                }
                Nonterminal nonterminal = (Nonterminal)startSymbol.children[0];
                if (nonterminal.isAttribute) {
                    Errors.D05.thro(new String[0]);
                }
                if (startSymbol.children.length != 1) {
                    Errors.D06.thro(new String[0]);
                }
                if (thread.isAmbiguous || Parser.this.isVersionMismatch) {
                    String state = thread.isAmbiguous && Parser.this.isVersionMismatch ? "ambiguous version-mismatch" : (thread.isAmbiguous ? "ambiguous" : "version-mismatch");
                    nonterminal.addChildren(new Symbol[]{Nonterminal.attribute("xmlns:ixml", Parser.IXML_NAMESPACE), Nonterminal.attribute("ixml:state", state)});
                }
            }
            catch (BlitzIxmlException e) {
                if (currentOptions.contains((Object)Blitz.Option.FAIL_ON_ERROR)) {
                    throw e;
                }
                Nonterminal ixml = new Nonterminal("ixml");
                ixml.addChildren(new Symbol[]{Nonterminal.attribute("xmlns:ixml", Parser.IXML_NAMESPACE), Nonterminal.attribute("ixml:state", "failed"), Nonterminal.attribute("ixml:error-code", e.getError().name()), new Insertion(e.getMessage().codePoints().toArray())});
                Nonterminal root = new Nonterminal("root");
                root.addChild(ixml);
                this.eventHandler.stack[0] = root;
            }
            catch (BlitzException e) {
                if (currentOptions.contains((Object)Blitz.Option.FAIL_ON_ERROR)) {
                    throw e;
                }
                Nonterminal ixml = new Nonterminal("ixml");
                ixml.addChildren(new Symbol[]{Nonterminal.attribute("xmlns:ixml", Parser.IXML_NAMESPACE), Nonterminal.attribute("ixml:state", "failed"), new Insertion(e.getMessage().codePoints().toArray())});
                Nonterminal root = new Nonterminal("root");
                root.addChild(ixml);
                this.eventHandler.stack[0] = root;
            }
            finally {
                if (currentOptions.contains((Object)Blitz.Option.TIMING)) {
                    long t1 = System.currentTimeMillis();
                    System.err.println("        ixml parsing time: " + (t1 - t0) + " msec");
                }
            }
            this.eventHandler.serialize(s);
            return w.toString();
        }

        private ParsingThread parse() throws ParseException {
            LinkedList<ParsingThread> currentThreads = new LinkedList<ParsingThread>();
            PriorityQueue<ParsingThread> otherThreads = new PriorityQueue<ParsingThread>();
            ParsingThread thread = new ParsingThread();
            int pos = 0;
            boolean stalled = false;
            while (true) {
                if (thread.equals(otherThreads.peek())) {
                    if (this.trace) {
                        Parser.this.writeTrace("  <parse thread=\"" + thread.id + "\" offset=\"" + thread.e0 + "\" state=\"" + thread.state + "\" action=\"discard\"/>\n");
                    }
                    ParsingThread t = (ParsingThread)otherThreads.remove();
                    if (t.deferredEvent == null || t.deferredEvent.getQueueSize() < thread.deferredEvent.getQueueSize()) {
                        thread = t;
                    }
                    thread.isAmbiguous = true;
                    continue;
                }
                boolean isUnambiguous = otherThreads.isEmpty();
                if (isUnambiguous && thread.deferredEvent != null) {
                    thread.deferredEvent.release(this.eventHandler);
                    thread.deferredEvent = null;
                }
                if (thread.status == Status.ACCEPTED) {
                    if (!isUnambiguous) {
                        throw new IllegalStateException();
                    }
                    return thread;
                }
                Arrays.fill(thread.forkCount, (byte)0);
                int repeatedForks = 0;
                do {
                    int fork;
                    if ((fork = thread.parse(isUnambiguous)) >= 0) {
                        isUnambiguous = false;
                        thread.action = Parser.this.forks[2 * fork];
                        if (thread.e0 > pos) {
                            otherThreads.add(thread);
                            otherThreads.add(new ParsingThread(thread, Parser.this.forks[2 * fork + 1]));
                            continue;
                        }
                        if (thread.forkCount[fork] > 0 && repeatedForks >= 8) {
                            stalled = true;
                            if (!this.trace) continue;
                            Parser.this.writeTrace("  <parse thread=\"" + thread.id + "\" offset=\"" + thread.e0 + "\" state=\"" + thread.state + "\" action=\"stalled\"/>\n");
                            continue;
                        }
                        int n = fork;
                        byte by = thread.forkCount[n];
                        thread.forkCount[n] = (byte)(by + 1);
                        if (by > 1) {
                            ++repeatedForks;
                        }
                        currentThreads.add(thread);
                        currentThreads.add(new ParsingThread(thread, Parser.this.forks[2 * fork + 1]));
                        continue;
                    }
                    if (thread.status != Status.ERROR) {
                        otherThreads.add(thread);
                        continue;
                    }
                    if (!otherThreads.isEmpty() || !currentThreads.isEmpty()) continue;
                    throw new ParseException(thread.b1, thread.state, thread.l1, stalled);
                } while ((thread = (ParsingThread)currentThreads.poll()) != null);
                thread = (ParsingThread)otherThreads.remove();
                if (thread.e0 <= pos) continue;
                pos = thread.e0;
            }
        }

        private String getErrorMessage(ParseException e, String[] tokenSet) {
            boolean eoi = e.getBegin() >= this.input.length();
            String found = eoi ? RangeSet.EOI.shortName() : "'" + Character.toString(this.input.codePointAt(e.getBegin())) + "'";
            int limit = 16;
            Object[] expectedTokens = (String[])Stream.concat(Arrays.stream(tokenSet).sorted((s1, s2) -> Boolean.compare(s1.startsWith("#"), s2.startsWith("#"))).limit(limit), tokenSet.length > limit ? Stream.of("...") : Stream.empty()).toArray(String[]::new);
            String message = e.getMessage() + ", found " + found + "\nwhile expecting " + (String)(expectedTokens.length == 1 ? expectedTokens[0] : "one of " + Arrays.toString(expectedTokens)) + "\nat " + this.lineAndColumn(e.getBegin());
            if (!eoi) {
                message = message + ":\n..." + this.input.subSequence(e.getBegin(), Math.min(this.input.length(), e.getBegin() + 64)) + "...";
            }
            if (e.wasStalled()) {
                message = message + "\nHowever, some alternatives were discarded while parsing because they were suspected to be involved in infinite ambiguity.";
            }
            return message;
        }

        private String lineAndColumn(int pos) {
            String prefix = this.input.subSequence(0, pos).toString();
            int line = prefix.replaceAll("[^\n]", "").length() + 1;
            int column = prefix.length() - prefix.lastIndexOf(10);
            return "line " + line + ", column " + column;
        }

        private class ParsingThread
        implements Comparable<ParsingThread> {
            public final byte[] forkCount;
            public DeferredEvent deferredEvent;
            public Status status;
            public final int id;
            public int state;
            public int action;
            public int b0;
            public int e0;
            public int b1;
            public int e1;
            public int c1;
            public int l1;
            public boolean isAmbiguous;
            private StackNode stack;

            public ParsingThread() {
                this.forkCount = new byte[Parser.this.forks.length / 2];
                this.b0 = 0;
                this.e0 = 0;
                this.b1 = 0;
                this.e1 = 0;
                this.id = ParsingContext.this.maxId = 0;
                this.isAmbiguous = false;
                this.status = Status.PARSING;
                this.deferredEvent = null;
                this.stack = new StackNode();
                this.state = 0;
                this.l1 = this.match();
                this.action = this.l1 < 0 ? 0 : Parser.this.terminalTransitions.get(this.state * Parser.this.numberOfTokens + this.l1);
            }

            public ParsingThread(ParsingThread other, int action) {
                this.forkCount = Arrays.copyOf(other.forkCount, other.forkCount.length);
                this.action = action;
                this.status = other.status;
                this.deferredEvent = other.deferredEvent;
                this.id = ++ParsingContext.this.maxId;
                this.state = other.state;
                this.stack = other.stack;
                this.b0 = other.b0;
                this.e0 = other.e0;
                this.c1 = other.c1;
                this.l1 = other.l1;
                this.b1 = other.b1;
                this.e1 = other.e1;
                this.isAmbiguous = other.isAmbiguous;
            }

            @Override
            public int compareTo(ParsingThread other) {
                int comp = this.e0 - other.e0;
                if (comp != 0) {
                    return comp;
                }
                return other.id - this.id;
            }

            public boolean equals(Object obj) {
                if (obj == null) {
                    return false;
                }
                ParsingThread other = (ParsingThread)obj;
                if (this.state != other.state) {
                    return false;
                }
                if (this.action != other.action) {
                    return false;
                }
                if (this.e0 != other.e0) {
                    return false;
                }
                if (this.e1 != other.e1) {
                    return false;
                }
                if (this.l1 != other.l1) {
                    return false;
                }
                if (this.status != other.status) {
                    return false;
                }
                return this.stack.equals(other.stack);
            }

            public int parse(boolean isUnambiguous) throws ParseException {
                int limit;
                int nonterminalId = -1;
                int n = limit = isUnambiguous ? Integer.MAX_VALUE : this.e0;
                while (true) {
                    if (ParsingContext.this.trace) {
                        Parser.this.writeTrace("  <parse thread=\"" + this.id + "\" offset=\"" + this.e0 + "\" state=\"" + this.state + "\" input=\"");
                        if (nonterminalId >= 0) {
                            Parser.this.writeTrace(Parser.xmlEscape(Parser.this.nonterminal[nonterminalId]));
                            if (this.l1 > 0) {
                                Parser.this.writeTrace(" ");
                            }
                        }
                        if (this.l1 > 0) {
                            Parser.this.writeTrace(Parser.xmlEscape(Parser.this.terminal[this.l1].shortName()));
                        }
                        Parser.this.writeTrace("\" action=\"");
                    }
                    int argument = this.action >> 3;
                    int shift = -1;
                    int reduce = -1;
                    switch (this.action & 7) {
                        case 1: {
                            shift = argument;
                            break;
                        }
                        case 2: {
                            shift = this.state;
                        }
                        case 3: {
                            reduce = argument;
                            break;
                        }
                        case 4: {
                            if (ParsingContext.this.trace) {
                                Parser.this.writeTrace("fork\"/>\n");
                            }
                            return argument;
                        }
                        case 5: {
                            if (ParsingContext.this.trace) {
                                Parser.this.writeTrace("accept\"/>\n");
                            }
                            this.status = Status.ACCEPTED;
                            this.action = 0;
                            ++this.e0;
                            return -1;
                        }
                        default: {
                            if (ParsingContext.this.trace) {
                                Parser.this.writeTrace("fail\"/>\n");
                            }
                            this.status = Status.ERROR;
                            return -1;
                        }
                    }
                    if (shift >= 0) {
                        if (ParsingContext.this.trace) {
                            Parser.this.writeTrace("shift");
                        }
                        if (nonterminalId < 0) {
                            if (isUnambiguous) {
                                ParsingContext.this.eventHandler.terminal(this.c1);
                            } else {
                                this.deferredEvent = new TerminalEvent(this.deferredEvent, this.c1);
                            }
                            this.b0 = this.b1;
                            this.e0 = this.e1;
                            this.c1 = -1;
                            this.l1 = 0;
                        }
                        this.stack = this.stack.push(this.state);
                        this.state = shift;
                    }
                    if (reduce < 0) {
                        if (ParsingContext.this.trace) {
                            Parser.this.writeTrace("\"/>\n");
                        }
                        if (this.l1 == 0) {
                            this.l1 = this.match();
                        }
                        int n2 = this.action = this.l1 < 0 ? 0 : Parser.this.terminalTransitions.get(this.state * Parser.this.numberOfTokens + this.l1);
                        if (this.e0 > limit) {
                            return -1;
                        }
                        nonterminalId = -1;
                        continue;
                    }
                    ReduceArgument reduceArgument = Parser.this.reduceArguments[reduce];
                    int symbols = reduceArgument.getMarks().length;
                    nonterminalId = reduceArgument.getNonterminalId();
                    if (ParsingContext.this.trace) {
                        if (shift >= 0) {
                            Parser.this.writeTrace(" ");
                        }
                        Parser.this.writeTrace("reduce\" nonterminal=\"" + Parser.xmlEscape(Parser.this.nonterminal[nonterminalId]) + "\" count=\"" + symbols + "\"/>\n");
                    }
                    if (symbols > 0) {
                        for (int i = 1; i < symbols; ++i) {
                            this.stack = this.stack.pop();
                        }
                        this.state = this.stack.getState();
                        this.stack = this.stack.pop();
                    }
                    if (isUnambiguous) {
                        ParsingContext.this.eventHandler.nonterminal(reduceArgument);
                    } else {
                        this.deferredEvent = new NonterminalEvent(this.deferredEvent, reduceArgument);
                    }
                    this.action = Parser.this.nonterminalTransitions.get(this.state * Parser.this.numberOfNonterminals + nonterminalId);
                }
            }

            private int match() {
                int charclass;
                if (ParsingContext.this.trace) {
                    Parser.this.writeTrace("  <tokenize thread=\"" + this.id + "\" offset=\"" + this.e1 + "\"");
                }
                this.b1 = this.e1;
                if (this.e1 >= ParsingContext.this.size) {
                    this.c1 = -1;
                    charclass = 0;
                } else {
                    this.c1 = ParsingContext.this.input.charAt(this.e1++);
                    if (this.c1 < 128) {
                        if (ParsingContext.this.trace && this.c1 >= 32 && this.c1 <= 126) {
                            Parser.this.writeTrace(" char=\"" + Parser.xmlEscape(String.valueOf((char)this.c1)) + "\"");
                        }
                        if (this.c1 == 13 && Parser.this.normalizeEol) {
                            if (this.e1 < ParsingContext.this.size && ParsingContext.this.input.charAt(this.e1) == '\n') {
                                ++this.e1;
                            }
                            this.c1 = 10;
                        }
                        charclass = Parser.this.asciiMap[this.c1];
                    } else if (this.c1 < 55296) {
                        charclass = Parser.this.bmpMap.get(this.c1);
                    } else {
                        if (this.c1 < 56320) {
                            int lowSurrogate;
                            int n = lowSurrogate = this.e1 < ParsingContext.this.size ? (int)ParsingContext.this.input.charAt(this.e1) : 0;
                            if (lowSurrogate >= 56320 && lowSurrogate < 57344) {
                                ++this.e1;
                                this.c1 = ((this.c1 & 0x3FF) << 10) + (lowSurrogate & 0x3FF) + 65536;
                            }
                        }
                        int smpMapSize = Parser.this.smpMap.length / 3;
                        int lo = 0;
                        int hi = smpMapSize - 1;
                        int m = hi >> 1;
                        while (true) {
                            if (Parser.this.smpMap[m] > this.c1) {
                                hi = m - 1;
                            } else if (Parser.this.smpMap[smpMapSize + m] < this.c1) {
                                lo = m + 1;
                            } else {
                                charclass = Parser.this.smpMap[2 * smpMapSize + m];
                                break;
                            }
                            if (lo > hi) {
                                charclass = -1;
                                break;
                            }
                            m = hi + lo >> 1;
                        }
                    }
                    if (ParsingContext.this.trace && this.c1 >= 0) {
                        Parser.this.writeTrace(" codepoint=\"" + this.c1 + "\"");
                    }
                    if (charclass <= 0) {
                        if (ParsingContext.this.trace) {
                            Parser.this.writeTrace(" status=\"fail\" end=\"" + this.e1 + "\"/>\n");
                        }
                        this.e1 = this.b1;
                        return -1;
                    }
                }
                if (ParsingContext.this.trace) {
                    Parser.this.writeTrace(" class=\"" + charclass + "\"");
                    Parser.this.writeTrace(" status=\"success\" result=\"");
                    Parser.this.writeTrace(Parser.xmlEscape(Parser.this.terminal[charclass].shortName()));
                    Parser.this.writeTrace("\" end=\"" + this.e1 + "\"/>\n");
                }
                return charclass;
            }
        }
    }

    private class ParseTreeBuilder {
        private Symbol[] stack = new Symbol[64];
        private int top = -1;

        ParseTreeBuilder() {
        }

        public void nonterminal(ReduceArgument reduceArgument) {
            Mark[] marks = reduceArgument.getMarks();
            int[] aliases = reduceArgument.getAliases();
            int count = marks.length;
            this.top -= count;
            int from = this.top + 1;
            int to = this.top + count + 1;
            Nonterminal nt = new Nonterminal(Parser.this.nonterminal[reduceArgument.getNonterminalId()]);
            block5: for (int i = from; i < to; ++i) {
                Symbol symbol = this.stack[i];
                Mark mark = marks[i - this.top - 1];
                if (symbol instanceof Terminal) {
                    if (mark != Mark.NODE) continue;
                    nt.addChild(symbol);
                    continue;
                }
                Nonterminal n = (Nonterminal)symbol;
                int alias = aliases[i - this.top - 1];
                if (alias >= 0) {
                    n.setName(Parser.this.nonterminal[alias]);
                }
                switch (mark) {
                    case ATTRIBUTE: {
                        n.setAttribute();
                    }
                    case NODE: {
                        nt.addChild(n);
                        continue block5;
                    }
                    case DELETE: {
                        nt.addChildren(n.children);
                        continue block5;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected mark: " + mark);
                    }
                }
            }
            int[] insertion = reduceArgument.getInsertion();
            if (insertion != null) {
                nt.addChild(new Insertion(insertion));
            }
            this.push(nt);
        }

        public void terminal(int codepoint) {
            this.push(new Terminal(codepoint));
        }

        public void serialize(XmlSerializer e) {
            ((Nonterminal)this.stack[0]).children[0].send(e);
        }

        public void push(Symbol s) {
            if (++this.top >= this.stack.length) {
                this.stack = Arrays.copyOf(this.stack, this.stack.length << 1);
            }
            this.stack[this.top] = s;
        }
    }

    private static enum Status {
        PARSING,
        ERROR,
        ACCEPTED;

    }

    private static class NonterminalEvent
    extends DeferredEvent {
        private ReduceArgument reduceArgument;

        public NonterminalEvent(DeferredEvent link, ReduceArgument reduceArgument) {
            super(link);
            this.reduceArgument = reduceArgument;
        }

        @Override
        public void execute(ParseTreeBuilder eventHandler) {
            eventHandler.nonterminal(this.reduceArgument);
        }
    }

    private static class TerminalEvent
    extends DeferredEvent {
        private int codepoint;

        public TerminalEvent(DeferredEvent link, int codepoint) {
            super(link);
            this.codepoint = codepoint;
        }

        @Override
        public void execute(ParseTreeBuilder eventHandler) {
            eventHandler.terminal(this.codepoint);
        }
    }

    private static abstract class DeferredEvent {
        private DeferredEvent link;
        private final int queueSize;

        public DeferredEvent(DeferredEvent link) {
            this.link = link;
            this.queueSize = link == null ? 0 : link.queueSize + 1;
        }

        public int getQueueSize() {
            return this.queueSize;
        }

        public abstract void execute(ParseTreeBuilder var1);

        public void release(ParseTreeBuilder eventHandler) {
            DeferredEvent current = this;
            DeferredEvent predecessor = current.link;
            current.link = null;
            while (predecessor != null) {
                DeferredEvent next = predecessor.link;
                predecessor.link = current;
                current = predecessor;
                predecessor = next;
            }
            do {
                current.execute(eventHandler);
            } while ((current = current.link) != null);
        }
    }

    private static class StackNode {
        private final StackNode link;
        private final int state;

        public StackNode() {
            this.link = null;
            this.state = -1;
        }

        private StackNode(int state, StackNode link) {
            this.link = link;
            this.state = state;
        }

        public int getState() {
            return this.state;
        }

        public StackNode push(int state) {
            return new StackNode(state, this);
        }

        public StackNode pop() {
            return this.link;
        }

        public boolean equals(Object obj) {
            StackNode lhs = this;
            StackNode rhs = (StackNode)obj;
            while (lhs != rhs) {
                if (lhs.state != rhs.state) {
                    return false;
                }
                lhs = lhs.link;
                rhs = rhs.link;
            }
            return true;
        }
    }

    private static class XmlSerializer {
        private static final String INDENTATION = "   ";
        private StringBuilder out;
        private int depth;
        private int attributeLevel;
        private boolean delayedTag;
        private boolean indent;
        private boolean hasChildElement;

        public XmlSerializer(StringBuilder out, boolean indent) {
            this.out = out;
            this.indent = indent;
            this.depth = 0;
            this.attributeLevel = 0;
            this.delayedTag = false;
            this.hasChildElement = false;
        }

        public void startNonterminal(String name) {
            if (this.attributeLevel == 0) {
                if (this.delayedTag) {
                    this.out.append('>');
                }
                this.delayedTag = true;
                if (this.indent && this.depth > 0) {
                    this.out.append('\n');
                    for (int i = 0; i < this.depth; ++i) {
                        this.out.append(INDENTATION);
                    }
                }
                this.out.append('<');
                this.out.append(name);
                this.hasChildElement = false;
                ++this.depth;
            }
        }

        public void endNonterminal(String name) {
            if (this.attributeLevel == 0) {
                --this.depth;
                if (this.delayedTag) {
                    this.delayedTag = false;
                    this.out.append("/>");
                } else {
                    if (this.indent && this.hasChildElement) {
                        this.out.append('\n');
                        for (int i = 0; i < this.depth; ++i) {
                            this.out.append(INDENTATION);
                        }
                    }
                    this.out.append("</");
                    this.out.append(name);
                    this.out.append('>');
                }
                this.hasChildElement = true;
            }
        }

        public void startAttribute(String name) {
            ++this.attributeLevel;
            this.out.append(' ');
            this.out.append(name);
            this.out.append("=\"");
        }

        public void endAttribute() {
            this.out.append('\"');
            --this.attributeLevel;
        }

        public void terminal(int codepoint) {
            if (!UnicodeCategory.xmlChar.containsCodepoint(codepoint)) {
                Errors.D04.thro(Codepoint.toString(codepoint));
            }
            if (this.attributeLevel > 0) {
                switch (codepoint) {
                    case 38: {
                        this.out.append("&amp;");
                        break;
                    }
                    case 60: {
                        this.out.append("&lt;");
                        break;
                    }
                    case 62: {
                        this.out.append("&gt;");
                        break;
                    }
                    case 34: {
                        this.out.append("&quot;");
                        break;
                    }
                    default: {
                        if (codepoint >= 32) {
                            this.out.append(Character.toString(codepoint));
                            break;
                        }
                        this.out.append("&x");
                        this.out.append(Integer.toString(codepoint, 16).toUpperCase());
                        this.out.append(';');
                        break;
                    }
                }
            } else {
                if (this.delayedTag) {
                    this.out.append('>');
                    this.delayedTag = false;
                }
                switch (codepoint) {
                    case 38: {
                        this.out.append("&amp;");
                        break;
                    }
                    case 60: {
                        this.out.append("&lt;");
                        break;
                    }
                    case 62: {
                        this.out.append("&gt;");
                        break;
                    }
                    case 10: {
                        this.out.append('\n');
                        break;
                    }
                    default: {
                        if (codepoint >= 32) {
                            this.out.append(Character.toString(codepoint));
                            break;
                        }
                        this.out.append("&#x");
                        this.out.append(Integer.toString(codepoint, 16).toUpperCase());
                        this.out.append(';');
                    }
                }
            }
        }
    }

    private static class Nonterminal
    extends Symbol {
        private static final Symbol[] NO_CHILDREN = new Symbol[0];
        private Symbol[] children;
        private String name;
        private boolean isAttribute;

        public Nonterminal(String name) {
            this.name = name;
            this.children = NO_CHILDREN;
            this.isAttribute = false;
        }

        public void setName(String newName) {
            this.name = newName;
        }

        public void setAttribute() {
            this.isAttribute = true;
        }

        public void addChildren(Symbol[] newChildren) {
            if (this.children == NO_CHILDREN) {
                this.children = newChildren;
            } else {
                this.children = Arrays.copyOf(this.children, this.children.length + newChildren.length);
                System.arraycopy(newChildren, 0, this.children, this.children.length - newChildren.length, newChildren.length);
            }
        }

        public void addChild(Symbol child) {
            if (this.children == NO_CHILDREN) {
                this.children = new Symbol[]{child};
            } else {
                this.children = Arrays.copyOf(this.children, this.children.length + 1);
                this.children[this.children.length - 1] = child;
            }
        }

        @Override
        public void send(XmlSerializer e) {
            if (this.name.charAt(0) == ' ') {
                Errors.D03.thro(this.name.substring(1));
            }
            if (this.isAttribute) {
                if (this.name.equals("xmlns")) {
                    Errors.D07.thro(new String[0]);
                }
                e.startAttribute(this.name);
                for (Symbol c : this.children) {
                    c.sendContent(e);
                }
                e.endAttribute();
            } else {
                e.startNonterminal(this.name);
                HashSet<String> names = null;
                for (Symbol c : this.children) {
                    if (!(c instanceof Nonterminal)) continue;
                    Nonterminal nonterminal = (Nonterminal)c;
                    if (!nonterminal.isAttribute) continue;
                    if (names == null) {
                        names = new HashSet<String>();
                    }
                    if (!names.add(nonterminal.name)) {
                        Errors.D02.thro(nonterminal.name);
                    }
                    c.send(e);
                }
                for (Symbol c : this.children) {
                    if (c instanceof Nonterminal && ((Nonterminal)c).isAttribute) continue;
                    c.send(e);
                }
                e.endNonterminal(this.name);
            }
        }

        @Override
        public void sendContent(XmlSerializer e) {
            for (Symbol c : this.children) {
                c.sendContent(e);
            }
        }

        public static Nonterminal attribute(String name, String value) {
            Nonterminal attribute = new Nonterminal(name);
            attribute.addChildren((Symbol[])value.codePoints().mapToObj(Terminal::new).toArray(Symbol[]::new));
            attribute.setAttribute();
            return attribute;
        }
    }

    private static class Insertion
    extends Symbol {
        private int[] codepoints;

        public Insertion(int[] codepoints) {
            this.codepoints = codepoints;
        }

        @Override
        public void send(XmlSerializer e) {
            for (int codepoint : this.codepoints) {
                e.terminal(codepoint);
            }
        }

        @Override
        public void sendContent(XmlSerializer e) {
            for (int codepoint : this.codepoints) {
                e.terminal(codepoint);
            }
        }
    }

    private static class Terminal
    extends Symbol {
        private int codepoint;

        public Terminal(int codepoint) {
            this.codepoint = codepoint;
        }

        @Override
        public void send(XmlSerializer e) {
            e.terminal(this.codepoint);
        }

        @Override
        public void sendContent(XmlSerializer e) {
            e.terminal(this.codepoint);
        }
    }

    private static abstract class Symbol {
        private Symbol() {
        }

        public abstract void send(XmlSerializer var1);

        public abstract void sendContent(XmlSerializer var1);
    }

    private static class ParseException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private int begin;
        private int offending;
        private int state;
        private boolean wasStalled;

        public ParseException(int begin, int state, int offending, boolean wasStalled) {
            this.begin = begin;
            this.state = state;
            this.offending = offending;
            this.wasStalled = wasStalled;
        }

        @Override
        public String getMessage() {
            return this.offending < 0 ? "lexical analysis failed" : "syntax error";
        }

        public int getBegin() {
            return this.begin;
        }

        public int getState() {
            return this.state;
        }

        public boolean wasStalled() {
            return this.wasStalled;
        }
    }
}

