/*
 * Decompiled with CFR 0.152.
 */
package net.xqj.core.xqsequence;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URI;
import java.util.Properties;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Result;
import javax.xml.xquery.XQException;
import javax.xml.xquery.XQItem;
import javax.xml.xquery.XQItemType;
import javax.xml.xquery.XQSequence;
import net.xqj.core.Factory;
import net.xqj.core.TextContainer;
import net.xqj.core.XQToolkit;
import net.xqj.core.exception.XQExceptionImpl;
import net.xqj.core.stax.MasterXMLStreamReader;
import net.xqj.core.toolkit.ReoFactory;
import net.xqj.core.xqitem.XQItemBase;
import net.xqj.core.xqitem.XQItemBaseIterator;
import net.xqj.core.xqsequence.ContentHandlerFilter;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public abstract class XQSequenceBase
implements XQSequence,
Cloneable {
    protected static int instanceCounter = 0;
    protected int instanceId = ++instanceCounter;
    private static final byte[] OPEN_AND_CLOSE = new byte[]{40, 41};
    private static final char[] OPEN_AND_CLOSE_C = new char[]{'(', ')'};
    private static final int OPEN = 40;
    private static final int CLOSE = 41;
    private static final int COMMA = 44;

    public XMLStreamReader getSequenceAsStream() throws XQException {
        XQItem xqItem2;
        if (!this.isOnItem()) {
            this.next();
        }
        XQItem xqItem1 = (XQItem)this.getItemIdentity().clone();
        boolean isMultiple = this.next();
        XQItem xQItem = xqItem2 = isMultiple ? this.getItem() : null;
        if (isMultiple || xqItem1.getItemType().getItemKind() == 1) {
            return new MasterXMLStreamReader(xqItem1, xqItem2, this);
        }
        return xqItem1.getItemAsStream();
    }

    public String getSequenceAsString(Properties properties) throws XQException {
        if (!this.isOnItem()) {
            this.next();
        }
        if (!this.isOnItem()) {
            return "";
        }
        TextContainer buffer = ReoFactory.getInstance().getTextContainer();
        do {
            buffer.append(this.getItemIdentity().getItemAsString(XQToolkit.tryToIgnoreXMLProcessing(properties)).toCharArray());
            buffer.append(' ');
        } while (this.next());
        String returnValue = new String(buffer.getRawCharArray(), 0, buffer.length() - 1);
        ReoFactory.getInstance().returnTextContainer(buffer);
        return returnValue;
    }

    public void writeSequence(OutputStream out, Properties properties) throws XQException {
        if (XQToolkit.isToWriteXQuery(properties)) {
            try {
                if (!this.isOnItem() && !this.next()) {
                    out.write(OPEN_AND_CLOSE, 0, 2);
                    return;
                }
                out.write(40);
                this.writeItem(out, properties);
                while (this.next()) {
                    out.write(44);
                    this.writeItem(out, properties);
                }
                out.write(41);
            }
            catch (IOException e) {
                throw new XQExceptionImpl("Encountered an IOException whilst writing a sequence to an OutputStream.", "XQJSBS017", e);
            }
        } else {
            if (!this.isOnItem()) {
                this.next();
            }
            boolean hasNext = true;
            while (hasNext) {
                this.getItemIdentity().writeItem(out, XQToolkit.tryToIgnoreXMLProcessing(properties));
                hasNext = this.next();
                if (!hasNext) continue;
                try {
                    out.write(10);
                }
                catch (IOException e) {
                    throw new XQExceptionImpl(e.getMessage(), "XQJSBS020", e);
                }
            }
        }
    }

    public void writeSequence(Writer writer, Properties properties) throws XQException {
        if (XQToolkit.isToWriteXQuery(properties)) {
            try {
                if (!this.isOnItem() && !this.next()) {
                    writer.write(OPEN_AND_CLOSE_C, 0, 2);
                    return;
                }
                writer.write(40);
                this.writeItem(writer, properties);
                while (this.next()) {
                    writer.write(44);
                    this.writeItem(writer, properties);
                }
                writer.write(41);
            }
            catch (IOException e) {
                throw new XQExceptionImpl("Encountered an IOException whilst writing a sequence to a Writer.", "XQJSBS018", e);
            }
        } else {
            if (!this.isOnItem()) {
                this.next();
            }
            boolean hasNext = true;
            while (hasNext) {
                this.getItemIdentity().writeItem(writer, XQToolkit.tryToIgnoreXMLProcessing(properties));
                hasNext = this.next();
                if (!hasNext) continue;
                try {
                    writer.write(10);
                }
                catch (IOException e) {
                    throw new XQExceptionImpl(e.getMessage(), "XQJSBS021", e);
                }
            }
        }
    }

    public void writeSequenceToSAX(ContentHandler saxhdlr) throws XQException {
        XQItemBase xqItem1 = null;
        XQItemBase xqItem2 = null;
        if (!this.isOnItem()) {
            this.next();
        }
        xqItem1 = (XQItemBase)this.getItemIdentity().clone();
        if (this.next()) {
            xqItem2 = this.getItemIdentity();
            try {
                saxhdlr.startDocument();
                saxhdlr.startPrefixMapping("r", "http://www.xqj.net/");
                saxhdlr.startElement("http://www.xqj.net/", "result", "r:result", new AttributesImpl());
                ContentHandlerFilter saxhdlrFilter = new ContentHandlerFilter(saxhdlr);
                saxhdlrFilter.writeItem(xqItem1);
                saxhdlrFilter.writeItem(xqItem2);
                while (this.next()) {
                    saxhdlrFilter.writeItem(this.getItem());
                }
                saxhdlr.endElement("http://www.xqj.net/", null, "r:result");
                saxhdlr.endPrefixMapping("r");
                saxhdlr.endDocument();
            }
            catch (SAXException e) {
                throw new XQExceptionImpl("Encountered a SAXException whilst writing sequence to a SAX ContentHandler.", "XQJSBS019", e);
            }
        } else {
            xqItem1.writeItemToSAX(saxhdlr);
        }
    }

    public void writeSequenceToResult(Result result) throws XQException {
        XQToolkit.transform(Factory.newSource(this.getSequenceAsStream()), result);
    }

    public boolean getBoolean() throws XQException {
        return this.getItemIdentity().getBoolean();
    }

    public byte getByte() throws XQException {
        return this.getItemIdentity().getByte();
    }

    public double getDouble() throws XQException {
        return this.getItemIdentity().getDouble();
    }

    public float getFloat() throws XQException {
        return this.getItemIdentity().getFloat();
    }

    public int getInt() throws XQException {
        return this.getItemIdentity().getInt();
    }

    public XQItemType getItemType() throws XQException {
        return this.getItemIdentity().getItemType();
    }

    public String getAtomicValue() throws XQException {
        return this.getItemIdentity().getAtomicValue();
    }

    public long getLong() throws XQException {
        return this.getItemIdentity().getLong();
    }

    public Node getNode() throws XQException {
        return this.getItemIdentity().getNode();
    }

    public URI getNodeUri() throws XQException {
        return this.getItemIdentity().getNodeUri();
    }

    public Object getObject() throws XQException {
        return this.getItemIdentity().getObject();
    }

    public XMLStreamReader getItemAsStream() throws XQException {
        return this.getItemIdentity().getItemAsStream();
    }

    public String getItemAsString(Properties properties) throws XQException {
        return this.getItemIdentity().getItemAsString(properties);
    }

    public short getShort() throws XQException {
        return this.getItemIdentity().getShort();
    }

    public void writeItem(OutputStream out, Properties properties) throws XQException {
        this.getItemIdentity().writeItem(out, properties);
    }

    public void writeItem(Writer writer, Properties properties) throws XQException {
        this.getItemIdentity().writeItem(writer, properties);
    }

    public void writeItemToSAX(ContentHandler saxhdlr) throws XQException {
        this.getItemIdentity().writeItemToSAX(saxhdlr);
    }

    public void writeItemToResult(Result result) throws XQException {
        this.getItemIdentity().writeItemToResult(result);
    }

    public boolean isClosed() {
        return false;
    }

    public abstract boolean absolute(int var1) throws XQException;

    public abstract void afterLast() throws XQException;

    public abstract void beforeFirst() throws XQException;

    public abstract void close() throws XQException;

    public abstract int count() throws XQException;

    public abstract int getPosition() throws XQException;

    public abstract boolean isOnItem() throws XQException;

    public abstract boolean isScrollable() throws XQException;

    public abstract boolean first() throws XQException;

    public abstract XQItem getItem() throws XQException;

    public abstract XQItemBase getItemIdentity() throws XQException;

    public abstract boolean isAfterLast() throws XQException;

    public abstract boolean isBeforeFirst() throws XQException;

    public abstract boolean isFirst() throws XQException;

    public abstract boolean isLast() throws XQException;

    public abstract boolean last() throws XQException;

    public abstract boolean next() throws XQException;

    public abstract boolean previous() throws XQException;

    public abstract boolean relative(int var1) throws XQException;

    public abstract boolean instanceOf(XQItemType var1) throws XQException;

    public abstract void reset(XQItemBaseIterator var1) throws XQException;

    public Object clone() {
        try {
            XQSequenceBase base = (XQSequenceBase)super.clone();
            base.instanceId = ++instanceCounter;
            return base;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

