// AID-GENERATED
// =========================================================================
// This class was generated by AID - Abstract Interface Definition          
// DO NOT MODIFY, but use the org.freehep.aid.Aid utility to regenerate it. 
// =========================================================================

//  This file is part of the AIDA library
//  Copyright (C) 2002 by the AIDA team.  All rights reserved.
//  This library is free software and under the terms of the
//  GNU Library General Public License described in the LGPL.txt 
package hep.aida;


/**
 * User level interface to a 3D Cloud.
 * 
 * @author The AIDA team (http://aida.freehep.org/)
 *
 */

public interface ICloud3D extends ICloud {

    /**
     * Fill the ICloud3D with a triplet of values and a corresponding weight.
     * @param x      The x value.
     * @param y      The y value.
     * @param z      The z value.
     * @throws IllegalArgumentException If the ICloud3D is full, if the weight's value is
     *                                  is not between 0 and 1.
     *
     */
    public void fill(double x, double y, double z) throws IllegalArgumentException;
    /**
     * Fill the ICloud3D with a triplet of values and a corresponding weight.
     * @param x      The x value.
     * @param y      The y value.
     * @param z      The z value.
     * @param weight The corresponding weight. By default it is 1.
     * @throws IllegalArgumentException If the ICloud3D is full, if the weight's value is
     *                                  is not between 0 and 1.
     *
     */
    public void fill(double x, double y, double z, double weight) throws IllegalArgumentException;

    /**
     * Get the lower edge of the ICloud3D along the x axis.
     * @return The lower edge along the x axis.
     *
     */
    public double lowerEdgeX();

    /**
     * Get the lower edge of the ICloud3D along the y axis.
     * @return The lower edge along the y axis.
     *
     */
    public double lowerEdgeY();

    /**
     * Get the lower edge of the ICloud3D along the z axis.
     * @return The lower edge along the z axis.
     *
     */
    public double lowerEdgeZ();

    /**
     * Get the upper edge of the ICloud3D along the x axis.
     * @return The upper edge along the x axis.
     *
     */
    public double upperEdgeX();

    /**
     * Get the upper edge of the ICloud3D along the y axis.
     * @return The upper edge along the y axis.
     *
     */
    public double upperEdgeY();

    /**
     * Get the upper edge of the ICloud3D along the z axis.
     * @return The upper edge along the z axis.
     *
     */
    public double upperEdgeZ();

    /**
     * Get the x value corresponding to a given entry.
     * @param index The entry's index.
     * @return      The x value of the index-th entry.
     * @throws      AlreadyConvertedException If the ICloud3D has already been converted.
     *
     */
      
    public double valueX(int index) throws AlreadyConvertedException;

    /**
     * Get the y value corresponding to a given entry.
     * @param index The entry's index.
     * @return      The y value of the index-th entry.
     * @throws      AlreadyConvertedException If the ICloud3D has already been converted.
     *
     */
      
    public double valueY(int index) throws AlreadyConvertedException;

    /**
     * Get the z value corresponding to a given entry.
     * @param index The entry's index.
     * @return      The z value of the index-th entry.
     * @throws      AlreadyConvertedException If the ICloud3D has already been converted.
     *
     */
      
    public double valueZ(int index) throws AlreadyConvertedException;

    /**
     * Get the weight corresponding to a given entry.
     * @param index The entry's index.
     * @return      The weight of the index-th entry.
     * @throws      AlreadyConvertedException If the ICloud has already been converted.
     *
     */
      
    public double weight(int index) throws AlreadyConvertedException;

    /**
     * Get the mean of the ICloud3D along the x axis.
     * @return The mean along the x axis.
     *
     */
    public double meanX();

    /**
     * Get the mean of the ICloud3D along the y axis.
     * @return The mean along the y axis.
     *
     */
    public double meanY();

    /**
     * Get the mean of the ICloud3D along the z axis.
     * @return The mean along the z axis.
     *
     */
    public double meanZ();

    /**
     * Get the RMS of the ICloud3D along the x axis.
     * @return The RMS along the x axis.
     *
     */
    public double rmsX();

    /**
     * Get the RMS of the ICloud3D along the y axis.
     * @return The RMS along the y axis.
     *
     */
    public double rmsY();

    /**
     * Get the RMS of the ICloud3D along the z axis.
     * @return The RMS along the z axis.
     *
     */
    public double rmsZ();

    /**
     * Convert internally the ICloud3D to an IHistogram3D 
     * with given number of bins, upper edge and lower edge.
     * @param nBinsX     The number of bins of the x axis.
     * @param lowerEdgeX The lower edge of bins of the x axis.
     * @param upperEdgeX The upper edge of bins of the x axis.
     * @param nBinsY     The number of bins of the y axis.
     * @param lowerEdgeY The lower edge of bins of the y axis.
     * @param upperEdgeY The upper edge of bins of the y axis.
     * @param nBinsZ     The number of bins of the z axis.
     * @param lowerEdgeZ The lower edge of bins of the z axis.
     * @param upperEdgeZ The upper edge of bins of the z axis.
     * @throws AlreadyConvertedException If the ICloud3D has already been converted.
     *
     */
    public void convert(int nBinsX, double lowerEdgeX, double upperEdgeX, int nBinsY, double lowerEdgeY, double upperEdgeY, int nBinsZ, double lowerEdgeZ, double upperEdgeZ) throws AlreadyConvertedException;

    /**
     * Convert internally the ICloud3D to an IHistogram3D 
     * with given bin edges.
     * @param binEdgesX The bins edges of the x axis.
     * @param binEdgesY The bins edges of the y axis.
     * @param binEdgesZ The bins edges of the z axis.
     * @throws          AlreadyConvertedException If the ICloud3D has already been converted.
     *
     */
    public void convert(double[] binEdgesX, double[] binEdgesY, double[] binEdgesZ) throws AlreadyConvertedException;

    /**     
     * Get the internal IHistogram3D in which the ICloud3D converted to.
     * @return The histogram.
     * @throws RuntimeException If the ICloud3D did not convert either automatically
     *                          or because of a convert() method invocation.
     *
     */
    public IHistogram3D histogram() throws RuntimeException;

    /**
     * Project the ICloud3D on an IHistogram3D.
     * @param hist The IHistogram3D to be filled.
     * @throws RuntimeException If the ICloud3D is already converted.
     *
     */
    public void fillHistogram(IHistogram3D hist) throws RuntimeException;
} // class or interface

