// AID-GENERATED
// =========================================================================
// This class was generated by AID - Abstract Interface Definition          
// DO NOT MODIFY, but use the org.freehep.aid.Aid utility to regenerate it. 
// =========================================================================

//  This file is part of the AIDA library
//  Copyright (C) 2002 by the AIDA team.  All rights reserved.
//  This library is free software and under the terms of the
//  GNU Library General Public License described in the LGPL.txt 
package hep.aida;


/**
 * User level interface to a 2D Cloud.
 * 
 * @author The AIDA team (http://aida.freehep.org/)
 *
 */
 
public interface ICloud2D extends ICloud {

    /**
     * Fill the ICloud2D with a couple of values and a corresponding weight.
     * @param x      The x value.
     * @param y      The y value.
     * @throws IllegalArgumentException If the ICloud2D is full, if the weight's value is
     *                                  is not between 0 and 1.
     *
     */
    public void fill(double x, double y) throws IllegalArgumentException;
    /**
     * Fill the ICloud2D with a couple of values and a corresponding weight.
     * @param x      The x value.
     * @param y      The y value.
     * @param weight The corresponding weight. By default it is 1.
     * @throws IllegalArgumentException If the ICloud2D is full, if the weight's value is
     *                                  is not between 0 and 1.
     *
     */
    public void fill(double x, double y, double weight) throws IllegalArgumentException;

    /**
     * Get the lower edge of the ICloud2D along the x axis.
     * @return The lower edge along the x axis.
     *
     */
    public double lowerEdgeX();

    /**
     * Get the lower edge of the ICloud2D along the y axis.
     * @return The lower edge along the y axis.
     *
     */
    public double lowerEdgeY();

    /**
     * Get the upper edge of the ICloud2D along the x axis.
     * @return The upper edge along the x axis.
     *
     */
    public double upperEdgeX();

    /**
     * Get the upper edge of the ICloud2D along the y axis.
     * @return The upper edge along the y axis.
     *
     */
    public double upperEdgeY();

    /**
     * Get the x value corresponding to a given entry.
     * @param index The entry's index.
     * @return      The x value of the index-th entry.
     * @throws      AlreadyConvertedException If the ICloud2D has already been converted.
     *
     */
      
    public double valueX(int index) throws AlreadyConvertedException;

    /**
     * Get the y value corresponding to a given entry.
     * @param index The entry's index.
     * @return      The y value of the index-th entry.
     * @throws      AlreadyConvertedException If the ICloud2D has already been converted.
     *
     */
      
    public double valueY(int index) throws AlreadyConvertedException;

    /**
     * Get the weight corresponding to a given entry.
     * @param index The entry's index.
     * @return      The weight of the index-th entry.
     * @throws      AlreadyConvertedException If the ICloud has already been converted.
     *
     */
      
    public double weight(int index) throws AlreadyConvertedException;

    /**
     * Get the mean of the ICloud2D along the x axis.
     * @return The mean along the x axis.
     *
     */
    public double meanX();

    /**
     * Get the mean of the ICloud2D along the y axis.
     * @return The mean along the y axis.
     *
     */
    public double meanY();

    /**
     * Get the RMS of the ICloud2D along the x axis.
     * @return The RMS along the x axis.
     *
     */
    public double rmsX();

    /**
     * Get the RMS of the ICloud2D along the y axis.
     * @return The RMS along the y axis.
     *
     */
    public double rmsY();

    /**
     * Convert internally the ICloud2D to an IHistogram2D 
     * with given number of bins, upper edge and lower edge.
     * @param nBinsX     The number of bins of the x axis.
     * @param lowerEdgeX The lower edge of bins of the x axis.
     * @param upperEdgeX The upper edge of bins of the x axis.
     * @param nBinsY     The number of bins of the y axis.
     * @param lowerEdgeY The lower edge of bins of the y axis.
     * @param upperEdgeY The upper edge of bins of the y axis.
     * @throws AlreadyConvertedException If the ICloud2D has already been converted.
     *
     */
    public void convert(int nBinsX, double lowerEdgeX, double upperEdgeX, int nBinsY, double lowerEdgeY, double upperEdgeY) throws AlreadyConvertedException;

    /**
     * Convert internally the ICloud2D to an IHistogram2D 
     * with given bin edges.
     * @param binEdgesX The bins edges of the x axis.
     * @param binEdgesY The bins edges of the y axis.
     * @throws          AlreadyConvertedException If the ICloud2D has already been converted.
     *
     */
    public void convert(double[] binEdgesX, double[] binEdgesY) throws AlreadyConvertedException;

    /**     
     * Get the internal IHistogram2D in which the ICloud2D converted to.
     * @return The histogram.
     * @throws RuntimeException If the ICloud2D did not convert either automatically
     *                          or because of a convert() method invocation.
     *
     */
    public IHistogram2D histogram() throws RuntimeException;

    /**
     * Project the ICloud2D on an IHistogram2D.
     * @param hist The IHistogram2D to be filled.
     * @throws RuntimeException If the ICloud2D is already converted.
     *
     */
    public void fillHistogram(IHistogram2D hist) throws RuntimeException;
} // class or interface

